<?php
/*
  $Id: abxNotification.php,v 1.19 2009/04/10 14:51:00 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class_exists('abxManager')      || require_once(dirname(__FILE__).'/abxManager.php');  
  class_exists('abxListing')      || require_once(dirname(__FILE__).'/abxListing.php');  
  class_exists('abxSchedule')     || require_once(dirname(__FILE__).'/abxSchedule.php');  
  class_exists('abxOrderService') || require_once(dirname(__FILE__).'/service/abxOrderService.php');  
  
  class abxNotification extends abxManager {

    function saveSchedule(&$postvars)
    {
      $scheduleInfo = array();

      $scheduleInfo['uuid']          = $postvars['uuid'];
      $scheduleInfo['trigger_state'] = $postvars['triggerState'];
      $scheduleInfo['trigger_type']  = $postvars['triggerType'];
      $scheduleInfo['repeat_count']  = $postvars['repeatCount'];
      $scheduleInfo['repeat_total']  = $postvars['repeatTotal'];
      $scheduleInfo['date_first']    = date_to_sql_date_format($postvars['scheduledDateFirst']);
      $scheduleInfo['date_end']      = date_to_sql_date_format($postvars['scheduledDateEnd']);
      $scheduleInfo['date_next']     = date_to_sql_date_format($postvars['scheduledDateNext']);

      $abxSchedule = new AbxSchedule();
      $abxSchedule->save($scheduleInfo);
      return 'ok';
    }

    function insertOrUpdateListing(&$postvars)
    {
      $auction_house_id = $postvars['auctionHouseID'];

      $ext_title = $postvars['extTitle'];
      $product_id = $postvars['productID'];

      $listing = array();
      $listing['uuid']             = $postvars['uuid'];
      $listing['parent_uuid']      = $postvars['parentUuid'];
      $listing['status']           = $postvars['status'];
      $listing['item_uuid']        = $postvars['itemUuid'];
      $listing['profile_id']       = $postvars['profileId'];
      $listing['auction_house_id'] = $auction_house_id;
      $listing['user_id']          = utf8_decode($postvars['sellerID']);
      $listing['site']             = $postvars['site'];
      $listing['listing_type']     = $postvars['type'];
      $listing['ext_id']           = $postvars['extID'];
      $listing['ext_title']        = utf8_decode($ext_title);
      $listing['start_time']       = date_to_sql_date_format($postvars['timeStart']); // GMT
      $listing['end_time']         = date_to_sql_date_format($postvars['timeEnd']); // GMT
      $listing['quantity']         = $postvars['qty'];
      $listing['quantity_sold']    = $postvars['qtySold'];
      $listing['currency']         = $postvars['currency'];
      $listing['start_price']      = $postvars['priceStart'];
      $listing['current_price']    = $postvars['priceCurrent'];
      $listing['listing_fee']      = $postvars['fee'];
      $listing['app_data']         = $postvars['appData'];
      $listing['error_code']       = $postvars['errorCode'];
      $listing['error_text']       = utf8_decode($postvars['errorText']);
      
      $listing = abxArray::prune($listing);
 
      $abxListing = new AbxListing();
      if($abxListing->exists($listing) === true) {

        $abxListing->updateByUuid($listing);

      } else {

        $abxListing->insert($listing);

      }
      return 'ok';

    }

    function insertTransaction(&$postvars)
    {
      $auction_house_id = $postvars['auctionHouseID'];
      $ext_title = $postvars['extTitle'];
      $ext_id = $postvars['extID'];
      $notify = $postvars['notify'];

      $product_id = $this->getProductID($ext_id);

      $winner = array(
        'auctionHouseID' => $auction_house_id,
        'email'          => $postvars['buyer_email'],
        'userID'         => utf8_decode($postvars['buyer_userId']),
        'name'           => utf8_decode($postvars['buyer_name']),
        'street1'        => utf8_decode($postvars['buyer_street1']),
        'street2'        => utf8_decode($postvars['buyer_street2']),
        'city'           => utf8_decode($postvars['buyer_city']),
        'state'          => utf8_decode($postvars['buyer_state']),
        'zip'            => $postvars['buyer_zip'],
        'country'        => utf8_decode($postvars['buyer_country']),
        'phone'          => $postvars['buyer_phone'],
        'score'          => $postvars['buyer_score']
      );

      $price_end = (float)$postvars['priceEnd'];

      $sale = array(
        'uuid'            => $postvars['uuid'],
        'auctionHouseID'  => $auction_house_id,
        'productID'       => $product_id,
        'sellerID'        => $postvars['sellerID'],
        'site'            => $postvars['site'],
        'listingType'     => $postvars['type'],
        'extID'           => $postvars['extID'],
        'extKey2'         => $postvars['extKey2'],
        'extTitle'        => utf8_decode($ext_title),
        'extDesc'         => utf8_decode($postvars['extDesc']),
        'timeStart'       => date_to_sql_date_format($postvars['timeStart']), // GMT
        'timeEnd'         => date_to_sql_date_format($postvars['timeEnd']),   // GMT
        'email'           => $postvars['buyer_email'],
        'qty'             => $postvars['qty'],
        'currency'        => $postvars['currency'],
        'priceStart'      => $postvars['priceStart'],
        'priceEnd'        => $postvars['priceAdjusted'],
        'tax'             => $postvars['tax'],
        'taxPercent'      => $postvars['taxPercent'],
        'shippingType'    => $postvars['shippingType'],
        'shipping'        => $postvars['shippingActual'],
        'shippingGlobal'  => $postvars['shippingGlobalActual'],
        'shippingZip'     => $postvars['shippingZip'],
        'shippingCountry' => $postvars['shippingCountry'],
        'insurance'       => $postvars['insuranceActual'],
        'insuranceOption' => $postvars['insuranceOption'],
        'workflow_state'  => $postvars['workflow_state'],
        'feedback_left'   => $postvars['feedback_state'],
        'statusID'        => $postvars['checkout_state'],
        'paymentProvider' => $postvars['paymentProvider'],
        'paymentTransactionId' => $postvars['paymentTransactionId'],
        'paymentCurrency' => $postvars['paymentCurrency'],
        'paymentTimestamp' => date_to_sql_date_format($postvars['paymentTimestamp']), //GMT
        'paymentAmount'   => $postvars['paymentAmount'],
        'paymentFee'      => $postvars['paymentFee'],
        'shippingMethodActual' => $postvars['shippingMethodActual'],
      );

      $id = $this->getSaleIdByUuid($sale);
      if(is_numeric($id) && $id > 0)
      {
        $sale['ID'] = $id;

        //+++FIXME: Eventually add this back in after we resolve syncronization with ABX
        unset($sale['statusID']);
        
        $this->update($winner, $sale);
      } 
      else
      {
        $this->insert($winner, $sale);
      }
      return 'ok';
    }


    function getProductID($extId)
    {
      global $abxDatabase;

      $app_data = &$abxDatabase->fetch_value('app_data',TABLE_ABX_LISTINGS,"ext_id = '".addslashes($extId)."'");

      return (empty($app_data) === false) ? $app_data : 0;
    }
    
    function saveOrder($orderXml)
    {
//        echo $orderXml; exit;
    	$orderInfo = xml2array($orderXml, 0);  // ignore attributes since it messes up the xml
      $orderSvc = new abxOrderService();
      $ret = $orderSvc->saveOrder($orderInfo);
      
      echo '<?xml version="1.0" encoding="UTF-8"?><result><code>' . $ret['code'] . '</code><orderId>'. $ret['orderId'] . '</orderId></result>';
      //var_dump( $ret);
    }

  }//end class
?>