<?php
/*
  $Id: abxProfiles.php,v 1.8 2005/04/11 17:13:29 auctionblox Exp $

  AuctionBlox, sell more, work less!

  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxProfilesFeedback {

    function updateTemplate(&$aPost) {
      $aArr = array(
        'id'         => $aPost['oID'],
        'profile_id' => $aPost['profile_id'],
        'type'       => $aPost['type'],
        'text'       => $aPost['text']
      );

      $aResult = abxAPI::call('profile.updateFeedbackTemplate', $aArr);

      if (abxAPI::isError($aResult)) {
        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED,'error');
      }
    }

    function insertTemplates(&$aPost) {
      $bError = false;
      foreach($aPost['abxList'] as $nProfileId) {
        $aArr = array(
          'id'         => $aPost['oID'],
          'profile_id' => $nProfileId,
          'type'       => $aPost['type'],
          'text'       => $aPost['text'],
          'date_added' => 'now()'
        );


        $aResult = abxAPI::call('profile.insertFeedbackTemplate', $aArr);
        if (abxAPI::isError($aResult)) {
          $bError = true;
        }
      }

      if ($bError) {
        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED, 'error');
      }
    }

    function insertTemplate(&$aPost) {
      $aArr = array(
        'profile_id' => $aPost['profile_id'],
        'type'       => $aPost['type'],
        'text'       => $aPost['text'],
      );

      $aResult = abxAPI::call('profile.insertFeedbackTemplate', $aArr);

      if (abxAPI::isError($aResult)) {
        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED,'error');
      }
    }

    function deleteTemplates($aTemplates) {
      if (!$aTemplates) {
        return false;
      }

      $bError = false;
      foreach($aTemplates as $nTemplate) {
        $aArr = array('id' => $nTemplate);

        $aResult = abxAPI::call('profile.removeFeedbackTemplate', $aArr);
        
        if (abxAPI::isError($aResult)) {
          $bError = true;
        }
      }

      if ($bError) {
        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED,'error');
      }
    }

    function getTemplates() {
      return "select SQL_CALC_FOUND_ROWS * from " . TABLE_ABX_FEEDBACK_TEMPLATES . "  where 1";
    }

    function getTemplateById($id) {
      $aArr = array('id' => $id);
      $aResult = abxAPI::call('profile.getFeedbackTemplateById', $aArr);

      if (abxAPI::isError($aResult)) {
        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED, 'error');
        abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=profiles-feedback&oID='.$id.abxPage::getSearchParams()));
      }

      return $aResult['data'];
    }
    
    function getProfileNameByFeedbackTemplateId($id) 
    {	
    	$profiles = abxProfiles::getProfiles();
    	
    	foreach($profiles as $key1 => $profile)
    	{
    		$templates = $profile['feedbackTemplates'];
    		foreach($templates as $key2 => $template)
    		{
    			if(strcmp($id, $template['id']) === 0)
    				return $profile['label'];
    		}
    	}
    	return "{UNKNOWN}";	
    }        

  }//end class

?>