<?php

/*
  $Id: abxOrderManager.php,v 1.3 2006/02/24 01:36:08 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/
require_once (DIR_FS_ABX_CLASSES . 'abxDatabase.php');
require_once (DIR_FS_ABX_CLASSES . 'abxConfiguration.php');
require_once (DIR_FS_ABX_CLASSES . 'abxAPIQueue.php');

class abxInventoryManager
{
  function getInventorySynchronizeApiCall()
  {
    return 'inventory.reviseQuantityAvailable';
  }
  
  //synonym for process - just for consistency
  function synchronize()
  {
  	abxInventoryManager::process();
  }
  
  function process()
  {
      global $abxDatabase;
/*
    	$configItem = abxConfiguration::queryByKey('AUCTIONBLOX_PASSCODE');
    	$passcode = $configItem['configuration_value'];
    	
    	if($_GET['passcode'] !== $passcode)
    	{
    	  echo "Not authorized";
    	  exit;
    	}
*/      
   	  $timestamp = time();
   	  $now = date('Y-m-d H:i:s', $timestamp);
   	  
    	$configItem = abxConfiguration::queryByKey('INVENTORY_LAST_RUN_TIMESTAMP');
    	$then = $configItem['configuration_value'];

	    if ($then == null || strlen($then) === 0) {
	      // must be the first time
    	  $then = $now;
    	  
        $cfg = array(
          'configuration_title'       => 'Inventory ',
          'configuration_key'         => 'INVENTORY_LAST_RUN_TIMESTAMP',
          'configuration_value'       => $now,
          'configuration_description' => 'Inventory',
          'visible'                   => '0',
          'sort_order'                => '0',
          'date_added'                => 'now()'
        );

        $abxDatabase->insert(TABLE_ABX_CONFIGURATION, $cfg);    	  
	    }
      
      $strQuery = "select p.products_id," .
                  " p.products_model," .
                  " p.products_quantity," .
								  " p.products_price," .
                  " p.products_last_modified" .
								  " FROM " . TABLE_PRODUCTS . " p" .
								  " WHERE p.products_last_modified > '$then'" .
                  " AND p.products_last_modified <= '$now'" .
                  " ORDER BY p.products_last_modified" .        // Used to get the last date processed                
                  " LIMIT 50";                                  // Dont overload a single request
				  
      $query = $abxDatabase->query($strQuery);
      $data = array();
		  $tempProduct = array();
      while ($product = $query->next())
		  {
        $tempProduct['productId'] = $product['products_id'];
        $tempProduct['quantityAvailable'] = $product['products_quantity'];
        $tempProduct['quantityPurchased'] = 0;
        
        $now = $product['products_last_modified'];      // new last modified date 
		
				$data[] = $tempProduct;
      }
      
      if(sizeof($data) == 0)
      {
        return;
      }

     	// do the api call 
     	abxAPIQueue::add(abxInventoryManager::getInventorySynchronizeApiCall(), array("list" => $data));

      // save last timestamp
      abxConfiguration::updateByKey('INVENTORY_LAST_RUN_TIMESTAMP', $now);

      abxAPIQueue::process();       
  }
} //end class
?>