function setInputs(input,other_input_type,other_input_name,other_input_value_type)
{
  var form = input.form;
  switch(input.type) {
    case 'select-one':
      if (input[input.selectedIndex].value != null && input[input.selectedIndex].value != '') {
        for(var i = 0; i < form.length; i++) {
          if (form[i].type == other_input_type && other_input_name == form[i].name.substring(0,other_input_name.length)) {
            switch(other_input_type) {
              case 'select-one':
                for(var j = 0; j < form[i].length; j++) {
                  if(form[i][j].value == input[input.selectedIndex].value) {
                    form[i][j].selected = 'true';
                    break;
                  }
                }
                break;
              case 'text':
                form[i].value = input[input.selectedIndex].value;
                break;
            }
          }
        }
      }
      break;
    case 'text':
      for(var i = 0; i < form.length; i++) {
        if (form[i].type == other_input_type && other_input_name == form[i].name.substring(0,other_input_name.length)) {
          switch(other_input_type) {
            case 'text':
            case 'hidden':
              switch(other_input_value_type) {
                case 'integer':
                  form[i].value = parseInt(input.value);
                  break;
                case 'float':
                  form[i].value = Math.round(parseFloat(input.value) * Math.pow(10, 2)) / Math.pow(10, 2);
                  break;
              }
              break;
          }
        }
      }
      break;
  }
}

function setPricePercentage(input)
{
  var form = input.form;
  var price;
  for(var i = 0; i < form.length; i++) {
    if (form[i].type == 'hidden' && form[i].name.substring(0,10) == 'base_price') {
      price = Math.round(parseFloat(((parseFloat(form[i].value)/100) * parseFloat(input.value))) * Math.pow(10, 2)) / Math.pow(10, 2);
    }
    if(form[i].type == 'text' && form[i].name.substring(0,11) == 'start_price') {
      form[i].value = price;
    }
  }
  form['global_price'].value = '';
}

function updatePrice(input)
{
  setInputs(input,'text','start_price','float');
  setInputs(input,'hidden','base_price','float');
  input.form['global_price_percentage'].value = '100.00';
}
