<?php
/*
  $Id: sales.php,v 1.17 2008/12/15 00:47:30 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Sales extends abxPaginator {

    function filterTerms()
    {
      static $filterTerms;

      if (isset($filterTerms) === false) {

        $salesTypes = abxConstants::getSaleTypes(array(array('id' => '', 'text' => '')));

        $saleTypesList = array();

        foreach($salesTypes as $salesType)
          $saleTypesList[] = array( 'id' => $salesType['id'], 'text' => $salesType['text']);

        $filterTerms = array(
          'name'   => 'a.listing_status',
          'values' => $saleTypesList
        );

      }

      return $filterTerms;
    }

    function filterBy()
    {
      if (empty($_GET['filter']) === false)
        return $_GET['filter'];

      return '';
    }

    function orderStatusBy()
    {
      if (empty($_GET['orderstatus']) === false)
        return $_GET['orderstatus'];

      return '';
    }

    function allSelected()
    {
      static $checkbox_SelectAll;

      if (isset($checkbox_SelectAll) === true)
        return $checkbox_SelectAll;

      return $checkbox_SelectAll = (isset($GLOBALS['checkbox_SelectAll']) && $GLOBALS['checkbox_SelectAll'] == 'on') ? 'CHECKED' : '';
    }

    // overrode base class to add orderstatus filter
    function tableDataHeader()
    {
      $additionalFormFields = array("orderstatus");
              
      $str = '<table border="0" width="100%" cellspacing="0" cellpadding="2">' .
             '  <tr>' .
             '    <td class="pageHeading" nowrap>' . HEADING_TITLE . '&nbsp;</td>';

      if($this->performAction === false && count($this->searchTerms()) > 0)
        $str .= '<td class="smallText" align="right" nowrap>' . $this->drawSearchForm(FILENAME_AUCTIONBLOX, $this->searchTerms(), $additionalFormFields) . '</td>';

      $str .= '</tr>';

      if ($this->performAction === false) {

        $pageFilters = '';

        $colspan = '2';

        if($this->countSellerIDs() > 0) {
          $colspan = '1';

          $seller_id_onChange = '';

          if($this->countFilterTerms() > 0)
            $seller_id_onChange .= 'document.forms[\'abxsearch\'].filter.value = document.forms[\'search_filter\'].filter[document.forms[\'search_filter\'].filter.selectedIndex].value;';

          $seller_id_onChange .= 'document.forms[\'abxsearch\'].seller_id.value = document.forms[\'seller_filter\'].seller_id[document.forms[\'seller_filter\'].seller_id.selectedIndex].value; document.forms[\'abxsearch\'].submit();';

          $pageFilters .= '<td colspan="'.$colspan.'" class="smallText">' . $this->drawFilterForm(FILENAME_AUCTIONBLOX, $this->sellerIDs(), ENTRY_EBAY_SELLER_ID, 'seller_filter', 'seller_id', 'onchange="' . $seller_id_onChange . '"') . '</td>';

        }


          $filter_terms_onChange = '';

          if($this->countSellerIDs() > 0)
            $filter_terms_onChange .= 'document.forms[\'abxsearch\'].seller_id.value = document.forms[\'seller_filter\'].seller_id[document.forms[\'seller_filter\'].seller_id.selectedIndex].value;';
          $filter_terms_onChange .= 'document.forms[\'abxsearch\'].filter.value = document.forms[\'search_filter\'].filter[document.forms[\'search_filter\'].filter.selectedIndex].value;';
          $filter_terms_onChange .= 'document.forms[\'abxsearch\'].submit();';

          $onchange .= "document.forms['abxsearch'].orderstatus.value = this.form.orderstatus[this.form.orderstatus.selectedIndex].value; document.forms['abxsearch'].submit();";
          $orderStatusTerms = $this->orderStatusTerms();
          $pageFilters .= '<td colspan="'.$colspan.'" class="smallText" align="right">' . $this->drawFilterForm(FILENAME_AUCTIONBLOX, $orderStatusTerms['values'], HEADING_AUCTION_ORDER_STATUS, 'order_filter', 'orderstatus', 'onchange="' . $onchange . '"');
          $pageFilters .= '&nbsp;&nbsp;';
            
          $filterTerms = $this->filterTerms();
          $pageFilters .= $this->drawFilterForm(FILENAME_AUCTIONBLOX, $filterTerms['values'], HEADING_TITLE_GOTO, 'search_filter', 'filter', 'onchange="' . $filter_terms_onChange . '"') . '</td>';

        $str .= (empty($pageFilters) === false) ? '<tr>' . $pageFilters . '</tr>' : '';
      }

      $str .= '</table>';

      return $str;
    }

    function orderStatusTerms()
    {
      global $abxSales;
      
      static $filterTerms;

      if (isset($filterTerms) === false)
      {
        $values = array(
                      array('id' => '', 'text' => '[-- No Filter --]'),
                      array('id' => '-1', 'text' => '-- Order Status --'),
                   );
                   
        $values = array_merge($values, $abxSales->getOrderStatuses());

        $filterTerms = array(
          'name'   => 'orderstatus',
          'values' => $values
        );      
      }
      return $filterTerms;
    }
    
    function sortDefaultArray()
    {
      return array(
        'name'  => 'time_end',
        'value' => 'desc'
      );
    }

    function sellerIDs()
    {
      static $eBaySellerList;

      if (isset($eBaySellerList) === false) {

        $sellers = abxConstants::getEbaySellerIDs(array(array('id' => '', 'text' => '')));

        $eBaySellerList = array();

        foreach($sellers as $seller)
          $eBaySellerList[] = array('id' => $seller['text'], 'text' => $seller['text']);

      }

      return $eBaySellerList;
    }

    function sellerID()
    {
      if (empty($_GET['seller_id']) === false)
        return array(
          'name'  => 'a.user_id',
          'value' => $_GET['seller_id']
        );

      return array();
    }

    function searchTerms()
    {
      return array(
        array('id'=>'a.ext_title','text'=>'SEARCH_LIST_1'),
        array('id'=>'a.ext_id','text'=>'SEARCH_LIST_2'),
        array('id'=>'b.ext_customer_id','text'=>'SEARCH_LIST_3'),
        array('id'=>'b.ext_email_address','text'=>'SEARCH_LIST_4'),
        array('id'=>'name','text'=>'SEARCH_LIST_5')
      );
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => '', 'sort_field' => ''),
        array('heading' => HEADING_AUCTION_TITLE, 'sort_field' => 'a.ext_title'),
        array('heading' => HEADING_AUCTION_SITE, 'sort_field' => 'a.site'),
        array('heading' => HEADING_AUCTION_TYPE, 'sort_field' => 'a.listing_type'),
        array('heading' => HEADING_AUCTION_USERID, 'sort_field' => 'b.ext_customer_id'),
        array('heading' => HEADING_AUCTION_QTY, 'sort_field' => 'a.quantity'),
        array('heading' => HEADING_AUCTION_PRICE_END, 'sort_field' => 'a.price_end'),
        array('heading' => HEADING_AUCTION_SHIPPING, 'sort_field' => 'a.shipping'),
        array('heading' => HEADING_AUCTION_END_DATE, 'sort_field' => 'a.time_end'),
        array('heading' => HEADING_AUCTION_ORDER_STATUS, 'sort_field' => 'o.orders_status'),
        array('heading' => HEADING_AUCTION_FEEDBACK, 'sort_field' => 'feedback_left'),
        array('heading' => HEADING_AUCTION_NEXT_STEPS, 'sort_field' => 'workflow_state'),
      );
    }

    function tableDataRowContents($array)
    {
      global $currencies, $abxSales;

      $listingTypes = abxConstants::getListingTypesShort();

      $user_id = $array['ext_customer_id'] . '<br /><span class="tableDataSubText">' . $array['ext_email_address'] . '</span>';
      
      $shipping = '--'; 
      if((double)$array['shipping'] >= 0.0)
        $shipping =  $this->cell($currencies->format($array['shipping'], false, $array['currency']));

      if (empty($array['customers_id']) === false)
        $user_id =  '<a href="' . abx_href_link(FILENAME_CUSTOMERS,'cID='.$array['customers_id']). '">' . $user_id . '</a>';
      
      if($array['products_id'] == 0 || $array['products_id'] == null)  
        $warning = $this->image(DIR_WS_ABX_IMAGES . 'icons/warning.gif', 'Warning: This sale does not have a product assigned','15','15');      

      $retvalue =
             '<td>' . $warning . '</td>' .
      			 '<td>' . $this->cell('<a href="' . sprintf($array['url'], $array['ext_id']) . '" target="ebay" >' . wordwrap($array['ext_title'],45,'<br />') . '<br /><span class="tableDataSubText">' . $array['ext_id'] . '</span>' . '</a>') . '</td>'.
             '<td>' . $this->cell($array['site']) . '</td>'.
             '<td>' . $this->cell($listingTypes[$array['listing_type']]) . '</td>'.
             '<td>' . $this->cell($user_id) . '</td>'.
             '<td>' . $this->cell($array['quantity']) . '</td>'.
             '<td align="right">' . $this->cell($currencies->format($array['price_end'], false, $array['currency'])) . '</td>'.
             '<td align="right">' . $shipping . '</td>'.
             '<td align="right">' . $this->cell(wordwrap(gmt_date_to_local_pretty_format($array['time_end']),8,'<br />')) . '</td>'.
             '<td><a href="' . abx_href_link(FILENAME_ORDERS,'selected_box=customers&oID=' . $array['orders_id']  . '&action=edit') . '">' .
                       $this->cell($array['orders_status_name']) . '</a></td>' .

             '<td>' . $this->cell($array['feedback_label']) . '</td>';
             
	  	if($array['payment_provider'] === 'PayPal')
	  	{
	    	$pptext = $currencies->format($array['payment_amount'], false, $array['currency']) .
	    	          " (" . 
	    	          $currencies->format($array['payment_fee'], false, $array['currency']) .
	    	          ")";

				// paypal ipn integration
				if(defined(TABLE_PAYPAL))
				{
					$link = abxPage::menu_link('action=details&info='.$array['payment_transaction_id'],'NONSSL',FILENAME_PAYPAL);
				}
	  		
	  		$retvalue .= '<td>' . $this->imageButton(DIR_WS_ABX_ICONS . 'pp.gif', 'PayPal ' . $status, '16', '16',"openWindow('".$link."')") . '&nbsp;' . $pptext . '</td>';
	  	}
      else if($array['payment_provider'] !== null && strlen($array['payment_provider']) >= 2)
      {
        $retvalue .= '<td>' . $this->cell($array['payment_provider']) . '</td>';
      }
	  	else
	  	{
		  	$retvalue .= '<td>' . $this->cell($array['workflow_label']) . '</td>';
	  	}
			
			return $retvalue;             
    }

    function bulkActions()
    {
      return array(
        'DeleteItems'      => array('icon'=>'delete.gif','alt'=>ACTION_DELETE,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_DELETE."','".TEXT_SALES."','DeleteConfirm');"),
        'Archive'          => array('icon'=>'archived.gif','alt'=>ACTION_ARCHIVE),
        'ChangeStatus'     => array('icon'=>'status.gif','alt'=>ACTION_CHANGE_STATUS),
        'Invoice'          => array('icon'=>'invoice_email.gif','alt'=>ACTION_SEND_INVOICE),
        'CourtesyReminder' => array('icon'=>'reminder.gif','alt'=>ACTION_COURTESY_REMINDER),
        'WarningEmail'     => array('icon'=>'warning_email.gif','alt'=>ACTION_WARNING_EMAIL),
        'PositiveFeedback' => array('icon'=>'feedback_pos.gif','alt'=>ACTION_POSITIVE_FEEDBACK),
        'NeutralFeedback'  => array('icon'=>'feedback_neu.gif','alt'=>ACTION_NEUTRAL_FEEDBACK),
        'NegativeFeedback' => array('icon'=>'feedback_neg.gif','alt'=>ACTION_NEGATIVE_FEEDBACK)
      );
    }

    function disableBulkActions(&$abxPageIcons)
    {
      global $abxSales;

      if ($this->performAction === false) {

        switch($_GET['filter']) {
          case $abxSales->ENDED:
            $abxPageIcons->enable(array('DeleteItems', 'Archive', 'ChangeStatus','Invoice','CourtesyReminder','WarningEmail','NeutralFeedback','NegativeFeedback'));
            break;
          case $abxSales->CHECKEDOUT:
            $abxPageIcons->enable(array('DeleteItems', 'Archive', 'ChangeStatus','CourtesyReminder','WarningEmail','PositiveFeedback','NeutralFeedback','NegativeFeedback'));
            break;
          case $abxSales->COMPLETED:
            $abxPageIcons->enable(array('DeleteItems', 'Archive', 'ChangeStatus','PositiveFeedback','NeutralFeedback','NegativeFeedback'));
            break;
          default:
            $abxPageIcons->enable(array());
            break;
        }

      }
    }

    function singleActions($array = array())
    {
      return array(
        'EditSale'    => array('enabled' => 'false','icon'=>'edit.gif','alt'=>TEXT_EDIT_SALE,'url'=>abx_href_link(FILENAME_AUCTIONBLOX, 'abx=sales-item-edit&oID=' . $array['id'].'&'.abxPage::getSearchParams(array('abx')))),
        'FileDispute' => array('enabled' => 'false','icon'=>'dispute.gif','alt'=>TEXT_FILE_DISPUTE,'onclick'=> 'openWindow(\''.abx_href_link(FILENAME_AUCTIONBLOX, 'abx=sales-dispute&oID=' . $array['id'].abxPage::getSearchParams()).'\',\'dispute\');'),
        'CreateOrder' => array('enabled' => 'false','icon'=>'createorder.gif','alt'=>TEXT_CREATE_ORDER,'url'=>abx_href_link(FILENAME_AUCTIONBLOX, 'abx=sales-order&' .  'oID='.$array['id'].'&'.abxPage::getSearchParams(array('abx')))),
        'ViewOrder'   => array('enabled' => 'false','icon'=>'orders.gif','alt'=>TEXT_VIEW_ORDER,'url'=>abx_href_link(FILENAME_ORDERS,'selected_box=customers&oID=' . $array['orders_id']  . '&action=edit'))
      );
    }

    function disableSingleActions($array,&$abxPageIcons)
    {
      global $abxSales;

      if ($this->performAction === false) {

        switch($array['listing_status']) {
          case $abxSales->ENDED:
            $abxPageIcons->enable(array('EditSale','FileDispute','CreateOrder'));
            break;
          case $abxSales->CHECKEDOUT:
            $abxPageIcons->enable(array('EditSale','FileDispute','ViewOrder'));
            break;
          case $abxSales->COMPLETED:
            $abxPageIcons->enable(array('EditSale','FileDispute','ViewOrder'));
            break;
        }

        if ($array['workflow_state_id'] == 'COMPLETE')
            $abxPageIcons->disable(array('FileDispute'));
      }
    }

    function drawExtraHiddenFields()
    {
      $profileSet = true;

      $str = '<input type="hidden" name="abx_last" value="sales">';

      for($i=0,$n = count($this->query->results);$i<$n;$i++)
        if (empty($this->query->results[$i]['profile_id']) === true)
          $profileSet = false;

      if ($profileSet === false)
        $str .= '<input type="hidden" name="profileNotSet" value="true">';

      return $str;
    }

    function infoBox($action)
    {
      switch($action) {
        case 'PositiveFeedback':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_POSITIVE_FEEDBACK,TEXT_INFO_POSITIVE_FEEDBACK,'PositiveFeedbackConfirm','','',$this->infoBoxProfiles());
          break;
        case 'NeutralFeedback':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_NEUTRAL_FEEDBACK,TEXT_INFO_NEUTRAL_FEEDBACK,'NeutralFeedbackConfirm','','',$this->infoBoxProfiles());
          break;
        case 'NegativeFeedback':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_NEGATIVE_FEEDBACK,TEXT_INFO_NEGATIVE_FEEDBACK,'NegativeFeedbackConfirm','','',$this->infoBoxProfiles());
          break;
        case 'Invoice':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_INVOICE,TEXT_INFO_INVOICE,'InvoiceConfirm','','',$this->infoBoxProfiles());
          break;
        case 'CourtesyReminder':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_COURTESY_REMINDER,TEXT_INFO_COURTESY_REMINDER,'CourtesyReminderConfirm','','',$this->infoBoxProfiles());
          break;
        case 'WarningEmail':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_WARNING_EMAIL,TEXT_INFO_WARNING_EMAIL,'WarningEmailConfirm','','',$this->infoBoxProfiles());
          break;
        case 'ChangeStatus':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_CHANGE_STATUS,TEXT_INFO_CHANGE_STATUS,'ChangeStatusConfirm','','',array(array('text' => ENTRY_STATUS . '&nbsp;&nbsp;' . $this->select('statusID',abxConstants::getSaleTypes()))));
          break;
        case 'download':
          return $this->infoPageBox(TEXT_INFO_HEADING_DOWNLOAD_SALES,TEXT_INFO_DOWNLOAD_SALES, 'sales', 'downloadConfirm','sales-download','', $this->infoBoxDownloads());
          break;
        case 'Archive':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_ARCHIVE,TEXT_INFO_ARCHIVE,'ArchiveConfirm','','',$this->infoBoxArchive());
          break;
      }
    }

    function tableDataFooter()
    {
      return '<div align="right">'.$this->navigation(TEXT_ENTER_NEW_SALE,'sales-item'.abxPage::getSearchParams()).'&nbsp;&nbsp;<form name="salesDownload" method="post">'.$this->submit(TEXT_DOWNLOAD_SALES,'this.form','download','sales-download'.abxPage::getSearchParams(),'','greenButton').'<input type="hidden" name="perform"></form></div>';
    }

    function infoBoxDownloads()
    {
      return array(array('text' =>  '<div style="margin: 10px;">' . $this->select('seller_id',abxConstants::getEbaySellerIDs()) . '</div>'));
    }

    function infoBoxArchive() {
      return array(
        array('text' =>  $this->checkbox('paid', '1') . '&nbsp;' .TEXT_PAID),
        array('text' =>  $this->checkbox('shipped', '1') . '&nbsp;' .TEXT_SHIPPED)
      );
    }

  }//end class
?>