<?php
/*
 * Created on Oct 15, 2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 
function abx_currencies_convertCurrency($price, $currency, $round = false, $format = false, $invert = false)
{
	global $currencies;
    
	$rate = $currencies->get_value($currency);

	if ($rate == 0) {
		$rate = 1;
	}

	if ($invert) {
		$price = $price * $rate;
	} else {
		$price = $price / $rate;
	}

	if ($round) {
		$price = round($price, $currencies->currencies[$currency]['decimal_places']);
	}

	if ($format) {
		$price =  number_format(
								$price,
								$currencies->currencies[$currency]['decimal_places'],
								$currencies->currencies[$currency]['decimal_point'],
								$currencies->currencies[$currency]['thousands_point']
		);
	}

	return $price;
}

function abx_currencies_invertCurrency($price, $currency, $round = false, $format = false)
{
    global $currencies;
	return abx_currencies_convertCurrency($price, $currency, $round, $format, true);
}

function abx_currencies_getCurrenciesDropDownSelectList($arr = array())
{
	global $currencies;
	static $selectList;

	if (isset($selectList) === false) {
		reset($currencies->currencies);
		$selectList = array();
		foreach($currencies->currencies as $key => $value)
			$selectList[] = array('id' => $key, 'text' => $value['title']);
	}

	return !empty($arr) ? array_merge($arr,$selectList) : $selectList;
}
?>