<?php
/*
  $Id: sales_order.php,v 1.9 2008/03/13 14:33:25 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  function abx_state_list(&$page, $country_id, $name, $zone = '', $zone_id = '', $parameters = '')
  {
    global $abxDatabase;

    $zonesQuery = $abxDatabase->query("select zone_id, zone_name, zone_code from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country_id . "' order by zone_name");

    if ($zonesQuery->numRows()) {

      $zones_array = array();

      $zone_match = false;

      while ($zonesQuery->next())  {

        $zones_array[] = array('id' => $zonesQuery->value('zone_code'), 'text' => $zonesQuery->value('zone_name'));

        if($zone_id == $zonesQuery->value('zone_id')) {

          $zone = $zonesQuery->value('zone_name');
          $zone_code = $zonesQuery->value('zone_code');

          $zone_match = true;

        }

      }

      if ($zone_match === true)
        return $page->select($name, $zones_array, $zone_code, $parameters);
      else
        return $page->input($name, $zone, 'size="32" maxlength="32"' . $parameters);
    }

    return $page->input($name, $zone, 'size="32" maxlength="32"' . $parameters);
  }

  function abx_country_list(&$page, $name, $country_id = '', $country_name = '', $parameters = '')
  {
    static $countries;

    if(isset($countries) === false)
      $countries = abx_get_countries();

    $match = false;

    foreach($countries as $country) {

      $countries_array[] = array('id' => $country['iso_code_2'], 'text' => $country['text']);

      if ((empty($country_name) === false && $country_name === $country['text']) || 
          (empty($country_name) === false && $country_name === $country['iso_code_2']) ||
          (empty($country_name) && !empty($country_id) && $country_id === $country['id'])) {

        $country_name = $country['text'];
        $country_code = $country['iso_code_2']; 

        $match = true;

      }

    }

    if($match === true)

      return $page->select($name, $countries_array, $country_code, $parameters);

    elseif (empty($country_id) === true)

      return $page->select($name, $countries_array, '', $parameters);

    else

      return $page->input($name, $country_name, 'maxlength="64" '.$parameters, true);

  }

  function abx_countryID($country = '')
  {
    global $abxDatabase;

    if(empty($country) === false) {

	  $countries_id = $abxDatabase->fetch_value('countries_id',TABLE_COUNTRIES,"countries_iso_code_2 = '" . addslashes($country) . "'");
      if(!intval($countries_id) || $countries_id < 0)
      {
	      $countries_id = $abxDatabase->fetch_value('countries_id',TABLE_COUNTRIES,"countries_name = '" . addslashes($country) . "'");
      }

      //return !empty($countries_id) ? $countries_id : STORE_COUNTRY;
      return $countries_id;

    }

    return ''; //STORE_COUNTRY;
  }

  function abx_zoneID($country,$state)
  {
    global $abxDatabase;

    $check = $abxDatabase->fetch_row("select count(*) as total from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "'");

    if ($check['total'] > 0) {

      //$zoneQuery = $abxDatabase->query("select distinct zone_id from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' and (zone_name like '" . addslashes($state) . "%' or zone_code like '%" . addslashes($state) . "%')");
      $zoneQuery = $abxDatabase->query("select distinct zone_id from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' and (zone_name = '" . addslashes($state) . "' or zone_code = '" . addslashes($state) . "')");

      if ($zoneQuery->numRows() == 1) {

        $zone = $zoneQuery->next();

        $zoneQuery->freeResult();

        return $zone['zone_id'];

      }

    }

    return STORE_ZONE;
  }

  function abx_addressFormatID($country_id = '')
  {
    global $abxDatabase;

    $country_id = !empty($country_id) ? $country_id : STORE_COUNTRY;

    $addressFormat = $abxDatabase->fetch_row("select address_format_id as format_id from " . TABLE_COUNTRIES . " where countries_id = " . (int)$country_id);

    if (empty($addressFormat) === false)

      return $addressFormat['format_id'];

    return '1';
  }

  function abx_osC_getModules($module_dir,$modules_list)
  {
    $language = abxRegistry::get("language");

    $modules_installed = explode(';', $modules_list);

    foreach($modules_installed as $module => $module_name)

      $modules[] = array('class' => substr($module_name, 0, strrpos($module_name, '.')), 'file' => $module_name);

    unset($modules_installed,$module,$module_name);

    $modules_installed = array();

    foreach($modules as $module) {

      include_once(DIR_FS_CATALOG_LANGUAGES . $language . '/modules/' . $module_dir . '/' . $module['file']);

      include_once(DIR_FS_CATALOG_MODULES . $module_dir . '/' . $module['file']);

      $module = new $module['class'];

      if ($module->check() > 0)

        if ($module->sort_order > 0)

          $modules_installed[$module->sort_order] = array('id' => strip_tags($module->title), 'text' => strip_tags($module->title));

        else

          $modules_installed[] = array('id' => strip_tags($module->title), 'text' => strip_tags($module->title));

    }

    return $modules_installed;
  }

  function abx_getPaymentMethods()
  {
    return abx_osC_getModules('payment',MODULE_PAYMENT_INSTALLED);
  }

  function abx_getShippingMethods()
  {
    return abx_osC_getModules('shipping',MODULE_SHIPPING_INSTALLED);
  }

  function abx_getOrderStatuses()
  {
    global $abxDatabase;
    $languages_id = abxRegistry::get("languages_id");

    $orders_statuses = array();

    $ordersStatusesQuery = $abxDatabase->query("select orders_status_id, orders_status_name from " . TABLE_ORDERS_STATUS . " where language_id = '" . (int)$languages_id . "'");

    while ($ordersStatusesQuery->next())

      $orders_statuses[] = array(
        'id' => $ordersStatusesQuery->value('orders_status_id'),
        'text' => $ordersStatusesQuery->value('orders_status_name')
      );

    return $orders_statuses;
  }

  function abx_generateRandomPassword()
  {
    // Generates a random 8 character password and encrypts it to OSC specs
    $pass = null;

    $raw_password = '';

    $password = '';

    $len = 8;

    for($i = 0; $i < $len; $i++) {

      $char = chr(rand(48, 122));

      while (!ereg("[a-zA-Z0-9]", $char)) {

        if ($char == $lchar)
          continue;

        $char = chr(rand(48, 90));

      }

      $pass .= $char;

      $lchar = $char;

    }

    $salt = substr(md5($password), 0, 2);

    $password = md5($salt . $pass) . ':' . $salt;

    return $password;
  }

?>