<?php
/*
  $Id: catalog_checkout.php,v 1.14 2006/04/07 02:48:44 devosc Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  include_once DIR_FS_ABX_CLASSES.'abxCheckout.php';
  include_once DIR_FS_ABX_CLASSES.'abxCustomer.php';

  class abxModule_Catalog_Checkout extends abxModule {

    function abxModule_Catalog_Checkout() {
      if (!empty($_REQUEST['email'])) { // comes in as GET from abx or POST from this form
        $this->process();
      }
    }

    function process() {
        
      $navigation = abxRegistry::get("navigation");
      $language = abxRegistry::get("language");

      abx_includeLanguageFile(DIR_FS_MYABX, $language, 'catalog_checkout');

      if (!empty($_REQUEST['email'])) { // comes in as GET from abx or POST from this form
        $email_address = trim($_REQUEST['email']);
      };

      // Check if email exists
      $cart = $_SESSION['cart'];
      if(!is_object($cart))
      {
        // THIS SHOULD NEVER HAPPEN...yet received a report that it was null...
        $cart = new abxCart();
      }
      
      $cart->setEmail($email_address);
      $cart->restore_contents();

    $_SESSION['cart'] = $cart;

//      $abxCheckout = new abxCheckout();
//      $auctions = $abxCheckout->getSales($email_address);

      if ($cart->count_auction_contents() === 0) {
        define('AUCTIONBLOX_CHECKOUT_ERROR', TEXT_AUCTION_FINDER_ERROR);
      } else {
        $Customer = new abxCustomer($email_address, $_GET['code']);

        if ($Customer->isAuctionBloxRequest())
        {
          if( $Customer->hasBuyerInfo() )
          {
            if( !$Customer->exists() )
            {
                      $Customer->create();
                      $Customer->doLogin();
                      
                  if(defined('WELCOME_EMAIL_ENABLED') && constant('WELCOME_EMAIL_ENABLED') === 'true')
                  {
                    $email_text = WELCOME_EMAIL_INTRODUCTION_PARAGRAPH .
                                  sprintf(WELCOME_EMAIL_PASSWORD_PARAGRAPH, $Customer->sPwd) .
                                  WELCOME_EMAIL_CONCLUSION_PARAGRAPH .
                                  WELCOME_EMAIL_SIGNATURE;
                    
                    abx_mail($Customer->name, 
                             $Customer->sEmail,
                             WELCOME_EMAIL_TITLE, 
                             $email_text, 
                             STORE_OWNER, 
                             STORE_OWNER_EMAIL_ADDRESS);
                }
                }
              else
              {
                  $Customer->update();
                  $Customer->doLogin();
              }
          }    
        }

        $_SESSION['auctionblox_email_address'] = $email_address;
        
        $navigation->remove_current_page();

        $params = '';
        if($_GET['PHPSESSID']) $params .= '&PHPSESSID=' . $_GET['PHPSESSID'];

        // use str_replace to fix CRE Loaded bug in tep_href_link        
        abxPage::redirect(str_replace('&amp;', '&', abx_href_link(FILENAME_AUCTIONBLOX, 'abx=attribute'.$params, 'SSL')));
      }
    }

    function display() {
      global $breadcrumb, $language, $request_type;
      
      $page = new abxPage_Catalog();
      $page->setContentFile('catalog_checkout', DIR_FS_MYABX_PAGES_DIR);

      abx_includeLanguageFile(DIR_FS_MYABX, $language, 'catalog_checkout');

      $page->setTitle(TITLE);
      $page->setOnLoad('document.auctionblox.email.focus();');

      $breadcrumb->add(NAVBAR_TITLE_CHECKOUT, abx_href_link(FILENAME_AUCTIONBLOX, '', 'SSL'));
      $breadcrumb->add(NAVBAR_TITLE, abx_href_link(FILENAME_AUCTIONBLOX, '', 'SSL'));

      define('AUCTIONBLOX_CHECKOUT_FORM',
          $page->form('auctionblox', FILENAME_AUCTIONBLOX, 'PHPSESSID='.session_id(), 'post', '', 'SSL').
          '<input type="hidden" name="perform" value="process"/>');

      define('AUCTIONBLOX_SUBMIT_BUTTON', abx_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE));

      define('AUCTIONBLOX_POWERED_LOGO', sprintf(
        '<a href="http%s://www.auctionblox.com" target="_blank"><img src="includes/modules/auctionblox/images/abx.gif" border="0" width="90" height="20" alt="Powered by AuctionBlox.com" title="Powered by AuctionBlox.com" /></a>',
        $request_type === 'SSL' ? 's' : '')
      );

      return $page;
    }

  }//end class
?>