<?php
/*
  $Id: configure.php,v 1.13 2008/03/13 14:33:02 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  require_once(DIR_FS_ABX_CLASSES . 'abxConfiguration.php');

  require_once(DIR_FS_ABX_CLASSES . 'abxAccount.php');
  
  require_once(DIR_FS_ABX_CLASSES . 'Page/abxPageFactory.php');  

  class abxModule_Configure extends abxModule {

    function abxModule_Configure()
    {
      if (empty($_POST) === false)
        $this->process();
    }

    function process()
    {
      switch ($_POST['perform']) {

        case 'downloadAccounts':

          if (abxAccount::configure()) {

            abxMessageStack::add_session(TEXT_ACCOUNT_UPDATED_SUCCESSFULLY,'success');

            abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=configure-account'));

          } else {

            abxMessageStack::add_session(ERROR_ACCOUNT_UPDATE_FAILED,'error');

            abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=configure-account'));

          }

          break;

        case 'saveGeneralConfig':

          abxConfiguration::update($_POST['oID'],$_POST['configuration_value']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=configure-general'));

          break;
      }
    }

    function display()
    {
      global $abx;

      switch (next($abx)) {

        case 'account':

          $page = abxPageFactory::newPaginator('abx_accounts');

          $page->paginatorQuery( abxAccount::paginatorAccountsQuery() );

          $page->includeLanguageFile('abx_account');

          $page->generatePaginatorContent();

          break;

        case 'general':

          $page = abxPageFactory::newPaginator('abx_configure');

          $page->paginatorQuery( abxConfiguration::paginatorQuery() );

          $page->includeLanguageFile('abx_general');

          $page->generatePaginatorContent();

          break;

      }

      return $page;
    }

  }//end class
?>
