<?php
/*
  $Id: generator.php,v 1.14 2008/03/31 18:22:19 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  require_once(DIR_FS_ABX_CLASSES . 'abxItemTemplates.php');
  require_once(DIR_FS_ABX_CLASSES . 'Page/abxPageFactory.php');  
  require_once DIR_FS_ABX_CLASSES . 'Page/abxCollatedPaginator.php';
  require_once(DIR_FS_ABX_CLASSES . 'catalog/abxCatalogService.php');  

  class abxModule_Generator extends abxModule {

    function abxModule_Generator()
    {
      if (empty($_POST) === false)
        $this->process();
    }

    function process()
    {
      switch($_POST['perform']) 
      {
        case 'GenerateConfirm':
          $abxItemTemplates = new abxItemTemplates;
          $abxItemTemplates->generateItems($_POST);
          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=items'));
          break;
      }
    }

    function display()
    {
      $abxItemTemplates = new abxItemTemplates;

      $page = abxPageFactory::newCollatedPaginator('items_generator');

      $page->paginatorQuery( $abxItemTemplates->getProductsQuery($page->filterBy()) );
      $page->addChildQuery("products_id", "app_data", "select app_data, sum(quantity)-sum(quantity_sold) as quantity_active FROM abx_listings WHERE status = 'A'", "GROUP BY app_data");          
      $page->addChildQuery("products_id", "app_data", "select l.app_data, sum(l.quantity) as quantity_pending FROM abx_listings l, abx_schedule_info si WHERE l.uuid = si.uuid AND l.status = 'P'", "GROUP BY app_data");          
      $page->addChildQuery("products_id", "products_id", "select products_id, sum(quantity) as quantity_reserved FROM abx_basket where listing_status = 3 AND archived = 0", "GROUP BY products_id");          

      $page->addJavaScript('items_generator.js');
		$page->addJavaScript('lazyimages.js');
      $page->includeLanguageFile('items_generator');
      $page->generatePaginatorContent();

      return $page;
    }

  }//end class
?>