<?php
/*
  $Id: items.php,v 1.26 2008/03/13 14:33:02 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/
  require_once(DIR_FS_ABX_CLASSES . 'abxItemManager.php');
  require_once(DIR_FS_ABX_CLASSES . 'abxItemTemplates.php');
  require_once(DIR_FS_ABX_CLASSES . 'Page/abxPageFactory.php');  
  require_once DIR_FS_ABX_CLASSES . 'Page/abxCollatedPaginator.php';
  require_once(DIR_FS_ABX_CLASSES . 'catalog/abxCatalogService.php');

  class abxModule_Items extends abxModule {

    function abxModule_Items()
    {
      if (empty($_POST) === false)
        $this->process();
    }

    function process()
    {
      global $abx;

      switch($_POST['perform']) {
        case 'save':
          $_POST['description'] = $_POST['spaw2'];
    
          switch(next($abx)) {

            case 'edit':
			       $abxItemManager = new abxItemManager;
             $id = $abxItemManager->updateItem($_POST, $_POST['oID']);
              break;

            case 'copy':
            case 'new':
              $abxItemManager = new abxItemManager;
              $id = $abxItemManager->insertItem($_POST);
              break;
              
            case 'generate':
				      $abxItemTemplates = new abxItemTemplates;
				      $_POST['templateid'] = $_POST['oID'];
				      $_POST['abxList'][] = $_POST['products_id'];
				      $id = $abxItemTemplates->generateItems($_POST);
            	break;
          }

          if (prev($abx) == 'items')

            if (strpos($_GET['abx'],'upload') && empty($id) === false) {

              $_POST['oID']             = (int)$id;
              $_POST['abx_last']        = $_GET['abx'];
              $_POST['perform']         = 'AddListings';

              next($abx);

            } else {

              abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=items'.abxPage::getSearchParams()));

            }

          elseif (current($abx) == 'templates')

            abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=templates'.abxPage::getSearchParams()));

          break;

        case 'Add2UploadConfirm':

          require_once(DIR_FS_ABX_CLASSES . 'abxItemUploads.php');
          $abxItemUploads = new abxItemUploads();

          $uploads = $abxItemUploads->queueAddItems($_POST['abxList']);

          if (empty($uploads) === false)
            abxMessageStack::add_session(sprintf(ABX_TEXT_NUMBER_ADDED_TO_UPLOAD_MANAGER,count($uploads)), 'success');

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=items'.abxPage::getSearchParams()));

          break;

        case 'DeleteConfirm':

          $abxItemManager = new abxItemManager;
          $abxItemManager->deleteItems($_POST['abxList']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=items'.abxPage::getSearchParams()));

          break;
      }

    }

    function display()
    {
      global $abx;

      $abxItemManager = new abxItemManager;

      $oID = (empty($_POST['oID']) === false) ? $_POST['oID'] : ((empty($_GET['oID']) === false) ? $_GET['oID'] : ((empty($_GET['itemID']) === false) ? $abxItemManager->getID($_GET['itemID']) : '') );

      switch(next($abx)) {

        case 'edit':
        case 'copy':
          if (empty($oID) === true) {
            abxMessageStack::add_session(ERROR_TEXT_LISTING_NOT_AVAILABLE, 'error');
            abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX, 'abx=items'));
          }

        case 'new':
        case 'generate':
          $page = new abxPage;
          $page->includeLanguageFile('items_new');
          $page->addJavaScript('items_new.js');
          //$page->addCSS('tabs.css', DIR_WS_ABX_EXTERNAL . 'jquery/tabs');
          //$page->addCSS('tabs_ie.css', DIR_WS_ABX_EXTERNAL . 'jquery/tabs');
          $page->setContentFile('items_new');
          $page->vars = $abxItemManager->newItem($oID,$_POST);
          break;

        case 'products':
          $page = abxPageFactory::newPaginator('items_product_search');
          $page->paginatorQuery( $abxItemManager->getProductsQuery($page->filterBy()) );
          $page->addJavaScript('items_product_search.js');
          $page->includeLanguageFile('items_products');
          $page->generatePaginatorContent();
          $page->setTitle(HEADING_TITLE);
          $page->setTemplate('popup');
          $page->no_close = true;
          break;

        case 'upload':
          $page = new abxPage;
          $page->addCalendar();
          $page->setContentFile('items_scheduler');
          $page->includeLanguageFile('items_scheduler');
          break;

        default:
          $page = abxPageFactory::newCollatedPaginator('items');
          $page->paginatorQuery( $abxItemManager->getItemsPaginatorQuery() );
          $page->addChildQuery("uuid", "item_uuid", "select l.item_uuid, l.status from abx_listings l", "GROUP BY l.item_uuid, l.status ORDER BY l.id desc");
		  $page->addJavaScript('lazyimages.js');
          $page->includeLanguageFile('items');
          $page->generatePaginatorContent();
          break;
      }

      return $page;
    }

  }//end class
?>