<?php
/*
  $Id: sales.php,v 1.40 2008/03/13 14:33:02 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  require_once(DIR_FS_ABX_CLASSES . 'abxSales.php');

  require_once(DIR_FS_ABX_CLASSES . 'abxSaleItem.php');

  require_once(DIR_FS_ABX_CLASSES . 'Page/abxPageFactory.php');

  class abxModule_Sales extends abxModule {

    function abxModule_Sales()
    {
      $this->process();
    }
    
    function process()
    {
      global $abxDatabase, $abxSales;

      $abxSales = new abxSales;

      require_once(DIR_FS_ABX_CLASSES . 'abxSalesFeedback.php');

      $abxSalesFeedback = new abxSalesFeedback;

      if (empty($_POST['perform']) === false)
        $profilesExists = (count(abxConstants::getProfilesDropDown()) > 0) ? true : false;

      switch($_POST['perform']) {

        case 'DeleteConfirm':

          $abxSales->remove($_POST['abxList']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=sales'.abxPage::getSearchParams()));

          break;

        case 'ChangeStatusConfirm':

          $abxSales->updateStatus($_POST['abxList'],$_POST['statusID']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=sales&filter='.$_POST['statusID'].abxPage::getSearchParams(array('filter'))));

          break;

        case 'InvoiceConfirm':

          if ($profilesExists === true)
            $abxSales->sendInvoice($_POST['abxList']);
          else
            abxMessageStack::add_session(ERROR_TEXT_NO_PROFILES_EXIST,'error');

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=sales'.abxPage::getSearchParams()));

          break;

        case 'CourtesyReminderConfirm':

          if ($profilesExists === true)
            $abxSales->sendReminder($_POST['abxList']);
          else
            abxMessageStack::add_session(ERROR_TEXT_NO_PROFILES_EXIST,'error');

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=sales'.abxPage::getSearchParams()));

          break;

        case 'WarningEmailConfirm':

          if ($profilesExists === true)
            $abxSales->sendWarning($_POST['abxList']);
          else
            abxMessageStack::add_session(ERROR_TEXT_NO_PROFILES_EXIST,'error');

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=sales'.abxPage::getSearchParams()));

          break;

        case 'insertSaleItem':

          $abxSaleItem = new abxSaleItem;

          $abxSaleItem->insert($_POST);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=sales&filter='.$_POST['statusID'].abxPage::getSearchParams(array('filter'))));

          break;

        case 'UpdateSaleItem':

          $abxSaleItem = new abxSaleItem;

          $abxSaleItem->update($_POST['oID'],$_POST);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=sales&filter='.$_POST['statusID'].abxPage::getSearchParams(array('filter'))));

          break;

        case 'PositiveFeedbackConfirm':

          $abxSalesFeedback->leavePositiveFeedback($_POST['abxList']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx='.$_POST['abx_last'].abxPage::getSearchParams()));

          break;

        case 'NeutralFeedbackConfirm':

          $abxSalesFeedback->leaveNeutralFeedback($_POST['abxList']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx='.$_POST['abx_last'].abxPage::getSearchParams()));

          break;

        case 'NegativeFeedbackConfirm':

          $abxSalesFeedback->leaveNegativeFeedback($_POST['abxList']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx='.$_POST['abx_last'].abxPage::getSearchParams()));

          break;

        case 'UpdateDisputeStatus':

          $abxDatabase->update(TABLE_ABX_BASKET, array('workflow_state' => $_POST['nextWorkflowState']),'auction_basket_id = ' . (int)$_POST['oID']);

          abxMessageStack::add_session(TEXT_SUCCESS, 'success');

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=sales-dispute&oID='. (int)$_POST['oID'] .'&state='.$_POST['nextWorkflowState'].abxPage::getSearchParams()));

          break;

        case 'insertOrUpdateOrder':

          require_once(DIR_FS_ABX_FUNCTIONS.'sales_order.php');

          abxPage::includeLanguageFile('sales_order');

          require_once(DIR_FS_ABX_CLASSES . 'abxOrder.php');

          global $order;
          $order = new abxOrder($_GET['oID']);
          $order->ShippingModules = new abxShippingModules();

          $order_id = $order->insertOrUpdateOrder($_POST);

          if(empty($order_id) === false)
            abxPage::redirect(abx_href_link(FILENAME_ORDERS, 'oID=' . $order_id));

          break;

        case 'downloadConfirm':

          $abxSales->downloadSales($_POST['seller_id']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=sales'.abxPage::getSearchParams()));

          break;

        case 'downloadFeedbackConfirm':

          $abxSalesFeedback->downloadFeedback($_POST['seller_id']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=sales-feedback'));

          break;

        case 'ArchiveConfirm':

          $abxSales->archive($_POST['abxList'], $_POST['paid'], $_POST['shipped'], $_GET['filter']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=sales'.abxPage::getSearchParams()));

          break;

        case 'RestoreArchivedConfirm':

          $abxSales->restoreArchived($_POST['abxList']);

          abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX,'abx=sales-archived'.abxPage::getSearchParams()));

          break;

      }

    }

    function &display()
    {
      global $abx, $abxSales, $order;
      
      $abxSaleItem = new abxSaleItem;

      switch(next($abx)) {

        case 'dispute':

          $page = new abxPage;

          $page->setBaseURL(DIR_WS_ABX);

          $page->setContentFile('sales_dispute');

          $page->includeLanguageFile('sales_dispute');

          $page->setTitle(HEADING_TITLE);

          $page->setTemplate('popup');

          $page->vars = $abxSaleItem->getSale($_GET['oID']);

          break;

        case 'item' :

          $page = new abxPage;

          if (class_exists('abxItemManager') === false) {

            require_once(DIR_FS_ABX_CLASSES . 'abxItemManager.php');

          }

          $page->includeLanguageFile('sales_item');

          $sale = array();

          switch(next($abx)) {

            case 'edit':

              $abxItemManager = new abxItemManager;

              $sale = $abxSaleItem->getSale($_GET['oID']);

            break;

          }

          $sale['productName'] = (empty($sale['productID']) === false) ? $abxItemManager->getProductNameByID($sale['productID']) : ABX_TEXT_NO_PRODUCT_SELECTED;
          $sale['qty']         = (empty($sale['qty']) === true) ? '1' : $sale['qty'];

          $page->vars = $sale;

          $page->setContentFile('sales_item');

          break;

        case 'feedback':

          $page = abxPageFactory::createWebServicePaginator('sales_feedback');

          $page->includeLanguageFile('sales_feedback');

          $page->generatePaginatorContent();

          break;

        case 'reports':

          $page = new abxPage;

          $page->includeLanguageFile('sales_reports');

          require_once(DIR_FS_ABX_EXTERNAL_CART . 'includes/classes/abxSalesReport.php');

          $report = new abxSalesReport($_GET['report'],$_GET['startDate'],$_GET['endDate'],$_GET['filter']);

          $page->addJavaScript('graph.js',DIR_FS_ABX_EXTERNAL_CART . 'includes/javascript/jsgraph');

          $page->setContent($report->display());

          break;

        case 'order':

          if (class_exists('abxOrder') === false) { //entry hasn't been submitted yet.

            require_once(DIR_FS_ABX_FUNCTIONS.'sales_order.php');

            require_once(DIR_FS_ABX_CLASSES . 'abxOrder.php');

            global $order;
            $order = new abxOrder($_GET['oID']);


            $order->calculateCart();

          }
          $_SESSION['cart'] = new shoppingCart;
          $order->ShippingModules = new abxShippingModules();

          $page = new abxPage;

          $page->addJavaScript('sales_order.js.php');

          $page->setContentFile('sales_order');

          $page->includeLanguageFile('sales_order');

          break;

        case 'checkoutButton':

          $page = new abxPage;

          $page->includeLanguageFile('sales_checkout_button');

          $page->setContentFile('sales_checkout_button');

          break;

        case 'archived':

          $page = abxPageFactory::newPaginator('sales_archived');

          $page->paginatorQuery($abxSales->getArchivedSalesPaginatorQuery($page->filterBy(), $page->orderStatusBy()));

          $page->includeLanguageFile('sales');

          $page->generatePaginatorContent();

          break;

        default:
          $page = abxPageFactory::newPaginator('sales');
          $page->paginatorQuery($abxSales->getSales($page->filterBy(), $page->orderStatusBy()) );
          $page->includeLanguageFile('sales');
          $page->generatePaginatorContent();
          break;
      }

      return $page;
    }

  }//end class
?>
