<?php
/*
  Contribution by Emmanuel Alliel <manu@maboutique.biz> 2003-07-15
	Update by Marquis 2007-04-29
	Update by Vincent Raffner <raffner@parasolder.com> 2007-08-06
	
  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

class paybox {
	var $code, $title, $description, $enabled, $url_http;

// class constructor
	function paybox() {
		global $order;

		$this->code = 'paybox';
		$this->title = MODULE_PAYMENT_PAYBOX_TEXT_TITLE;
		$this->description = MODULE_PAYMENT_PAYBOX_TEXT_DESCRIPTION;
		$this->sort_order = MODULE_PAYMENT_PAYBOX_SORT_ORDER;
		$this->enabled = ((MODULE_PAYMENT_PAYBOX_STATUS == 'True') ? true : false);
	    $this->icon = DIR_WS_ICONS . 'paiement_cb.jpg'; //NBen je rajoute cette notion pour affichage logo SPPLUS
		$this->url_http = ((MODULE_PAYMENT_PAYBOX_URL_HTTP == 'True') ? true : false);

		if ((int)MODULE_PAYMENT_PAYBOX_ORDER_STATUS_ID > 0) {
			$this->order_status = MODULE_PAYMENT_PAYBOX_ORDER_STATUS_ID;
		}

		if (is_object($order)) $this->update_status();

		$this->form_action_url = MODULE_PAYMENT_PAYBOX_CGI;
	}

// class methods
	function update_status() {
		global $order;

		if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_PAYBOX_ZONE > 0) ) {
			$check_flag = false;
			$check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_PAYBOX_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
			while ($check = tep_db_fetch_array($check_query)) {
				if ($check['zone_id'] < 1) {
					$check_flag = true;
					break;
				} elseif ($check['zone_id'] == $order->billing['zone_id']) {
					$check_flag = true;
					break;
				}
			}

			if ($check_flag == false) {
				$this->enabled = false;
			}
		}
	}

	function javascript_validation() {
		return false;
	}

	function selection() {
		return array('id' => $this->code,
								 'module' => $this->title, 'icon' => $this->icon);
	}

	function pre_confirmation_check() {
		return false;
	}

	function confirmation() {
		return false;
	}

	function process_button() {
		global $order, $language;

		switch ($language) {
		case 'french':
			$pbx_langue = 'FRA';
			break;
		case 'espanol':
			$pbx_langue = 'ESP';
			break;
		case 'italian':
			$pbx_langue = 'ITA';
			break;
		case 'german':
			$pbx_langue = 'DEU';
			break;
		case 'dutch':
			$pbx_langue = 'NLD';
			break;
		case 'swedish':
			$pbx_langue = 'SWE';
			break;
		case 'english':
		default:
			$pbx_langue = 'GBR';
			break;
		}
						//					 			 tep_draw_hidden_field('PBX_PAYBOX', 'https://preprod-tpeweb.paybox.com/cgi/MYchoix_pagepaiement.cgi') . 

		$process_button_string = tep_draw_hidden_field('PBX_MODE', '1') .
														 tep_draw_hidden_field('PBX_SITE', MODULE_PAYMENT_PAYBOX_PBX_SITE) .
														 tep_draw_hidden_field('PBX_RANG', MODULE_PAYMENT_PAYBOX_PBX_RANG) .
														 tep_draw_hidden_field('PBX_IDENTIFIANT', MODULE_PAYMENT_PAYBOX_PBX_IDENTIFIANT) .
														 tep_draw_hidden_field('PBX_TOTAL', '0'.round($order->info['total'], 2) * 100) .
														 tep_draw_hidden_field('PBX_DEVISE', '978') .
														 tep_draw_hidden_field('PBX_LANGUE', $pbx_langue) .
											 			 tep_draw_hidden_field('PBX_PORTEUR', $order->customer['email_address']) .
														 tep_draw_hidden_field('PBX_REFUSE', tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=' . $this->code, 'SSL', true, false)) .
														 tep_draw_hidden_field('PBX_REPONDRE_A', tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL', true, false)) .
														 tep_draw_hidden_field('PBX_ANNULE', tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL', true, false));
														 
		if ($this->url_http) {
			$process_button_string .= tep_draw_hidden_field('PBX_RUF1', 'POST') .
																tep_draw_hidden_field('PBX_CMD', tep_session_id()) .
																tep_draw_hidden_field('PBX_RETOUR', 'pbx_montant:M;' . tep_session_name() . ':R;pbx_auto:A;pbx_trans:T;pbx_erreur:E;pbx_sign:K') .
																tep_draw_hidden_field('PBX_EFFECTUE', tep_href_link(FILENAME_CHECKOUT_SUCCESS, '', 'SSL', true, false));
		} else {
			$process_button_string .= tep_draw_hidden_field('PBX_CMD', $order->customer['email_address'] . '_' . date('Y-m-d_H:i:s')) .
																tep_draw_hidden_field('PBX_RETOUR', 'pbx_montant:M;pbx_ref:R;pbx_auto:A;pbx_trans:T;pbx_erreur:E;pbx_sign:K') .
																tep_draw_hidden_field('PBX_EFFECTUE', tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL', true, false));
		}

		return $process_button_string;
	}

	function before_process() {
		global $HTTP_GET_VARS, $HTTP_POST_VARS;

		// vrification des adresses IP des serveurs de paiement
		if (MODULE_PAYMENT_PAYBOX_IP) {
			$unauthorized_server = true;
			$authorized_ips = preg_split('/[\s,]+/', MODULE_PAYMENT_PAYBOX_IP);
			foreach ($authorized_ips as $authorized_ip) {
				if ($_SERVER['REMOTE_ADDR'] == $authorized_ip) {
					$unauthorized_server = false;
					break;
				}
			}
			if ($unauthorized_server) {
				if ($this->url_http) exit();
			}
		}

		// vrification du code erreur
		if ($this->url_http) $pbx_erreur = $HTTP_POST_VARS['pbx_erreur'];
		else $pbx_erreur = $HTTP_GET_VARS['pbx_erreur'];
		switch ($pbx_erreur) {
			case '00000':
				break;
			default:
				if ($this->url_http) exit();
				else tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=' . $this->code, 'SSL', true, false));
		}
		
		// vrification de la signature
		$fp = fopen(MODULE_PAYMENT_PAYBOX_PUBKEY, 'r');
		$public_key = fread($fp, 8192);
		fclose($fp);
		if ($public_key) {
			if ($this->url_http) $vars = $HTTP_POST_VARS;
			else $vars = $HTTP_GET_VARS;
			foreach ($vars as $key => $val) {
				if ($key == 'pbx_sign') $pbx_sign = $val;
				else $pbx_retour .= '&' . $key . '=' . $val;
			}
			$pbx_retour = substr($pbx_retour, 1);
			$pbx_sign = base64_decode($pbx_sign);
			$public_key = openssl_pkey_get_public($public_key);
			if (openssl_verify($pbx_retour, $pbx_sign, $public_key) != 1) {
				if ($this->url_http) exit();
				else tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=' . $this->code, 'SSL', true, false));
			}
		}		
		
		return false;
	}

	function after_process() {
		global $cart;

		// on termine le checkout_process ici (pour l'url http uniquement)
    if ($this->url_http) {
			$cart->reset(true);
			tep_session_unregister('sendto');
			tep_session_unregister('billto');
			tep_session_unregister('shipping');
			tep_session_unregister('payment');
			tep_session_unregister('comments');
			tep_session_unregister('coupon');
			require(DIR_WS_INCLUDES . 'application_bottom.php');
			exit();
		}

		return false;
	}

	function get_error() {
		global $HTTP_GET_VARS;

		if (isset($HTTP_GET_VARS['message']) && (strlen($HTTP_GET_VARS['message']) > 0)) {
			$error = stripslashes(urldecode($HTTP_GET_VARS['message']));
		} else {
			$error = MODULE_PAYMENT_PAYBOX_TEXT_ERROR_MESSAGE;
		}

		return array('title' => MODULE_PAYMENT_PAYBOX_TEXT_ERROR,
								 'error' => $error);
	}

	function check() {
		if (!isset($this->_check)) {
			$check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_PAYBOX_STATUS'");
			$this->_check = tep_db_num_rows($check_query);
		}
		return $this->_check;
	}

	function install() {
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Enable Paybox Module', 'MODULE_PAYMENT_PAYBOX_STATUS', 'True', 'Activer ce module Paybox ?', '6', '1', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('PBX_SITE', 'MODULE_PAYMENT_PAYBOX_PBX_SITE', '0123456', 'PBX_SITE fourni par Paybox', '6', '2', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('PBX_RANG', 'MODULE_PAYMENT_PAYBOX_PBX_RANG', '01', 'PBX_RANG fourni par Paybox', '6', '3', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('PBX_IDENTIFIANT', 'MODULE_PAYMENT_PAYBOX_PBX_IDENTIFIANT', '0123345678', 'PBX_IDENTIFIANT fourni par Paybox', '6', '4', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Module CGI', 'MODULE_PAYMENT_PAYBOX_CGI', 'http://www.maboutique.biz/cgi-bin/paybox.cgi', 'Chemin de votre module CGI', '6', '5', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('URL HTTP', 'MODULE_PAYMENT_PAYBOX_URL_HTTP', 'False', 'Utiliser l\'url http (validation automatique des commandes) ?', '6', '6', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('IP serveurs', 'MODULE_PAYMENT_PAYBOX_IP', '195.101.99.76,195.101.99.77,62.39.109.166,194.50.38.6', 'Adresses IP des serveurs de paiement', '6', '7', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Cl publique Paybox', 'MODULE_PAYMENT_PAYBOX_PUBKEY', 'http://www.maboutique.biz/pub/pubkey.pem', 'Chemin du fichier pubkey.pem', '6', '8', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sort order of display.', 'MODULE_PAYMENT_PAYBOX_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', '6', '9', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Payment Zone', 'MODULE_PAYMENT_PAYBOX_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', '6', '10', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('Set Order Status', 'MODULE_PAYMENT_PAYBOX_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', '6', '11', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");
	}

	function remove() {
		tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
	}

	function keys() {
		return array('MODULE_PAYMENT_PAYBOX_STATUS', 'MODULE_PAYMENT_PAYBOX_PBX_SITE', 'MODULE_PAYMENT_PAYBOX_PBX_RANG', 'MODULE_PAYMENT_PAYBOX_PBX_IDENTIFIANT', 'MODULE_PAYMENT_PAYBOX_CGI', 'MODULE_PAYMENT_PAYBOX_URL_HTTP', 'MODULE_PAYMENT_PAYBOX_IP', 'MODULE_PAYMENT_PAYBOX_PUBKEY', 'MODULE_PAYMENT_PAYBOX_ZONE', 'MODULE_PAYMENT_PAYBOX_ORDER_STATUS_ID', 'MODULE_PAYMENT_PAYBOX_SORT_ORDER');
	}
}
?>