<?php
/*
  French Chronopost Shipping module version 20081220
  This module has been adapted to fit in the osCommerce 2.2 MS2-051113.

  Copyright  2008 Philippe BLAIN <pblain@free.fr>
  
  TARIFS HORS TAXES 2010
*/

  define ('MODULE_SHIPPING_CHRONOPOST_LIMIT', 30);         /* Poids maximum accept en Kgs */
  define ('MODULE_SHIPPING_CHRONOPOST_SUPP_CORSE', 10.0);  /* Supplment EUR HT pour CORSE */
  define ('MODULE_SHIPPING_CHRONOPOST_ENLEVEMENT', 11);    /* Enlvement sur demande */

  class chronopost {
	var $code, $title, $description, $sort_order, $icon, $tax_class, $international, $avec_enlevement, $avec_assurance, $enabled, $table, $quotes;

	/***** Class constructor *****/
	function chronopost() {
		global $order;

		$this->code            = 'chronopost';
		$this->title           = MODULE_SHIPPING_CHRONOPOST_TEXT_TITLE;
		$this->description     = MODULE_SHIPPING_CHRONOPOST_TEXT_DESCRIPTION;
		$this->sort_order      = MODULE_SHIPPING_CHRONOPOST_SORT_ORDER;
		$this->icon            = DIR_WS_ICONS . 'shipping_chronopost.gif';
		$this->icon2           = DIR_WS_ICONS . 'chrono_13.gif';
		$this->icon3           = DIR_WS_ICONS . 'chrono_int.gif';
		$this->tax_class       = MODULE_SHIPPING_CHRONOPOST_TAX_CLASS;
		$this->international   = ((MODULE_SHIPPING_CHRONOPOST_INTERNATIONAL_ENABLED == 'True') ? true : false);
		$this->avec_enlevement = ((MODULE_SHIPPING_CHRONOPOST_AVEC_ENLEVEMENT == 'True') ? true : false);
		$this->avec_assurance  = ((MODULE_SHIPPING_CHRONOPOST_AVEC_ASSURANCE == 'True') ? true : false);
		$this->enabled         = ((MODULE_SHIPPING_CHRONOPOST_STATUS == 'True') ? true : false);

   /* Seulement au dpart de France mtropolitaine et Monaco */
    $shipping_country_query = tep_db_query("select countries_iso_code_2 from " . TABLE_COUNTRIES . " where countries_id = '" . SHIPPING_ORIGIN_COUNTRY . "' limit 1");
    $shipping_country = tep_db_fetch_array($shipping_country_query);
    if (($shipping_country['countries_iso_code_2'] != 'FR') && ($shipping_country['countries_iso_code_2'] != 'FX') && ($shipping_country['countries_iso_code_2'] != 'MC')) $this->enabled = false;

		/* DEFINITIONS DES ZONES TARIFAIRES CHRONOPOST */
    $this->table = array (
      array (
        'desc' => 'Zone tarifaire Domestique Chrono 13 (vers France mtropolitaine et Monaco)',
        'iso_codes' => 'FR,FX,MC',
        'tarif' => '0.5:2.5,5:12.5,10:16.66,30:33.33,30:51.6',
        'supp' => 0.0,
        'tarif_int' => '2:17,5:19.45,6:20.30,7:21.15,8:22,9:22.85,10:23.7',
        'supp_int' => 0.85
      ),
/* zone tarifaires vierge pour international et dom-tom '0.5:,1:,1.5:,2:,2.5:,3:,3.5:,4:,4.5:,5:,5.5:,6:,6.5:,7:,7.5:,8:,8.5:,9:,9.5:,10:' */
      array (
        'desc' => 'Zone tarifaire 1 (vers l\'Union Europenne)',
        'iso_codes' => 'BE,DE,LU,NL',
        'tarif' => '0.5:2.5,5:12.5,10:16.66,30:33.33,30:51.6',
        'supp' => 3,
        'tarif_int' => '0.5:33.1,1:37.4,1.5:41.7,2:46,2.5:50.3,3:54.6,3.5:58.9,4:63.2,4.5:67.5,5:71.8,5.5:76.1,6:80.4,6.5:84.7,7:89,7.5:93.3,8:97.6,8.5:101.9,9:106.2,9.5:110.5,10:114.8',
        'supp_int' => 2.50
      ),

      array (
        'desc' => 'Zone tarifaire 2 (vers l\'Union Europenne)',
        'iso_codes' => 'AT,DK,ES,ES,ES,FI,GB,GR,IE,IT,PT,SE',
        'tarif' => '0.5:43.32,1:48.96,1.5:54.6,2:60.24,2.5:65.88,3:71.52,3.5:77.16,4:82.8,4.5:88.44,5:94.08,5.5:99.72,6:105.36,6.5:111,7:116.64,7.5:122.28,8:127.92,8.5:133.56,9:139.2,9.5:144.84,10:150.48',
        'supp' => 4.08,
        'tarif_int' => '0.5:36.4,1:41.1,1.5:45.8,2:50.5,2.5:55.2,3:59.9,3.5:64.6,4:69.3,4.5:74,5:78.7,5.5:83.4,6:88.1,6.5:92.8,7:97.5,7.5:102.2,8:106.9,8.5:111.6,9:116.3,9.5:121,10:125.7',
        'supp_int' => 3.40
      ),

      array (
        'desc' => 'Zone tarifaire 3 (vers l\'Union Europenne)',
        'iso_codes' =>'BG,CY,CZ,EE,HU,LT,LV,MT,PL,RO,SI,SK',
        'tarif' => '0.5:80.91,1:95.51,1.5:110.11,2:124.71,2.5:139.31,3:153.91,3.5:164.61,4:175.31,4.5:186.01,5:196.71,5.5:207.41,6:218.11,6.5:228.81,7:239.51,7.5:250.21,8:260.91,8.5:271.61,9:282.31,9.5:293.01,10:303.71',
        'supp' => 8.8,
        'tarif_int' => '0.5:67.3,1:81.9,1.5:96.5,2:111.1,2.5:125.7,3:140.3,3.5:153,4:165.7,4.5:178.4,5:191.1,5.5:201.8,6:212.5,6.5:223.2,7:233.9,7.5:244.6,8:255.3,8.5:266,9:276.7,9.5:287.4,10:298.1',
        'supp_int' => 7.60
      ),

      array (
        'desc' => 'Zone tarifaire 4',
        'iso_codes' => 'AD,AL,AM,BA,BY,CH,FO,GE,GI,GS,HR,IC,IS,JE,LI,MD,ME,MK,NO,RS,RU,SM,TR,UA,VA',
        'tarif' => '0.5:75.71,1:84.22,1.5:92.73,2:101.24,2.5:109.75,3:118.26,3.5:125.26,4:132.26,4.5:139.26,5:146.26,5.5:152.26,6:158.26,6.5:164.26,7:168.26,7.5:172.26,8:176.26,8.5:180.26,9:184.26,9.5:188.26,10:192.26',
        'supp' => 4.32,
        'tarif_int' => '0.5:64.2,1:71.6,1.5:79,2:86.4,2.5:93.8,3:101.2,3.5:106.9,4:112.6,4.5:118.3,5:124,5.5:127.6,6:131.2,6.5:134.8,7:138.4,7.5:142,8:145.6,8.5:149.2,9:152.8,9.5:156.4,10:160',
        'supp_int' => 3.60
      ),

      array (
        'desc' => 'Zone tarifaire 5',
        'iso_codes' => 'AG,AI,AN,AR,AW,BB,BM,BO,BR,BS,BZ,CA,CL,CO,CR,CU,DM,DO,EC,GD,GL,GT,GY,HN,HT,JM,KN,KY,LC,MS,MX,NI,PA,PE,PR,PY,SR,SV,TC,TT,US,UY,VC,VE,VG,VI',
        'tarif' => '0.5:86.51,1:96.51,1.5:106.51,2:116.51,2.5:126.51,3:136.51,3.5:141.01,4:145.51,4.5:150.01,5:154.51,5.5:159.01,6:163.51,6.5:168.01,7:172.51,7.5:177.01,8:181.51,8.5:186.01,9:190.51,9.5:195.01,10:199.51',
        'supp' => 7.80,
        'tarif_int' => '0.5:73.4,1:81.8,1.5:90.2,2:98.6,2.5:107,3:115.4,3.5:118.6,4:121.8,4.5:125,5:128.2,5.5:132.3,6:136.4,6.5:140.5,7:144.6,7.5:148.7,8:152.8,8.5:156.9,9:161,9.5:165.1,10:169.2',
        'supp_int' => 6.50
      ),

      array (
        'desc' => 'Zone tarifaire 6',
        'iso_codes' => 'AE,AO,AZ,BF,BH,BI,BJ,BW,CD,CF,CG,CI,CM,CV,DJ,DZ,EG,ER,ET,GA,GH,GM,GN,GQ,GW,IL,IQ,IR,JO,KE,KM,KW,LB,LR,LS,LY,MA,MG,ML,MR,MU,MW,MZ,NA,NE,NG,OM,PS,QA,RW,SA,SC,SD,SL,SN,SO,ST,SY,SZ,TD,TG,TN,TZ,UG,YE,ZA,ZM,ZW',
        'tarif' =>  '0.5:97.93,1:115.32,1.5:132.7,2:150.09,2.5:167.48,3:184.87,3.5:195.34,4:205.81,4.5:216.28,5:226.75,5.5:237.45,6:248.15,6.5:258.85,7:269.65,7.5:280.25,8:290.95,8.5:301.65,9:312.35,9.5:323.05,10:333.75',
        'supp' => 12.72,
        'tarif_int' => '0.5:83.2,1:97.6,1.5:112,2:126.4,2.5:140.8,3:155.2,3.5:164.3,4:173.4,4.5:182.5,5:191.6,5.5:200.9,6:210.2,6.5:219.5,7:228.8,7.5:238.1,8:247.4,8.5:256.7,9:266,9.5:275.3,10:284.6',
        'supp_int' => 10.60
      ),

      array (
        'desc' => 'Zone tarifaire 7',
        'iso_codes' => 'AF,AS,AU,BD,BN,BT,CC,CK,CN,CX,FJ,FM,GU,HK,ID,IN,JP,KG,KH,KI,KR,KZ,LA,LK,MH,MM,MN,MO,MP,MV,MY,NF,NP,NR,NZ,PG,PH,PK,PW,SB,SG,TH,TJ,TL,TM,TO,TV,TW,UZ,VN,VU,WS',
        'tarif' =>  '0.5:103.02,1:121.37,1.5:139.72,2:158.08,2.5:176.43,3:194.79,3.5:205.83,4:216.87,4.5:227.91,5:238.95,5.5:250.22,6:261.49,6.5:272.76,7:284.03,7.5:295.3,8:306.57,8.5:317.84,9:329.11,9.5:340.38,10:351.65',
        'supp' => 13.32,
        'tarif_int' => '0.5:87.5,1:102.7,1.5:117.9,2:133.1,2.5:148.3,3:163.5,3.5:173.1,4:182.7,4.5:192.3,5:201.9,5.5:211.7,6:221.5,6.5:231.3,7:241.1,7.5:250.9,8:260.7,8.5:270.5,9:280.3,9.5:290.1,10:299.9',
        'supp_int' => 11.10
      ),

      array (
        'desc' => 'Zone tarifaire 8 (vers DOM)',
        'iso_codes' => 'GP,MI,MQ,RE',
        'tarif' => '0.5:84.51,1:94.77,1.5:105.04,2:115.3,2.5:125.56,3:135.83,3.5:140.33,4:144.83,4.5:149.33,5:153.83,5.5:158.33,6:162.83,6.5:167.33,7:171.83,7.5:176.33,8:180.83,8.5:185.33,9:189.83,9.5:194.33,10:198.83',
        'supp' => 6.60,
        'tarif_int' => '0.5:71.4,1:79.9,1.5:88.4,2:96.9,2.5:105.4,3:113.9,3.5:117.5,4:121.1,4.5:124.7,5:128.3,5.5:132.4,6:136.5,6.5:140.6,7:144.7,7.5:148.8,8:152.9,8.5:157,9:161.1,9.5:165.2,10:169.3',
        'supp_int' => 5.50
      ),

      array (
        'desc' => 'Zone tarifaire 9 (vers COM)',
        'iso_codes' => 'GF,NC,PF,PM,WF,YT',
        'tarif' => '0.5:100.88,1:123.1,1.5:145.31,2:167.53,2.5:189.75,3:211.97,3.5:227.38,4:242.79,4.5:258.2,5:273.61,5.5:287.87,6:302.13,6.5:316.39,7:330.65,7.5:344.91,8:359.17,8.5:373.43,9:387.69,9.5:401.95,10:416.21',
        'supp' => 16.68,
        'tarif_int' => '0.5:85.3,1:103.7,1.5:122.1,2:140.5,2.5:158.9,3:177.3,3.5:190.7,4:204.1,4.5:217.5,5:230.9,5.5:243.3,6:255.7,6.5:268.1,7:280.5,7.5:292.9,8:305.3,8.5:317.7,9:330.1,9.5:342.5,10:354.9',
        'supp_int' => 13.90
      )
    );

		$this->quotes = array();

		/* Vrification que le pays de livraison est dans la zone de taxation restreinte, sinon le module se dsactive. */
		if ( ($this->enabled == true) && ((int)MODULE_SHIPPING_CHRONOPOST_TAX_ZONE > 0) ) {
			$check_flag = false;
			$check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_SHIPPING_CHRONOPOST_TAX_ZONE . "' and zone_country_id = '" . $order->delivery['country']['id'] . "' order by zone_id");
			while ($check = tep_db_fetch_array($check_query)) {
				if ($check['zone_id'] < 1) {
					$check_flag = true;
					break;
				} elseif ($check['zone_id'] == $order->delivery['zone_id']) {
					$check_flag = true;
					break;
				}
			}
			if ($check_flag == false) $this->enabled = false;
		}
	}

	/***** Private methods *****/
	function _add_method($indice) {
		global $order, $cart, $shipping_num_boxes, $shipping_weight;

		if ($indice < 0) return;

		/* Calcul du cot d'1 colis (voir colis fractionns dans la classe 'shipping') */
		if (MODULE_SHIPPING_CHRONOPOST_TARIF_SELECTED == 'PDV') {
      $tarifs_array = split("[:,]", $this->table[$indice]["tarif"]);
      $cout_pour_05 = $this->table[$indice]["supp"];
    }
    else {
      $tarifs_array = split("[:,]", $this->table[$indice]["tarif_int"]);
      $cout_pour_05 = $this->table[$indice]["supp_int"];
    }
    $n = count($tarifs_array);
    $cost = -1;

		if ($indice == 0) {    /* Zone Domestique */
			for ($i = 0; $i < $n; $i += 2) {
				if ($shipping_weight <= $tarifs_array[$i]) {
					$cost = $tarifs_array[$i+1];
					if (substr($order->delivery['postcode'], 0, 2) == '20' || substr($order->delivery['postcode'], 0, 2) == '2A' || substr($order->delivery['postcode'], 0 ,2) == '2B')
						$cost += MODULE_SHIPPING_CHRONOPOST_SUPP_CORSE;
					break;
				}
			}
		}
		else {    /* International */
			/* Comparaison du poids d'1 colis avec le max dans table */
			if ($shipping_weight > $tarifs_array[$n-2]) { /* + supplment */
				$weight_sup = ceil(($shipping_weight - $tarifs_array[$n - 2]) * 2);  /* par 0.5 kg supplmentaire */
				$cost = $tarifs_array[$n-1];
				$cost += $weight_sup * ($this->table[$indice]["supp"]);
			}
			else { /* Dans le tableau tarif */
				for ($i = 0; $i < $n; $i += 2) {
					if ($shipping_weight <= $tarifs_array[$i]) {
						$cost = $tarifs_array[$i+1];
						break;
					}
				}
			}
		}

		if ($cost == -1) { /* Prix pas trouv */
			$this->quotes['error'] = MODULE_SHIPPING_CHRONOPOST_UNDEFINED_RATE;
			return;
		}
		else {
			if ($this->avec_enlevement)
			$cost += MODULE_SHIPPING_CHRONOPOST_ENLEVEMENT;
			$cost += MODULE_SHIPPING_CHRONOPOST_HANDLING;
		}

		/* Cot pour tous les colis */
		$cost *= $shipping_num_boxes;

		/* Assurance du bien transport */
		if ($this->avec_assurance) {
			$total = $cart->show_total();
			if ($total < 500) $assurance = 2.51;
			elseif ($total < 1000) $assurance = 5.02;
			elseif ($total < 2000) $assurance = 8.36;
			elseif ($total < 5000) $assurance = 20.9;
			else $assurance = 0;

			$cost += $assurance;
		}

		/* Stockage paramtres */
$destination = $order->delivery['country']['iso_code_2']; 		
if ($destination == 'FR' or $destination == 'FX') {		
		$this->quotes['methods'][] = array(
			'id'    => $this->code,
			'title' => $this->quotes['icon2'] . ' <span style="vertical-align:15px;">' . MODULE_SHIPPING_CHRONOPOST2_TEXT_TITLE . '</span>',
			'cost'  => $cost);
}else{
		$this->quotes['methods'][] = array(
			'id'    => $this->code,
			'title' => $this->quotes['icon3'] . ' <span style="vertical-align:15px;">' . MODULE_SHIPPING_CHRONOPOST3_TEXT_TITLE . ' ' . $order->delivery['country']['title'] . '</span>',
			'cost'  => $cost);
}
		return;
	}

	/***** Public methods *****/
	function quote($method = '') {
		global $order, $shipping_weight, $shipping_num_boxes;

		$this->quotes = array(
		  'id' => $this->code,
			'module' => '<b>' . MODULE_SHIPPING_CHRONOPOST_TEXT_TITLE .'</b> (' . $shipping_num_boxes . 'x' . $shipping_weight . ' ' . MODULE_SHIPPING_CHRONOPOST_TEXT_UNITS . ')',
			'methods' => array());

		if (tep_not_null($this->icon)) $this->quotes['icon'] = tep_image($this->icon, $this->title);
		if (tep_not_null($this->icon2)) $this->quotes['icon2'] = tep_image($this->icon2, $this->title);
	  	if (tep_not_null($this->icon3)) $this->quotes['icon3'] = tep_image($this->icon3, $this->title);
		if ($shipping_weight > MODULE_SHIPPING_CHRONOPOST_LIMIT) {
			$this->quotes['error'] = $shipping_num_boxes . ' x ' . $shipping_weight . MODULE_SHIPPING_CHRONOPOST_TOO_HEAVY;
			return $this->quotes;
		}

		/* Returns the tax rate for a zone / class -  TABLES: tax_rates, zones_to_geo_zones */
		if ($this->tax_class > 0)
			$this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);

		$destination = $order->delivery['country']['iso_code_2'];  /* Pays de destination */

		/* Correction selon code postal du destinataire en cas mauvaise saisie utilisateur pour DOM,TOM,CT */
		if ($destination == 'FR' or $destination == 'FX') {
			$dest3 = substr(trim($order->delivery['postcode']), 0, 3);
			if ($dest3 == '971') $destination = 'GP';
			elseif ($dest3 == '972') $destination = 'MQ';
			elseif ($dest3 == '973') $destination = 'GF';
			elseif ($dest3 == '974') $destination = 'RE';
			elseif ($dest3 == '975') $destination = 'PM';
			elseif ($dest3 == '976') $destination = 'YT';
			elseif ($dest3 == '984') $destination = 'TF';
			elseif ($dest3 == '986') $destination = 'WF';
			elseif ($dest3 == '987') $destination = 'PF';
			elseif ($dest3 == '988') $destination = 'NC';
		}

		/* Recherche zone Chronopost du pays de destination */
		$dest_zone = -1;
		for ($i = 0; $i < count($this->table); $i++) {
			$iso_codes_array = split("[,]", $this->table[$i]["iso_codes"]);
			if (in_array($destination, $iso_codes_array)) {
				$dest_zone = $i;
				break;
			}
		}
		if ($dest_zone < 0) {
			$this->quotes['error'] = MODULE_SHIPPING_CHRONOPOST_INVALID_ZONE;
			return $this->quotes;
		}

		switch ($destination) {
			/* Mtropole */
		case 'FR' :
		case 'FX' :
		case 'MC' :
			/* DOM */
		case 'GP' :
		case 'MQ' :
		case 'RE' :
		case 'GF' :
			/* TOM */
		case 'NC' :
		case 'PF' :
		case 'WF' :
		case 'TF' :
			/* Collectivits Territoriales */
		case 'YT' :
		case 'PM' :
			$this->_add_method($dest_zone);
			break;

		default :
			/* Hors de France */
			if ($this->international) {
				$this->_add_method($dest_zone);
			}
			else $this->quotes['error'] = MODULE_SHIPPING_CHRONOPOST_INVALID_COUNTRY;
			break;
		} /* end switch */

		return $this->quotes;
	}

	/* Active - Dsactive */
	function check() {
		if (!isset($this->_check)) {
			$check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_CHRONOPOST_STATUS'");
			$this->_check = tep_db_num_rows($check_query);
		}
		return $this->_check;
	}

	/* Constantes stockes dans BDD */
	function install() {

		/* Activation du module */
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Module Chronopost activ ?', 'MODULE_SHIPPING_CHRONOPOST_STATUS', 'True', 'Voulez-vous activer l\'expdition par Chronopost ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

    /* Tarif point de vente ou internet */
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Tarif \'Point de Vente\' ou \'Internet\' ?', 'MODULE_SHIPPING_CHRONOPOST_TARIF_SELECTED', 'PDV', 'Appliquer le tarif public ou exclusif internet (moins cher) ?', '6', '0','tep_cfg_select_option(array(\'PDV\', \'Internet\'), ', now())");

		/* Ajouter des frais fixes HT ? */
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Frais fixes Chronopost HT', 'MODULE_SHIPPING_CHRONOPOST_HANDLING', '0', 'Les frais fixes HT d\'expdition par Chronopost (emballage, ...)', '6', '0', now())");

		/* Appliquer une taxe sur frais d'expdition ? */
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Classe de taxe sur frais d\'expdition', 'MODULE_SHIPPING_CHRONOPOST_TAX_CLASS', '0', 'Appliquer le taux de taxe suivant sur les frais d\'expdition', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");

		/* Expdier seulement vers une zone de taxe ? */
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Expdier seulement vers cette zone de taxe', 'MODULE_SHIPPING_CHRONOPOST_TAX_ZONE', '0', 'Si une zone de taxe est slectionne, ce mode de livraison fonctionnera uniquement pour la zone choisie.', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");

		/* Slection des affichages */
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Autoriser livraisons  l\'International ?', 'MODULE_SHIPPING_CHRONOPOST_INTERNATIONAL_ENABLED', 'False', 'Voulez-vous autoriser les livraisons  l\'International ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

		/* Enlvement sur demande */
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Enlvement sur demande ?', 'MODULE_SHIPPING_CHRONOPOST_AVEC_ENLEVEMENT', 'False', 'Voulez-vous ajouter l\'enlvement au prix du transport ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

		/* Avec assurance ? */
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Ajouter assurance ?', 'MODULE_SHIPPING_CHRONOPOST_AVEC_ASSURANCE', 'False', 'Voulez-vous faire payer une prime d\'assurance selon la valeur dclare ?', '6', '0','tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

		/* Ordre d'affichage */
		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de Tri', 'MODULE_SHIPPING_CHRONOPOST_SORT_ORDER', '0', 'Ordre de tri pour l\'affichage.', '6', '0', now())");

   }

	/* Effacement de toutes les cls dans la BDD */
	function remove() {
		tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
	}

	/* Retourne un tableau des cls */
	function keys() {
		return array(
			'MODULE_SHIPPING_CHRONOPOST_STATUS',
			'MODULE_SHIPPING_CHRONOPOST_TARIF_SELECTED',
			'MODULE_SHIPPING_CHRONOPOST_HANDLING',
			'MODULE_SHIPPING_CHRONOPOST_TAX_CLASS',
			'MODULE_SHIPPING_CHRONOPOST_TAX_ZONE',
			'MODULE_SHIPPING_CHRONOPOST_INTERNATIONAL_ENABLED',
			'MODULE_SHIPPING_CHRONOPOST_AVEC_ENLEVEMENT',
			'MODULE_SHIPPING_CHRONOPOST_AVEC_ASSURANCE',
			'MODULE_SHIPPING_CHRONOPOST_SORT_ORDER');
	}
}
?>
