<?php
/*
  $Id: colissimoR2.php,v 1.3 2003/01/05 09:24:47 jpcivade Exp $

  The Exchange Project - Community Made Shopping!
  http://www.theexchangeproject.org

  Copyright (c) 2000,2001 The Exchange Project

  Released under the GNU General Public License

    adaptation Stphane GUIBOUD-RIBAUD <devteam@e-network.fr>
	           xaglo <xaglo@free.fr>
			   
	mise a jour v1.4.2 by fram 2003/05/10	
	
	MAJ v1.5 by lepoissonrouge 19/06/2005
	MAJ v1.5.2 by lepoissonrouge 20/11/2005	   
  
  MAJ v.1.5.2 by bacri 01/02/2007
        Ajout colissimo recommand R1, R2 et R3
        Ajout icones
        Modif tarifs 2007 
        Suppression de l'affichage du module si poids > 30kg)	   

  MAJ v.1.5.2 by frpons 05/04/2007
  	Modif tarifs 2007 (?)

www.oscommerce-fr.info
*/


  class colissimoR2 {
    var $code, $title, $description, $icon, $enabled;

// class constructor
    function colissimoR2() 
	{
      $this->code = 'colissimoR2';
      $this->title = MODULE_SHIPPING_COLISSIMOR2_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_COLISSIMOR2_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_SHIPPING_COLISSIMOR2_SORT_ORDER;
      $this->icon = DIR_WS_ICONS . 'colissimoR2.gif'; // ou shipping_laposte.gif au choix
      $this->tax_class = MODULE_SHIPPING_COLISSIMOR2_TAX_CLASS;
      $this->enabled = MODULE_SHIPPING_COLISSIMOR2_STATUS;
// disable the module if the order only weight > 30
      global $PHP_SELF;
        if (basename($PHP_SELF) != FILENAME_MODULES) {
      global $cart;
        if ($this->enabled == true) {
		if ( basename($PHP_SELF) != FILENAME_CUSTOMERS && basename($PHP_SELF) != FILENAME_CUSTOMERS_GROUPS){
        if ($cart->show_weight() > '30') {
     $this->enabled = false;}
        }
        }
        }
	}

// class methods
    function quote($method = '') 
	{
      global $order, $cart, $shipping_weight;

      $this->quotes = array('id' => $this->code,
                            'module' => MODULE_SHIPPING_COLISSIMOR2_TEXT_TITLE,
                            'methods' => array());

      if (tep_not_null($this->icon))
	$this->quotes['icon'] = tep_image($this->icon, $this->title);

      $dest_country = $order->delivery['country']['iso_code_2'];

      if (($dest_country != 'FR') && ($dest_country != 'FX')) {
	$this->quotes['error'] = MODULE_SHIPPING_COLISSIMOR2_INVALID_ZONE;
	return $this->quotes;
      }

	$cost = constant('MODULE_SHIPPING_COLISSIMOR2_NATIONAL');
      $table = split("[:,]" , $cost);
      for ($i = 0; $i < sizeof($table); $i+=2) {
	if ($shipping_weight > $table[$i])
	  continue;

	$this->quotes['methods'][] = array('id'    => $this->code,
					   'title' => $shipping_weight . ' ' . MODULE_SHIPPING_COLISSIMOR2_TEXT_UNITS,
					   'cost'  => $table[$i+1] + MODULE_SHIPPING_COLISSIMOR2_HANDLING);
	
      if ($this->tax_class > 0) {
        $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
      }
    return $this->quotes;
      }

      $this->quotes['error'] = MODULE_SHIPPING_COLISSIMOR2_TOO_HEAVY;
      return $this->quotes;
    }

    function check() {
      $check = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_COLISSIMOR2_STATUS'");
      $check = tep_db_num_rows($check);

      return $check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Valider Colissimo', 'MODULE_SHIPPING_COLISSIMOR2_STATUS', 'True', 'Activer / Dsactiver Colissimo sans perdre les valeurs chang&eacute;es', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Colissimo national', 'MODULE_SHIPPING_COLISSIMOR2_NATIONAL', '0.500:8.20, 1:9.40, 2:10.30, 3:11.20, 5:13.10, 7:14.90, 10:17.60, 15:19.40, 30:24.70', 'Port bas&eacute; sur le poids total des produits, tarif national TTC. Exemple: 1:6.15, 2:6.95, etc. Jusqu\' 1 Kg factur 6.15, jusqu\' 2 Kg , 6.95, etc', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Frais fixes', 'MODULE_SHIPPING_COLISSIMOR2_HANDLING', '0', 'Frais fixes (emballage) pour colissimo', '6', '0', now())");
  	  tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Classe de taxe', 'MODULE_SHIPPING_COLISSIMOR2_TAX_CLASS', '0', 'Appliquer le taux de taxe suivant sur les frais de livraison.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Code postal', 'MODULE_SHIPPING_COLISSIMOR2_STORE_POSTCODE', '13400', 'Code postal de la boutique', '6', '0', now())");
	    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de tri', 'MODULE_SHIPPING_COLISSIMOR2_SORT_ORDER', '0', 'Ordre de tri pour l\'affichage (Le plus petit nombre est montr&eacute; en premier).', '6', '0', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_SHIPPING_COLISSIMOR2_STATUS', 
		'MODULE_SHIPPING_COLISSIMOR2_NATIONAL', 
		'MODULE_SHIPPING_COLISSIMOR2_HANDLING', 
		'MODULE_SHIPPING_COLISSIMOR2_STORE_POSTCODE', 
		'MODULE_SHIPPING_COLISSIMOR2_TAX_CLASS',
		'MODULE_SHIPPING_COLISSIMOR2_SORT_ORDER');
    }
  }
?>
