<?php
/*
  Paybox paiement pour banque compatible 
  e-transaction (http://www.e-transactions.credit-agricole.fr/)
  
  Copyright © 2007 osCommerce-France by Delaballe
  www.oscommerce-fr.info

  Released under the GNU General Public License

  En remerciant également les auteur précedent qui avait déjà contribué au module Paybox (Emmanuel Alliel et Marquis)

*/


// Récuparation des données renvoyées par la banque
  $request_method = $HTTP_SERVER_VARS["REQUEST_METHOD"];
  $wRequestVars = "HTTP_" . $request_method . "_VARS";
  $RequestVars = ${$wRequestVars};

// On récupére la session utilisé après par le fichier application_top.php
  session_name($RequestVars['osCsid']);
  include('includes/application_top.php');

// Vérification que la session est bien ouverte
  $session_registered = 'false';
  if (tep_session_is_registered('customer_id')) {
    $session_registered = 'true';
  }

// Vérification du numéro d'IP de la banque
  $no_ip = 'true';
  foreach (preg_split('/[,\s]+/', MODULE_PAYMENT_PAYBOX_IP) as $authorized_ip) {
    if ($_SERVER['REMOTE_ADDR'] == $authorized_ip) {
      $no_ip = 'false';
	  break;
	}
  }
  
// Modification du retour de l'URL code erreur de la banque suite à une erreur de vérification sur la session ou le numéro d'IP
  if (($no_ip == 'true') && ($session_registered == 'false')) {
    $RequestVars['erreur'] = 'no_ip_and_session';
  } else if ($no_ip == 'true') {
    $RequestVars['erreur'] = 'no_ip';
  } else if ($session_registered == 'false') {
    $RequestVars['erreur'] = 'no_session';
  }

// On inclus le fichier langue du module paybox
  include(DIR_WS_LANGUAGES . $language . '/modules/payment/paybox.php');

// On inclus les différents fichiers dont on a besoin pour poursuivre la procédure de commande
  if (($no_ip == 'false') && ($session_registered == 'true')) {
    include(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CHECKOUT_PROCESS);

    include(DIR_WS_MODULES . 'payment/paybox.php');
    $payment_modules = new paybox();

    require(DIR_WS_CLASSES . 'shipping.php');
    $shipping_modules = new shipping($shipping);

    require(DIR_WS_CLASSES . 'order.php');
    $order = new order;

    $payment_modules->before_process();

    require(DIR_WS_CLASSES . 'order_total.php');
    $order_total_modules = new order_total;
  
    $order_totals = $order_total_modules->process();
  }

// Début de procédure de vérification du paiement en retour des informations des serveurs de paybox
  $mail_erreur = '0';

  switch ($RequestVars['erreur']) {
	case "no_ip_and_session" :
	  $mail_erreur = '1';
	  $mail_message = '-- ' . MODULE_PAYMENT_PAYBOX_MAIL_ERROR_IP . ' : ' . $_SERVER['REMOTE_ADDR'] . "\n\n" . '-- ' . MODULE_PAYMENT_PAYBOX_MAIL_ERROR_SESSION;
	  break;
	case "no_ip" :
	  $mail_erreur = '1';
	  $mail_message = MODULE_PAYMENT_PAYBOX_MAIL_ERROR_IP . ' : ' . $_SERVER['REMOTE_ADDR'];
	  break;
	case "no_session" :
	  $mail_erreur = '1';
	  $mail_message = MODULE_PAYMENT_PAYBOX_MAIL_ERROR_SESSION;
	  break;
	case "00000" :
	  if ($RequestVars['auto']) { 
// Début de la procédure de validation de la commande
        $sql_data_array = array('customers_id' => $customer_id,
                                'customers_name' => $order->customer['firstname'] . ' ' . $order->customer['lastname'],
                                'customers_company' => $order->customer['company'],
                                'customers_street_address' => $order->customer['street_address'],
                                'customers_suburb' => $order->customer['suburb'],
                                'customers_city' => $order->customer['city'],
                                'customers_postcode' => $order->customer['postcode'],
                                'customers_state' => $order->customer['state'],
                                'customers_country' => $order->customer['country']['title'],
                                'customers_telephone' => $order->customer['telephone'],
                                'customers_email_address' => $order->customer['email_address'],
                                'customers_address_format_id' => $order->customer['format_id'],
                                'delivery_name' => $order->delivery['firstname'] . ' ' . $order->delivery['lastname'],
                                'delivery_company' => $order->delivery['company'],
                                'delivery_street_address' => $order->delivery['street_address'],
                                'delivery_suburb' => $order->delivery['suburb'],
                                'delivery_city' => $order->delivery['city'],
                                'delivery_postcode' => $order->delivery['postcode'],
                                'delivery_state' => $order->delivery['state'],
                                'delivery_country' => $order->delivery['country']['title'],
                                'delivery_address_format_id' => $order->delivery['format_id'],
                                'billing_name' => $order->billing['firstname'] . ' ' . $order->billing['lastname'],
                                'billing_company' => $order->billing['company'],
                                'billing_street_address' => $order->billing['street_address'],
                                'billing_suburb' => $order->billing['suburb'],
                                'billing_city' => $order->billing['city'],
                                'billing_postcode' => $order->billing['postcode'],
                                'billing_state' => $order->billing['state'],
                                'billing_country' => $order->billing['country']['title'],
                                'billing_address_format_id' => $order->billing['format_id'],
                                'payment_method' => MODULE_PAYMENT_PAYBOX_ORDER_METHOD,
                                'cc_type' => $order->info['cc_type'],
                                'cc_owner' => $order->info['cc_owner'],
                                'cc_number' => $order->info['cc_number'],
                                'cc_expires' => $order->info['cc_expires'],
                                'date_purchased' => 'now()',
                                'orders_status' => $order->info['order_status'],
                                'currency' => $order->info['currency'],
                                'currency_value' => $order->info['currency_value']);

        tep_db_perform(TABLE_ORDERS, $sql_data_array);
		$insert_id = tep_db_insert_id();
		for ($i = 0, $n = sizeof($order_totals); $i < $n; $i++) {
		  $sql_data_array = array('orders_id' => $insert_id,
                                  'title' => $order_totals[$i]['title'],
                                  'text' => $order_totals[$i]['text'],
                                  'value' => $order_totals[$i]['value'],
                                  'class' => $order_totals[$i]['code'],
                                  'sort_order' => $order_totals[$i]['sort_order']);
          tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
		} 

		$customer_notification = (SEND_EMAILS == 'true') ? '1' : '0';
		$sql_data_array = array('orders_id' => $insert_id,
								'orders_status_id' => $order->info['order_status'],
								'date_added' => 'now()',
								'customer_notified' => $customer_notification,
								'comments' => $order->info['comments']);
		tep_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array); 

// Initialisé pour l'e-mail de confirmation de la commande
		$products_ordered = '';
		$subtotal = 0;
		$total_tax = 0;

// Gestion des Stocks
		for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
		  if (STOCK_LIMITED == 'true') {
			if (DOWNLOAD_ENABLED == 'true') {
			  $stock_query_raw = "SELECT products_quantity, pad.products_attributes_filename 
                                  FROM " . TABLE_PRODUCTS . " p
                                  LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                                  ON p.products_id=pa.products_id
                                  LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                                  ON pa.products_attributes_id=pad.products_attributes_id
                                  WHERE p.products_id = '" . tep_get_prid($order->products[$i]['id']) . "'"; 
			  $products_attributes = $order->products[$i]['attributes'];

			  if (is_array($products_attributes)) {
			    $stock_query_raw .= " AND pa.options_id = '" . $products_attributes[0]['option_id'] . "' AND pa.options_values_id = '" . $products_attributes[0]['value_id'] . "'";
			  } 
			  $stock_query = tep_db_query($stock_query_raw);
			} else {
			  $stock_query = tep_db_query("select products_quantity from " . TABLE_PRODUCTS . " where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
			} 

			if (tep_db_num_rows($stock_query) > 0) {
			  $stock_values = tep_db_fetch_array($stock_query); 
			  if ((DOWNLOAD_ENABLED != 'true') || (!$stock_values['products_attributes_filename'])) {
			    $stock_left = $stock_values['products_quantity'] - $order->products[$i]['qty'];
			  } else {
				$stock_left = $stock_values['products_quantity'];
			  } 
			  tep_db_query("update " . TABLE_PRODUCTS . " set products_quantity = '" . $stock_left . "' where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
			  if (($stock_left < 1) && (STOCK_ALLOW_CHECKOUT == 'false')) {
				tep_db_query("update " . TABLE_PRODUCTS . " set products_status = '0' where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
			  } 
			} 
		  } 

// Gestion des produits for bestsellers list)
		  tep_db_query("update " . TABLE_PRODUCTS . " set products_ordered = products_ordered + " . sprintf('%d', $order->products[$i]['qty']) . " where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");

		  $sql_data_array = array('orders_id' => $insert_id,
								  'products_id' => tep_get_prid($order->products[$i]['id']),
								  'products_model' => $order->products[$i]['model'],
								  'products_name' => $order->products[$i]['name'],
								  'products_price' => $order->products[$i]['price'],
								  'final_price' => $order->products[$i]['final_price'],
								  'products_tax' => $order->products[$i]['tax'],
								  'products_quantity' => $order->products[$i]['qty']);
		  tep_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array);
		  $order_products_id = tep_db_insert_id(); 

// Gestion des attribues produits
		  $attributes_exist = '0';
		  $products_ordered_attributes = '';

		  if (isset($order->products[$i]['attributes'])) {
			$attributes_exist = '1';
			for ($j = 0, $n2 = sizeof($order->products[$i]['attributes']); $j < $n2; $j++) {
			  if (DOWNLOAD_ENABLED == 'true') {
				$attributes_query = "SELECT popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix, pad.products_attributes_maxdays, pad.products_attributes_maxcount , pad.products_attributes_filename 
                                     FROM " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa 
                               		 LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                                	 ON pa.products_attributes_id=pad.products_attributes_id
                                     WHERE pa.products_id = '" . $order->products[$i]['id'] . "' 
                                     AND pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "' 
                                	 AND pa.options_id = popt.products_options_id 
                                	 AND pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "' 
                                	 AND pa.options_values_id = poval.products_options_values_id 
                                	 AND popt.language_id = '" . $languages_id . "' 
                               	     AND poval.language_id = '" . $languages_id . "'";
				$attributes = tep_db_query($attributes_query);
			  } else {
				$attributes = tep_db_query("select popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa where pa.products_id = '" . $order->products[$i]['id'] . "' and pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "' and pa.options_id = popt.products_options_id and pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "' and pa.options_values_id = poval.products_options_values_id and popt.language_id = '" . $languages_id . "' and poval.language_id = '" . $languages_id . "'");
			  } 
			  $attributes_values = tep_db_fetch_array($attributes);

			  $sql_data_array = array('orders_id' => $insert_id,
									  'orders_products_id' => $order_products_id,
									  'products_options' => $attributes_values['products_options_name'],
									  'products_options_values' => $attributes_values['products_options_values_name'],
									  'options_values_price' => $attributes_values['options_values_price'],
									  'price_prefix' => $attributes_values['price_prefix']);
			  tep_db_perform(TABLE_ORDERS_PRODUCTS_ATTRIBUTES, $sql_data_array);

			  if ((DOWNLOAD_ENABLED == 'true') && isset($attributes_values['products_attributes_filename']) && tep_not_null($attributes_values['products_attributes_filename'])) {
				$sql_data_array = array('orders_id' => $insert_id,
										'orders_products_id' => $order_products_id,
										'orders_products_filename' => $attributes_values['products_attributes_filename'],
										'download_maxdays' => $attributes_values['products_attributes_maxdays'],
									    'download_count' => $attributes_values['products_attributes_maxcount']);
				tep_db_perform(TABLE_ORDERS_PRODUCTS_DOWNLOAD, $sql_data_array);
			  } 
			  $products_ordered_attributes .= "\n\t" . $attributes_values['products_options_name'] . ' ' . $attributes_values['products_options_values_name'];
			} 
		  } 

		  $total_weight += ($order->products[$i]['qty'] * $order->products[$i]['weight']);
		  $total_tax += tep_calculate_tax($total_products_price, $products_tax) * $order->products[$i]['qty'];
		  $total_cost += $total_products_price;

		  $products_ordered .= $order->products[$i]['qty'] . ' x ' . $order->products[$i]['name'] . ' (' . $order->products[$i]['model'] . ') = ' . $currencies->display_price($order->products[$i]['final_price'], $order->products[$i]['tax'], $order->products[$i]['qty']) . $products_ordered_attributes . "\n";
		} 

// e-Mail de confirmation commande
		$email_order = STORE_NAME . "\n" .
		EMAIL_SEPARATOR . "\n" .
		EMAIL_TEXT_ORDER_NUMBER . ' ' . $insert_id . "\n" .
		EMAIL_TEXT_INVOICE_URL . ' ' . tep_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $insert_id, 'SSL', false) . "\n" .
		EMAIL_TEXT_DATE_ORDERED . ' ' . strftime(DATE_FORMAT_LONG) . "\n\n";

		if ($order->info['comments']) {
		  $email_order .= tep_db_output($order->info['comments']) . "\n\n";
		} 

		$email_order .= EMAIL_TEXT_PRODUCTS . "\n" .
		EMAIL_SEPARATOR . "\n" . $products_ordered .
		EMAIL_SEPARATOR . "\n";

		for ($i = 0, $n = sizeof($order_totals); $i < $n; $i++) {
		  $email_order .= strip_tags($order_totals[$i]['title']) . ' ' . strip_tags($order_totals[$i]['text']) . "\n";
		} 

		if ($order->content_type != 'virtual') {
		  $email_order .= "\n" . EMAIL_TEXT_DELIVERY_ADDRESS . "\n" .
		  EMAIL_SEPARATOR . "\n" .
		  tep_address_label($customer_id, $sendto, 0, '', "\n") . "\n";
		} 

		$email_order .= "\n" . EMAIL_TEXT_BILLING_ADDRESS . "\n" .
		EMAIL_SEPARATOR . "\n" .
		tep_address_label($customer_id, $billto, 0, '', "\n") . "\n\n";

		if (is_object($$payment)) {
		  $email_order .= EMAIL_TEXT_PAYMENT_METHOD . "\n" .
		  EMAIL_SEPARATOR . "\n";
		  $payment_class = $$payment;
		  $email_order .= $payment_class->title . "\n\n";
		  if ($payment_class->email_footer) {
			$email_order .= $payment_class->email_footer . "\n\n";
		  } 
		} 

		tep_mail($order->customer['firstname'] . ' ' . $order->customer['lastname'], $order->customer['email_address'], EMAIL_TEXT_SUBJECT, $email_order, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS); 

// Emails de commande aux administrateurs complémentaires de la boutique
		if (SEND_EXTRA_ORDER_EMAILS_TO != '') {
		  tep_mail('', SEND_EXTRA_ORDER_EMAILS_TO, EMAIL_TEXT_SUBJECT, $email_order, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);
		} 

// load the after_process function from the payment modules
        $payment_modules->after_process();

		$cart->reset(true); 

// unregister session variables used during checkout
		tep_session_unregister('sendto');
		tep_session_unregister('billto');
		tep_session_unregister('shipping');
		tep_session_unregister('payment');
	    tep_session_unregister('comments'); 
	  } else {
	    $mail_erreur = '1';
	    $mail_message = E_TRANSACTION_CODE_ERREUR_XXXXX;
	  }
	  break;
	default:
	  $mail_erreur = '1';
      $code_erreur = $RequestVars['erreur'];
	  $mail_message = constant(E_TRANSACTION_CODE_ERREUR_.$code_erreur);
	  $test = "Erreur";
  }

// Envoi mail des états d'alerte
  if (($mail_erreur == '1') && (MODULE_PAYMENT_PAYBOX_MAIL == 'True')) {
    if (SEND_EXTRA_ORDER_EMAILS_TO != '') {
      tep_mail('', SEND_EXTRA_ORDER_EMAILS_TO, E_TRANSACTION_MAIL_ERREUR_SUBJECT . ' ' . MODULE_PAYMENT_PAYBOX_NAME_BANK, $mail_message . "\n\n" . E_TRANSACTION_MAIL_ERREUR_FOOTER, STORE_NAME, STORE_OWNER_EMAIL_ADDRESS);
	} else {
      tep_mail('', STORE_OWNER_EMAIL_ADDRESS, E_TRANSACTION_MAIL_ERREUR_SUBJECT . ' ' . MODULE_PAYMENT_PAYBOX_NAME_BANK, $mail_message . "\n\n" . E_TRANSACTION_MAIL_ERREUR_FOOTER, STORE_NAME, STORE_OWNER_EMAIL_ADDRESS);
	}
  }
?>



<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Validation commande paybox</title>
</head>
<body>
</body>
</html>
