<?php
//------------------------------------------------------------------------------------------------------------
// retour_spcheck_php.php
// KIT SPPLUS : Page de retour CGI paiement avec de test du contrle IP puis HMAC
//---------------------------------------------------------------------------------------------------------
// Destinataire :                Sites en intgration
// Auteur :                      Service intgration SP PLUS
// Numro Version :              1.2
// Date cration	:	             18/08/2005
// Date dernire Modification :  12/03/2007
//---------------------------------------------------------------------------------------------------------
//
//	LURL CGI de retour paiement doit tre utilise pour effectuer un traitement sur le site commerant, cette page
// nest pas visible et est appele la premire fois par le serveur de paiement ds que linternaute a valid son
// paiement. Cest une page applicative, son utilisation est facultative. Il sagit gnralement dune page dynamique
// (Php, Asp) pemettant une mise  jour du suivi de commande du site commerant.
//
// En effet, si le site offre un suivi de ltat des paiements, il est possible de synchroniser la base du commerant
// avec celle du serveur SP PLUS.
//
// Cette URL est appele  chaque fois quun vnement modifie ltat dune transaction (paramtre "etat").
//
// Ce script vous permettra de vrifier que l'appel sur la page CGI retour paiement vient
// bien du serveur de paiement SP PLUS. En effet, il permet dans un premier temps de filtrer l'adresse IP de
// l'appellant pour n'autoriser que le serveur SPPLUS puis de recalculer le HMAC pour le comparer  celui envoy.
//
// Ce script utilise la fonction de calcul nthmac($clent, $chaineParam) prsente dans l'API PHP php_spplus.so
//
// Dans cette configuration, le serveur SP PLUS se comporte comme un navigateur qui interroge une page de traitement
// situe sur le serveur du commerant. Le serveur va analyser le code affich par cette page et non la page elle-mme.
// La page doit donc SYSTEMATIQUEMENT rpondre "spcheckok" pour informer le serveur SPPLUS de la prise en compte de la
// requte. Si ce n'est pas le cas, le serveur SPPLUS appelle 3 fois la page avec le mme code d'tat et envoie un mail
// d'alerte au commerant et ce, pour chaque code d'tat envoy.
//
// Code Etat	Signification
// 1	Autorisation carte accepte
// 2	Autorisation carte refuse
// 4	Paiement par carte accept
// 5	Paiement par carte refus par la banque
// 6	Paiement par cheque accept
// 8	Chque encaiss
// 10 Transaction termine
// 11	Paiement annul par le commerant
// 12	Abandon de linternaute
// 15	Remboursement
// 99	Paiement de test en production
//
// Validation automatique des paiements :
// Paiement accept : cette page est appele 3 fois avec le code etat  1 puis  4 et  10
// Paiement refus :  cette page est appele avec le code etat correspondant ( 2 ou  5)
//
// Validation manuelle des paiements :
// Paiement accept : cette page est appele 1 fois avec avec le code etat 1
// elle sera  nouveau appele 2 fois avec le code etat 4 puis 10 lors de la validation
// du paiement par le commerant dans l'interface de suivi des paiements SPPLUS.
// Paiement refus :  cette page est appele avec le code etat correspondant ( 2 ou  5)
//
//------------------------------------------------------------------------------------------------------------

   // Nous rpondons SYSTEMATIQUEMENT au serveur SPPLUS
   echo("spcheckok");

   //------------------------------------------------------------------------------------------------------------
   // Liste des adresses IP de sortie des serveurs SP PLUS
   $liste_IP = array( "195.6.195.3",   "83.145.90.3",   "195.115.37.3", 
                      "195.6.195.8",   "83.145.90.8",   "195.115.37.8", 
                      "84.233.159.91", "84.233.159.92", "84.233.159.93", "84.233.159.94", 
                      "84.233.159.95", "84.233.159.96", "84.233.159.97", "84.233.159.98", 
                      "81.255.54.91",  "81.255.54.92",  "81.255.54.93",  "81.255.54.94", 
                      "81.255.54.95",  "81.255.54.96",  "81.255.54.97",  "81.255.54.98",
                      "212.99.102.96", "84.233.159.107", "81.255.54.107", "212.99.102.107",
                     "212.99.102.98"   

                    );

   // Nous testons que c'est bien le serveur SPPLUS qui appelle cette page
   // en rcuprant l'adresse IP de l'appelant puis en la testant
   $remote_addr = $_SERVER['REMOTE_ADDR'];
   //if( in_array($remote_addr, $liste_IP) )
   if( 1==1 )
   {

      //------------------------------------------------------------------------------------------------------------
      // INFORMATIONS A MODIFIER POUR CHAQUE COMMERCANT FOURNIES PAR LE SERVICE INTEGRATION SPPLUS
      // cle marchand du commercant au format NT
      $clent = "d1 6d 26 3a 22 d3 5e b5 15 ab c7 96 ba 7c f2 62 9f 79 5b 06 1f 43 be b6";
      // code siret du commercant
      $codesiret = "48218304300017-003";

      echo("<p><b>Cl marchand utilise : </b>" . $clent . "<br>");
      echo("<b>code siret utilis : </b>". $codesiret . "</b><p>");

      //------------------------------------------------------------------------------------------------------------
      // la fonction ci dessous permet de charger la librairie SP PLUS si elle n'est pas dclare dans le fichier php.ini (rubrique extensions)
      dl('php_spplus.so');

      // on a p charger la librairie php_spplus.so
      if (extension_loaded('SPPLUS'))
      {
         echo ("extension SP PLUS charge<p>");

         //------------------------------------------------------------------------------------------------------------
         // $_SERVER['QUERY_STRING'] : permet de rcuperer tel quel la chaine de requte si elle existe
         // qui est utilise pour accder  la page. Valable uniquement pour les paramtres passs en GET.
         $chaineParam = $_SERVER['QUERY_STRING'];

         echo("<b>Parametres recus : </b><br>" . $chaineParam . "<p>");

         //------------------------------------------------------------------------------------------------------------
         // on cherche la position du premier caractre de la chaine '&hmac'
         // et on teste la valeur du hmac et son type
         $pos = strpos($chaineParam,"&hmac=");

         if($pos == false || !is_integer($pos)) { echo("Erreur : Hmac non present<p>"); }
         else
         {
            // on supprime le paramtre hmac de la chane
            $chaineCalcul = substr($chaineParam,0,$pos);
            $chaineCalcul .= substr($chaineParam,$pos+strlen($_GET["hmac"])+6,strlen($chaineParam));
            $chaineParam = "";

            //------------------------------------------------------------------------------------------------------------
            // on dcoupe la chane de paramtres afin de ne rcuprer que les valeurs concatnes
            $tok = strtok($chaineCalcul,"=&");
            while($tok)
            {
               if($_REQUEST[$tok] != "")
               {
                  $tok = strtok("&=");
                  $chaineParam .= $tok;
               }
               $tok = strtok("&=");
               $tok = urldecode($tok);
            }

            echo("<b>Chaine de paramtres  contrler : </b><br>" . $chaineParam . "<p>");

            //------------------------------------------------------------------------------------------------------------
            // on calcul le sceau numrique hmac
            $hmac_calcule = nthmac($clent, $chaineParam);

            //------------------------------------------------------------------------------------------------------------
            // Si le hmac calcul est gal  celui reu on traite les tats pour mise  jour du site
            if ( strcmp( $hmac_calcule, $_GET["hmac"]) == 0 )
            {
               $message = "HMAC_OK";

               // initialisation des variables locales
               $montant    = 0;
               $reference  = 0;
               $refsfp     = 0;
               $etat       = 0;
               $email      = "";
               $info       = "";

               // Rcupration des paramtres avec mthode GET (mthode par dfaut)
               if(isset($_GET['montant']))   { $montant     = $_GET['montant']; }
               if(isset($_GET['reference'])) { $reference   = $_GET['reference']; }
               if(isset($_GET['refsfp']))    { $refsfp      = $_GET['refsfp']; }
               if(isset($_GET['etat']))      { $etat        = $_GET['etat']; }
               if(isset($_GET['email']))     { $email       = $_GET['email']; }

/////////////////////////////////////////////////////////////////////////////
  $ip = $HTTP_SERVER_VARS["REMOTE_ADDR"];
  $client = gethostbyaddr($HTTP_SERVER_VARS["REMOTE_ADDR"]);
  $str = preg_split("/\./", $client);
  $i = count($str);
  $x = $i - 1;
  $n = $i - 2;
  $isp = $str[$n] . "." . $str[$x];

$nbr=2;
$refsfp=substr($refsfp, 0, -$nbr);// retirer les deux derniers caracteres qui servent au echance

  include('includes/application_top.php');
  include(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CHECKOUT_PROCESS);
/////////////////////////////////////////////////////////////////////////////
               // Test de la valeur du paramtre Etat et exemple de traitement correspondant
               switch ($etat)
               {
                  case 0:
                     $info = "etat=0 : pas de traitement";
                     break;
                  case 1:
                     $info = "etat=1 : autorisation de paiement accept - panier vid - commande en attente";

/////////////////////////////////////////////////////////////////////////////


// load selected payment module
  require(DIR_WS_CLASSES . 'payment.php');
  if ($credit_covers) $payment=''; //ICW added for CREDIT CLASS
  $payment_modules = new payment($payment);

// load the selected shipping module
  require(DIR_WS_CLASSES . 'shipping.php');
  $shipping_modules = new shipping($shipping);
  require(DIR_WS_CLASSES . 'order.php');
  $order = new order;

// check order total minimum
  if ($order->info['subtotal'] < MIN_ORDER_AMOUNT) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART, '', 'NONSSL'));
  }


if(!class_exists('order_total')) {
 include(DIR_WS_CLASSES . 'order_total.php');
 $order_total_modules = new order_total;
}

  $order_totals = $order_total_modules->process();

// BOF: WebMakers.com Added: Downloads Controller
  $sql_data_array = array('customers_id' => $customer_id,
                          'customers_name' => $order->customer['firstname'] . ' ' . $order->customer['lastname'],
                          'customers_company' => $order->customer['company'],
                          'customers_street_address' => $order->customer['street_address'],
                          'customers_suburb' => $order->customer['suburb'],
                          'customers_city' => $order->customer['city'],
                          'customers_postcode' => $order->customer['postcode'],
                          'customers_state' => $order->customer['state'],
                          'customers_country' => $order->customer['country']['title'],
                          'customers_telephone' => $order->customer['telephone'],
                          'customers_email_address' => $order->customer['email_address'],
                          'customers_address_format_id' => $order->customer['format_id'],
                          'delivery_name' => $order->delivery['firstname'] . ' ' . $order->delivery['lastname'],
                          'delivery_company' => $order->delivery['company'],
                          'delivery_street_address' => $order->delivery['street_address'],
                          'delivery_suburb' => $order->delivery['suburb'],
                          'delivery_city' => $order->delivery['city'],
                          'delivery_postcode' => $order->delivery['postcode'],
                          'delivery_state' => $order->delivery['state'],
                          'delivery_country' => $order->delivery['country']['title'],
                          'delivery_address_format_id' => $order->delivery['format_id'],
                          'billing_name' => $order->billing['firstname'] . ' ' . $order->billing['lastname'],
                          'billing_company' => $order->billing['company'],
                          'billing_street_address' => $order->billing['street_address'],
                          'billing_suburb' => $order->billing['suburb'],
                          'billing_city' => $order->billing['city'],
                          'billing_postcode' => $order->billing['postcode'],
                          'billing_state' => $order->billing['state'],
                          'billing_country' => $order->billing['country']['title'],
                          'billing_address_format_id' => $order->billing['format_id'],
                          'payment_method' => 'SPPLUS',
                          'payment_info' => 'Paiement CB caisse d epargne',
                          'cc_type' => $order->info['cc_type'],
                          'cc_owner' => $order->info['cc_owner'],
                          'cc_number' => $cc_number1,
                          'cc_ccv' => '',
                          'cc_start' => $order->info['cc_start'],
                          'cc_issue' => $order->info['cc_issue'],
                          'cc_expires' => $cc_expires1,
                          'date_purchased' => 'now()',
                          'last_modified' => 'now()',
                          'orders_status' => $order->info['order_status'],
                          'currency' => $order->info['currency'],
                          'currency_value' => $order->info['currency_value'],
                          'ipaddy' => $ip,
                          'ipisp' => $isp,
                          'refsfp' => $refsfp);
    $sql_data_array['poids_commande'] = $cart->show_weight();
  if ( isset($order->info['num_relais_mr_id']) )
  {
    $sql_data_array['num_relais_mr_id'] = $order->info['num_relais_mr_id'];
  }
               
// EOF: WebMakers.com Added: Downloads Controller
  tep_db_perform(TABLE_ORDERS, $sql_data_array);
  $insert_id = tep_db_insert_id();

   //Start Mondial Relay
      if(substr($shipping['id'],0,12)=="mondialrelay")
      {
        tep_db_query("update " . TABLE_ORDERS . " set shipping_pointrelay = '" . substr($shipping['id'],-8) . "' where  orders_id = '".$insert_id."'");

        tep_db_query("update " . TABLE_ORDERS . " set num_relais_mr_id = '" . substr($shipping['id'],-8) . "' where  orders_id = '".$insert_id."'");
      }
    //End Mondial Relay

// Make sure the /catalog/includes/class/order.php is included
// and $order object is created before this!!!
// load the before_process function from the payment modules

//************
  if( defined(MODULE_PAYMENT_AUTHORIZENET_STATUS) && (MODULE_PAYMENT_AUTHORIZENET_STATUS == 'True') && ($payment == 'authorizenet') ) {
    include(DIR_WS_MODULES . 'authorizenet_direct.php');
    $payment_modules->before_process();
  }
//************************************************************

 //quickcommerce
 if(defined(MODULE_PAYMENT_QUICKCOMMERCE_STATUS) && (MODULE_PAYMENT_QUICKCOMMERCE_STATUS =='True') && ($payment == 'quickcommerce')) {
    include(DIR_WS_MODULES . 'quickcommerce_direct.php');
    $payment_modules->before_process();
  }
//***********************************
  if(defined(MODULE_PAYMENT_PLUGNPAY_STATUS) && (MODULE_PAYMENT_PLUGNPAY_STATUS =='True')  && ($payment == 'plugnpay')) {
    include(DIR_WS_MODULES . 'plugnpay_api.php');
    $payment_modules->before_process();
  }



//insert order total

  for ($i=0, $n=sizeof($order_totals); $i<$n; $i++) {
    $sql_data_array = array('orders_id' => $insert_id,
                            'title' => $order_totals[$i]['title'],
                            'text' => $order_totals[$i]['text'],
                            'value' => $order_totals[$i]['value'],
                            'class' => $order_totals[$i]['code'],
                            'sort_order' => $order_totals[$i]['sort_order']);
    tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
  }

  $customer_notification = (SEND_EMAILS == 'true') ? '1' : '0';
  $sql_data_array = array('orders_id' => $insert_id,
                          'orders_status_id' => $order->info['order_status'],
                          'date_added' => 'now()',
                          'customer_notified' => $customer_notification,
                          'comments' => $order->info['comments']);
if ($order->info['order_status'] != 0 ) {
  tep_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);
}

// initialized for the email confirmation
  $products_ordered = '';
  $subtotal = 0;
  $total_tax = 0;

  for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
// Stock Update - Joao Correia
//++++ QT Pro: Begin Changed code
    $products_stock_attributes=null;
    if (STOCK_LIMITED == 'true') {
        $products_attributes = $order->products[$i]['attributes'];
//      if (DOWNLOAD_ENABLED == 'true') {
//++++ QT Pro: End Changed Code
        $stock_query_raw = "SELECT products_quantity, pad.products_attributes_filename 
                            FROM " . TABLE_PRODUCTS . " p
                            LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                             ON p.products_id=pa.products_id
                            LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                             ON pa.products_attributes_id=pad.products_attributes_id
                            WHERE p.products_id = '" . tep_get_prid($order->products[$i]['id']) . "'";
// Will work with only one option for downloadable products
// otherwise, we have to build the query dynamically with a loop
//++++ QT Pro: Begin Changed code
//      $products_attributes = $order->products[$i]['attributes'];
//++++ QT Pro: End Changed Code
        if (is_array($products_attributes)) {
          $stock_query_raw .= " AND pa.options_id = '" . $products_attributes[0]['option_id'] . "' AND pa.options_values_id = '" . $products_attributes[0]['value_id'] . "'";
        }
        $stock_query = tep_db_query($stock_query_raw);
      } else {
        $stock_query = tep_db_query("select products_quantity from " . TABLE_PRODUCTS . " where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
      }
      if (tep_db_num_rows($stock_query) > 0) {
        $stock_values = tep_db_fetch_array($stock_query);
//++++ QT Pro: Begin Changed code
        $actual_stock_bought = $order->products[$i]['qty'];
        $download_selected = false;
        if ((DOWNLOAD_ENABLED == 'true') && isset($stock_values['products_attributes_filename']) && tep_not_null($stock_values['products_attributes_filename'])) {
          $download_selected = true;
          $products_stock_attributes='$$DOWNLOAD$$';
        }
// If not downloadable and attributes present, adjust attribute stock
        if (!$download_selected && is_array($products_attributes)) {
          $all_nonstocked = true;
          $products_stock_attributes_array = array();
          foreach ($products_attributes as $attribute) {
            if ($attribute['track_stock'] == 1) {
              $products_stock_attributes_array[] = $attribute['option_id'] . "-" . $attribute['value_id'];
              $all_nonstocked = false;
            }
          } 
          if ($all_nonstocked) {
            $actual_stock_bought = $order->products[$i]['qty'];
          }  else {
            asort($products_stock_attributes_array, SORT_NUMERIC);
            $products_stock_attributes = implode(",", $products_stock_attributes_array);
            $attributes_stock_query = tep_db_query("select products_stock_quantity from " . TABLE_PRODUCTS_STOCK . " where products_stock_attributes = '$products_stock_attributes' AND products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
            if (tep_db_num_rows($attributes_stock_query) > 0) {
              $attributes_stock_values = tep_db_fetch_array($attributes_stock_query);
              $attributes_stock_left = $attributes_stock_values['products_stock_quantity'] - $order->products[$i]['qty'];
              tep_db_query("update " . TABLE_PRODUCTS_STOCK . " set products_stock_quantity = '" . $attributes_stock_left . "' where products_stock_attributes = '$products_stock_attributes' AND products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
              $actual_stock_bought = ($attributes_stock_left < 1) ? $attributes_stock_values['products_stock_quantity'] : $order->products[$i]['qty'];
            } else {
              $attributes_stock_left = 0 - $order->products[$i]['qty'];
              tep_db_query("insert into " . TABLE_PRODUCTS_STOCK . " (products_id, products_stock_attributes, products_stock_quantity) values ('" . tep_get_prid($order->products[$i]['id']) . "', '" . $products_stock_attributes . "', '" . $attributes_stock_left . "')");
              $actual_stock_bought = 0;
            }
          }
        }
//        $stock_query = tep_db_query("select products_quantity from " . TABLE_PRODUCTS . " where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
//      }
//      if (tep_db_num_rows($stock_query) > 0) {
//        $stock_values = tep_db_fetch_array($stock_query);
// do not decrement quantities if products_attributes_filename exists
        if (!$download_selected) {
          $stock_left = $stock_values['products_quantity'] - $actual_stock_bought;
          tep_db_query("UPDATE " . TABLE_PRODUCTS . " 
                        SET products_quantity = products_quantity - '" . $actual_stock_bought . "' 
                        WHERE products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
//++++ QT Pro: End Changed Code
        if ( ($stock_left < 1) && (STOCK_ALLOW_CHECKOUT == 'false') ) {
          tep_db_query("update " . TABLE_PRODUCTS . " set products_status = '0' where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
        }
      }
    }

// Update products_ordered (for bestsellers list)
    tep_db_query("update " . TABLE_PRODUCTS . " set products_ordered = products_ordered + " . sprintf('%d', $order->products[$i]['qty']) . " where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");

//++++ QT Pro: Begin Changed code
    if (!isset($products_stock_attributes)) $products_stock_attributes=null;
    $sql_data_array = array('orders_id' => $insert_id,
                            'products_id' => tep_get_prid($order->products[$i]['id']),
                            'products_model' => $order->products[$i]['model'],
                            'products_name' => $order->products[$i]['name'],
                            'products_price' => $order->products[$i]['price'],
									//debut modif by paddyl for ecotax
									'ecotax_rates_id' => $order->products[$i]['ecotax_rates_id'],
                                    'final_price' => $order->products[$i]['final_price']+tep_round(tep_get_ecotax_price_value($order->products[$i]['ecotax_rates_id'])+tep_get_ecotax_price_value($order->products[$i]['ecotax_rates_id'])*($order->products[$i]['ecotax_taxe_rate']/100),2),
									//fin modif by paddybl for ecotax
                            'products_tax' => $order->products[$i]['tax'],
									//debut modif by paddyl for ecotax
                            		'products_ecotax' => tep_round(tep_get_ecotax_price_value($order->products[$i]['ecotax_rates_id'])+tep_get_ecotax_price_value($order->products[$i]['ecotax_rates_id'])*($order->products[$i]['ecotax_taxe_rate']/100), $currencies->currencies[DEFAULT_CURRENCY]['decimal_places']),
									//fin modif by paddybl for ecotax
                            'products_quantity' => $order->products[$i]['qty'],
                            'products_stock_attributes' => $products_stock_attributes);
//++++ QT Pro: End Changed Code
    tep_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array);
    $order_products_id = tep_db_insert_id();
    $order_total_modules->update_credit_account($i);//ICW ADDED FOR CREDIT CLASS SYSTEM

//------insert customer choosen option to order--------
    $products_ordered_attributes = '';
    if (isset($order->products[$i]['attributes'])) {
      for ($j=0, $n2=sizeof($order->products[$i]['attributes']); $j<$n2; $j++) {
        
        $sql_data_array = array('orders_id' => $insert_id,
                                'orders_products_id' => $order_products_id,
                                'products_options' => $order->products[$i]['attributes'][$j]['option'],
                                'products_options_values' => $order->products[$i]['attributes'][$j]['value'],
                                'options_values_price' => $order->products[$i]['attributes'][$j]['price'],
                                'price_prefix' => $order->products[$i]['attributes'][$j]['prefix'],
                                'products_options_id' => $order->products[$i]['attributes'][$j]['option_id'],
                                'products_options_values_id' => $order->products[$i]['attributes'][$j]['value_id']);
        tep_db_perform(TABLE_ORDERS_PRODUCTS_ATTRIBUTES, $sql_data_array);
        
        if (DOWNLOAD_ENABLED == 'true') {
          $attributes_query = "select pad.products_attributes_maxdays, pad.products_attributes_maxcount , pad.products_attributes_filename
                           from " . TABLE_PRODUCTS_ATTRIBUTES . " pa,
                                " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                              where pa.products_id = '" . $order->products[$i]['id'] . "'
                                and pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "'
                                and pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "'
                                and pa.products_attributes_id = pad.products_attributes_id";
          $attributes = tep_db_query($attributes_query);
          
          $attributes_values = tep_db_fetch_array($attributes);
        
          if ( isset($attributes_values['products_attributes_filename']) && tep_not_null($attributes_values['products_attributes_filename']) ) {
            $sql_data_array = array('orders_id' => $insert_id,
                                    'orders_products_id' => $order_products_id,
                                    'orders_products_filename' => $attributes_values['products_attributes_filename'],
                                    'download_maxdays' => $attributes_values['products_attributes_maxdays'],
                                    'download_count' => $attributes_values['products_attributes_maxcount']);
            tep_db_perform(TABLE_ORDERS_PRODUCTS_DOWNLOAD, $sql_data_array);
          }
        }
		//debut modif by paddyl for ecotax

        $products_ordered_attributes .= "\n\t" . $order->products[$i]['attributes'][$j]['option'] . ' ' . $order->products[$i]['attributes'][$j]['value'] . ' ' . $order->products[$i]['attributes'][$j]['prefix'] . ' ' . $currencies->display_price($order->products[$i]['attributes'][$j]['price'], tep_get_tax_rate($products[$i]['tax_class_id']),0, 1);
		//fin modif by paddybl for ecotax
      }
    }
//------insert customer choosen option eof ----
    $total_weight += ($order->products[$i]['qty'] * $order->products[$i]['weight']);
    $total_tax += tep_calculate_tax($total_products_price, $products_tax) * $order->products[$i]['qty'];
    $total_cost += $total_products_price;

//debut modif by paddybl for ecotax
    $products_ordered .= $order->products[$i]['qty'] . ' x ' . tep_db_decoder($order->products[$i]['name']) . ' (' . $order->products[$i]['model'] . ') = ' . $currencies->display_price($order->products[$i]['final_price'], $order->products[$i]['tax'],0, $order->products[$i]['qty']) . $products_ordered_attributes . "\n";
	if (MODULE_ORDER_TOTAL_ECOTAX_STATUS=='true' && !$order->products[$i]['ecotax_rates_id']=="0"){$products_ordered .='Eco-participation : Catgorie '.$order->products[$i]['ecotax_description'][0]['code'].' '.''.$currencies->display_price(tep_get_ecotax_price_value($order->products[$i]['ecotax_rates_id']), $order->products[$i]['ecotax_taxe_rate'],0, $order->products[$i]['qty']).'<br>';}
//fin modif by paddybl for ecotax
  }
$order_total_modules->apply_credit();//ICW ADDED FOR CREDIT CLASS SYSTEM
// lets start with the email confirmation

  // Include OSC-AFFILIATE
  require(DIR_WS_INCLUDES . 'affiliate_checkout_process.php');

  if (!tep_session_is_registered('noaccount'))
{
$email_order = STORE_NAME . "\n" .
EMAIL_RECAP_COMMANDE_DEBUT . "\n" .
EMAIL_SEPARATOR . "\n" .
EMAIL_TEXT_ORDER_NUMBER . ' ' . $insert_id . "\n" .
EMAIL_TEXT_INVOICE_URL . ' ' . tep_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $insert_id, 'SSL', false) . "\n" .
EMAIL_TEXT_DATE_ORDERED . ' ' . strftime(DATE_FORMAT_LONG) . "\n\n";
}else{
$email_order = STORE_NAME . "\n" .
EMAIL_SEPARATOR . "\n" .
EMAIL_TEXT_ORDER_NUMBER . ' ' . $insert_id . "\n" .
EMAIL_TEXT_DATE_ORDERED . ' ' . strftime(DATE_FORMAT_LONG) . "\n\n";
}

// EOF: daithik change for PWA

  if ($order->info['comments']) {
    $email_order .= tep_db_output($order->info['comments']) . "\n\n";
  }
  $email_order .= EMAIL_TEXT_PRODUCTS . "\n" .
                  EMAIL_SEPARATOR . "\n" .
                  $products_ordered .
                  EMAIL_SEPARATOR . "\n";

  for ($i=0, $n=sizeof($order_totals); $i<$n; $i++) {
//    $email_order .= strip_tags($order_totals[$i]['title']) . ' ' . strip_tags($order_totals[$i]['text']) . "\n";

    $email_order .= ($order_totals[$i]['title']) . ' ' . ($order_totals[$i]['text']) . "\n";
  }

  if ($order->content_type != 'virtual') {
    $email_order .= "\n" . EMAIL_TEXT_DELIVERY_ADDRESS . "\n" .
                    EMAIL_SEPARATOR . "\n" .
                    tep_address_label($customer_id, $sendto, 0, '', "\n") . "\n";
  }

  $email_order .= "\n" . EMAIL_TEXT_BILLING_ADDRESS . "\n" .
                  EMAIL_SEPARATOR . "\n" .
                  tep_address_label($customer_id, $billto, 0, '', "\n") . "\n\n";
  if (is_object($$payment)) {
    $email_order .= EMAIL_TEXT_PAYMENT_METHOD . "\n" .
                    EMAIL_SEPARATOR . "\n";
    $payment_class = $$payment;
    $email_order .= $payment_class->title . "\n\n";
    if ($payment_class->email_footer) {
      $email_order .= $payment_class->email_footer . "\n\n";
    }
  }
      $email_order .= EMAIL_RECAP_COMMANDE_FIN . "\n\n";
  
  tep_mail($order->customer['firstname'] . ' ' . $order->customer['lastname'], $order->customer['email_address'], EMAIL_TEXT_SUBJECT, $email_order, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);

// send emails to other people
  if (SEND_EXTRA_ORDER_EMAILS_TO != '') {
    tep_mail('', SEND_EXTRA_ORDER_EMAILS_TO, EMAIL_TEXT_SUBJECT, $email_order, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);
  }

// load the after_process function from the payment modules
  $payment_modules->after_process();
  
// AFSv1.0 - record the customers order and ip address info for fraud screening process

$ip = $REMOTE_ADDR;
$proxy = $HTTP_X_FORWARDED_FOR;
if($proxy != ''){ $ip = $proxy; }
$sql_data_array = array( 'order_id' => $insert_id,
'ip_address' => $ip);

tep_db_perform('algozone_fraud_queries', $sql_data_array);

// End AFSv1.0
  $cart->reset(true);

// unregister session variables used during checkout
  tep_session_unregister('sendto');
  tep_session_unregister('billto');
  tep_session_unregister('shipping');
  tep_session_unregister('payment');
  tep_session_unregister('comments');
  if(tep_session_is_registered('credit_covers')) tep_session_unregister('credit_covers');
  $order_total_modules->clear_posts();//ICW ADDED FOR CREDIT CLASS SYSTEM
// BOF: Lango added for print order mod

//  tep_redirect(tep_href_link(FILENAME_CHECKOUT_SUCCESS, 'spcheckok', 'SSL'));//NBen je rajoute pour SPPLUS
  //tep_redirect(tep_href_link(FILENAME_CHECKOUT_SUCCESS, '' . urlencode('spcheckok'), 'SSL'));//NBen je teste error_message=


////////////////////////////////////////////////////////////////////////////
                     break;
                  case 2:
                     $info = "etat=2 : autorisation de paiement refus - commande annule";
                     break;
                  case 4:
                     $info = "etat=4 : paiement par carte accept et en attente de remise";
////////////////////////////////////////////////////////////////////////////
				       $commande_query = tep_db_query("select orders_id, refsfp  from " . TABLE_ORDERS . " where refsfp = '" . $refsfp . "'");
      
					      if (tep_db_num_rows($commande_query) > 0) {
					        $commande_values = tep_db_fetch_array($commande_query);

  $customer_notification =  '0';

// statut  en traitement bancaire

              tep_db_query("update " . TABLE_ORDERS . " set  orders_status = '10' where refsfp = '" . $refsfp . "'");

  $sql_data_array = array('orders_id' => $commande_values['orders_id'],
                          'orders_status_id' => 10,
                          'date_added' => 'now()',
                          'customer_notified' => $customer_notification,
                          'comments_interne' => $info);
  tep_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);

							
						  }
////////////////////////////////////////////////////////////////////////////
                     break;
                  case 5:
                     $info = "etat=5 : paiement refus -  commande annule";
////////////////////////////////////////////////////////////////////////////
				       $commande_query = tep_db_query("select orders_id, refsfp  from " . TABLE_ORDERS . " where refsfp = '" . $refsfp . "'");
      
					      if (tep_db_num_rows($commande_query) > 0) {
					        $commande_values = tep_db_fetch_array($commande_query);

  $customer_notification =  '0';

// statut rembourse


              tep_db_query("update " . TABLE_ORDERS . " set  orders_status = '8' where refsfp = '" . $refsfp . "'");

  $sql_data_array = array('orders_id' => $commande_values['orders_id'],
                          'orders_status_id' => 8,
                          'date_added' => 'now()',
                          'customer_notified' => $customer_notification,
                          'comments_interne' => $info);
  tep_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);


							
						  }
////////////////////////////////////////////////////////////////////////////
                     break;
                  case 6:
                     $info = "etat=6 : paiement par chque accept -  commande en attente";
                     break;
                  case 8:
                     $info = "etat=8 : chque encaiss - commande valide";
                     break;
                  case 10:
                     $info = "etat=10 : transaction termine";
                     break;
                  case 11:
                     $info = "etat=11 : Paiement annul par le commerant -  commande annule";
////////////////////////////////////////////////////////////////////////////
				       $commande_query = tep_db_query("select orders_id, refsfp  from " . TABLE_ORDERS . " where refsfp = '" . $refsfp . "'");
      
					      if (tep_db_num_rows($commande_query) > 0) {
					        $commande_values = tep_db_fetch_array($commande_query);

  $customer_notification =  '0';

// statut regl transaction termni


              tep_db_query("update " . TABLE_ORDERS . " set  orders_status = '8' where refsfp = '" . $refsfp . "'");

  $sql_data_array = array('orders_id' => $commande_values['orders_id'],
                          'orders_status_id' => 8,
                          'date_added' => 'now()',
                          'customer_notified' => $customer_notification,
                          'comments_interne' => $info);
  tep_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);


							
						  }
////////////////////////////////////////////////////////////////////////////
                     break;
                  case 12:
                     $info = "etat=12 : Abandon de linternaute - panier vid - commande annule";
                     break;
                  case 15:
                     $info = "etat=15 : remboursement - traitement compte client";
////////////////////////////////////////////////////////////////////////////
				       $commande_query = tep_db_query("select orders_id, refsfp  from " . TABLE_ORDERS . " where refsfp = '" . $refsfp . "'");
      
					      if (tep_db_num_rows($commande_query) > 0) {
					        $commande_values = tep_db_fetch_array($commande_query);

  $customer_notification =  '0';

// statut rembourse


              tep_db_query("update " . TABLE_ORDERS . " set  orders_status = '11' where refsfp = '" . $refsfp . "'");

  $sql_data_array = array('orders_id' => $commande_values['orders_id'],
                          'orders_status_id' => 11,
                          'date_added' => 'now()',
                          'customer_notified' => $customer_notification,
                          'comments_interne' => $info);
  tep_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);


							
						  }
////////////////////////////////////////////////////////////////////////////
                     break;

                     $info = "etat=30 : remboursement - traitement compte client";
////////////////////////////////////////////////////////////////////////////
				       $commande_query = tep_db_query("select orders_id, refsfp  from " . TABLE_ORDERS . " where refsfp = '" . $refsfp . "'");
      
					      if (tep_db_num_rows($commande_query) > 0) {
					        $commande_values = tep_db_fetch_array($commande_query);

  $customer_notification =  '0';

// statut rembourse


              tep_db_query("update " . TABLE_ORDERS . " set  orders_status = '2' where refsfp = '" . $refsfp . "'");

  $sql_data_array = array('orders_id' => $commande_values['orders_id'],
                          'orders_status_id' => 2,
                          'date_added' => 'now()',
                          'customer_notified' => $customer_notification,
                          'comments_interne' => $info);
  tep_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);


							
						  }
////////////////////////////////////////////////////////////////////////////
                     break;
                  case 99:
                     $info = "etat=99 : Paiement de test en production - panier vid - commande annule";
                     break;
               }
               echo ($info."<p>");
						    	  //            mail('admin@artoisweb.com', 'info', $info); 

            }
            else { $message = "ERREUR_HMAC"; }

            //------------------------------------------------------------------------------------------------------------
            // on affiche le rsultat du traitement hmac
            echo("<b>Hmac reu : </b>" . $_GET["hmac"] . "<br>");
            echo("<b>Hmac calcul : </b>" . $hmac_calcule . "<p>");
            echo("<b>Rsultat : " . $message . "</b>");
          }
      }
    	// on a pas p charger la librairie php_spplus.so
      else
      {
         echo("extension SP PLUS non charge");
      }
   }
?>