/*-----------------------------------------------------------*/
/* NOM........  genks.c                                      */
/* OBJET......  High Level API secure functions              */
/* PROJET.....  SFP V.1                                      */
/* REFERENCES.                                               */
/* VERSION....  1.0                                          */
/* HISTORIQUE.                                               */
/*-----------------------------------------------------------*/

/*----------------------------------------------------------*/
/*          Include Files                                   */
/*----------------------------------------------------------*/

#include <stdio.h>   /* printf */
#include <string.h>
#include "sha.h"


/*----------------------------------------------------------*/
/*          var declaration                                 */
/*----------------------------------------------------------*/
static char b1[128]={
    0x30,0x82,0x06,0x2F,0x30,0x82,0x05,0x17,0xA0,0x03,0x02,0x01,0x02,0x02,0x01,0x6A,
    0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x30,
    0x20,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x11,
    0x30,0x0F,0x06,0x03,0x55,0x04,0x0A,0x13,0x08,0x53,0x45,0x54,0x20,0x52,0x6F,0x6F,
    0x74,0x30,0x1E,0x17,0x0D,0x39,0x37,0x30,0x37,0x31,0x35,0x30,0x30,0x30,0x30,0x30,
    0x30,0x5A,0x17,0x0D,0x30,0x34,0x30,0x37,0x31,0x35,0x30,0x30,0x30,0x30,0x30,0x30,
    0x5A,0x30,0x20,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,
    0x31,0x11,0x30,0x0F,0x06,0x03,0x55,0x04,0x0A,0x13,0x08,0x53,0x45,0x54,0x20,0x52
    };

static char b2[128]={
    0x20,0x00,0x58,0xD9,0xF4,0x40,0x13,0x18,0x77,0x0C,0xB5,0x04,0xDE,0xB7,0xB6,0x43,
    0x8B,0xA4,0xCC,0x36,0x76,0x79,0xC5,0x0B,0x17,0xCB,0x7E,0x88,0xA1,0x33,0xB0,0xD3,
    0x34,0x27,0xBF,0x3B,0x61,0xDA,0xC5,0x20,0xEB,0xF9,0x94,0x9A,0x8B,0x79,0xB2,0xA8,
    0x8E,0xCB,0xC1,0xD9,0x94,0x4A,0x99,0x66,0x50,0x55,0xB2,0x83,0x28,0x7D,0x22,0x3D,
    0xEC,0xDC,0xA3,0xE8,0x39,0xDB,0x83,0x54,0xC9,0x89,0xA9,0xDF,0x59,0x52,0x9F,0x7A,
    0xEF,0x7C,0x11,0x62,0x52,0xEC,0xE6,0x67,0xBA,0x3D,0xEA,0xAB,0x47,0xDB,0xE4,0xF4,
    0x1F,0x73,0xC3,0x3D,0xEC,0x7E,0x84,0x7D,0x2F,0x29,0xFE,0x6C,0x17,0x3F,0x75,0x6D,
    0x56,0x6E,0xC0,0x4E,0xB5,0xBF,0x2A,0x20,0x8A,0xE4,0x57,0xAE,0xC0,0x2E,0x68,0xC9
    };


/*----------------------------------------------------------*/
/*              GenKs()                                     */
/*----------------------------------------------------------*/
void GenKs(unsigned char* Ks)
{
    int i;
    unsigned char c[20];
    unsigned char b3[128];

/*  printf("GenKs\n");  */

    memcpy(b3,b1,128);
    for(i=0; i<128;i++ )  b3[i]^=b2[i];
    ShaProc((unsigned char*)b3,128,c);
    memcpy(Ks,c,8);
    
};
