/*
  +----------------------------------------------------------------------+
  | PHP Version 4                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2002 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 2.02 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available at through the world-wide-web at                           |
  | http://www.php.net/license/2_02.txt.                                 |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: GCE Newtec <service.installation@spplus.net>                 |
  |         CHAILLAN Nicolas <nicos@php.net>                             |
  +----------------------------------------------------------------------+

  $Id: php_spplus.c,v 1.5 2007/05/22 16:19:45 bodj Exp $
*/


  #include "config.h"


#include "php.h"
#include "php_ini.h"

#include "spp_signe.h"

ZEND_MINFO_FUNCTION(php_spplus);
ZEND_FUNCTION(calcul_hmac);
ZEND_FUNCTION(nthmac);
ZEND_FUNCTION(signeurlpaiement);
ZEND_FUNCTION(calculhmac);

/* {{{ spplus_functions[] */
zend_function_entry php_spplus_functions[] = {
  ZEND_FE(calcul_hmac,  NULL)
  ZEND_FE(nthmac, NULL)
  ZEND_FE(signeurlpaiement, NULL)
  ZEND_FE(calculhmac, NULL)
  {NULL, NULL, NULL}  
};
/* }}} */

/* {{{ spplus_module_entry */
zend_module_entry php_spplus_module_entry={
  STANDARD_MODULE_HEADER,
  "SPPLUS",
  php_spplus_functions,
  NULL,
  NULL,
  NULL,
  NULL,
  ZEND_MINFO(php_spplus),
  "3.0",
  STANDARD_MODULE_PROPERTIES
};
/* }}} */

#if COMPILE_DL_PHP_SPPLUS
ZEND_GET_MODULE(php_spplus)
#endif

/* {{{ ZEND_MINFO_FUNCTION
 */
ZEND_MINFO_FUNCTION(php_spplus)
{
  php_info_print_table_start();
  php_info_print_table_row(2, "SPPLUS functions", "enabled ");
  php_info_print_table_end();

}
/* }}} */

/* {{{ proto string calcul_hmac(string clent , string codesiret , string reference , string langue , string devise , string montant , string taxe , string validite) Getting a calcul_hmac key. */
ZEND_FUNCTION(calcul_hmac)
{
  char *iclent, *icodesiret, *ireference, *ilangue, *idevise, *imontant, *itaxe, *ivalidite;
  int   iclent_len, icodesiret_len, ireference_len, ilangue_len, idevise_len, imontant_len, itaxe_len, ivalidite_len;
  char *result;
  
  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ssssssss", &iclent, &iclent_len, &icodesiret, &icodesiret_len, &ireference, &ireference_len, &ilangue, &ilangue_len, &idevise, &idevise_len, &imontant, &imontant_len, &itaxe, &itaxe_len, &ivalidite, &ivalidite_len) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  result = sp_calcul_hmac(iclent, icodesiret, ireference, ilangue, idevise, imontant, itaxe, ivalidite);

  RETURN_STRING(result, 1);
}
/* }}} */

/* {{{ proto string nthmac(string clent , string data) Getting a nthmac key. Note that data is: $data = "$codesiret$reference$langue$devise$montant$taxe$validite"; */
ZEND_FUNCTION(nthmac)
{
  char   *iclent, *idata;
  int   iclent_len, idata_len;
  char   *result;

  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ss", &iclent, &iclent_len, &idata, &idata_len) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  result = sp_NTHMAC(iclent, idata);

  RETURN_STRING(result, 1);
}
/* }}} */

/* {{{ proto string signerurlpaiement(string clent , string data) Getting a url for the paiement redirection. Note that data is: $data = "$codesiret$reference$langue$devise$montant$taxe$validite"; */
ZEND_FUNCTION(signeurlpaiement)
{
  char   *iclent, *idata;
  int   iclent_len, idata_len;
  char   *result;

  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ss", &iclent, &iclent_len, &idata, &idata_len) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  result = sp_signeURLPaiement(iclent, idata);

  RETURN_STRING(result, 1);
}
/* }}} */

/* {{{ proto string calculhmac(string clent , string data) Getting a calculhmac key. Note that data is: $data = "$codesiret$reference$langue$devise$montant$taxe$validite"; */
ZEND_FUNCTION(calculhmac)
{
  char   *iclent, *idata;
  int   iclent_len, idata_len;
  char   *result;

  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ss", &iclent, &iclent_len, &idata, &idata_len) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  result = sp_CalculHmac(iclent, idata);

  RETURN_STRING(result, 1);

}
/* }}} */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
