<?php
	
	class AMAZ_SP_API
	{
		
		protected $host = "https://sellingpartnerapi-eu.amazon.com";
		protected $hostSts = "https://sts.amazonaws.com";        
		protected $CanonicalUri;		
		protected $apiOAuthUrl;
		protected $awsStsVersion = "2011-06-15";
		protected $awsRegion = "eu-west-1";
		protected $awsRegionSts = "us-east-1";		
		protected $RoleArn;
		protected $appClientID;
		protected $appClientSecret;
		protected $awsUserKey;
		protected $awsUserSecret;
		protected $refreshToken;
		protected $accessToken;
		protected $service = "execute-api";
		protected $serviceSts = "sts";
		protected $uriPath;
		protected $terminationString	= 'aws4_request';
		
		protected $reqDate ;
		protected $reqDateTime ;
		
		protected $MarketplaceIds = array();
		
		protected $AccessKey;
		protected $SecretKey;
		protected $SessionToken;
		protected $nextToken;
        
        protected $Test;
		protected $StrRegionMarketID;
		
		protected $IsRestrictedDataToken = FALSE;
		protected $restrictedDataToken = "";
		protected $withOrderStatus = "";
				
		
		protected $isAssumeRole = FALSE ;
        
        protected $debugTab = array();
        protected $debug = FALSE;
		
		protected $config = array();
		
		protected $Market;
		const     _US_EAST_1_ = "us-east-1";		//North America (Canada, US, Mexico, and Brazil marketplaces)	https://sellingpartnerapi-na.amazon.com	us-east-1
		const     _EU_WEST_1_ = "eu-west-1"; //Europe (Spain, UK, France, Belgium, Netherlands, Germany, Italy, Sweden, Poland, Saudi Arabia, Egypt, Turkey, United Arab Emirates, and India marketplaces)	https://sellingpartnerapi-eu.amazon.com	eu-west-1
		const     _US_WEST_2_ = "us-west-2";	// Far East (Singapore, Australia, and Japan marketplaces)	https://sellingpartnerapi-fe.amazon.com	us-west-2
		
        public function __construct()
        {
			
			$this->Market["us-east-1"]["Endpoints"] = "https://sellingpartnerapi-na.amazon.com";
			$this->Market["us-east-1"]["MarketplaceID"]["CA"] = "A2EUQ1WTGCTBG2"; //Canada
			$this->Market["us-east-1"]["MarketplaceID"]["US"] = "ATVPDKIKX0DER"; //United States of America
			$this->Market["us-east-1"]["MarketplaceID"]["MX"] = "A1AM78C64UM0Y8"; // Mexico
			$this->Market["us-east-1"]["MarketplaceID"]["BR"] = "A2Q3Y263D00KWC"; // Brazil
			
			
			$this->Market["eu-west-1"]["Endpoints"] = "https://sellingpartnerapi-eu.amazon.com";
			$this->Market["eu-west-1"]["MarketplaceID"]["ES"] = "A1RKKUPIHCS9HS"; //Spain			
			$this->Market["eu-west-1"]["MarketplaceID"]["UK"] = "A1F83G8C2ARO7P"; //United Kingdom			
			$this->Market["eu-west-1"]["MarketplaceID"]["FR"] = "A13V1IB3VIYZZH"; //France			
			$this->Market["eu-west-1"]["MarketplaceID"]["BE"] = "AMEN7PMS3EDWL";  //Belgium			
			$this->Market["eu-west-1"]["MarketplaceID"]["NL"] = "A1805IZSGTT6HS"; //Netherlands			
			$this->Market["eu-west-1"]["MarketplaceID"]["DE"] = "A1PA6795UKMFR9"; //Germany		
			$this->Market["eu-west-1"]["MarketplaceID"]["IT"] = "APJ6JRA9NG5V4";  //Italy		
			$this->Market["eu-west-1"]["MarketplaceID"]["SE"] = "A2NODRKZP88ZB9"; //Sweden	
			$this->Market["eu-west-1"]["MarketplaceID"]["PL"] = "A1C3SOZRARQ6R3"; //Poland	
	//		$this->Market["eu-west-1"]["MarketplaceID"]["EG"] = "ARBP9OOSHTCHU";  //Egypt	
			$this->Market["eu-west-1"]["MarketplaceID"]["TR"] = "A33AVAJ2PDY3EV"; //Turkey
	//		$this->Market["eu-west-1"]["MarketplaceID"]["SA"] = "A17E79C6D8DWNP"; //Saudi Arabia	
	//		$this->Market["eu-west-1"]["MarketplaceID"]["AE"] = "A2VIGQ35RCS4UG"; //United Arab Emirates
	//		$this->Market["eu-west-1"]["MarketplaceID"]["IN"] = "A21TJRUUN4KGV";  //India
			
			
			$this->Market["us-west-2"]["Endpoints"] = "https://sellingpartnerapi-fe.amazon.com";	
			$this->Market["us-west-2"]["MarketplaceID"]["SG"] = "A19VAU5U5O7RUS"; //Singapore
			$this->Market["us-west-2"]["MarketplaceID"]["AU"] = "A39IBJ37TRP1C6"; //Australia
			$this->Market["us-west-2"]["MarketplaceID"]["JP"] = "A1VC38T7YXB528"; //Japan
			
			$this->isAssumeRole = false;
			
			$this->SetVariableDateTimeReq();

			//$this->$StrRegionMarketID  = explode(",",$this->Market[["MarketplaceID"]]);
					
		}
        
		//_________________________________________________________________________________________________________________________		
		public function SetAwsRegion($v) 		{	
			$this->awsRegion = $v;	
			$this->host = $this->Market[$this->awsRegion]["Endpoints"];
			$this->CanonicalUri = parse_url($this->host, PHP_URL_HOST);
			//printr($this->Market[$this->awsRegion]["MarketplaceID"]);
			$this->StrRegionMarketID = implode(",",$this->Market[$this->awsRegion]["MarketplaceID"]);
			$this->GetMarketPlaceArrayLst();
		}    
		//_________________________________________________________________________________________________________________________		
		public function SetTest($v) 				{	$this->Test = $v;	}        
		public function SetRoleArn($v) 				{	$this->RoleArn = $v;	}
		public function SetAppClientID($v) 			{	$this->appClientID = $v;	}
		public function SetAppClientSecret($v) 		{	$this->appClientSecret = $v;	}
		public function SetAwsUserKey($v) 			{	$this->awsUserKey = $v;	}        
		public function SetAwsUserSecret($v) 		{	$this->awsUserSecret = $v;	}
		public function SetRefreshToken($v) 		{	$this->refreshToken = $v;	}
		public function SetAccessToken($v) 	    	{	$this->accessToken = $v;	}		
		public function SetApiOAuthUrl($v) 	    	{	$this->apiOAuthUrl = $v;	}
		public function SetDebug($v) 	        	{	$this->debug = $v;	}    
		public function SetService($v) 	        	{	$this->service = $v;	} 	
		public function SetAssumeRole($v) 	    	{	$this->isAssumeRole = $v;	} 	
		public function SetIsRestrictedDataToken($v){	$this->IsRestrictedDataToken = $v;	} 	
		public function setWithOrderStatus($v)		{	$this->withOrderStatus = $v;	} 			
		//_________________________________________________________________________________________________________________________			
		public function getIsRestrictedDataToken()  {	return $this->IsRestrictedDataToken ;	} 			
		//_________________________________________________________________________________________________________________________		
		public function SetVariableDateTimeReq() 		{	
			$currentDateTime = new DateTime('UTC'); 
            $this->reqDate = $currentDateTime->format('Ymd');
            $this->reqDateTime = $currentDateTime->format('Ymd\THis\Z');  
		}		
		//_________________________________________________________________________________________________________________________		
		public function GetMarketPlaceArrayLst() 		{	
			$tab = array();
			foreach ($this->Market[$this->awsRegion]["MarketplaceID"] as $key => $v){
				$tab[] = $v;
			}
			$this->MarketplaceIds = $tab;
		}			
		
		//_______________________________________________________________________________________________________________________
		public function getAccessToken() {
			
			$rep = "";
			if($this->accessToken == "") {
				$requestUrl = "https://api.amazon.com/auth/o2/token";
				$headers =  array(
				'Content-Type: application/x-www-form-urlencoded'
				);
				$httpRequestMethod = "POST";
				$data = 'grant_type=refresh_token&refresh_token='.urlencode($this->refreshToken).'&client_id='.$this->appClientID.'&client_secret='.$this->appClientSecret;
				$rep = $this->callToAPI($requestUrl, $httpRequestMethod , $headers, $data, FALSE);
				$tmp = json_decode($rep["response"]);
				//printr($tmp);
                
				$this->accessToken = $tmp->access_token;
                if ($this->isAssumeRole){
                    $this->assumeRole();
				}
			}
			return $rep ;
			
		}
		//_______________________________________________________________________________________________________________________
		public function getSessionTokenHeaderV4($requestUrl,$httpRequestMethod = "GET",$debug = false,$needRestricedDataToken = false) {
			
            //------------------------- 1: Create a Canonical Request for Signature ----------------------------
			
			$canonicalURI = parse_url($requestUrl, PHP_URL_HOST);
			$canonicalPath = parse_url($requestUrl, PHP_URL_PATH);
			$canonicalQueryString = parse_url($requestUrl, PHP_URL_QUERY);			
			
            $canonicalrequest = "";
            $canonicalrequest .= $httpRequestMethod . "\n";
            $canonicalrequest .= $canonicalPath . "\n";
            $canonicalrequest .= $canonicalQueryString . "\n";			
            $canonicalrequest .= "host:".$canonicalURI . "\n";
			if ($needRestricedDataToken)  $canonicalrequest .= "x-amz-access-token:" . $this->restrictedDataToken . "\n";
            else $canonicalrequest .= "x-amz-access-token:" . $this->accessToken . "\n";				
            $canonicalrequest .= "x-amz-date:" . $this->reqDateTime . "\n";
            $canonicalrequest .= "\n";
            $canonicalrequest .= "host;x-amz-access-token;x-amz-date" . "\n";
            $canonicalrequest .= strtolower(bin2hex(hash('sha256', '', true)));
			
            if($debug){
                echo "<h5>Canonical to string</h5>";
                echo "<pre>";
                echo $canonicalrequest;
                echo "</pre>";
			}
			
            //------------------------- 2: Create a String to Sign for Signature ------------------------------
			
            $Algorithm = 'AWS4-HMAC-SHA256';
            $RequestDateTime = $this->reqDateTime;
            $CredentialScope = $this->reqDate . '/'.$this->awsRegion.'/'.$this->service.'/'.$this->terminationString;
            $HashedCanonicalRequest = strtolower(bin2hex(hash('sha256', $canonicalrequest, true)));
            $StringToSign = $Algorithm . "\n" . $RequestDateTime . "\n" . $CredentialScope . "\n" . $HashedCanonicalRequest;
            if($debug){
                echo "<h5>String to Sign</h5>";
                echo "<pre>";
                echo $StringToSign ;
                echo "</pre>";
			}			
            //-------------------------------- 3: Calculate the AWS Signature -----------------------------------
            
            $kSecret = "AWS4" . $this->awsUserSecret;
            $kDate = hash_hmac('sha256', $this->reqDate, $kSecret, true);
            $kRegion = hash_hmac('sha256', $this->awsRegion, $kDate, true);
            $kService = hash_hmac('sha256', $this->service, $kRegion, true);
            $kSigning = hash_hmac('sha256', 'aws4_request', $kService, true);
            
            $notHexSignature = hash_hmac('sha256', $StringToSign, $kSigning, true);
            $signature = strtolower(bin2hex($notHexSignature));    
			
            //-------------------------- 4: Add the AWS Signature to the Request --------------------------------
			$session_token_header[] = 'X-Amz-Date: ' . $this->reqDateTime;
			$session_token_header[] = 'Authorization: AWS4-HMAC-SHA256 Credential=' . $this->awsUserKey . '/' . $this->reqDate . '/'.$this->awsRegion.'/'.$this->service.'/'.$this->terminationString.', SignedHeaders=host;x-amz-access-token;x-amz-date, Signature=' . $signature;           
			
			if ($needRestricedDataToken) $session_token_header[] = 'x-amz-access-token: ' . $this->restrictedDataToken ;
			else $session_token_header[] = 'x-amz-access-token: ' . $this->accessToken ;
			
			//printr($session_token_header);	
			Return $session_token_header;
			
			
		}	
		//_______________________________________________________________________________________________________________________
		public function getSessionTokenHeaderV4Sts($requestUrl,$httpRequestMethod = "GET",$debug = false) {
			
            //------------------------- 1: Create a Canonical Request for Signature ----------------------------
			
		//	$canonicalURI = parse_url($requestUrl, PHP_URL_HOST);
		//	$canonicalPath = parse_url($requestUrl, PHP_URL_PATH);
		//	$canonicalQueryString = parse_url($requestUrl, PHP_URL_QUERY);		
		
			$canonicalURI = "sts.amazonaws.com";
			$canonicalPath = "/";
			$canonicalQueryString = "Version=".$this->awsStsVersion."&Action=AssumeRole&RoleSessionName=seb&RoleArn=" .urlencode($this->RoleArn);					
			
            $canonicalrequest = "";
            $canonicalrequest .= $httpRequestMethod . "\n";
            $canonicalrequest .= $canonicalPath . "\n";
//$canonicalrequest .= $canonicalQueryString .($this->RoleArn) . "\n";		
            $canonicalrequest .= $canonicalQueryString . "\n";	
	//		$canonicalrequest .= "content-type:application/x-www-form-urlencoded; charset=utf-8". "\n";
            $canonicalrequest .= "host:".$canonicalURI . "\n";
			//echo "<br>".$canonicalQueryString;

			
			
			//    $canonicalrequest .= "x-amz-access-token:" . $this->accessToken . "\n";				
            $canonicalrequest .= "x-amz-date:" . $this->reqDateTime . "\n";
            $canonicalrequest .= "\n";
            $canonicalrequest .= "host;x-amz-date" . "\n";
            $canonicalrequest .= strtolower(bin2hex(hash('sha256', '', true)));
			
            if($debug){
                echo "<h5>Canonical to string</h5>";
                echo "<pre>";
                echo $canonicalrequest;
                echo "</pre>";
			}
            //------------------------- 2: Create a String to Sign for Signature ------------------------------
			
            $Algorithm = 'AWS4-HMAC-SHA256';
            $RequestDateTime = $this->reqDateTime;
            $CredentialScope = $this->reqDate . '/'.$this->awsRegionSts.'/'.$this->serviceSts.'/'.$this->terminationString;
            $HashedCanonicalRequest = strtolower(bin2hex(hash('sha256', $canonicalrequest, true)));
            $StringToSign = $Algorithm . "\n" . $RequestDateTime . "\n" . $CredentialScope . "\n" . $HashedCanonicalRequest;
            if($debug){
                echo "<h5>String to Sign</h5>";
                echo "<pre>";
                echo $StringToSign ;
                echo "</pre>";
			}			
            
            //-------------------------------- 3: Calculate the AWS Signature -----------------------------------
            
            $kSecret = "AWS4" . $this->awsUserSecret;
            $kDate = hash_hmac('sha256', $this->reqDate, $kSecret, true);
            $kRegion = hash_hmac('sha256', $this->awsRegionSts, $kDate, true);
            $kService = hash_hmac('sha256', $this->serviceSts, $kRegion, true);
            $kSigning = hash_hmac('sha256', 'aws4_request', $kService, true);
            
            $notHexSignature = hash_hmac('sha256', $StringToSign, $kSigning, true);
            $signature = strtolower(bin2hex($notHexSignature)); 
            if($debug){
                echo "<h5>signature</h5>";
                echo "<pre>";
                echo $signature;
                echo "</pre>";
			}			
			
            //-------------------------- 4: Add the AWS Signature to the Request --------------------------------
			
            
			$session_token_header[] = 'X-Amz-Date: ' . $this->reqDateTime;
			$session_token_header[] = 'Authorization: AWS4-HMAC-SHA256 Credential=' . $this->awsUserKey . '/' . $this->reqDate . '/'.$this->awsRegionSts.'/'.$this->serviceSts.'/'.$this->terminationString.', SignedHeaders=host;x-amz-date, Signature=' . $signature;           
			//$session_token_header[] = 'x-amz-access-token: ' . $this->accessToken ;
			
			//printr($session_token_header);	
			Return $session_token_header;
			
			
		}				
		//__________________________________________________________________________________________________________________________________
		public function callToAPI($requestUrl, $httpRequestMethod = "GET", $headers, $data, $debug = false){
			// Execute the call
			
			if($debug){
				echo "<h5>Request callToAPI</h5>";
			}	
			
			$curl = curl_init();
			curl_setopt_array($curl, array(
			CURLOPT_URL => $requestUrl,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',	
			CURLOPT_MAXREDIRS => 10,			
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => false,			
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => $httpRequestMethod,
			CURLINFO_HEADER_OUT => true,
			CURLOPT_POSTFIELDS => $data,			
			CURLOPT_HTTPHEADER => $headers,
			));
			
			$response = curl_exec($curl);
			$err = curl_error($curl);
			$responseCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			if (($responseCode <> 200)&&($responseCode <> 201)&&($responseCode <> 202)) $debug = TRUE;
			
			if($debug){
				$headers = curl_getinfo($curl, CURLINFO_HEADER_OUT);
				echo "<h5>Request</h5>";echo "<pre>";echo $headers;	echo "</pre>";
			}	
			curl_close($curl);
			if ($err) {
				if($debug){
					echo "<h5>Error:" . $responseCode . "</h5>";echo "<pre>";echo $err;	echo "</pre>";
				}
			} else {
				if($debug){
					echo "<h5>Response:" . $responseCode . "</h5>";	echo "<pre>";echo $response;echo "</pre>";
				}
			}
			if (($responseCode <> 200)&&($responseCode <> 201)&&($responseCode <> 202)) die("ERREUR CURL");
			return array(
			"responseCode" => $responseCode,
			"response" => $response,			
			"error" => $err
			);
		}// End callToAPI	
		//_______________________________________________________________________________________________________________________
		public function assumeRole() {	
			
			$this->uriPath = "";
			$session_token_url_to_sign = "";
			$session_token_url_to_sign .= $this->hostSts;
			$session_token_url_to_sign .= $this->uriPath;
			$session_token_url_to_sign .= "?";
			$session_token_url_to_sign .= 'Version='.$this->awsStsVersion;            
			
         //   $session_token_url_to_sign .= "&Action=AssumeRole&RoleSessionName=seb&RoleArn=".($this->RoleArn);
            $session_token_url_to_sign .= '&Action=AssumeRole&RoleSessionName=seb&RoleArn='.urlencode($this->RoleArn);			
            //echo $session_token_url_to_sign ; echo "<br>"; 			
			
			
			$session_token_url = $session_token_url_to_sign;
		//	$session_token_url = 'https://sts.amazonaws.com?Version=2011-06-15&Action=AssumeRole&RoleSessionName=seb&RoleArn=arn:aws:iam::217611090416:role/SP-API_client';
			//echo "<h5>session_token_url seb</h5>";echo "<pre>";echo $session_token_url;	echo "</pre>";
			$session_token_header = $this->getSessionTokenHeaderV4Sts($session_token_url_to_sign,"GET",false);
			//printr($session_token_header);     
            
			$requestUrl = $session_token_url;
			// echo $requestUrl ; echo "<br>"; 	
			$headers =  array(
			'Content-Type: application/x-www-form-urlencoded'
			);
			$httpRequestMethod = "GET";
			$data = '';
			$rep = $this->callToAPI($requestUrl, $httpRequestMethod , $session_token_header, $data, false);
			$tmp = json_decode($rep["response"]);
           // printr($tmp);
            
            Return $session_token_header;
		}		
		//__________________________________________________________________________________________________________________________________
		public function getOrders($nextToken = "",$debug = false) {
			
			$this->getAccessToken();
			$this->uriPath = "/orders/v0/orders";
			$d = date('Y-m-d\TH:i:s\Z',time()-15*24*60*60);		
			$d = date('Y-m-d\TH:i:s\Z',time()-7*24*60*60);				
			//$dateCreateAfter = "2023-07-01T20:38:13Z";
			$dateCreateAfter = $d;
			echo $dateCreateAfter;
			//die();
			$needRestricedDataToken = false;
			if ($this->IsRestrictedDataToken)  { 
				$needRestricedDataToken = true;
				$this->getRestrictedData();
			}
			$session_token_url_to_sign = "";
			$session_token_url_to_sign .= $this->host."";
			$session_token_url_to_sign .= $this->uriPath."";
			$session_token_url_to_sign .= "?";
			

			
			if ($nextToken == "") {
				$session_token_url_to_sign .= "CreatedAfter=".urlencode($dateCreateAfter);
				$session_token_url_to_sign .= "&MarketplaceIds=".$this->StrRegionMarketID;
				$session_token_url_to_sign .= "&MaxResultsPerPage=100";	
				$session_token_url_to_sign .= "&OrderStatuses=".$this->withOrderStatus;			
			}else{
				$session_token_url_to_sign .= "NextToken=".urlencode($nextToken);
			}
			//echo $session_token_url_to_sign ; echo "<br>"; 			
			
			
			$session_token_url = $session_token_url_to_sign;
			//echo "<h5>session_token_url seb</h5>";echo "<pre>";echo $session_token_url;	echo "</pre>";
			$session_token_header = $this->getSessionTokenHeaderV4($session_token_url_to_sign,"GET",false,$needRestricedDataToken);
			//printr($session_token_header);
			
			$requestUrl = $session_token_url;
			//echo $requestUrl ; echo "<br>"; 
			$headers =  array(
			'Content-Type: application/x-www-form-urlencoded'
			);
			$httpRequestMethod = "GET";
			$data = '';
			$rep = $this->callToAPI($requestUrl, $httpRequestMethod , $session_token_header, $data, false);
			//printr($rep);
			$rep = json_decode($rep["response"]);
			//printr($tmp);
			//$this->accessToken = $tmp->access_token;
			return $rep ;
		}
		//__________________________________________________________________________________________________________________________________
		public function getRestrictedData($debug = false) {
			
			//$this->getAccessToken();			
			$restrictedResources ='
					{
					  "restrictedResources": [
						{
						  "method": "GET",
						  "path": "/orders/v0/orders",
						  "dataElements": ["buyerInfo", "shippingAddress"]
						}
					  ]
					}
			
			';
			$rep = $this->getRestrictedDataToken($restrictedResources);
			$rep =  json_decode($rep);
			$this->restrictedDataToken = $rep->restrictedDataToken;
			
		}		
		//__________________________________________________________________________________________________________________________________
		public function getOrdersItems($OrderIdAma, $nextToken = "",$debug = false) {
			
			$this->getAccessToken();
			$this->uriPath = "/orders/v0/orders/".$OrderIdAma."/orderItems";
			
			
            //------------------------- 1: Create a Canonical Request for Signature ----------------------------
			
			/*		$session_token_url = "";
				$session_token_url .= $this->host."";
				$session_token_url .= $this->uriPath."";
				$session_token_url .= "?";
				$session_token_url .= "&CreatedAfter=".$dateCreateAfter;
				$session_token_url .= "&MarketplaceIds=A13V1IB3VIYZZH";		
				$session_token_url .= "&MaxResultsPerPage=10";				
				echo $session_token_url ;			
				echo "<br>"; 				
			*/      
			
			// echo "<br>"; 
			// attention Option dans l ordre aphabétique
			$session_token_url_to_sign = "";
			$session_token_url_to_sign .= $this->host."";
			$session_token_url_to_sign .= $this->uriPath."";
			$session_token_url_to_sign .= "?";
			if ($nextoken == "") {
				$session_token_url_to_sign .= "orderId=".urlencode($dateCreateAfter);		
				} else {
				$session_token_url_to_sign .= "NextToken=".urlencode($nextToken);
			}
			// echo $session_token_url_to_sign ; echo "<br>"; 			
			
			
			$session_token_url = $session_token_url_to_sign;
			
			$session_token_header = $this->getSessionTokenHeaderV4($session_token_url_to_sign,"GET",false);
			//printr($session_token_header);
			
			$requestUrl = $session_token_url;
			$headers =  array(
			'Content-Type: application/x-www-form-urlencoded'
			);
			$httpRequestMethod = "GET";
			$data = '';
			$rep = $this->callToAPI($requestUrl, $httpRequestMethod , $session_token_header, $data, false);
			$tmp = json_decode($rep["response"]);
			//printr($tmp);
			$this->accessToken = $tmp->access_token;
			return $rep ;
		}
		//__________________________________________________________________________________________________________________________________
		public function confirmShipment($OrderIdAma,$debug = false) {
			
			//$this->getAccessToken();
			$this->uriPath = "/orders/v0/orders/".$OrderIdAma."/shipmentConfirmation";
			
			
            //------------------------- 1: Create a Canonical Request for Signature ----------------------------
			
			/*		$session_token_url = "";
				$session_token_url .= $this->host."";
				$session_token_url .= $this->uriPath."";
				$session_token_url .= "?";
				$session_token_url .= "&CreatedAfter=".$dateCreateAfter;
				$session_token_url .= "&MarketplaceIds=A13V1IB3VIYZZH";		
				$session_token_url .= "&MaxResultsPerPage=10";				
				echo $session_token_url ;			
				echo "<br>"; 				
			*/      
			
			// echo "<br>"; 
			// attention Option dans l ordre aphabétique
			$session_token_url_to_sign = "";
			$session_token_url_to_sign .= $this->host."";
			$session_token_url_to_sign .= $this->uriPath."";

			$session_token_url = $session_token_url_to_sign;
			$session_token_header = $this->getSessionTokenHeaderV4($session_token_url_to_sign,"GET",false);
			//printr($session_token_header);
			
			$requestUrl = $session_token_url;
			$headers =  array(
			'Content-Type: application/x-www-form-urlencoded'
			);
			$httpRequestMethod = "POST";
			$data = '';
			$rep = $this->callToAPI($requestUrl, $httpRequestMethod , $session_token_header, $data, false);
			$tmp = json_decode($rep["response"]);
			//printr($tmp);
			$this->accessToken = $tmp->access_token;
			return $rep ;
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		public function getRestrictedDataToken($restrictedResources) {
			$curl = curl_init();
			curl_setopt_array($curl, array(
			CURLOPT_URL => $this->host.'/tokens/2021-03-01/restrictedDataToken',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS => $restrictedResources,
			CURLOPT_HTTPHEADER => array('Content-Type: application/json','Accept: application/json','x-amz-access-token:' . $this->accessToken)
			));
			$response = curl_exec($curl);
			curl_close($curl);
			return $response;
		}		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		public function token($config) {
			$curl = curl_init();
			curl_setopt_array($curl, array(
			CURLOPT_URL => 'https://api.amazon.com/auth/o2/token',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS => 'grant_type=refresh_token&refresh_token=' . $config['refresh_token'] . '&client_id=' . $config['client_id'] . '&client_secret=' . $config['client_secret'] . '',
			CURLOPT_HTTPHEADER => array('Host: api.amazon.com', 'Content-Type: application/x-www-form-urlencoded;charset=UTF-8')
			));
			$response = curl_exec($curl);
			curl_close($curl);
			return $response;
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		public function createFeedDocument($debug = false) {
			
			$this->getAccessToken();
			$this->uriPath = "/feeds/2021-06-30/documents";
			$session_token_url_to_sign = "";
			$session_token_url_to_sign .= $this->host."";
			$session_token_url_to_sign .= $this->uriPath."";
		//	$session_token_url_to_sign .= "?";

			//echo $session_token_url_to_sign ; echo "<br>"; 			

			$session_token_url = $session_token_url_to_sign;
			//echo "<h5>session_token_url seb</h5>";echo "<pre>";echo $session_token_url;	echo "</pre>";
			$session_token_header = $this->getSessionTokenHeaderV4($session_token_url_to_sign,"GET",false);
			$session_token_header[]='Content-Type: application/json';
			$session_token_header[]='Accept: application/json';
			//printr($session_token_header);
	
			$requestUrl = $session_token_url;
			//echo $requestUrl ; echo "<br>"; 
			$headers =  array(
			'Content-Type: application/x-www-form-urlencoded'
			);
			$httpRequestMethod = "POST";
			$data = '{ "contentType": "text/xml; charset=UTF-8" }';
			$rep = $this->callToAPI($requestUrl, $httpRequestMethod , $session_token_header, $data, $debug);
			$rep = json_decode($rep["response"]);
			//printr($rep);
			//printr($tmp);
			return $rep ;		
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		public function createFeed($dataA , $seller , $debug = false ) {
			
			//$this->getAccessToken();
			$this->uriPath = "/feeds/2021-06-30/feeds";
			$session_token_url_to_sign = "";
			$session_token_url_to_sign .= $this->host."";
			$session_token_url_to_sign .= $this->uriPath."";
		//	$session_token_url_to_sign .= "?";

			//echo $session_token_url_to_sign ; echo "<br>"; 			

			$session_token_url = $session_token_url_to_sign;
			//echo "<h5>session_token_url seb</h5>";echo "<pre>";echo $session_token_url;	echo "</pre>";
			$session_token_header = $this->getSessionTokenHeaderV4($session_token_url_to_sign,"GET",false);
			$session_token_header[]='Content-Type: application/json';
			$session_token_header[]='Accept: application/json';
			//printr($session_token_header);
	
			$requestUrl = $session_token_url;
			//echo $requestUrl ; echo "<br>"; 
			$headers =  array(
			'Content-Type: application/x-www-form-urlencoded'
			);
			$httpRequestMethod = "POST";
			//$data = '{ "contentType": "text/xml; charset=UTF-8" }';
			if ( $seller <> "" )  $dataA['marketplaceIds'] = array($this->Market[$this->awsRegion]["MarketplaceID"][$seller]);
				else $dataA['marketplaceIds'] = $this->MarketplaceIds;
			//printr($dataA);
			$data = json_encode($dataA);		
			//printr($data);
			$rep = $this->callToAPI($requestUrl, $httpRequestMethod , $session_token_header, $data, $debug);
			$rep = json_decode($rep["response"]);
			//printr($rep);
			//printr($tmp);
			return $rep ;		
		}		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////		
		public function getFeeds($feedTypes, $debug = false) {
			
			$this->getAccessToken();
			$this->uriPath = "/feeds/2021-06-30/feeds";
			$session_token_url_to_sign = "";
			$session_token_url_to_sign .= $this->host."";
			$session_token_url_to_sign .= $this->uriPath."";			
			$session_token_url_to_sign .= "?";		
			$session_token_url_to_sign .= "feedTypes=".$feedTypes;			
			$session_token_url_to_sign .= "&pageSize=100";	
			
			//echo $session_token_url_to_sign ; echo "<br>"; 			

			$session_token_url = $session_token_url_to_sign;
			//echo "<h5>session_token_url seb</h5>";echo "<pre>";echo $session_token_url;	echo "</pre>";
			$session_token_header = $this->getSessionTokenHeaderV4($session_token_url_to_sign,"GET",false);
			$session_token_header[]='Content-Type: application/json';
			$session_token_header[]='Accept: application/json';
			//printr($session_token_header);
	
			$requestUrl = $session_token_url;
			//echo $requestUrl ; echo "<br>"; 
			$headers =  array(
			'Content-Type: application/x-www-form-urlencoded'
			);
			$httpRequestMethod = "GET";
			//$data = '{ "contentType": "text/xml; charset=UTF-8" }';
			$rep = $this->callToAPI($requestUrl, $httpRequestMethod , $session_token_header, $data, $debug);
			$rep = json_decode($rep["response"]);
			//printr($rep);
			//printr($tmp);
			return $rep ;		
		}			
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////		
		public function getFeed($feedId, $debug = false) {
			
			$this->getAccessToken();
			$this->uriPath = "/feeds/2021-06-30/feeds";
			$session_token_url_to_sign = "";
			$session_token_url_to_sign .= $this->host."";
			$session_token_url_to_sign .= $this->uriPath."";			
			$session_token_url_to_sign .= "/".$feedId;
		

			//echo $session_token_url_to_sign ; echo "<br>"; 			

			$session_token_url = $session_token_url_to_sign;
			//echo "<h5>session_token_url seb</h5>";echo "<pre>";echo $session_token_url;	echo "</pre>";
			$session_token_header = $this->getSessionTokenHeaderV4($session_token_url_to_sign,"GET",false);
			$session_token_header[]='Content-Type: application/json';
			$session_token_header[]='Accept: application/json';
			//printr($session_token_header);
	
			$requestUrl = $session_token_url;
			//echo $requestUrl ; echo "<br>"; 
			$headers =  array(
			'Content-Type: application/x-www-form-urlencoded'
			);
			$httpRequestMethod = "GET";
			//$data = '{ "contentType": "text/xml; charset=UTF-8" }';
			$rep = $this->callToAPI($requestUrl, $httpRequestMethod , $session_token_header, $data, $debug);
			$rep = json_decode($rep["response"]);
			//printr($rep);
			//printr($tmp);
			return $rep ;		
		}	
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////		
		public function getFeedDocument($FeedDocumentId, $debug = false) {
			
			//$this->getAccessToken();
			$this->uriPath = "/feeds/2021-06-30/documents";
			$session_token_url_to_sign = "";
			$session_token_url_to_sign .= $this->host."";
			$session_token_url_to_sign .= $this->uriPath."";			
			$session_token_url_to_sign .= "/".$FeedDocumentId;
		

			//echo $session_token_url_to_sign ; echo "<br>"; 			

			$session_token_url = $session_token_url_to_sign;
			//echo "<h5>session_token_url seb</h5>";echo "<pre>";echo $session_token_url;	echo "</pre>";
			$session_token_header = $this->getSessionTokenHeaderV4($session_token_url_to_sign,"GET",false);
			$session_token_header[]='Content-Type: application/json';
			$session_token_header[]='Accept: application/json';
			//printr($session_token_header);
	
			$requestUrl = $session_token_url;
			//echo $requestUrl ; echo "<br>"; 
			$headers =  array(
			'Content-Type: application/x-www-form-urlencoded'
			);
			$httpRequestMethod = "GET";
			//$data = '{ "contentType": "text/xml; charset=UTF-8" }';
			$rep = $this->callToAPI($requestUrl, $httpRequestMethod , $session_token_header, $data, $debug);
			$rep = json_decode($rep["response"]);
			//printr($rep);
			//printr($tmp);
			return $rep ;		
		}
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		public function featuredOfferExpectedPrice($dataA , $seller , $debug = false ) {
			
			//$this->getAccessToken();
			$this->uriPath = "/batches/products/pricing/2022-05-01/offer/featuredOfferExpectedPrice";
			$session_token_url_to_sign = "";
			$session_token_url_to_sign .= $this->host."";
			$session_token_url_to_sign .= $this->uriPath."";
		//	$session_token_url_to_sign .= "?";

			//echo $session_token_url_to_sign ; echo "<br>"; 			

			$session_token_url = $session_token_url_to_sign;
			//echo "<h5>session_token_url seb</h5>";echo "<pre>";echo $session_token_url;	echo "</pre>";
			$session_token_header = $this->getSessionTokenHeaderV4($session_token_url_to_sign,"GET",false);
			$session_token_header[]='Content-Type: application/json';
			$session_token_header[]='Accept: application/json';
			//printr($session_token_header);
	
			$requestUrl = $session_token_url;
			//echo $requestUrl ; echo "<br>"; 
			$headers =  array(
			'Content-Type: application/x-www-form-urlencoded'
			);
			$httpRequestMethod = "POST";
			$requests = array();
			$i = 0;
			$marketplaceId = $this->Market[$this->awsRegion]["MarketplaceID"][$seller];
	
			foreach($dataA as $v){
				//printr($v);
				$requests['requests'][$i]['marketplaceId'] = $marketplaceId;				
				$requests['requests'][$i]['sku'] = $v;
				$requests['requests'][$i]['method'] = 'GET';	
				$requests['requests'][$i]['uri'] = '/products/pricing/2022-05-01/offer/featuredOfferExpectedPrice';					
				$i++;
			}
						
			//$data = '{ "contentType": "text/xml; charset=UTF-8" }';
			//printr($requests);
			//printr($dataA);
			$data = json_encode($requests);		
			$rep = $this->callToAPI($requestUrl, $httpRequestMethod , $session_token_header, $data, $debug);
			$rep = json_decode($rep["response"]);
			//printr($rep);
			//printr($tmp);
			return $rep ;		
		}			
	}		
	
?>