<?php


class WebServiceAmaOrders {

	public $serviceUrl = "https://mws-eu.amazonservices.com/Orders/2013-09-01";


	
//__________________________________________________________________________________________________________________________________
	public function setServiceURL( $service = 'Europe') {
		
		if ($service == "Europe" ) 			$this->serviceUrl = "https://mws-eu.amazonservices.com/Orders/2013-09-01";
		if ($service == "North America" ) 	$this->serviceUrl = "https://mws.amazonservices.com/Orders/2013-09-01";
		if ($service == "China" ) 			$this->serviceUrl = "https://mws.amazonservices.jp/Orders/2013-09-01";
		if ($service == "Europe" ) 			$this->serviceUrl = "https://mws.amazonservices.com.cn/Orders/2013-09-01";
		
	}
//__________________________________________________________________________________________________________________________________
	public function getListOrders(){
		

		$config = array (
	   'ServiceURL' => $this->serviceUrl,
	   'ProxyHost' => null,
	   'ProxyPort' => -1,
	   'ProxyUsername' => null,
	   'ProxyPassword' => null,
	   'MaxErrorRetry' => 3,
		);

		 $service = new MarketplaceWebServiceOrders_Client(
				AWS_ACCESS_KEY_ID,
				AWS_SECRET_ACCESS_KEY,
				APPLICATION_NAME,
				APPLICATION_VERSION,
				$config);
				
				
			
		// Get total from 31 days ago for 30 days
		$t1 = date("c", time()-31*24*60*60);
		//$t2 = date("c", time()-1*24*60*60);
		$t2 = date("c", time()-1*60*60);

		/************************************************************************
		* Setup request parameters and uncomment invoke to try out
		* sample for List Orders Action
		***********************************************************************/
		// @TODO: set request. Action can be passed as MarketplaceWebServiceOrders_Model_ListOrders
		$request = new MarketplaceWebServiceOrders_Model_ListOrdersRequest();
		$request->setSellerId(MERCHANT_ID);
		$request->setCreatedAfter($t1);
		//$request->setCreatedBefore($t2);
		$request->withOrderStatus('Canceled','Pending','Unshipped','PartiallyShipped','Shipped');
		$request->withMarketplaceId('A1PA6795UKMFR9','APJ6JRA9NG5V4','A1RKKUPIHCS9HS','A1F83G8C2ARO7P','A1C3SOZRARQ6R');
		//I want all orders in this case
		//$request->setFulfillmentChannel("MFN HTTP/1.1");
		// object or array of parameters
		printr($request);
		$oAma = $this->invokeListOrders($service, $request);

	return $oAma;	
	}


//__________________________________________________________________________________________________________________________________
	/**
	  * Get List Orders Action Sample
	  * Gets competitive pricing and related information for a product identified by
	  * the MarketplaceId and ASIN.
	  *
	  * @param MarketplaceWebServiceOrders_Interface $service instance of MarketplaceWebServiceOrders_Interface
	  * @param mixed $request MarketplaceWebServiceOrders_Model_ListOrders or array of parameters
	  */
	public function invokeListOrders(MarketplaceWebServiceOrders_Interface $service, $request)
	  {
		  try {
			$response = $service->ListOrders($request);
			$dom = new DOMDocument();
			$dom->loadXML($response->toXML());
			$dom->preserveWhiteSpace = true;
			$dom->formatOutput = true;
			$xml = $dom->saveXML();     
			$orderdata = new SimpleXMLElement($xml);
			//$array=json_encode($orderdata, TRUE);
			$array=json_encode($orderdata);		
		   // print_r($array);
			$result = json_decode($array);
			  if ($result) {
					return $result;
				  } else {
					  echo 'error decoding json';
					  return FALSE;
				  }
		} catch (MarketplaceWebServiceOrders_Exception $ex) {
			echo("Caught Exception: " . $ex->getMessage() . "\n");
			echo("Response Status Code: " . $ex->getStatusCode() . "\n");
			echo("Error Code: " . $ex->getErrorCode() . "\n");
			echo("Error Type: " . $ex->getErrorType() . "\n");
			echo("Request ID: " . $ex->getRequestId() . "\n");
			echo("XML: " . $ex->getXML() . "\n");
			echo("ResponseHeaderMetadata: " . $ex->getResponseHeaderMetadata() . "\n");
			return FALSE;
		}
	}


 //__________________________________________________________________________________________________________________________________
 





}
?>