<?php
	/********************************************************************************
	  * AUTHOR: Eswara Rajesh Pinapala, eBay Developer Technical Support epinapala@ebay.com *
	  *******************************************************************************/
    //show all errors
    error_reporting(E_ALL);

    // these keys can be obtained by registering at http://developer.ebay.com
    
    $production         = true;   // toggle to true if going against production
    $compatabilityLevel = 867;    // eBay API version
    
    if ($production) {
        $devID = Ebay_devID;   // these prod keys are different from sandbox keys
        $appID = Ebay_appID;
        $certID = Ebay_certID;
        //set the Server to use (Sandbox or Production)
        $serverUrl = 'https://api.ebay.com/ws/api.dll';      // server URL different for prod and sandbox
        //the token representing the eBay user to assign the call with
        $userToken = Ebay_userToken;          
    } else {  
        // sandbox (test) environment
        $devID = 'xxxxxxxx';   // these SB keys are different from prod keys
        $appID = 'xxxxxxxxx';
        $certID = 'xxxxxxxxxxxxxx';
        //set the Server to use (Sandbox or Production)
        $serverUrl = 'https://api.sandbox.ebay.com/ws/api.dll';
        // the token representing the eBay user to assign the call with
        // this token is a long string - don't insert new lines - different from prod token
        $userToken = '*************';          
    }
    
    
?>