<?php
 set_time_limit (0);

function ebay_commandes($page){

		require_once('./import_top_special.php');
		require('./get-common/keys.php');
		require_once('./get-common/eBaySession.php'); 
		
		
		//SiteID must also be set in the Request's XML
		//SiteID = 0  (US) - UK = 3, Canada = 2, Australia = 15, ....
		//SiteID Indicates the eBay site to associate the call with
		$siteID = 71;
		//the call being made:
		$verb = 'GetOrders';
		
		//Time with respect to GMT
		//by default retreive orders in last 30 minutes
		//$CreateTimeFrom = gmdate("Y-m-d\TH:i:s",time()-1800); //current time minus 30 minutes
		echo 'from : ' . $CreateTimeFrom = gmdate("Y-m-d\TH:i:s",time()-(86400*10)); // 86400 secondes  = 1 jour    X 30 pour 30 jours
		echo '<br>';
		echo 'To   : ' . $CreateTimeTo = gmdate("Y-m-d\TH:i:s") ;
		
		echo '<hr>';
		
		
		//If you want to hard code From and To timings, Follow the below format in "GMT".
		//$CreateTimeFrom = YYYY-MM-DDTHH:MM:SS; //GMT
		//$CreateTimeTo = YYYY-MM-DDTHH:MM:SS; //GMT
		
		//$CreateTimeFrom = "2012-06-15T00:00:00"; //GMT
		//$CreateTimeTo = "2012-06-26T00:00:00"; //GMT
		
		
		///Build the request Xml string
		$requestXmlBody = '<?xml version="1.0" encoding="utf-8" ?>';
		$requestXmlBody .= '<GetOrdersRequest xmlns="urn:ebay:apis:eBLBaseComponents">';
		$requestXmlBody .= '<DetailLevel>ReturnAll</DetailLevel>';
		$requestXmlBody .= "<CreateTimeFrom>$CreateTimeFrom</CreateTimeFrom><CreateTimeTo>$CreateTimeTo</CreateTimeTo>";
		$requestXmlBody .= '<OrderRole>Seller</OrderRole><OrderStatus>All</OrderStatus>';
		$requestXmlBody .= '<SortingOrder>Descending</SortingOrder>';
//		$requestXmlBody .= '<NumberOfDays>15</NumberOfDays>';
		$requestXmlBody .= '<Pagination><EntriesPerPage>100</EntriesPerPage><PageNumber>'. $page .'</PageNumber></Pagination>';
		//$requestXmlBody .= '<OrderRole>Seller</OrderRole><OrderStatus>All</OrderStatus>';
		$requestXmlBody .= "<RequesterCredentials><eBayAuthToken>$userToken</eBayAuthToken></RequesterCredentials>";
		$requestXmlBody .= '</GetOrdersRequest>';
		
		//Create a new eBay session with all details pulled in from included keys.php
		$session = new eBaySession($userToken, $devID, $appID, $certID, $serverUrl, $compatabilityLevel, $siteID, $verb);
		
		//send the request and get response
		$responseXml = $session->sendHttpRequest($requestXmlBody);
		if (stristr($responseXml, 'HTTP 404') || $responseXml == '')
		    die('<P>Error sending request');
		
		//Xml string is parsed and creates a DOM Document object
		$responseDoc = new DomDocument();
		$responseDoc->loadXML($responseXml);
		
		
		//get any error nodes
		$errors = $responseDoc->getElementsByTagName('Errors');
		$response = simplexml_import_dom($responseDoc);
		$entries = $response->PaginationResult->TotalNumberOfEntries;
		
		//if there are error nodes
		if ($errors->length > 0) {
		    echo '<P><B>eBay returned the following error(s):</B>';
		    //display each error
		    //Get error code, ShortMesaage and LongMessage
		    $code = $errors->item(0)->getElementsByTagName('ErrorCode');
		    $shortMsg = $errors->item(0)->getElementsByTagName('ShortMessage');
		    $longMsg = $errors->item(0)->getElementsByTagName('LongMessage');
		    
		    //Display code and shortmessage
		    echo '<P>', $code->item(0)->nodeValue, ' : ', str_replace(">", "&gt;", str_replace("<", "&lt;", $shortMsg->item(0)->nodeValue));
		    
		    //if there is a long message (ie ErrorLevel=1), display it
		    if (count($longMsg) > 0)
		        echo '<BR>', str_replace(">", "&gt;", str_replace("<", "&lt;", $longMsg->item(0)->nodeValue));
		}else { //If there are no errors, continue
		    if(isset($_GET['debug']))
		    {  
		       header("Content-type: text/xml");
		       print_r($responseXml);
		    }else
		     {  //$responseXml is parsed in view.php
		      //  header("Content-type: text/plain");
		    //    include_once 'view_org.php';
				echo 'page suivante ? : ' . $response->HasMoreOrders; echo '<hr>';
			        include 'view.php';
				return strval($response->HasMoreOrders);
		    }
		} 

}

///////////////////////////////
$page = 1;
ebay_commandes(1);
ebay_commandes(2);
ebay_commandes(3);
ebay_commandes(4);
ebay_commandes(5);

//while(ebay_commandes($page)) echo $page++;
?>