<?php
/*
 * This file is part of the partner api fnac marketplace package.
 * (c) 2008-2010 Francois Crossette <fcrossette@fnac.com>
 *
 * Example of a common use case for FNAC MARKETPLACE API
 *   - Authentication
 *   - Offers Update
 *   - Offers Query
 *   - Batch Status
 *   - Orders Query
 *   - Orders Update
 *
 */

/*
 * Init :
 *   $partner_id : unique id given by Fnac team
 *   $shop_id    : unique id of Fnac shop
 *   $key        : partner sauthentication key
 */

// CB


// CB
  $partner_id = fnac_fr_partner_id;
  $key        = fnac_fr_key;
  $shop_id    = fnac_fr_shop_id;

  $url        = 'https://vendeur.fnac.com/api.php/';

  try
  {
    /* call auth service  */
    $xmlAuthentication = simplexml_load_file('fnac/xml_files/authentification-request.xml');
    $xmlAuthentication->partner_id = $partner_id;
    $xmlAuthentication->shop_id = $shop_id;
    $xmlAuthentication->key = $key;

    /* Validated XML request using XSD */
    $dom = new DOMDocument;
    $dom->loadXML($xmlAuthentication->asXML());
    $valide = $dom->schemaValidate('fnac/xsd/AuthenticationService.xsd');
    if( ! $valide)
    {
      throw new Exception('xmlAuthentication: validation failed !');
    }

    // send xml to webservice auth
    $response = do_post_request($url . "auth", $xmlAuthentication->asXML());

    // load xml response
    $xmlResponse = simplexml_load_string(trim($response));
    // get token for session authentication
	$tokenForSession = $xmlResponse->token;
    // Post to this date , the session for this token is no more valid.
    $validityDateForSession = $xmlResponse->validity;


    /* call order query service */
    $xmlOrdersQuery = simplexml_load_file('fnac/xml_files/orders-query-request.xml');


 echo  $now=date("c");
   $dateretention=date("c", mktime(0,0,0,date("m"),date("d")-5,date("Y")));




$string = <<<XML
<?xml version="1.0" encoding="utf-8"?>
<offers_query results_count="50" partner_id="$partner_id"  shop_id="$shop_id"  token="$tokenForSession"  xmlns="http://www.fnac.com/schemas/mp-dialog.xsd">
	<paging>1</paging>
	<date type="Modified">
		<min>2013-01-28T11:53:24+02:00</min>
		<max>$now</max >
	</date>
	<quantity mode="GreaterThanOrEquals" value="0"/>
</offers_query>
XML;

/**************************************************  ***********************************************/

   /* call offer query service  */
    $xmlOffersQuery = simplexml_load_file($string);
    $xmlOffersQuery['partner_id'] = $partner_id;
    $xmlOffersQuery['shop_id'] = $shop_id;
//    $xmlOffersQuery['token'] = $tokenForSession;

	echo "<pre>";
	print_r($xmlOffersQuery);
// var_dump($xmlOffersQuery);
	echo "</pre>";
	echo "oooooo";
	echo "<hr />";

    /* Validated XML request using XSD */
    $dom = new DOMDocument;
    $dom->loadXML($xmlOffersQuery->asXML());
echo    $valide = $dom->schemaValidate('fnac/xsd/OffersQueryService.xsd');
    if( ! $valide)
    {
      throw new Exception('xmlOffersQuery: validation failed !');
    }

    // send xml to webservice OffersQuery
    $response = do_post_request($url . "offers_query", $xmlOffersQuery->asXML());
    // NOCDATA convert CDATA into string to avoid manual cast on value
    $xmlResponse = simplexml_load_string(trim($response), 'SimpleXMLElement', LIBXML_NOCDATA);

	echo "<pre>";
	print_r($xmlResponse);
// var_dump($xmlResponse);
	echo "</pre>";
	echo "<hr />";

    /* get the result of query */
    foreach($xmlResponse->offer as $offer)
    {
      // do what you want with the result
	echo "offers";
	echo "<pre>";
      var_dump($offer);
	echo "</pre>";
    }


//require('includes/import_top.php');



    

  }
  catch(Exception $e)
  {
    // do what you want with exception
    var_dump($e);
  }


/************************************************** Fin Traitement commande ***********************************************/


  /**
   * Simulate a post method
   *
   * @param string   $url              : target url
   * @param string   $data             : xml query
   * @param string   $optional_headers : optional headers
   *
   * @return response of the http request
   */
  function do_post_request($url, $data, $optional_headers = null)
  {
/*    $params = array( 'http' => array ( 'method' => 'POST', 'content' => $data ) );
    if ( $optional_headers !== null )
    {
      $params['http']['header'] = $optional_headers;
    }

	echo "<pre>";
    var_dump($params);
	echo "</pre>";

 echo   $ctx = stream_context_create($params);
    $fp = fopen($url, 'rb', false, $ctx);

    if ( !$fp )
    {
      throw new Exception("Problem with $url");
    }

    $response = @stream_get_contents($fp);

    if ( $response === false )
    {
      throw new Exception("Problem reading data from $url");
    }
*/
    // Here is an example with cURL (could be faster)
     $ch = curl_init();

     curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); 
     curl_setopt($ch, CURLOPT_POST, 1); 
     curl_setopt($ch, CURLOPT_URL, $url);
     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
     curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
     curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,true); 
curl_setopt($ch,CURLOPT_CAINFO,'cacert.pem'); /* fixed! */

     $response = curl_exec($ch);

     if(0 != curl_errno($ch))
     {
       echo 'curl Error: '.curl_error($ch)."\n<br/>curl info:";
       echo '<pre>';
       print_r(curl_getinfo($ch));
       echo '</pre>';
     }

     curl_close($ch);


    return $response;
  }
?>