<?php
 $dir_ws_includes = dirname(__FILE__) . '/../../../../../../../';

 if (file_exists($dir_ws_includes . 'local/configure.php')) 
   require_once($dir_ws_includes . 'local/configure.php');
 else
   require_once($dir_ws_includes . 'configure.php');

// global filetypes definitions
// warning: changing default filetypes may lead to unexpected behaviour 
SpawConfig::setStaticConfigItem(
  'PG_SPAWFM_FILETYPES',
  array(
    // default filetypes
    'any'           => array('.*'),
    'images'        => array('.jpg', '.gif', '.png'),
    'flash'         => array('.swf'),
    'documents'     => array('.doc', '.xls', '.pdf', '.rtf', '.odt', '.ods', '.txt'),
    'audio'         => array('.wav', '.mp3', '.ogg', '.wma'),
    'video'         => array('.avi', '.mpg', '.mpeg', '.mov', '.wmv'),
    'archives'      => array('.zip', '.rar', '.gz'),
    // add your custom filetypes below
    //'' => '',
  ), 
  SPAW_CFG_TRANSFER_SECURE
);

// filetypes icons:
// default icons
SpawConfig::setStaticConfigItem(
  'PG_SPAWFM_FILETYPES_ICON_DEFAULT',
  array(
    'icon'      => 'ico_default.gif',
    'icon_big'  => 'ico_default_big.gif',
  )
);
// icons for folders
SpawConfig::setStaticConfigItem(
  'PG_SPAWFM_FILETYPES_ICON_FOLDER',
  array(
    'icon'      => 'ico_folder.gif',
    'icon_big'  => 'ico_folder_big.gif',
  )
);  

// icons for specific filetypes (determined by their extensions)
SpawConfig::setStaticConfigItem(
  'PG_SPAWFM_FILETYPES_ICONS',
  array(
    array(
      'extensions'  => array('.jpg', '.gif', '.png'),
      'icon'        => 'ico_image.gif',
      'icon_big'    => 'ico_image_big.gif',
    ),
    array(
      'extensions'  => array('.swf'),
      'icon'        => 'ico_flash.gif',
      'icon_big'    => 'ico_flash_big.gif',
    ),
    /*
    array(
      'extensions'  => array('.doc', '.xls', '.pdf', '.rtf', '.odt', '.ods', '.txt'),
      'icon'        => 'ico_document.gif',
      'icon_big'    => 'ico_document_big.gif',
    ),
    */
  )
);

// character to separate base dir path and subdir (should be unused in filesystem names)
SpawConfig::setStaticConfigItem(
  'spawfm_path_separator',
  '|',
  SPAW_CFG_TRANSFER_JS
);

SpawConfig::setStaticConfigItem(
  'PG_SPAWFM_SETTINGS',
  array(
    'allowed_filetypes' => array('images', 'flash'),  // allowed filetypes groups/extensions
    'allow_modify'        => true,         // allow edit filenames/delete files in directory
    'allow_upload'        => true,         // allow uploading new files in directory
    //'chmod_to'          => 0777,          // change the permissions of an uploaded file if allowed
                                            // (see PHP chmod() function description for details), or comment out to leave default
    'max_upload_filesize' => 0,             // max upload file size allowed in bytes, or 0 to ignore
    'max_img_width'       => 0,             // max uploaded image width allowed, or 0 to ignore
    'max_img_height'      => 0,             // max uploaded image height allowed, or 0 to ignore
    'recursive'           => true,         // allow using subdirectories
    'allow_modify_subdirectories' => true, // allow renaming/deleting subdirectories
    'allow_create_subdirectories' => true, // allow creating subdirectories
  ),
  SPAW_CFG_TRANSFER_SECURE
); 

SpawConfig::setStaticConfigItem(
  'PG_SPAWFM_DIRECTORIES',
  array(
    array(
      'dir' => DIR_WS_CATALOG . DIR_WS_IMAGES,
      'caption' => 'Catalog Images',
      'params' => array(
        'allowed_filetypes' => array('images', 'flash')
      )
    ),
  ),
  SPAW_CFG_TRANSFER_SECURE
);
?>