<?php
/*
  $Id: abxMessageStack.php,v 1.2 2008/03/13 14:33:21 auctionblox Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2004 osCommerce

  Released under the GNU General Public License
*/

  class abxMessageStack {
    var $messages;

// class constructor
    function abxMessageStack() {
      $this->messages = array();
    }

// class methods
    function add($class, $message, $type = 'error') {
      $this->messages[] = array('class' => $class, 'type' => $type, 'message' => $message);
    }

    function add_session($class, $message, $type = 'error') {
      global $abxSession;

      if ($abxSession->exists('abxMsgStack')) {
        $abxMsgStack = $abxSession->value('abxMsgStack');
      } else {
        $abxMsgStack = array();
      }

      $abxMsgStack[] = array('class' => $class, 'text' => $message, 'type' => $type);

      $abxSession->set('abxMsgStack', $abxMsgStack);

      $this->add($class, $message, $type);
    }

    function reset() {
      $this->messages = array();
    }

    function output($class) {
      $messages = '<ul>';
      for ($i=0, $n=sizeof($this->messages); $i<$n; $i++) {
        if ($this->messages[$i]['class'] == $class) {
          switch ($this->messages[$i]['type']) {
            case 'error':
              $bullet_image = DIR_WS_ABX_EXTERNAL_CART_IMAGES . 'error.gif';
              break;
            case 'warning':
              $bullet_image = DIR_WS_ABX_EXTERNAL_CART_IMAGES . 'warning.gif';
              break;
            case 'success':
              $bullet_image = DIR_WS_ABX_EXTERNAL_CART_IMAGES . 'success.gif';
              break;
            default:
              $bullet_image = DIR_WS_ABX_EXTERNAL_CART_IMAGES . 'bullet_default.gif';
          }

          $messages .= '<li style="list-style-image: url(\'' . $bullet_image . '\')">' . abxPage::outputString($this->messages[$i]['message']) . '</li>';
        }
      }
      $messages .= '</ul>';

      return '<div class="messageStack">' . $messages . '</div>';
    }

    function outputPlain($class) {
      $message = false;

      for ($i=0, $n=sizeof($this->messages); $i<$n; $i++) {
        if ($this->messages[$i]['class'] == $class) {
          $message = abxPage::outputString($this->messages[$i]['message']);
          break;
        }
      }

      return $message;
    }

    function size($class) {
      $class_size = 0;

      for ($i=0, $n=sizeof($this->messages); $i<$n; $i++) {
        if ($this->messages[$i]['class'] == $class) {
          $class_size++;
        }
      }

      return $class_size;
    }

    function loadFromSession() {
      global $abxSession;

      if ($abxSession->exists('abxMsgStack')) {
        $abxMsgStack = $abxSession->value('abxMsgStack');

        for ($i=0, $n=sizeof($abxMsgStack); $i<$n; $i++) {
          $this->add($abxMsgStack[$i]['class'], $abxMsgStack[$i]['text'], $abxMsgStack[$i]['type']);
        }

        $abxSession->remove('abxMsgStack');
      }
    }
  }
?>
