<?php
/*
  $Id: abxPageProgressBar.php,v 1.6 2008/04/02 18:46:24 devosc Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  if (class_exists('abxPage') === false) {

    require_once(dirname(__FILE__) . '/abxPage.php');

  }

  class abxPageProgressBar extends abxPage {

    var $counter,
        $progress,
        $totalCount;

    function abxPageProgressBar($counter = 0, $progress = 0, $totalCount = 0, &$postvars, $errorCount, $successCount)
    {
      parent::abxPage();

      $this->setBaseURL(DIR_WS_ABX);

      $this->addJavaScript('progressbar.js');

      $this->setTemplate('popup');

      $this->templateType('string');

      $this->counter = (is_numeric($counter) && $counter > 0) ? (int) $counter : 0;

      $this->progress = (is_numeric($progress) && $progress > 0) ? (int) $progress : 0;

      $this->totalCount = (is_numeric($totalCount) && $totalCount > 0) ? (int) $totalCount : count($postvars);

      $this->errorCount = (is_numeric($errorCount) && $errorCount > 0) ? (int) $errorCount : 0;

      $this->successCount = (is_numeric($successCount) && $successCount > 0) ? (int) $successCount : 0;

      $this->completed = false;
    }

    function init($state_label = array(TEXT_ACTION_UPLOADING, TEXT_ACTION_PREPARING))
    {
      $label = (empty($this->progress) === false) ? $state_label[0] : $state_label[1];

      $this->content = $this->progressBar($label,$this->progress);

      $this->closeButtonHidden = true;
    }

    function setProgress($progress)
    {
      $this->progress = $this->calcProgress($progress);
    }

    function calcProgress($current)
    {
      return (int) (((($current)*100)/$this->totalCount)/10);
    }

    function progressBar($state_label, $progress = 0)
    {
      $str = '<div align="center"><span id="state" class="smalltext">' . $state_label . '</span></div><br class="h10" /><table align="center"><tr><td><div style="font-size:8pt;border:solid black 1px;background-color: lightgrey;">';

      for($i=1; $i <= 10; $i++) {

        $str .= "<span id=\"progress{$i}\" class=\"progressbar\"";

        if($progress > ($i-1))

          $str .= 'style="background-color: navy;"';

        $str .= '>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';

      }

      $str .= '</div></td></tr></table>'."\n";

      return $str;
    }

    function submitNext($formname,$perform, $module)
    {
      return "<script type=\"text/javascript\">submit_form(document.forms['{$formname}'],'{$perform}','$module&counter={$this->counter}&totalCount={$this->totalCount}&progress={$this->progress}&errorCount={$this->errorCount}&successCount={$this->successCount}');</script>\n";
    }

    function listAsHiddenFields($form, $key_name, &$array)
    {
      $str .= $this->form($form,FILENAME_AUCTIONBLOX)."\n";

      $str .= $this->hidden('perform')."\n";

      foreach($array as $key => $val)

        $str .= $this->hidden($key_name.'[]',$val)."\n";

      $str .= '</form>'."\n";

      return $str;
    }

    function reset($text)
    {
      $this->progress = '0';

      $this->completed = false;

      return $this->_update($text);
    }

    function completed($text)
    {
      $this->progress = '10';

      $this->completed = true;

      return $this->_update($text);
    }

    function update($text,$progress)
    {
      $this->setProgress($progress);

      return $this->_update($text);
    }

    function _update($text)
    {
      $str = "<script type=\"text/javascript\">changeState('state','".addslashes($text)."');</script>\n";

      if($this->progress > 0)
        $str .= "<script type=\"text/javascript\">updateProgressBar('{$this->progress}');</script>\n";
      else
        $str .= "<script type=\"text/javascript\">resetProgressBar('{$this->progress}');</script>\n";

      if($this->completed === true)
        $str .= "<script type=\"text/javascript\">showPopupCloseButton();</script>\n";

      return $str;
    }

  }//end class
?>
