<?php
/*
  $Id: abxPaginatorQuery.php,v 1.6 2008/10/23 21:19:21 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  if(class_exists('abxDatabaseQuery') === false) {

    include(DIR_FS_ABX_CLASSES . 'abxDatabaseQuery.php');

  }

  class abxPaginatorQuery extends abxDatabaseQuery {

    function abxPaginatorQuery($page_number,$maximum_rows,$query_string,$sortDefaultArray,$sortArray,$searchArray,$filterTerms,$filterBy,$sellerID)
    {

      global $abxDatabase;

      parent::abxDatabaseQuery($abxDatabase);

      $this->page_number = ((empty($page_number) === false) && $page_number > 1) ? (int) $page_number : 1;

      $this->page_rows = (int) $maximum_rows;

      $query_string = $this->query_string($query_string,$sortDefaultArray,$sortArray,$searchArray,$filterTerms,$filterBy,$sellerID);

      $this->execute($query_string);

      $this->page_size = $abxDatabase->calcFoundRows($query_string);

      $this->page_to = ($this->page_rows * $this->page_number);

      $this->page_to = ($this->page_to > $this->page_size) ? $this->page_size : $this->page_to;

      $this->page_from = ($this->page_rows * ($this->page_number - 1));

      $this->page_from = ($this->page_to == 0) ? 0 : $this->page_from++;

    }

    function query_string($query_string,$sortDefaultArray,$sortArray,$searchArray,$filterTerms,$filterBy,$sellerIDArray)
    {

      global $abxDatabase;

			$extra_query = '';
      if(!empty($sellerIDArray) != null && is_array($sellerIDArray))
        $extra_query .= " {$sellerIDArray['name']} = '" . addslashes($sellerIDArray['value']) . "' and ";

      //if(!empty($filterBy) && !empty($filterTerms['name']))
      //  $query_string .= " and {$filterTerms['name']} = '" . addslashes($filterBy) . "'";

      if($searchArray != null && is_array($searchArray) && strlen($searchArray['value']) > 0 )
        $extra_query .= $searchArray['name'] . " like '%" . addslashes($searchArray['value']) . "%' and ";
        
      if(strlen($extra_query) > 0)
      {
      	$parts = preg_split('/where/i', $query_string, -1, PREG_SPLIT_OFFSET_CAPTURE);
        if(sizeof($parts) == 2)
        {
           $query_string = $parts[0][0] . " WHERE " . $extra_query . $parts[1][0];
        } 
      }

      if($sortArray != null && is_array($sortArray))
      {
      	// a query may have a default "order by" to be used with the group by 
      	// function.  However, we want the sort param provided by the user as
      	// the first part of the order by
      	$parts = preg_split('/order by/i', $query_string, -1, PREG_SPLIT_OFFSET_CAPTURE);
        if(sizeof($parts) == 2)
        {
           $query_string = $parts[0][0] . " ORDER BY " . 
                           $sortArray['name'] . " " . $sortArray['value'] . ", " .
                           $parts[1][0];
        } 
        else
           $query_string .= " order by " . $sortArray['name'] . " " . $sortArray['value'];
      }  

      elseif ($sortDefaultArray != null && count($sortDefaultArray) >0)
      {
      	$parts = preg_split('/order by/i', $query_string, -1, PREG_SPLIT_OFFSET_CAPTURE);
        if(sizeof($parts) == 2)
        {
           $query_string = $parts[0][0] . " ORDER BY " . 
                           $sortDefaultArray['name'] . " " . $sortDefaultArray['value'] . ", " .
                           $parts[1][0];
        } 
        else
           $query_string .= " order by " . $sortDefaultArray['name'] . " " . $sortDefaultArray['value'];
      }

      $from = ($this->page_number * $this->page_rows) - $this->page_rows;

      $query_string .= ' limit ' . $from . ', ' . $this->page_rows;

      return $query_string;
    }

    function displayPageLinksTotal($text,$typeOfResults)
    {

      return sprintf($text, $this->page_from, $this->page_to, $this->page_size, $typeOfResults);
    }

    function displayPageLinks($page_keyword = 'page', $parameters = '')
    {

      $this->pageLinkParameters = $parameters;

      $number_of_pages = @ceil($this->page_size / $this->page_rows);

      $current_page = $this->page_number;

      if ($number_of_pages > 1) {

        $jumpTo = (($current_page + 1) > $number_of_pages) ? $number_of_pages - 1 : $current_page + 1;

        $display_links .= $this->pageLink('',$number_of_pages.'&nbsp;Pages','pageLinkPrompt(\''.TEXT_PAGELINK_PROMPT.'\',\''.str_replace('abx=', '', $this->pageLinkParameters).'\',\''.$jumpTo.'\',\''.$current_page.'\',\''.$number_of_pages.'\')');

        if ($this->page_number > 2)
          $display_links .= $this->pageLink('1','&laquo;','','pageLinkLast');

        if ($this->page_number > 1)
          $display_links .= $this->pageLink($current_page - 1,'&lt;');

        for ($i=1; $i<=$number_of_pages; $i++) {

          if($i == ($current_page -2))
            $display_links .= $this->pageLink($i,$i);

          if($i == ($current_page -1))
            $display_links .= $this->pageLink($i,$i);

          if($i == $current_page)
            $display_links .= '<span class="pageLinkCurrent">'.($current_page).'</span>';

          if($i == ($current_page +1))
            $display_links .= $this->pageLink($i,$i);

          if($i == ($current_page +2))
            $display_links .= $this->pageLink($i,$i);
        }

        if (($this->page_number < $number_of_pages) && ($number_of_pages != 1)) {

          $display_links .= $this->pageLink($current_page + 1,'&gt;');

          if($this->page_number < ($number_of_pages - 1))
            $display_links .= $this->pageLink($number_of_pages,'&raquo;','','pageLinkLast');

        }

      }

      return $display_links;
    }

    function pageLink($page,$txt,$onclickJS='',$class='pageLink')
    {
      $href = (empty($onclickJS) === false) ? 'javascript: javascript()' : abx_href_link(basename($_SERVER['PHP_SELF']), $this->pageLinkParameters . '&page=' . $page);

      $onclick = (empty($onclickJS) === false) ? "onclick=\"{$onclickJS}; return false;\"" : '';

      return "<a class=\"{$class}\" href=\"{$href}\" {$onclick}>{$txt}</a>";
    }

  }//end class
?>