<?php
/*
  $Id: abxCheckout.php,v 1.10 2005/10/03 02:47:34 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  include_once dirname(__FILE__).'/API/abxToken.php';

  // ----------------------------------------------------------------------

  class abxCustomer {

    // --------------------------------------------------------------------

    var
      $nWinnerId,
      $sExtId,
      $sEmail,
      $sName,
      $sFirstName,
      $sLastName,
      $sStreetAddress,
      $sStreetAddress2,
      $sCity,
      $sState,
      $sZip,
      $sCountryIsoCode,
      $nCountryId,
      $nZoneId,
      $sPhone,
      $nId,
      $sPwd,
      $nAddressId,
      $sCheckoutCode;

    // --------------------------------------------------------------------

    function abxCustomer($sEmail, $sCheckoutCode = null) {
      $this->sEmail = $sEmail;
      $this->sCheckoutCode = $sCheckoutCode;
    }    

    // --------------------------------------------------------------------

    function isAuctionBloxRequest() {
      global $abxDatabase;

      $sQuery = "SELECT w.auction_winner_id "
               ."FROM %s w, %s b "
               ."WHERE w.auction_winner_id = b.auction_winner_id "
               ."AND w.ext_email_address = '%s' "
               ."AND b.uuid = '%s' "
               ."LIMIT 1";

      $sQuery = sprintf(
        $sQuery,
        TABLE_ABX_WINNERS,        
        TABLE_ABX_BASKET,
        $abxDatabase->escape($this->sEmail),
        $abxDatabase->escape($this->sCheckoutCode)
      );

      $Query = $abxDatabase->query($sQuery);
      return (bool) $Query->numRows();
    }

    // --------------------------------------------------------------------

    function exists() {
        global $abxDatabase;
    
        $sQuery = "SELECT" .
    		 " c.customers_id," .
             " c.customers_firstname," .
             " c.customers_default_address_id," .
             " a.entry_country_id," .
             " a.entry_zone_id" .
             " FROM %s c" .
             " LEFT JOIN %s a ON c.customers_id = a.customers_id" .
             " WHERE a.address_book_id = c.customers_default_address_id" .
             " AND c.customers_email_address = '%s'" .
             " LIMIT 1";
    
        $sQuery = sprintf(
          $sQuery,
          TABLE_CUSTOMERS,
          TABLE_ADDRESS_BOOK,
          $abxDatabase->escape($this->sEmail)
        );
    
        $Query = $abxDatabase->query($sQuery);
    
        $bExists = (bool) $Query->numRows();
    
        if ($bExists) {
          $this->nId        = $Query->valueInt('customers_id');
        }

        return $bExists;
    }
    
    function isAnonymous() {
      global $abxDatabase;

      $sQuery = "SELECT is_anonymous" .
                " FROM " . TABLE_ABX_WINNERS .
                " WHERE ext_email_address = '" . $abxDatabase->escape($this->sEmail) . "'" .
                " LIMIT 1";

      $Query = $abxDatabase->query($sQuery);

      if ($Query->numRows() > 0 && $Query->valueInt('is_anonymous') ===  1) {
        return true;
      }
      
      return false;

    }

    // --------------------------------------------------------------------

    function hasBuyerInfo() {
      global $abxDatabase;

      $sQuery = "SELECT * "
               ."FROM %s "
               ."WHERE ext_email_address = '%s' "
               ."LIMIT 1";

      $sQuery = sprintf(
        $sQuery,
        TABLE_ABX_WINNERS,
        $abxDatabase->escape($this->sEmail)
      );

      $Query = $abxDatabase->query($sQuery);

      if (!$Query->numRows()) {
        return false;
      }

      if (strlen($Query->value('name')) === 0 || strlen($Query->value('street1')) === 0 ) {
        return false;
      }

      $this->nWinnerId = $Query->valueInt('auction_winner_id');
      $this->sExtId = $Query->value('ext_customer_id');
      $this->sEmail = $Query->value('ext_email_address');
      $this->sName = $Query->value('name');

      list($this->sFirstName, $this->sLastName)
        = explode(' ', $this->sName, 2);

      $this->sStreetAddress = $Query->value('street1');
      $this->sStreetAddress2 = $Query->value('street2');
      $this->sCity = $Query->value('city');
      $this->sState = $Query->value('state');
      $this->sZip = $Query->value('zip');
      $this->sCountryIsoCode = $Query->value('country');
      $this->nCountryId = $this->getCountryIdByIsoCode($this->sCountryIsoCode);
      $this->nZoneId = $this->getZoneIdByState($this->sState);
      $this->sPhone = $Query->value('phone');
      $this->nId = $Query->value('customers_id');

      return true;
    }

    // --------------------------------------------------------------------

    function create() {
      global $abxDatabase;

      $aCustomer = array(
        'customers_gender'        => 'U', 	// unknown
        'customers_firstname'     => $this->sFirstName,
        'customers_lastname'      => $this->sLastName . " (" . $this->sExtId. ")",
        'customers_email_address' => $this->sEmail,
        //'customers_telephone'     => $this->sPhone,
        'customers_newsletter'    => '0',
        'customers_password'      => $this->getNewPassword()
      );

      $this->nId = $abxDatabase->insert(TABLE_CUSTOMERS, $aCustomer);

      $aInfo = array(
        'customers_info_id'                         => $this->nId,
        'customers_info_number_of_logons'           => 0,
        'customers_info_date_account_created'       => date("Y-m-d H:i:s"),
        'customers_info_date_account_last_modified' => '0000-00-00 00:00:00'
      );

      $abxDatabase->insert(TABLE_CUSTOMERS_INFO, $aInfo);

      $aAddress = array(
        'customers_id'         => $this->nId,
        'entry_gender'         => 'U',
        'entry_firstname'      => $this->sFirstName,
        'entry_lastname'       => $this->sLastName,
        'entry_company'        => $this->sCompany,
        'entry_street_address' => ($this->sStreetAddress . ' ' .$this->sStreetAddress2),
        'entry_suburb'         => '',
        'entry_city'           => $this->sCity,
        'entry_postcode'       => $this->sZip,
        'entry_state'          => $this->sState,
        'entry_country_id'     => $this->nCountryId,
        'entry_zone_id'        => $this->nZoneId
      );

      $this->nAddressId = $abxDatabase->insert(TABLE_ADDRESS_BOOK, $aAddress);

      $abxDatabase->update(
        TABLE_CUSTOMERS,
        array('customers_default_address_id' => $this->nAddressId),
        'customers_id='.$this->nId
      );

      $sWhere = sprintf(
        "ext_email_address = '%s' LIMIT 1",
        $abxDatabase->escape($this->sEmail)
      );

      $aUpdate = array(
        'customers_id' => $this->nId,
        'is_anonymous' => 1
      );

      $abxDatabase->update(TABLE_ABX_WINNERS, $aUpdate, $sWhere);
    }
    
    function update()
    {
      global $abxDatabase;

    	// Check the following:
      $aAddress = array(
        'customers_id'         => $this->nId,
        'entry_gender'         => 'U',
        'entry_firstname'      => $this->sFirstName,
        'entry_lastname'       => $this->sLastName,
        'entry_company'        => $this->sCompany,
        'entry_street_address' => ($this->sStreetAddress . ' ' .$this->sStreetAddress2),
        'entry_suburb'         => '',
        'entry_city'           => $this->sCity,
        'entry_postcode'       => $this->sZip,
        'entry_state'          => $this->sState,
        'entry_country_id'     => $this->nCountryId,
        'entry_zone_id'        => $this->nZoneId
      );

      $this->nAddressId = $abxDatabase->insert(TABLE_ADDRESS_BOOK, $aAddress);

      $abxDatabase->update(
        TABLE_CUSTOMERS,
        array('customers_default_address_id' => $this->nAddressId),
        'customers_id='.$this->nId
      );
      
      $sWhere = sprintf(
        "ext_email_address = '%s' LIMIT 1",
        $abxDatabase->escape($this->sEmail)
      );

      $aUpdate = array(
        'customers_id' => $this->nId
      );
      
      $abxDatabase->update(TABLE_ABX_WINNERS, $aUpdate, $sWhere);
    }

    // --------------------------------------------------------------------

    function getNewPassword() {
      $sPassword = '';
      $nLength   = 8;

      for($i=0; $i<$nLength; $i++) {
        $sChar = chr(rand(48, 122));

        while(!ereg("[a-zA-Z0-9]", $sChar)) {
          if ($sChar == @$sLastChar) {
            continue;
          }
          $sChar = chr(rand(48, 90));
        }
        $sPassword .= $sChar;
        $sLastChar  = $sChar;
      }

      $this->sPwd = $sPassword;

      $sSalt     = substr(md5($sPassword), 0, 2);
      $sEncryptedPassword = md5($sSalt.$sPassword).':'.$sSalt;

	  	return $sEncryptedPassword;
    }

    // --------------------------------------------------------------------

    function doLogIn() {
      /*
      MMD - removing this section to remove use of globals - not sure
      how much i'm going to break here
      $GLOBALS['customer_id']  = $this->nId;
      $_SESSION['customer_id'] = $GLOBALS['customer_id'];

      $GLOBALS['customer_default_address_id']  = $this->nAddressId;
      $_SESSION['customer_default_address_id'] = $GLOBALS['customer_default_address_id'];

      $GLOBALS['customer_first_name']  = $this->sFirstName;
      $_SESSION['customer_first_name'] = $GLOBALS['customer_first_name'];

      $GLOBALS['customer_country_id']  = $this->nCountryId;
      $_SESSION['customer_country_id'] = $GLOBALS['customer_country_id'];

      $GLOBALS['customer_zone_id']  =  $this->nZoneId;
      $_SESSION['customer_zone_id'] = $GLOBALS['customer_zone_id'];
	  */

	  $_SESSION['customer_id'] = $this->nId;

      $_SESSION['customer_default_address_id'] = $this->nAddressId;

      $_SESSION['customer_first_name'] = $this->sFirstName;

      $_SESSION['customer_country_id'] = $this->nCountryId;

      $_SESSION['customer_zone_id'] = $this->nZoneId;

      $this->updateLoginTracker();
    }

    // --------------------------------------------------------------------

    function updateLoginTracker() {
      global $abxDatabase;

      $sQuery = "UPDATE %s SET "
                ."customers_info_date_of_last_logon = now(),"
                ."customers_info_number_of_logons = customers_info_number_of_logons + 1 "
              ."WHERE customers_info_id = %d LIMIT 1";

      $sQuery = sprintf(
        $sQuery,
        TABLE_CUSTOMERS_INFO,
        $this->nId
      );

      $abxDatabase->query($sQuery);
    }

    // --------------------------------------------------------------------

    function getCountryIdByIsoCode($sCountryIsoCode) {
      $aCountries = $this->getCountries();
      foreach($aCountries as $nCountryId => $aCountry) {
        if ($aCountry['countries_iso_code_2'] == $sCountryIsoCode) {
          return $nCountryId;
        }
      }
    }

    // --------------------------------------------------------------------

    function getCountries($nCountryId = null) {
      static $aCountries;
      if (!$aCountries) {
        global $abxDatabase;

        $sQuery = "SELECT countries_id,"
                        ."countries_name,"
                        ."countries_iso_code_2,"
                        ."countries_iso_code_3,"
                        ."c.address_format_id,"
                        ."address_format "
                ."FROM %s c "
                ."LEFT JOIN %s a on c.address_format_id = a.address_format "
                ."ORDER BY countries_name";

        $sQuery = sprintf($sQuery, TABLE_COUNTRIES, TABLE_ADDRESS_FORMAT);
        $Query = $abxDatabase->query($sQuery);

        while($aCountry = $Query->next()) {
          $aCountries[$aCountry['countries_id']] = $aCountry;
        }
      }

      return (!$nCountryId) ? $aCountries : $aCountries[$nCountryId];
    }

    // --------------------------------------------------------------------

    function hasCountryZones($nCountry = null) {
      static $aCountries;

      if (!($nCountry = intval($nCountry))) {
        $nCountry = $this->nCountryId;
      }

      if ($nCountry = intval($nCountry)) {
        if (!isset($aCountries[$nCountry])) {
          global $abxDatabase;

          $sQuery = "SELECT count(*) AS total "
                   ."FROM %s "
                   ."WHERE zone_country_id = %d";

          $aRes = $abxDatabase->fetch_row(sprintf($sQuery, TABLE_ZONES, $nCountry));

          $aCountries[$nCountry] = ($aRes['total'] > 0);
        }

        return $aCountries[$nCountry];
      }

      return false;
    }

    // --------------------------------------------------------------------

    function getZoneIdByState($sState, $nCountry = null) {
      global $abxDatabase;

      if (!$nCountry) {
        $nCountry = $this->nCountryId;
      }

      $this->bCountryZones = $this->hasCountryZones($nCountry);

      if ($this->bCountryZones) {
        $sQuery = "SELECT DISTINCT zone_id "
                 ."FROM %s "
                 ."WHERE zone_country_id = %d "
                  ."AND (zone_name = '%s' OR zone_code = '%s')";

        $sQuery = sprintf(
          $sQuery,
          TABLE_ZONES,
          $nCountry,
          $abxDatabase->escape($sState),
          $abxDatabase->escape($sState)
        );

        $Query = $abxDatabase->query($sQuery);

        if ($Query->numRows() == 1) {
          return $Query->valueInt('zone_id');
        }
      }
    }

    // --------------------------------------------------------------------

  }//end class

  // ----------------------------------------------------------------------

?>