<?php
/*
  $Id: abxItem.php,v 1.21 2008/12/15 00:47:29 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxItem {

    function buildSQLArray(&$vars)
    {
      $keys = array(
        'seller_id',
        'profile_id',
        'type',
        'label',
        'site',
        'region',
        'city_state',
        'country',
        'listing_type',
        'item_specifics',
        'duration',
        'quantity',
        'title',
        'subtitle',
        'category1',
        'category2',
        'store_category',
        'description',
        'products_id',
        'extra_private',
        'extra_bold',
        'extra_highlight',
        'extra_category_featured',
        'extra_homepage_featured',
        'extra_gallery',
        'counter'
      );

      $dbItem                  = abxArray::setArray($keys,$vars);
      $dbItem['last_modified'] = 'now()';

      $dbPayment      = $this->buildPaymentSQLArray($vars);
//      $dbShipping     = $this->buildShippingSQLArray($vars);
      $dbReturnPolicy = $this->buildReturnPolicySQLArray($vars);
      $dbPictures     = $this->buildPictureSQLArray($vars);
      $dbObjectInfo   = $this->buildObjectInfoArray($vars);

      //return array_merge($dbItem,$dbPayment,$dbShipping,$dbReturnPolicy,$dbPictures,$dbObjectInfo);
      return array_merge($dbItem,$dbPayment,$dbReturnPolicy,$dbPictures,$dbObjectInfo);
    }

    function buildPictureSQLArray(&$vars)
    {
      $keys = array(
        'picture1_url',
        'picture2_url',
        'picture3_url',
        'picture4_url',
        'picture5_url',
        'picture6_url',
        'picture7_url',
        'picture8_url',
        'extra_gallery_url'
      );

      return abxArray::setArray($keys,$vars);
    }

    function buildPaymentSQLArray(&$vars)
    {
      $keys = array(
        'price',
        'bin_price',
        'reserve_price',
        'currency',
        'paypal_email',
        'payment_description',
        'payment_methods',
        'sales_tax_state',
        'sales_tax_percent',
        'sales_tax_sandh');

      return abxArray::setArray($keys,$vars);
    }

    function buildShippingSQLArray(&$vars)
    {
      $keys = array(
        'shipping_type',
        'shipping_location',
        'shipping_pkg',
        'shipping_svc',
        'shipping',
        'shipping_addl',
        'shipping_postcode',
        'shipping_global_svc',
        'shipping_global',
        'shipping_global_addl',
        'shipping_weight',
        'shipping_weight_unit',
        'insurance_option',
        'insurance'
      );

      return abxArray::setArray($keys,$vars);
    }
    
    function buildObjectInfoArray(&$vars)
    {
      $keys = array(
        'now_and_new',
        'store_category2',
        'extra_border',
        'extra_gift_icon',
        'sku',
        'external_product_id',
        'best_offer_enabled',
        'handling_fee',
        'digital_delivery',
        'add_tax_to_prices',
        'use_tax_table',
        'lotsize',
        'extra_pro_pack',
        'extra_value_pack',
        'enable_invmgr',
        'quantity_min',
        'intl_site_visibility'
      );      

      $objArray = abxArray::setArray($keys,$vars);
      
      $prefix = 'abxship_';
      $objShipArray = abxArray::setArrayWithKeyPrefix($prefix, $vars);
      
      $objArray = array_merge($objArray, $objShipArray);
      
      // compact this whole array down into 'object_info'
	  return array('object_info' => serialize($objArray));
    }
    

    function buildReturnPolicySQLArray(&$vars)
    {
      $array = array();

      if (empty($vars['return_policy_accepted'])) {

        unset($vars['return_policy_accepted'],$vars['return_policy_description'],$vars['return_policy_no_of_days'], $vars['return_policy_refund_type']);
        $array['return_policy'] = '';
        
      } else {
      //} elseif (in_array(strtoupper($vars['site']), array('US','CA','UK','AU','AT','FR','DE','CH'))) {

        $vcsid = abxConstants::getCharacterSetSiteId($vars['site']);

        $return_policy_details = array();

        $return_policy_details[] = "vcsid=$vcsid";
        $return_policy_details[] = "attr{$vcsid}_3803=32040";
        $return_policy_details[] = "attr{$vcsid}_3804={$vars['return_policy_no_of_days']}";
        if (isset($vars['return_policy_refund_type']))
          $return_policy_details[] = "attr{$vcsid}_3805={$vars['return_policy_refund_type']}";
        $return_policy_details[] = "attr_t{$vcsid}_3806=".urlencode(substr($vars['return_policy_description'], 0, 500));


        $array['return_policy'] = implode('&', $return_policy_details);
      }
      return $array;
    }
  }//end class
?>