<?php
/*
  $Id: abxListings.php,v 1.18 2008/12/15 00:47:29 auctionblox Exp $

  AuctionBlox, sell more, work less!

  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  if(class_exists('abxListing') === false) {

    require_once(DIR_FS_ABX_CLASSES . 'abxListing.php');

  }

  class abxListings extends abxListing {

    function getSoldItemsQuery()
    {
      return "select SQL_CALC_FOUND_ROWS l.*, s.url, p.products_image,p.products_quantity,i.label from " . TABLE_ABX_LISTINGS ." l ".
             " LEFT JOIN " . TABLE_ABX_SITES . " s on (l.auction_house_id = s.auction_house_id and l.site = s.site)" .
             " LEFT JOIN " . TABLE_PRODUCTS ." p on l.app_data=p.products_id " .
             " LEFT JOIN " . TABLE_ABX_ITEMS. " i on l.item_uuid=i.uuid " .
             " WHERE quantity_sold > 0 AND status = 'E'";
    }

    function getUnsoldItemsQuery()
    {
      return "select SQL_CALC_FOUND_ROWS l.*, s.url, p.products_image,p.products_quantity,i.label from " . TABLE_ABX_LISTINGS ." l ".
             " LEFT JOIN " . TABLE_ABX_SITES . " s on (l.auction_house_id = s.auction_house_id and l.site = s.site)" .
             " LEFT JOIN " . TABLE_PRODUCTS ." p on l.app_data=p.products_id " .
             " LEFT JOIN " . TABLE_ABX_ITEMS. " i on l.item_uuid=i.uuid " .
             " WHERE quantity_sold = 0 AND status = 'E'";
    }

    function &getRelistItemsEditQuery($ids)
    {
      require_once(DIR_FS_ABX_CLASSES . 'abxItemManager.php');
      $listings = $GLOBALS['abxDatabase']->fetch_results('SELECT * from ' . TABLE_ABX_LISTINGS . ' where id in (' . implode(',',$ids) . ') order by ext_id');
      for($i = 0, $n = count($listings); $i < $n; $i++) {
        $listings[$i]['productDisplayName'] = abxItemManager::getProductNameByID($listings[$i]['app_data']);
      }
      return $listings;
    }

    function getEndedItemsQuery()
    {
      return "select SQL_CALC_FOUND_ROWS l.*, s.url, p.products_image,p.products_quantity,i.label from " . TABLE_ABX_LISTINGS ." l ".
             " LEFT JOIN " . TABLE_ABX_SITES . " s on (l.auction_house_id = s.auction_house_id and l.site = s.site)" .
             " LEFT JOIN " . TABLE_PRODUCTS ." p on l.app_data=p.products_id " .
             " LEFT JOIN " . TABLE_ABX_ITEMS. " i on l.item_uuid=i.uuid " .
             " WHERE status = 'E'";
    }

    function getActiveItemsQuery()
    {
      return "select SQL_CALC_FOUND_ROWS l.*, s.url, p.products_image,p.products_quantity,i.label from " . TABLE_ABX_LISTINGS ." l ".
             " LEFT JOIN " . TABLE_ABX_SITES . " s on (l.auction_house_id = s.auction_house_id and l.site = s.site)" .
             " LEFT JOIN " . TABLE_PRODUCTS ." p on l.app_data=p.products_id " .
             " LEFT JOIN " . TABLE_ABX_ITEMS. " i on l.item_uuid=i.uuid " .
             " WHERE status = 'A'";
    }

    function getPendingItemsQuery() {

      return "select SQL_CALC_FOUND_ROWS l.*, s.*, p.products_image,p.products_quantity,i.label from " . TABLE_ABX_LISTINGS ." l ".
             " LEFT JOIN " . TABLE_ABX_SCHEDULE_INFO . " s using (uuid)" .
             " LEFT JOIN " . TABLE_PRODUCTS ." p on l.app_data=p.products_id " .
             " LEFT JOIN " . TABLE_ABX_ITEMS. " i on l.item_uuid=i.uuid " .
             " WHERE status = 'P' and s.uuid IS NOT NULL";
    }

    function getFailedItemsQuery()
    {
      return "select SQL_CALC_FOUND_ROWS l.*, s.url, p.products_image,p.products_quantity,i.label from " . TABLE_ABX_LISTINGS ." l ".
             " LEFT JOIN " . TABLE_ABX_SITES . " s on (l.auction_house_id = s.auction_house_id and l.site = s.site)" .
             " LEFT JOIN " . TABLE_PRODUCTS ." p on l.app_data=p.products_id " .
             " LEFT JOIN " . TABLE_ABX_ITEMS. " i on l.item_uuid=i.uuid " .
             " where status = 'F'";
    }

    function getCancelledItemsQuery()
    {
      return "select SQL_CALC_FOUND_ROWS l.*, s.url,p.products_image,p.products_quantity,i.label from " . TABLE_ABX_LISTINGS ." l ".
             " LEFT JOIN " . TABLE_ABX_SITES . " s on (l.auction_house_id = s.auction_house_id and l.site = s.site)" .
             " LEFT JOIN " . TABLE_PRODUCTS ." p on l.app_data=p.products_id " .
             " LEFT JOIN " . TABLE_ABX_ITEMS. " i on l.item_uuid=i.uuid " .
             " WHERE status = 'C'";
    }

    function getAllItemsQuery()
    {
      return "select SQL_CALC_FOUND_ROWS * from " . TABLE_ABX_LISTINGS .
             " LEFT JOIN " . TABLE_ABX_SITES . " using (auction_house_id, site) " .
             " where 1";
    }

    function downloadListings($seller_id)
    {

      $abxAPI = new abxAPI();

      $response = $abxAPI->callBySellerID('lister.downloadListings',$seller_id);

      if($response['code'] == 'success')

        abxMessageStack::add_session(TEXT_REQUEST_SUCCESSFULL, 'success');

      else

        abxMessageStack::add_session(ERROR_TEXT_REQUEST_FAILED, 'error');
    }
    
    function cancelById($ids)
    {
      global $abxDatabase;
      $query = $abxDatabase->query("select uuid from " . TABLE_ABX_LISTINGS . " WHERE id in (" . implode(',', $ids) . ")");
        
      $uuids = array();
      while($data = $query->next()) {
        $uuids[] = $data['uuid'];
      }

      $abxAPI = new abxAPI();
      $response = $abxAPI->call('lister.cancelBulkListings', array('list' => $uuids));

      if($response['code'] == 'success')
        abxMessageStack::add_session(TEXT_REQUEST_SUCCESSFULL, 'success');
      else
        abxMessageStack::add_session($response['message'], 'error');
    }

  }//end class
?>