<?php
/*
  $Id: abxMacros.php,v 1.17 2008/10/23 21:19:20 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxMacros {

    function emailMacros()
    {
      return array(
        'CHECKOUT_URL',
        'LISTING_TYPE',
        'LISTING_ID',
        'TRANSACTION_ID',
        'TIME_END',
        'QUANTITY',
        'PRICE_END',
        'CURRENCY',
        'SALES_TAX_AMOUNT',
        'SALES_TAX_PERCENT',
        'SHIPPING_ACTUAL',
        'INSURANCE_ACTUAL',
        'BUYER_ID',
        'BUYER_EMAIL',
        'SITE',
        'NAME',
        'STREET1',
        'STREET2',
        'CITY',
        'STATE',
        'ZIP',
        'COUNTRY',
        'PHONE',
        'TITLE',
        'SHIPPING_TYPE',
        'SHIPPING',
        'SHIPPING_ADDL',
        'SHIPPING_GLOBAL',
        'SHIPPING_GLOBAL_ADDL',
        'INSURANCE',
        'INSURANCE_OPTION'
      );
    }

    function categoryMacros()
    {
      return array(
        'EBAY_CATEGORY1_ID',
        'EBAY_CATEGORY2_ID',
        'EBAY_SHOP_CATEGORY1_ID',
        'EBAY_SHOP_CATEGORY2_ID',
      );
    }

    function productMacros()
    {
      global $abxDatabase;

			$query = "select p.*," .
              " pd.products_name, pd.products_description, pd.products_url," .
              " pfs.shipping, pfs.shipping_addl, pfs.shipping_global, pfs.shipping_global_addl," .
              " pei.custom1,pei.custom2,pei.custom3,pei.custom4,pei.custom5,pei.custom6,pei.custom7,pei.custom8,pei.custom9,pei.custom10," .
              " pei.exclude_auction, pei.exclude_store, pei.exclude_fixed, " .
              " m.manufacturers_name, m.manufacturers_image" .
              " FROM " . TABLE_PRODUCTS . " p" .
              " LEFT JOIN " . TABLE_PRODUCTS_DESCRIPTION . " pd on p.products_id = pd.products_id" .
              " LEFT JOIN " . TABLE_ABX_FIXED_SHIPPING . " pfs on p.products_id = pfs.products_id" .
              " LEFT JOIN " . TABLE_ABX_PRODUCTS_EXTRA_INFO . " pei on p.products_id = pei.products_id" .
			        " LEFT JOIN " . TABLE_MANUFACTURERS . " m ON p.manufacturers_id = m.manufacturers_id" .
              " WHERE 1 LIMIT 1";
			
      $arr = $abxDatabase->fetch_row($query);
			return array_keys($arr);
    }
    
    function productImageMacros()
    {
      return array(
        'PRODUCTS_IMAGE',
        'PICTURE1_URL',
        'PICTURE2_URL',
        'PICTURE3_URL',
        'PICTURE4_URL',
        'PICTURE5_URL',
        'PICTURE6_URL',
        'PICTURE7_URL',
        'PICTURE8_URL'
      );
    }

    function categoryMacrosQueryString($site, $productId)
    {
      return "SELECT p.products_id, ci.categories_id, ci.ebay_category1_id, ci.ebay_category2_id, ci.ebay_shop_category1_id, ci.ebay_shop_category2_id" .
              " FROM " . TABLE_PRODUCTS . " p" .
              " INNER JOIN " . TABLE_PRODUCTS_TO_CATEGORIES . " cat on p.products_id = cat.products_id" .
              " INNER JOIN " . TABLE_ABX_CATEGORY_INFO . " ci on cat.categories_id = ci.categories_id" .
              " WHERE p.products_id = " . (int)$productId .
              " AND ci.categories_site = '" . addslashes($site) . "'";
    }

    function productMacrosQueryString($productIds, $language_id)
    {
     return "SELECT p.*," .
             " pd.products_name, pd.products_description, pd.products_url," .
             " pfs.shipping, pfs.shipping_addl, pfs.shipping_global, pfs.shipping_global_addl," .
             " pei.custom1,pei.custom2,pei.custom3,pei.custom4,pei.custom5,pei.custom6,pei.custom7,pei.custom8,pei.custom9,pei.custom10," .
             " pei.exclude_auction, pei.exclude_store, pei.exclude_fixed, " .
             " m.manufacturers_name, m.manufacturers_image" .
             " FROM " . TABLE_PRODUCTS . " p" .
             " LEFT JOIN " . TABLE_PRODUCTS_DESCRIPTION . " pd on p.products_id = pd.products_id" .
             " LEFT JOIN " . TABLE_ABX_FIXED_SHIPPING . " pfs on p.products_id = pfs.products_id" .
             " LEFT JOIN " . TABLE_ABX_PRODUCTS_EXTRA_INFO . " pei on p.products_id = pei.products_id" .
             " LEFT JOIN " . TABLE_MANUFACTURERS . " m ON p.manufacturers_id = m.manufacturers_id" .
             " WHERE p.products_id in (" . implode(',',$productIds) . ")" .
             " AND pd.language_id = $language_id"; 
    }
    
    function productCustomMacros()
    {
    	return array();
    }

    function runProductCustomMacros(&$target, &$product)
    {
    	return $target;
    }    

    function runMacro($macro, $value, &$target)
    {
      // str_replace will take an array as target
     	return $this->runRawMacro('{'.strtoupper($macro).'}', $value, $target);
    }
    
    function runRawMacro($rawmacro, $value, &$target)
    {
      // str_replace will take an array as target
      return str_replace($rawmacro, $value, $target);
    	
    }
    
    function evaluate($expression)
    {
      ob_start();
      eval($expression);
      $result = ob_get_contents();
      ob_end_clean();
      
      return $result;    	
    }

    function runCategoryMacros($site,  &$target, &$product)
    {
      global $abxDatabase;

      $sQuery = $this->categoryMacrosQueryString($site, $product['products_id']);
      $categoriesQuery = $abxDatabase->query($sQuery);
      $categoryMacros = $categoriesQuery->next();
      if($categoryMacros !== false)
      {
        foreach($categoryMacros as $macro => $value) 
        {
    	    $target =& $this->runMacro($macro, $value, $target);
     	  }
      }
      else
      {
        $macros = $this->categoryMacros($product);
        foreach($macros as $macro) 
        {
          $target =& $this->runMacro($macro, "Not set", $target);
        }
      }
	    return $target;
    }

    function runProductMacros(&$target, &$product)
    {
      $macros = $this->productMacros();
      
      foreach($macros as $macro) 
      {
        // We want this macro to show up in the macro list, but we dont want to replace it locally        
        if(stristr($macro, 'products_quantity') !== false)
          continue; 
        
        $macro = trim($macro);
        $value = $product[$macro];  // stupid mysql columns are case-sensitive, so dont strtolower
        $target =& $this->runMacro($macro, $value, $target);
      }
      
      return $target;
    }

    function runProductImageMacros(&$target, &$product)
    {
      $macros = $this->productImageMacros();
      foreach($macros as $macro) 
      {
        $macro = trim($macro);
        $value = $product[strtolower($macro)];
        
        // replace missing images with a transparent 1-pixel image
        $value = trim($value);
        if(strlen($value) == 0) $value = "pixel_trans.gif";
        
        // urlencode any spaces  		
        $value =& str_replace(' ', '%20', $value);

        // Make fully-qualified URL
        if (strlen($value) > 0 && 
           (strtolower(substr($value, 0, 7)) !== "http://" && 
            strtolower(substr($value, 0, 6)) !== "ftp://"))
        {
  		  //because DIR_WS_CATALOG_IMAGES is a fully qualified URL on Zen, we have to do this
		  if (strtolower(substr(DIR_WS_CATALOG_IMAGES, 0, 7)) !== "http://" &&
		      strtolower(substr(DIR_WS_CATALOG_IMAGES, 0, 8)) !== "https://" &&
			  strtolower(substr(DIR_WS_CATALOG_IMAGES, 0, 6)) !== "ftp://"){
			  
			  $fullvalue = HTTP_CATALOG_SERVER . DIR_WS_CATALOG_IMAGES . $value;
		  }
		  else{
		  	  $fullvalue = DIR_WS_CATALOG_IMAGES . $value;
		  }

        }

				// If the macro is URL encoded, then it is part of a fully-qualified URL, 
				// simply replace the macro
        $target =& $this->runRawMacro('%7B'.strtoupper($macro).'%7D', $value, $target);

        // This is likely a gallery image
        $target =& $this->runRawMacro('{'.strtoupper($macro).'}', $fullvalue, $target);

        // run *real* macro
        $target =& $this->runMacro($macro, $value, $target);
      }

	    return $target;
    }
    
    function runItemMacros($site,  $item, $product)
    {
      // run imageMacros before productMacros since they require special processing
      $item =& $this->runProductCustomMacros($item, $product);
      $item =& $this->runProductImageMacros($item, $product);	
      $item =& $this->runProductMacros($item, $product);
      $item =& $this->runCategoryMacros($site, $item, $product);

      return $item;
    }

    function &getInstance() {
      static $Instance;

      if (!$Instance) {
				if (file_exists(DIR_FS_MYABX_CLASS_DIR . 'Custom/macros.php')) {
          require_once DIR_FS_MYABX_CLASS_DIR.'Custom/macros.php';
          $Instance = new abxMacrosManager;
        } else {
          $Instance = new abxMacros;
        }
      }
      return $Instance;
    }

    function displayMacroGroupList($set)
    {
      switch($set) {
        case 'email':
          return abxMacros::displayMacroKeysAsHtmlList('email',$this->emailMacros());
          break;

        case 'items':
        case 'generator':
          return abxMacros::displayMacroKeysAsHtmlList('items',
          array_merge($this->productMacros(), $this->productImageMacros(), $this->productCustomMacros(), $this->categoryMacros()));
          break;
      }
    }

    function getMacroKeys(&$macros)
    {
      $array = array();
      for($i =0, $n = count($macros); $i < $n; $i++)
        $array[] = $macros[$i]['name'];

      return $array;
    }

    function displayMacroKeysAsHtmlList($liName,&$macros)
    {
      $str = '<ul class="macros" id="'.$liName.'">'."\n";

      foreach((array)$macros as $macro)
        $str .= '<li id="'.$macro.'" onClick="setMacro(\''.$macro.'\',\''.$_GET['fName'].'\')">{'.strtoupper($macro).'}</li>'."\n";

      $str .= '</ul>'."\n";

      return $str;
    }

    function displayMacros()
    {
      return '<table border="0" cellspacing="2" cellpadding="3">'.
             '  <tr valign="top">'.
             '    <td class="smallText">'.'<b>'.ABX_TEXT_HELP_EMAIL_TOKENS.'</b>'.$this->displayMacroGroupList('email').'</td>'.
             '    <td class="smallText">'.'<b>'.ABX_TEXT_HELP_TEMPLATE_TOKENS.'</b>'.$this->displayMacroGroupList('templates').'<br class="h10"><b>'.ABX_TEXT_HELP_ITEM_TOKENS . '&nbsp;&amp;&nbsp;' . ABX_TEXT_HELP_GENERATOR_TOKENS.'</b>'.$this->displayMacroGroupList('items').'</td>'.
             '  </tr>'.
             '</table>';
    }
    
	  function linkencode ($p_url) {
	   $ta = parse_url($p_url);
	   if (!empty($ta[scheme])) { $ta[scheme].='://'; }
	   if (!empty($ta[pass]) and !empty($ta[user])) {
	           $ta[user].=':';
	           $ta[pass]=rawurlencode($ta[pass]).'@';
	   } elseif (!empty($ta[user])) {
	       $ta[user].='@';
	   }
	   if (!empty($ta[port]) and !empty($ta[host])) {
	       $ta[host]=''.$ta[host].':';
	   } elseif    (!empty($ta[host])) {
	       $ta[host]=$ta[host];
	   }
	   if (!empty($ta[path])) {
	       $tu='';
	       $tok=strtok($ta[path], "\\/");
	       while (strlen($tok)) {
	           $tu.=rawurlencode($tok).'/';
	           $tok=strtok("\\/");
	       }
	       $ta[path]='/'.trim($tu, '/');
	   }
	   if (!empty($ta[query])) { $ta[query]='?'.$ta[query]; }
	   if (!empty($ta[fragment])) { $ta[fragment]='#'.$ta[fragment]; }
	   return implode('', array($ta[scheme], $ta[user], $ta[pass], $ta[host], $ta[port], $ta[path], $ta[query], $ta[fragment]));
	}
}//end class
?>