<?php
/*
  $Id: abxMessageStack.php,v 1.2 2008/03/13 14:33:10 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxMessageStack
  {

      function add($message, $type = 'error')
    {
      $messageStack = &abxMessageStack::getMessageStack();
      $messageStack[] = array('msg' => $message, 'type' => $type);

    }

    function add_session($message, $type = 'error')
    {
      $messageStack = isset($_SESSION['abxMessageStack']) ? $_SESSION['abxMessageStack'] : array();

      $messageStack[] = array('msg' => $message, 'type' => $type);

      $_SESSION['abxMessageStack'] = $messageStack;

      abxMessageStack::add($message, $type);

    }

    function reset()
    {
      $messageStack = &abxMessageStack::getMessageStack();
      $messageStack = array();
    }

    function output($output = false, $html_output = true, $seperator = "\n")
    {

	  $numberOfMessages = abxMessageStack::size();
	  echo 'number of messages: ' . $numberOfMessages;
      if ($numberOfMessages > 0) {
        $messageStack = abxMessageStack::getMessageStack();

        $messages = array();
        if ($html_output === true) {
          for($i = 0; $i < $numberOfMessages; $i++) {
            switch($messageStack[$i]['type']) {
              case 'error':
                $bullet_image = DIR_WS_ABX_IMAGES . 'icons/error.gif';
                break;
              case 'warning':
                $bullet_image = DIR_WS_ABX_IMAGES . 'icons/warning.gif';
                break;
              case 'success':
                $bullet_image = DIR_WS_ABX_IMAGES . 'icons/success.gif';
                break;
              default:
                $bullet_image = DIR_WS_ABX_IMAGES . 'icons/bullet_default.gif';
                break;
            }
            $messages[] = '<li style="list-style-image: url(\'' . $bullet_image . '\')">' . htmlspecialchars($messageStack[$i]['msg']) . '</li>';
          }
          if ($output === true) {
            echo '<div class="abxMessageStack"><ul>' . implode($seperator, $messages) . '</ul></div>';
          } else {
            return '<div class="abxMessageStack"><ul>' . implode($seperator, $messages) . '</ul></div>';
          }
        } else {
          for($i = 0; $i < $numberOfMessages; $i++) {
            $messages[] = $messageStack[$i]['msg'];
          }
          if ($output === true) {
            echo implode($seperator, $messages);
          } else {
            return implode($seperator, $messages);
          }
        }
      }
    }

    function size()
    {
      $messageStack = abxMessageStack::getMessageStack();
      return isset($messageStack) ? count($messageStack) : 0;
    }

    function &getMessageStack()
    {
      static $messageStack = array();
      //if (is_null($class)) {
        return $messageStack;
      //} else {
        //return $messageStack[$class];
      //}
    }

    function loadFromSession()
    {
      if (isset($_SESSION['abxMessageStack'])) {
        foreach($_SESSION['abxMessageStack'] as  $messages) {
        	 abxMessageStack::add($messages['msg'], $messages['type']);
          $messageStack = &abxMessageStack::getMessageStack();

        }

        unset($_SESSION['abxMessageStack']);
      }
    }
  }//end class
?>