<?php
/*
  $Id: abxSaleItem.php,v 1.11 2008/03/13 14:33:09 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  if(class_exists('abxSales') === false) {

    require_once(DIR_FS_ABX_CLASSES . 'abxSales.php');

  }

  class abxSaleItem extends abxSales {

    function saleItemWinner(&$info)
    {
      return array(
        'auctionHouseID' => $info['auctionHouseID'],
        'userID'         => $info['userID'],
        'email'          => $info['email']
      );
    }

    function saleItem(&$info)
    {
      return array(
        'auctionHouseID'  => $info['auctionHouseID'],
        'sellerID'        => $info['sellerID'],
        'productID'       => $info['productID'],
        'statusID'        => $info['statusID'],
        'extTitle'        => $info['extTitle'],
        'currency'        => $info['currency'],
        'timeEnd'         => local_date_to_gmt_sql_format($info['timeEnd']),
        'email'           => $info['email'],
        'qty'             => $info['qty'],
        'priceEnd'        => $info['priceEnd'],
        'shippingType'    => $info['shippingType'],
        'shipping'        => $info['shipping'],
        'insurance'       => $info['insurance'],
        'insuranceOption' => $info['insuranceOption'],
      );
    }

    function update($oID,&$info)
    {
      global $abxDatabase, $abxSales;

      $saleItem       = abxSaleItem::saleItem($info);
      $saleItem['ID'] = (int) $oID;

      $winner = abxSaleItem::saleItemWinner($info);

      $abxAPI = new abxAPI;

      $oInfo = $this->getSale($oID);

      $array = array(
        'site'             => $info['site'],
        'seller_id'        => $abxDatabase->fetch_value('seller_id',TABLE_ABX_SELLER_INFO,"user_id='".addslashes($saleItem['sellerID'])."'"),
        'uuid'             => $oInfo['uuid'],
        'listing_id'       => $oInfo['extID'],
        'transaction_id'   => $oInfo['extKey2'],
        'buyer_userId'     => $winner['userID'],
        'buyer_email'      => $winner['email'],
        'checkout_status'  => $info['statusID'],
        'title'            => $info['extTitle'],
        'currency'         => $info['currency'],
        'quantity'         => $info['qty'],
        'price_end'        => $saleItem['priceEnd'],
        'insurance'        => $saleItem['insurance'],
        'insurance_option' => $info['insuranceOption'],
        'shipping'         => $saleItem['shipping'],
        'shipping_type'    => $saleItem['shippingType'],
        'sales_tax'        => $oInfo['taxPercent'],
        'sales_tax_amount' => $oIinfo['tax'],
        'statusID'         => $saleItem['statusID']
      );

      $response = $abxAPI->call('sale.updateSale',$array);

      if($response['code'] == 'success')

        parent::update($winner,$saleItem);

      else

        abxMessageStack::add_session(ERROR_TEXT_SALE_UPDATE_FAILED,'error');

    }

    function insert(&$info)
    {
      global $abxDatabase, $abxSales;

      $winner = abxSaleItem::saleItemWinner($info);

      $saleItem                 = abxSaleItem::saleItem($info);
      $saleItem['extID']        = $info['extID'];
      $saleItem['extKey2']      = time();
      $saleItem['site']         = $info['site'];
      $saleItem['listingType']  = '9'; // Fixed Listing Type
      $saleItem                 = array_merge($saleItem,$winner);

      $abxAPI = new abxAPI;

      $array = array(
        'site'             => $info['site'],
        'seller_id'        => $abxDatabase->fetch_value('seller_id',TABLE_ABX_SELLER_INFO,"user_id='".addslashes($saleItem['sellerID'])."'"),
        'listing_id'       => $info['extID'],
        'transaction_id'   => $saleItem['extKey2'],
        'buyer_userId'     => $winner['userID'],
        'buyer_email'      => $winner['email'],
        'checkout_status'  => $info['statusID'],
        'title'            => $info['extTitle'],
        'currency'         => $info['currency'],
        'quantity'         => $info['qty'],
        'price_end'        => $saleItem['priceEnd'],
        'insurance'        => (empty($saleItem['insurance']) === false) ? $saleItem['insurance'] : '0.00',
        'insurance_option' => $info['insuranceOption'],
        'shipping'         => (empty($saleItem['shipping']) === false) ? $saleItem['shipping'] : '0.00',
        'shipping_type'    => $saleItem['shippingType'],
        'statusID'         => $saleItem['statusID']
      );

      $response = $abxAPI->call('sale.insertSale',$array);

      if($response['code'] == 'success') {

        $saleItem['uuid'] = $response['uuid'];

        parent::insert($winner,$saleItem);

      } else {

        abxMessageStack::add_session(ERROR_TEXT_SALE_INSERT_FAILED,'error');

      }
    }
    
    function getSale($basket_id)
    {
      global $currencies, $abxDatabase;

       $auction_query_raw =
        "select a.*, b.ext_customer_id, b.ext_email_address" .
        " from " . TABLE_ABX_BASKET . " a, " . TABLE_ABX_WINNERS . " b" .
        " where a.auction_winner_id = b.auction_winner_id" .
        " and a.auction_basket_id = " . (int)$basket_id;

      $auctionQuery = &$abxDatabase->query($auction_query_raw);

      $retArray = null;

      if ($auctions = $auctionQuery->next()) {

        $retArray = array(
          'ID'              => $basket_id,
          'uuid'            => $auctions['uuid'],
          'auctionHouseID'  => $auctions['auction_house_id'],
          'site'            => $auctions['site'],
          'listingType'     => $auctions['listing_type'],
          'sellerID'        => $auctions['user_id'],
          'extID'           => $auctions['ext_id'],
          'extKey2'         => $auctions['ext_key2'],
          'extTitle'        => $auctions['ext_title'],
          'extDesc'         => $auctions['ext_desc'],
          'qty'             => $auctions['quantity'],
          'currency'        => $auctions['currency'],
          'priceStart'      => $auctions['price_start'],
          'priceEnd'        => $auctions['price_end'],
          'insurance'       => $auctions['insurance'],
          'insuranceOption' => $auctions['insurance_option'],
          'shippingType'    => $auctions['shipping_type'],
          'shipping'        => $auctions['shipping'],
          'shippingGlobal'  => $auctions['shipping_global'],
          'shippingZip'     => $auctions['shipping_zip'],
          'shippingCountry' => $auctions['shipping_country'],
          'tax'             => $auctions['sales_tax'],
          'taxPercent'      => $auctions['sales_tax_percent'],
          'timeStart'       => $auctions['time_start'],
          'timeEnd'         => $auctions['time_end'],
          'statusID'        => $auctions['listing_status'],
          'email'           => $auctions['ext_email_address'],
          'userID'          => $auctions['ext_customer_id'],
          'ordersID'        => $auctions['orders_id'],
          'productID'       => $auctions['products_id'],
          'workflowStateID' => $auctions['workflow_state'],
          'feedbackStateID' => $auctions['feedback_left']
        );

        /*
            Notes:
            Added currency for sale.updateSale w/s
        */

      }

      return $retArray;
    }
    
    
    function remove($auction_basket_id)
    {
      global $abxDatabase;
      return $abxDatabase->delete(TABLE_ABX_BASKET,"auction_basket_id = $auction_basket_id");
    }
    

  }//end class
?>
