<?php

/*
  $Id: abxOrderManager.php,v 1.7 2007/06/23 01:31:46 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/
require_once (DIR_FS_ABX_CLASSES . 'abxDatabase.php');
require_once (DIR_FS_ABX_CLASSES . 'abxConfiguration.php');
require_once (DIR_FS_ABX_CLASSES . 'abxAPIQueue.php');

class abxOrderManager
{
  function getOrderStatusUpdateApiCall()
  {
    return 'sale.updateStatusEx';
  }

  function getUpdateProductInventoryApiCall()
  {
    return 'inventory.reviseQuantityAvailable';
  }
  
  function synchronize()
  {
    $lastId = abxOrderManager::getLastProcessedOrderStatusHistoryId();
    $maxId = abxOrderManager::getMaxOrderStatusHistoryId();

    abxOrderManager::addQuantityFromRecentOrderProductsToApiQueue($lastId);
    abxOrderManager::addUpdatedSalesToApiQueue($lastId);
    
    abxConfiguration::updateByKey('LAST_UPDATED_ORDERS_STATUS_HISTORY_ID', $maxId);

    abxAPIQueue::process();    
  }

  function addQuantityFromRecentOrderProductsToApiQueue($lastProcessedOrderStatusHistoryId)
  {
    global $abxDatabase;

    $strQuery =
         "SELECT" .
         " op.orders_id as orderId," .
         " op.products_quantity as quantityPurchased," .
         " p.products_id as productId," .
         " p.products_quantity as quantityAvailable" .
         " FROM " . TABLE_ORDERS_STATUS_HISTORY . " osh," . TABLE_ORDERS_PRODUCTS . " op," . TABLE_PRODUCTS . " p" .
         " WHERE op.products_id = p.products_id" .
         " AND op.orders_id = osh.orders_id" .
         " AND osh.orders_status_history_id > $lastProcessedOrderStatusHistoryId" .
         " ORDER BY osh.orders_status_history_id DESC " .
         " LIMIT 100 ";	// of course must limit this!

    $results = $abxDatabase->query($strQuery);
    $values = array();
    while($result = $results->next())
    {

	      $values[] = $result;
    }

    if(sizeof($values) > 0)
    {
      abxAPIQueue::add(abxOrderManager::getUpdateProductInventoryApiCall(), array('list' => $values));
    }
  }

  function addUpdatedSalesToApiQueue($lastProcessedOrderStatusHistoryId)
  {
    global $abxDatabase;
    
      $strQuery =
          "SELECT b.uuid as uuid," .
          " b.listing_status as checkoutState," .
          " osh.orders_id as orderId," .
          " osh.orders_status_id as status," .
          " osh.orders_status_history_id" .
          ' FROM ' . TABLE_ABX_BASKET . ' b , ' . TABLE_ORDERS_STATUS_HISTORY . ' osh' .
          " WHERE b.orders_id = osh.orders_id" .
          " AND osh.orders_status_history_id > $lastProcessedOrderStatusHistoryId " .
          " ORDER BY osh.orders_status_history_id DESC " .
          " LIMIT 100 ";	// of course must limit this!

    $results = $abxDatabase->query($strQuery);

    $values = array();
    while($result = $results->next())
    {
	      $values[] = $result;
    }

    if(sizeof($values) > 0)
    {
      abxAPIQueue::add(abxOrderManager::getOrderStatusUpdateApiCall(), array('list' => $values));
    }
  }

  function getLastProcessedOrderStatusHistoryId()
  {
    $configItem = abxConfiguration::queryByKey('LAST_UPDATED_ORDERS_STATUS_HISTORY_ID');
    $lastId = $configItem['configuration_value'];

    if ($lastId == null || intval($lastId) <= 0) {
      // must be the first time, so let's just get the last order status id from osCommerce and
      // store that for later.  old orders won't be processed
      $lastId = abxOrderManager::getMaxOrderStatusHistoryId();
    }
    return $lastId;
  }

  function getMaxOrderStatusHistoryId()
  {
    global $abxDatabase;
    $query = $abxDatabase->query('SELECT max(orders_status_history_id) as id FROM '.TABLE_ORDERS_STATUS_HISTORY);
    
    $id = $query->value('id');
    if ($id == null || intval($id) <= 0)
      $id = 0;
    
    return $id;
  }
} //end class
?>