dojo.provide("abx.widget.InternationalShippingService");

dojo.require("dojo.parser");
dojo.require("dijit._Widget");
dojo.require("dijit._Templated");
dojo.require("dijit.form.CheckBox");
dojo.require("dijit.form.FilteringSelect");
dojo.require("dijit.form.TextBox");
dojo.require("dijit.layout.ContentPane");

dojo.declare("abx.widget.InternationalShippingService",
        [dijit._Widget,dijit._Templated],
        {        
        templatePath: dojo.moduleUrl("abx","layout/widget/InternationalShippingService.html"),
        templateString: "",
        src: "",
        widgetsInTemplate: true,
        
        //instance variables
        selectBox: null,
        servicesName: "",
        flatCostField: null,
        flatCostName: "",
        flatCostAddlField: null,
        flatCostAddlName: "",
        flatCostContainer: null,
        shiptoBox: null,
        shiptoName: "",
        customLocationContainer: null,
        customLocationCol1: null,
        customLocationCol2: null,
        customLocationCol3: null,
        
        servicePopulated: false,
        readyForPopulate: false,
        serviceReady: false,
		
		shiptoChanged: function(){
        	if (this.shiptoBox.getValue() == 'Custom'){
 				dojo.style(this.customLocationContainer, "display", "");       	
        	}
        	else{
        		dojo.style(this.customLocationContainer, "display", "none");
        	}
        },
               
        shippingTypeChange: function(shippingType){
  			if (shippingType == "F"){
        		this.selectBox.store = intFlatShippingServicesStore;
        		dojo.style(this.flatCostContainer, "display", "");
        	}
        	else if (shippingType == "E"){
        		this.selectBox.store = intCalcShippingServicesStore;
        		dojo.style(this.flatCostContainer, "display", "none");        		
        	}
        	this.serviceReady = false;
        	this.selectBox.store.fetch({onComplete: dojo.hitch(this, 'setService')});
        },
        
        serviceChanged: function(){
        
        	dojo.publish('redraw_shipping_portlet');
        
        },
        
        dimensionsRequired: function(){
        
        	var item = this.selectBox.item;
        	if (item == null){
        		return false;
        	}
        	var dimensionsRequired = this.selectBox.store.getValue(item, 'dimensionsRequired');
        	if (dimensionsRequired != null && dimensionsRequired == '1'){
        		return true;
        	}
        	else{
        		return false;
        	}	
        
        },
        
        populateCustomLocations: function(items, request){
        	var itemsPerContainer = items.length / 3;
        	if (items.length % 3 > 0){
        		itemsPerContainer++;
        	}
        	
        	var checkedCustomLocations = new Array();
        	if (abxShipping[this.shiptoName + "_locations"]){
        		checkedCustomLocations = abxShipping[this.shiptoName + "_locations"].split(",");
        	}
        	
        	for (var i = 0; i < 3; i++){
        		this.customLocationCols[i].innerHTML = '';
        		dojo.style(this.customLocationCols[i], "padding", "10px");
        		for (var j = i*3; j < (i*3 + itemsPerContainer); j++){
        			var theMarkup = "<input type='checkbox' dojoType='dijit.form.CheckBox' name='" + this.shiptoName + "_locations[" + items[j]['id'] + "]'";
        			
        			//check if this one should be checked
        			for (var k = 0; k < checkedCustomLocations.length; k++){
        				if (checkedCustomLocations[k] == items[j]['id']){
        					theMarkup += " checked ";
        				}
        			}
        			
        			theMarkup += "/>&nbsp;" + items[j]['name'] + "<br>";
        			this.customLocationCols[i].innerHTML += theMarkup;        			
        		}
        		dojo.parser.parse(this.customLocationCols[i]);
        	}
        	
        	if (abxShipping[this.shiptoName] == 'Custom'){
 				dojo.style(this.customLocationContainer, "display", "");       	
        	}
        	else{
        		dojo.style(this.customLocationContainer, "display", "none");
        	}
        },
        
        setService: function(items, request){
        	var selVal = abxShipping[this.servicesName];
        	//if the value doesn't exist or we have already populated this widget (meaning
        	//this change is the result of a shipping type change, we set the value to ''
        	if (null == selVal || this.servicePopulated){
        		selVal = '';
        	}
        	//due to an apparent dojo bug, we need to look up the 'item' for this box and set it
        	for (var i = 0; i < items.length; i++){
        		if (items[i]['id'] == selVal){
        			this.selectBox.item = items[i];
        		}
        	}
        	
        	this.selectBox.setValue(selVal);
        	
        	this.serviceReady = true;
        	this.servicePopulated = true;
        },
        
        populateFields: function(shippingType){
        	//populate values
        	//we have to do this to make sure the correct store is chosen
        	//before we try to set the initial value of the drop down
			if (shippingType == "E"){
        		this.selectBox.store = intCalcShippingServicesStore;
        	}
        	else if (shippingType == "F" || shippingType == null){
        		this.selectBox.store = intFlatShippingServicesStore;
        	}
        	else{
        		//we must be doing 'abx' shipping, no need to wait for population
        		this.serviceReady = true;	
        		this.servicePopulated = true;        	
        	}
        	
        	this.selectBox.store.fetch({onComplete: dojo.hitch(this, 'setService')});
        	var shiptoVal = abxShipping[this.shiptoName];
        	if (shiptoVal == null || shiptoVal == ''){
        		shiptoVal = 'Worldwide';
        	}
        	this.shiptoBox.setValue(shiptoVal);
        	this.flatCostField.setValue(abxShipping[this.flatCostName]);
        	this.flatCostAddlField.setValue(abxShipping[this.flatCostAddlName]);
        },
        
        wireAndDraw: function(shippingType){
        	if (shippingType == "F"){
        		dojo.style(this.flatCostContainer, "display", "");
        	}
        	else if (shippingType == "E"){
        		dojo.style(this.flatCostContainer, "display", "none");        		
        	}
        	
        	dojo.subscribe("int_ship_type_change", this, "shippingTypeChange");
        	//intialize select box
        	this.selectBox.onChange = dojo.hitch(this, 'serviceChanged');
        	this.shiptoBox.onChange = dojo.hitch(this, 'shiptoChanged');
        },
        
        populated: function(){
        	return this.servicePopulated;
        },
        
        canBePopulated: function(){
        	return this.readyForPopulate;
        },
        
        isReady: function(){
        	return this.serviceReady;
        },
        
        postCreate: function(){
                	
        },
        
        startup: function(){
        	this.customLocationCols = new Array(this.customLocationCol1, this.customLocationCol2, this.customLocationCol3);
        	//here we populate the shipto custom location checkboxes
        	intShiptoCustomLocationStore.fetch({onComplete: dojo.hitch(this, 'populateCustomLocations')});
        	this.shiptoChanged();
        
        	this.readyForPopulate = true;
        } 
                
});