<?php
/*
  $Id: abx_profiles.php,v 1.9 2008/02/27 15:37:55 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Abx_Profiles extends abxWebServicePaginator {

    var
      $sMethod = 'profile.getProfilesList';

    function abxPaginator_Abx_Profiles()
    {
      global $abx;

      parent::abxWebServicePaginator();

      switch(current($abx)) {
        case 'new':
        case 'edit':
          $this->performAction = true;
          break;
      }
    }

    function sortDefaultArray()
    {
      return array(
        'name' => 'date_added',
        'value' => 'desc'
      );
    }

    function countSellerIDs()
    {
      return 0;
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => HEADING_PROFILE_LABEL, '', 'width' => '50%'),
//        array('heading' => HEADING_PROFILE_EMAIL, '', 'width' => '50%'),
//        array('heading' => HEADING_PROFILE_BCC_EMAIL, '', 'width' => '50%'),        
//        array('heading' => HEADING_PROFILE_HTML_EMAIL, '', 'width' => '50%'),       
//        array('heading' => HEADING_PROFILE_SEND_WBN, '', 'width' => '50%')      
      );
    }

    function tableDataRowContents($array)
    {
      return '<td>' . $this->cell($array['label']) . '</td>';
//             '<td>' . $this->cell($array['fromAddress']) . '</td>'.
//             '<td>' . $this->cell($array['bccAddress']) . '</td>'.
//             '<td>' . $this->bool($array['htmlEmail']) . '</td>'.
//             '<td>' . $this->bool($array['sendWBN']) . '</td>';
    }

    function bulkActions()
    {
      return array();
    }

    function singleActions($array = array())
    {
      return array();
    }

    function tableDataFooter()
    {
      //return '<div align="right">' .$this->navigation(TEXT_CREATE_PROFILE,'profiles-new') . '</div>';
    }

    function infoBox($action)
    {	
      global $abx;

      switch($action) {
        case 'createFeedbackTemplate':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_CREATE_FEEDBACK_TEMPLATE,TEXT_INFO_CREATE_FEEDBACK_TEMPLATE,'insertFeedbackTemplates','profiles','',$this->feedbackTemplateForm());
          break;
        case 'createEmailTemplate':
          return $this->infoBoxConfirmation(TEXT_INFO_HEADING_CREATE_EMAIL_TEMPLATE,'<div style="float: left;">'.TEXT_INFO_CREATE_EMAIL_TEMPLATE.'</div><div style="float: right;">'.$this->imageButton(DIR_WS_ABX_ICONS . 'contents.gif', TEXT_HELP, '16', '16',"openWindow('".abx_href_link(FILENAME_AUCTIONBLOX, 'abx=help-tokens')."');").'</div>','insertEmailTemplates','profiles','',$this->emailTemplateForm());
          break;
        default:
          switch(implode('-', $abx)) {
            case 'profiles-edit':
              return $this->infoPageBox(TEXT_INFO_HEADING_ABX_PROFILE,TEXT_INFO_EDIT_PROFILE,'profiles','editProfile','profiles-edit','',$this->profileBoxContent($_GET['oID']));
              break;
            case 'profiles-new':
              return $this->infoPageBox(TEXT_INFO_HEADING_ABX_PROFILE,TEXT_INFO_CREATE_PROFILE,'profiles','createNewProfile','profiles-new','',$this->profileBoxContent());
              break;
          }
          break;
      }
    }

    function profileBoxContent($profile_id = '')
    {
      global $abxDatabase;

      $profile = array();
      if ($profile_id) {
        $profile = abxProfiles::getProfileById($profile_id);
      }

      $str = '<table border="0" width="100%" cellspacing="2" cellpadding="5" class="tableForm">' .
             '  <tr>' .
             '    <td>' . TEXT_ENTRY_PROFILE_LABEL . '</td>' .
             '  </tr>' .
             '  <tr>' .
             '    <td>' . $this->input('label',$profile['label'],'maxlength="64"') . '</td>' .
             '  </tr>' .
             '  <tr>' .
             '    <td>' . TEXT_ENTRY_FROM_ADDRESS . '</td>' .
             '  </tr>' .
             '  <tr>' .
             '    <td>' . $this->input('fromAddress',$profile['fromAddress'],'maxlength="255"') . '</td>' .
             '  </tr>' .
             '  <tr>' .
             '    <td>' . TEXT_ENTRY_BCC_ADDRESS . '</td>' .
             '  </tr>' .
             '  <tr>' .
             '    <td>' . $this->input('bccAddress',$profile['bccAddress'],'maxlength="255"') . '</td>' .
             '  </tr>' .
             '  <tr>' .
             '    <td>' . $this->checkbox('htmlEmail','','',($profile['htmlEmail'] == 1 ? true : false)) . '&nbsp;&nbsp;' .TEXT_ENTRY_HTML_EMAIL . '</td>' .
             '  </tr>' .
             '  <tr>' .
             '    <td>' . $this->checkbox('sendWBN','','',($profile['sendWBN'] == 1 ? true : false)) . '&nbsp;&nbsp;' .TEXT_ENTRY_SEND_WBN . '</td>' .
             '  </tr>' .
             '</table>';

      if (empty($profile_id) === false)
        $str .= $this->hidden('oID',(int) $profile_id);

      return array(array('text' => $str));
    }

    function emailTemplateForm()
    {
      $str = '<table border="0" width="790" cellspacing="0" cellpadding="0" class="tableForm">' .
             '  <tr>' .
             '    <td nowrap colspan="2">' . TEXT_TYPE . '&nbsp;&nbsp;' . $this->radio('type', 'INVOICE', '', true). TEXT_INVOICE . '&nbsp;&nbsp;' . $this->radio('type', 'REMINDER', '', false) . '&nbsp;' . TEXT_REMINDER . '&nbsp;&nbsp;' . $this->radio('type', 'WARNING', '', false) . '&nbsp;' . TEXT_WARNING . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td style="padding-top: 10px;">' . '<b>' . TEXT_SUBJECT . '&nbsp;&nbsp;' . $this->input('subject', '', 'size="64" maxlength="64" class="emailTemplate"'). '</b>' . '</td>'.
             '    <td align="right">' . $this->imageButton(DIR_WS_ABX_ICONS . 'htmleditor.gif',TEXT_HTML_EDITOR,'16','16',"loadHTMLAREA('confirm',document.forms['confirm'].body.value,'body');") . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td colspan="2">' . $this->textarea('body', 'soft', 125, 5, '', 'id="body" class="emailTemplate"') .'</td>'.
             '  </tr>' .
             '</table>';

      return array(array('text' =>  $str));
    }

    function feedbackTemplateForm()
    {
      $str = '<table border="0" cellspacing="2" cellpadding="5" style="width: 580px; margin: 10px;">' .
             '  <tr>' .
             '    <td nowrap colspan="2">' . TEXT_FEEDBACK . '&nbsp;&nbsp;' . $this->radio('type', '+', '', true). TEXT_POSITIVE . '&nbsp;&nbsp;' . $this->radio('type', 'N', '', false) . '&nbsp;' . TEXT_NEUTRAL . '&nbsp;&nbsp;' . $this->radio('type', '-', '', false) . '&nbsp;' . TEXT_NEGATIVE . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td colspan="2">' . $this->input('text', '', 'id="feedback"  maxlength="255" class="emailTemplate" style="width: 100%;"') . '</td>' .
             '  </tr>' .
             '</table>';

      return array(array('text' =>  $str));
    }

  }//end class
?>