<?php
/*
  $Id: abx_profiles_email.php,v 1.6 2007/01/03 02:00:13 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  require_once(DIR_FS_ABX_CLASSES.'abxPaginatorProfiles.php');
  require_once(DIR_FS_ABX_CLASSES.'abxProfiles.php');

  class abxPaginator_Abx_Profiles_Email extends abxPaginatorProfiles {

    var
      $sMethod = 'profile.getEmailTemplates';

    function filterTerms()
    {
      return array();
    }

    function searchTerms()
    {
      return array();
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => HEADING_PROFILE_LABEL, 'sort_field' => 'profile_id'),
        array('heading' => HEADING_PROFILE_EMAIL_TYPE, 'sort_field' => 'type'),
        array('heading' => HEADING_PROFILE_EMAIL_SUBJECT, 'sort_field' => 'subject', 'width' => '75%')
      );
    }

    function tableDataRowContents($array)
    {
      switch($array['type']) {
        case 'INVOICE':
          $emailType = $this->image(DIR_WS_ABX_ICONS . 'invoice_email.gif',TEXT_POSITIVE,'16','16');
          break;
        case 'REMINDER':
          $emailType = $this->image(DIR_WS_ABX_ICONS . 'reminder.gif',TEXT_REMINDER,'16','16');
          break;
        case 'WARNING':
          $emailType = $this->image(DIR_WS_ABX_ICONS . 'warning_email.gif',TEXT_WARNING,'16','16');
          break;
      }
	  
	  $profile_label = abxProfilesEmail::getProfileNameByEmailTemplateId($array['id']);

      return '<td>' . $this->cell($profile_label) . '</td>'.
             '<td align="center">' . $this->cell($emailType) . '</td>'.
             '<td>' . $this->cell($array['subject']) . '</td>';
    }

    function bulkActions()
    {
      return array(
        'DeleteItems' => array('icon'=>'delete.gif','alt'=>ACTION_DELETE,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_DELETE."','".TEXT_EMAIL_TEMPLATES."','DeleteEmailTemplatesConfirm');"),
      );
    }

    function singleActions($array = array())
    {
      $profile_id = (isset($_GET['profile_id']) && !empty($_GET['profile_id'])) ? '&profile_id=' . $_GET['profile_id'] : '';

      return array(
        'edit' => array('icon'=>'edit.gif','alt'=>ACTION_EDIT,'url'=>abx_href_link(FILENAME_AUCTIONBLOX, 'abx=profiles-email-edit&oID=' . $array['id'] . $profile_id . abxPage::getSearchParams())),
        'copy' => array('icon'=>'copy.gif','alt'=>ACTION_COPY,'url'=>abx_href_link(FILENAME_AUCTIONBLOX, 'abx=profiles-email-copy&oID=' . $array['id'] . $profile_id . abxPage::getSearchParams()))
      );
    }

    function tableDataFooter()
    {
      return '<div align="right">' . $this->navigation(TEXT_CREATE_EMAIL_TEMPLATE,'profiles-email-new') . '</div>';
    }

    function infoBox($action)
    { 	
      global $abx;

      switch($action) {
        default:
          switch(implode('-', $abx)) {

          case 'profiles-email-copy':
          case 'profiles-email-edit':
            return $this->emailTemplateForm($_GET['oID']);
            break;

          case 'profiles-email-new':
            return $this->emailTemplateForm();
            break;
          }

          break;
      }
    }

    function emailTemplateForm($id = null)
    {
      global $abxDatabase, $abx;

      $eBaySellerProfilesIDs = abxConstants::getProfilesDropDown();

      if ($id) {
        $emailTemplate = abxProfilesEmail::getTemplateById($id);

        $perform    = implode('-', $abx) == 'profiles-email-edit' ? 'updateEmailTemplate' : 'insertEmailTemplate';
        $subject    = $emailTemplate['subject'];
        $body       = $emailTemplate['body'];
        $invoice    = $emailTemplate['type'] == 'INVOICE' ? true : false;
        $reminder   = $emailTemplate['type'] == 'REMINDER' ? true : false;
        $warning    = $emailTemplate['type'] == 'WARNING' ? true : false;
        $profile_id = $emailTemplate['profileId'];

      } else {

        $perform    = 'insertEmailTemplate';
        $subject    = '';
        $body       = '';
        $invoice    = true;
        $reminder   = false;
        $warning    = false;
        $profile_id = '';

      }

      $edit_disabled = (current($abx) == 'edit') ? 'readonly="1"' : '';

      $heading = array();

      $contents = array();

      $heading[] = array('text' => '<b>' . 'Create Email Template' . '</b>');

      $str = '<table border="0" width="790" cellspacing="0" cellpadding="0" class="tableForm">' .
             '  <tr>' .
             '    <td nowrap>' . TEXT_PROFILE . '&nbsp;&nbsp;' . $this->select('profile_id', $eBaySellerProfilesIDs, $profile_id, $edit_disabled) . '</td>'.
             '    <td align="right">' . $this->imageButton(DIR_WS_ABX_ICONS . 'contents.gif', TEXT_HELP_TOKENS, '16', '16',"openWindow('".abx_href_link(FILENAME_AUCTIONBLOX, 'abx=help-tokens')."');") . '</td>' .
             '  </tr>' .
             '  <tr>' .
             '    <td nowrap colspan="2">' . TEXT_TYPE . '&nbsp;&nbsp;' . $this->radio('type', 'INVOICE', $edit_disabled, $invoice). TEXT_INVOICE . '&nbsp;&nbsp;' . $this->radio('type', 'REMINDER', $edit_disabled, $reminder) . '&nbsp;' . TEXT_REMINDER . '&nbsp;&nbsp;' . $this->radio('type', 'WARNING', $edit_disabled, $warning) . '&nbsp;' . TEXT_WARNING . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td style="padding-top: 10px;">' . '<b>' . TEXT_SUBJECT . '&nbsp;&nbsp;' . $this->input('subject', $subject, 'size="100" maxlength="150"'). '</b>' . '</td>'.
             '    <td align="right">' . $this->imageButton(DIR_WS_ABX_ICONS . 'htmleditor.gif',TEXT_HTML_EDITOR,'16','16',"loadHTMLAREA('confirm',document.forms['confirm'].body.value,'body');") . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td colspan="2">' . $this->textarea('body', 'soft', 125, 5, $body) .'</td>'.
             '  </tr>' .
             '</table>';

      $contents[] = array('text' =>  $str);

      $contents[] = array('align' => 'center', 'text' => '<div style="padding: 5px;">' . $this->submit(TEXT_SUBMIT,'this.form',$perform). '&nbsp;' . $this->cancel('profiles-email') . '<div>' );

      $form = $this->form("confirm", FILENAME_AUCTIONBLOX,'abx=profiles-email');

      $form .= $this->hidden('perform',$perform);

      $form .= $this->infoBoxDisplay($heading, $contents);

      if ($id && implode("-",$abx) == 'profiles-email-edit') {
        $form .= $this->hidden('oID', $id);
      }

      $form .= '</form>';

      return $form;
    }

  }//end class
?>