<?php
/*
  $Id: abx_profiles_feedback.php,v 1.7 2007/01/03 02:00:13 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  require_once(DIR_FS_ABX_CLASSES.'abxPaginatorProfiles.php');
  
  class abxPaginator_Abx_Profiles_Feedback extends abxPaginatorProfiles {

    var
      $sMethod = 'profile.getFeedbackTemplates';

    function filterTerms() {
      return array();
    }

    function searchTerms() {
      return array();
    }

    function tableDataHeadings() {
      return array(
        array('heading' => THEADING_PROFILE, 'sort_field' => 'profile_id'),
        array('heading' => THEADING_TYPE, 'sort_field' => 'type'),
        array('heading' => THEADING_FEEDBACK, 'width' => '75%')
      );
    }

    function tableDataRowContents($array) {

      switch($array['type']) {
        case '+':
          $feedbackType = $this->image(DIR_WS_ABX_ICONS . 'feedback_pos.gif',TEXT_POSITIVE,'16','16');
          break;
        case 'N':
          $feedbackType = $this->image(DIR_WS_ABX_ICONS . 'feedback_neu.gif',TEXT_NEUTRAL,'16','16');
          break;
        case '-':
          $feedbackType = $this->image(DIR_WS_ABX_ICONS . 'feedback_neg.gif',TEXT_NEGATIVE,'16','16');
          break;
      }

	  $profile_label = abxProfilesFeedback::getProfileNameByFeedbackTemplateId($array['id']);

      return '<td>' . $this->cell($profile_label) . '</td>'.
             '<td align="center">' . $this->cell($feedbackType) . '</td>'.
             '<td>' . $this->cellWrap($array['text']) . '</td>';
    }

    function bulkActions() {
      return array(
        'DeleteItems' => array('icon'=>'delete.gif','alt'=>ACTION_DELETE,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_DELETE."','".TEXT_FEEDBACK_TEMPLATES."','DeleteFeedbackTemplatesConfirm');"),
      );
    }

    function singleActions($array = array()) {
      $profile_id = (isset($_GET['profile_id']) && !empty($_GET['profile_id'])) ? '&profile_id=' . $_GET['profile_id'] : '';

      return array(
        'edit' => array('icon'=>'edit.gif','alt'=>ACTION_EDIT,'url'=>abx_href_link(FILENAME_AUCTIONBLOX, 'abx=profiles-feedback-edit&oID=' . $array['id'] . $profile_id.abxPage::getSearchParams())),
        'copy' => array('icon'=>'copy.gif','alt'=>ACTION_COPY,'url'=>abx_href_link(FILENAME_AUCTIONBLOX, 'abx=profiles-feedback-copy&oID=' . $array['id'] . $profile_id.abxPage::getSearchParams()))
      );
    }

    function tableDataFooter() {
      return '<div align="right">' . $this->navigation(TEXT_CREATE_FEEDBACK_TEMPLATE,'profiles-feedback-new') . '</div>';
    }

    function infoBox($action)
    { 	
      global $abx;

      switch($action) {
        default:
          switch(implode('-', $abx)) {

          case 'profiles-feedback-copy':
          case 'profiles-feedback-edit':
            return $this->feedbackTemplateForm($_GET['oID']);
            break;

          case 'profiles-feedback-new':
            return $this->feedbackTemplateForm();
            break;
          }

          break;
      }
    }


    function feedbackTemplateForm($id = null) {
      global $abxDatabase, $abx;

      $eBaySellerProfilesIDs = abxConstants::getProfilesDropDown();

      if ($id) {
        $template = abxProfilesFeedback::getTemplateById($id);

        $perform = 'insertFeedbackTemplate';
        if (implode('-', $abx) == 'profiles-feedback-edit') {
          $perform  = 'updateFeedbackTemplate';
        }

        $positive = $template['type'] == '+' ? true : false;
        $neutral  = $template['type'] == 'N' ? true : false;
        $negative = $template['type'] == '-' ? true : false;

      } else {

        $template = array();
        $perform  = 'insertFeedbackTemplate';
        $positive = true;
        $neutral  = false;
        $negative = false;

      }


      $heading = array();

      $contents = array();

      $heading[] = array('text' => '<b>' . TEXT_CREATE_FEEDBACK_TEMPLATE . '</b>');

      $str = '<table border="0" cellspacing="2" cellpadding="5" style="width: 580px; margin: 10px;">' .
             '  <tr>' .
             '    <td>' . TEXT_PROFILE . '&nbsp;&nbsp;' . $this->select('profile_id', $eBaySellerProfilesIDs, @$template['profile_id']) . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . TEXT_FEEDBACK . '&nbsp;&nbsp;' . $this->radio('type', '+', '', $positive). TEXT_POSITIVE . '&nbsp;&nbsp;' . $this->radio('type', 'N', '', $neutral) . '&nbsp;' . TEXT_NEUTRAL . '&nbsp;&nbsp;' . $this->radio('type', '-', '', $negative) . '&nbsp;' . TEXT_NEGATIVE . '</td>'.
             '  </tr>' .
             '  <tr>' .
             '    <td>' . TEXT_FEEDBACK_TEXT . '&nbsp;&nbsp;' . $this->input('text', @$template['text'], 'id="feedback"  maxlength="255" size="64"') . '</td>' .
             '  </tr>' .
             '</table>';

      $contents[] = array('text' =>  $str);

      $contents[] = array('align' => 'center', 'text' => '<div style="padding: 5px;">' . $this->submit('Submit','this.form',$perform). '&nbsp;' . $this->cancel('profiles-feedback') . '<div>' );

      $form = $this->form("confirm", FILENAME_AUCTIONBLOX,'abx=profiles-feedback');

      $form .= $this->hidden('perform','null');

      $form .= $this->infoBoxDisplay($heading, $contents);

      if($id && current($abx) == 'edit') {
        $form .= $this->hidden('oID', $id);
      }

      $form .= '</form>';

      return $form;
    }

  }//end class
?>