<?php
/*
  $Id: category_generator.php,v 1.4 2008/03/31 18:19:41 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Category_Mapper extends abxCollatedPaginator {

    function filterTerms()
    {
      static $filterTerms;

      if(isset($filterTerms) === false) {

        $filterTerms = array(
          'values' => abx_get_category_tree()
        );

      }

      return $filterTerms;
    }

    function sortDefaultArray()
    {
      return array();
    }

    function countSellerIDs()
    {
      return 0;
    }

    function searchTerms()
    {
      return array(
        array('id'=>"cd.categories_name",'text'=>'SEARCH_LIST_1'),
        array('id'=>"ebay_category1_id",'text'=>'EBAY_CAT_1'),
        array('id'=>"ebay_category2_id",'text'=>'EBAY_CAT_2'),
        array('id'=>"ebay_shop_category1_id",'text'=>'EBAY_STORE_CAT_1'),
        array('id'=>"ebay_shop_category2_id",'text'=>'EBAY_STORE_CAT_2')
      );
    }

    function tableDataHeadings()
    {
      return array(
                array('heading' => TABLE_HEADING_DELETE),
        array('heading' => TABLE_HEADING_SHOP_CATEGORY, 'sort_field' => 'categories_name'),
        array('heading' => TABLE_HEADING_EBAY_CATEGORY_1),
        array('heading' => TABLE_HEADING_EBAY_CATEGORY_2),
        array('heading' => TABLE_HEADING_EBAY_STORE_CATEGORY_1),
        array('heading' => TABLE_HEADING_EBAY_STORE_CATEGORY_2)
//        array('heading' => TABLE_HEADING_STATUS, 'align' => 'center', 'sort_field' => 'is_enabled')
      );
    }

    function tableDataRowContents($array)
    {
      $str = '';
            
      $categories_id = $array['categories_id'];
      
      if (isset($array['childRecords']) && sizeof($array['childRecords']) > 0)
        $str .= '<td align="right">' .$this->cell($this->checkbox('ebay_categories[' . $categories_id . '][deletebox]','','',false)) . '</td>';
      else
        $str .= '<td align="right">' .$this->cell('&nbsp;') . '</td>';
      
      $str .= '<td>' . $this->cellWrap($array['categories_name'], 150) . '</td>';
      $str .= '<td align="right">' . $this->cell( $this->input('ebay_categories[' . $categories_id . '][ebay_category1_id]', $array['childRecords'][0]['ebay_category1_id'] , 'id="ebay_category1_id_'. $array['categories_id'] .'" size="20" maxlength="32"') .     $this->imageButton(DIR_WS_ABX_ICONS . 'search.gif', TEXT_CATEGORY_FIND, '16', '16', "selectcat(document.forms['abxPaginator'],'ebay_category1_id_" . $array['categories_id'] ."');")                 )  . '</td>';
      $str .= '<td align="right">' . $this->cell( $this->input('ebay_categories[' . $categories_id . '][ebay_category2_id]', $array['childRecords'][0]['ebay_category2_id'], 'id="ebay_category2_id_'. $array['categories_id'] .'" size="20" maxlength="32"') .  $this->imageButton(DIR_WS_ABX_ICONS . 'search.gif', TEXT_CATEGORY_FIND, '16', '16', "selectcat(document.forms['abxPaginator'],'ebay_category2_id_" . $array['categories_id'] ."');")                 )  . '</td>';

//        $str .= '<td align="right">' . $this->cell( $this->select('ebay_categories[][ebay_shop_category1_id]' , abxCatalogService::getEBayStoreCategories(), $array['ebay_shop_category1_id'])) . '</td>';
      $str .= '<td align="right">' . $this->cell( $this->select('ebay_categories[' . $categories_id . '][ebay_shop_category1_id]' , abxCatalogService::getEbayStoreCategories_nomacro(), $array['childRecords'][0]['ebay_shop_category1_id'])) . '</td>';
      $str .= '<td align="right">' . $this->cell( $this->select('ebay_categories[' . $categories_id . '][ebay_shop_category2_id]' , abxCatalogService::getEbayStoreCategories_nomacro(), $array['childRecords'][0]['ebay_shop_category2_id'])) . '</td>';
 
      $str .= abx_draw_hidden_field('ebay_categories[' . $categories_id . '][cat_id]', $categories_id);

      if (isset($array['childRecords']) && sizeof($array['childRecords']) > 0) {
        $str .= abx_draw_hidden_field('ebay_categories_hidden[' . $categories_id . '][ebay_category1_id]', $array['childRecords'][0]['ebay_category1_id']);
        $str .= abx_draw_hidden_field('ebay_categories_hidden[' . $categories_id . '][ebay_category2_id]', $array['childRecords'][0]['ebay_category2_id']);
        $str .= abx_draw_hidden_field('ebay_categories_hidden[' . $categories_id . '][ebay_shop_category1_id]', $array['childRecords'][0]['ebay_shop_category1_id']);
        $str .= abx_draw_hidden_field('ebay_categories_hidden[' . $categories_id . '][ebay_shop_category2_id]', $array['childRecords'][0]['ebay_shop_category2_id']);
      }

      /* set up the hidden fields so we can see which lines were changed if they save it */
      /* this way we don't have to write every line or set flags with javascript */

      return $str;
    }

    function tableDataSubHeader() {
      $this->category_vars['site'] = $_SESSION['category_vars_site'];
    
      $str = $this->form('site_change', FILENAME_AUCTIONBLOX, $this->getSearchParams(array('oID'),array('abx'),'')) . '<input type="hidden" name="perform" value="">';
      $str .= abx_draw_hidden_field('site_change_var', '0');
      $str .= '<div align="left"><label>' . TEXT_ENTRY_SITE .
              '<span  style="font-family:verdana;font-size: 18px;font-weight: bold;text-align: left;white-space: nowrap;color: #ee0000;">*</span></label>' .
								  $this->select('site', abxConstants::getSites(), $this->category_vars['site'], 'onchange="submit_form(document.forms[\'site_change\'],\'site_change_var\',\'category_mapper\');"') .'</div>';
      $str .= '</form>';                                  

      return $str;
    }
    
    function bulkActions()
    {
      return array(); 
    }

    function drawExtraHiddenFields()
    {
      $category_vars['site'] = $_SESSION['category_vars_site'];
      $str = abx_draw_hidden_field('site', $category_vars['site']);  // used for the select cat javascript form['site']

      $str .= '<div align="right">' . $this->submit(TEXT_CATEGORY_MAPPER_SAVE,'this.form','save') . '</div>';
      return $str;
    }

  }//end class
  ?>