<?php
/*
  $Id: items_product_search.php,v 1.1 2005/04/11 01:07:13 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Items_Product_Search extends abxPaginator {

    var $max_display_results = MAX_ABX_DISPLAY_SEARCH_PRODUCT_ITEMT_RESULTS;

    function filterTerms()
    {
      static $filterTerms;

      if(isset($filterTerms) === false)
        $filterTerms = array(
          //'name' => 'pd.products_id',
          'values' => abx_get_category_tree()
        );

      return $filterTerms;
    }

    function sortDefaultArray()
    {
      return array(
        'name' => 'pd.products_name',
        'value' => 'desc'
      );
    }

    function countSellerIDs()
    {
      return 0;
    }

    function searchTerms()
    {
      return array(
        array('id'=>"pd.products_name",'text'=>'SEARCH_LIST_1'),
        array('id'=>"p.products_model",'text'=>'SEARCH_LIST_2'),
        array('id'=>"p.products_price",'text'=>'SEARCH_LIST_3'),
        array('id'=>"p.products_last_modified",'text'=>'SEARCH_LIST_4')
      );
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => TABLE_HEADING_SELECT, 'align' => 'center'),
        array('heading' => TABLE_HEADING_PRODUCT_TITLE, 'sort_field' => 'pd.products_name'),
        array('heading' => TABLE_HEADING_PRODUCT_MODEL, 'sort_field' => 'p.products_model'),
        array('heading' => TABLE_HEADING_PRODUCTS_PRICE, 'sort_field' => 'p.products_price'),
        array('heading' => TABLE_HEADING_PRODUCTS_QTY_AVAILABLE, 'sort_field' => 'p.products_quantity'),
        array('heading' => TABLE_HEADING_DOMESTIC_SHIPPING, 'sort_field' => 'pfs.shipping'),
        array('heading' => TABLE_HEADING_DOMESTIC_SHIPPING_ADDL, 'sort_field' => 'pfs.shipping_addl'),
        array('heading' => TABLE_HEADING_PRODUCTS_LAST_MODIFIED, 'sort_field' => 'p.products_last_modified')
      );
    }

    function tableDataRowContents($array)
    {
      global $currencies;

      return '<td align="center">' . $this->radio('abxList[]',$array['id']) . '</td>'.
             '<td>' . $this->hidden('products_name_'.$array['id'],$array['products_name']) . $this->cell($array['products_name']) . '</td>'.
             '<td>' . $this->cell($array['products_model']) . '</td>'.
             '<td align="right">' . $this->cell($currencies->format($array['products_price'])) . '</td>'.
             '<td align="right">' . $this->cell($array['products_quantity']) . '</td>'.
             '<td align="right">' . $this->cell($currencies->format($array['shipping'])) . '</td>'.
             '<td align="right">' . $this->cell($currencies->format($array['shipping_addl'])) . '</td>'.
             '<td align="right">' . $this->cellWrapDate(abx_short_date($array['products_last_modified'])) . '</td>';
    }

    function tableDataFooter()
    {
      return '<div align="right">' . $this->button(TEXT_SUBMIT,"setProduct('" . addslashes($_GET['form']) . "','" . addslashes($_GET['pID']) . "','" . addslashes($_GET['pName']) . "','" . addslashes(JAVASCRIPT_ERROR_MSG_SELECT_ONE_PRODUCT) . "')") . '&nbsp;&nbsp;' . $this->button(TEXT_CANCEL,'window.close();return(false);','','aquaButton') . '&nbsp;&nbsp;' . $this->button(ABX_TEXT_NONE,"setEmptyProduct('".addslashes(ABX_TEXT_NO_PRODUCT_SELECTED)."','" . addslashes($_GET['form']) . "','" . addslashes($_GET['pID']) . "','" . addslashes($_GET['pName']) . "')",'','greenButton') . '</div><hr class="solid">';
    }

    function &paginatorQuery($query)
    {
      $this->query = & new abxPaginatorQuery($_GET['page'],$this->max_display_results,$query, $this->sortDefaultArray(), $this->sortArray(), $this->searchArray(), $this->filterTerms(), $this->filterBy(), $this->sellerID());

      return $this->query;
    }

    function drawSearchForm($filename, $searchterms)
    {
      foreach($searchterms as $key => $val)
        $searchList[] = array('id' => $val['id'], 'text' => @constant($val['text']));

      $str = $this->form('search', $filename, '', 'GET') . $this->hidden('abx',$_GET['abx']) . $this->hidden('form',$_GET['form']) . $this->hidden('pID',$_GET['pID']) . $this->hidden('pName',$_GET['pName']) . HEADING_SEARCH_TERM . '&nbsp;' . $this->input('searchvalue','','size="26" maxlength="64"') . '&nbsp;' . HEADING_SEARCH_FIELD . '&nbsp;' . $this->select('searchname', $searchList, $_GET['searchname']) . '&nbsp;';

      if ($this->countFilterTerms() > 0 || $this->countSellerIDs() > 0) {

        if ($this->countSellerIDs() > 0) {
          $str .= $this->hidden('seller_id','null');
          $seller_id_onclick = 'this.form.seller_id.value = document.forms[\'seller_filter\'].seller_id[document.forms[\'seller_filter\'].seller_id.selectedIndex].value;';
        }

        if ($this->countFilterTerms() > 0) {
          $str .= $this->hidden('filter','null');
          $filter_onclick = 'this.form.filter.value = document.forms[\'search_filter\'].filter[document.forms[\'search_filter\'].filter.selectedIndex].value;';
        }

        $str .= $this->button(IMAGE_SEARCH,$filter_onclick.$seller_id_onclick.' if (this.form.searchvalue.value != \'\') { this.form.submit(); }');

      } else {

        $str .= $this->submit(IMAGE_SEARCH,'this.form');

      }

      $str .= '&nbsp;' . $this->submit(TEXT_RESET_SEARCH,'','',$_GET['abx'],'','aquaButton');

      $str .= $this->hidden('form',$_GET['form']).$this->hidden('pID',$_GET['pID']).$this->hidden('pName',$_GET['pName']);

      $str .= '</form>';

      return $str;
    }

  }//end class
?>