<?php
/*
  $Id: items_uploads.php,v 1.2 2005/05/27 14:53:40 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxPaginator_Items_Uploads extends abxPaginator {

    function filterTerms()
    {
      static $filterTerms;

      if (isset($filterTerms) === false) {

        $array = array(
          array('id' => 'PENDING', 'text' => 'Pending'),
          array('id' => 'HISTORY', 'text' => 'History')
        );

        $filterTerms = array(
          'values' => $array
        );

      }

      return $filterTerms;
    }

    function sortDefaultArray()
    {
      return array(
        'name' => 'id',
        'value' => 'desc'
      );
    }

    function searchTerms()
    {
      return array(
        array('id'=>"title",'text'=>'SEARCH_LIST_1'),
        array('id'=>"listing_type",'text'=>'SEARCH_LIST_2'),
        array('id'=>"duration",'text'=>'SEARCH_LIST_3'),
        array('id'=>"price",'text'=>'SEARCH_LIST_4'),
        array('id'=>"quantity",'text'=>'SEARCH_LIST_5'),
        array('id'=>"last_modified",'text'=>'SEARCH_LIST_6')
      );
    }

    function drawExtraHiddenFields()
    {
      return '<input type="hidden" name="abx_last" value="uploads">';
    }

    function tableDataHeadings()
    {
      return array(
        array('heading' => TH_UPLOADS_TITLE, 'sort_field' => 'title'),
        array('heading' => TH_UPLOADS_TYPE, 'sort_field' => 'listing_type'),
        array('heading' => TH_UPLOADS_DURATION, 'sort_field' => 'duration'),
        array('heading' => TH_UPLOADS_PRICE, 'sort_field' => 'price'),
        array('heading' => TH_UPLOADS_QTY, 'sort_field' => 'quantity'),
        array('heading' => TH_UPLOADS_TIME_START, 'sort_field' => 'scheduled_start'),
        array('heading' => TH_UPLOADS_DATE_ADDED, 'sort_field' => 'date_added')
      );
    }

    function tableDataRowContents($array)
    {
      global $currencies;

      $listingTypes = abxConstants::getListingTypesShort();

      $scheduled_start = gmt_date_to_local_timestamp($array['scheduled_start']) === false ? 'ASAP' : gmt_date_to_local_pretty_format($array['scheduled_start']);

      return '<td>' . $this->cellWrap($array['title']) . '</td>'.
             '<td>' . $this->cell($listingTypes[$array['listing_type']]) . '</td>'.
             '<td align="right">' . $this->cell($array['duration']) . '</td>'.
             '<td align="right">' . $this->cell($currencies->format($array['price'])) . '</td>'.
             '<td align="right">' . $this->cell($array['quantity']) . '</td>'.
             '<td align="right">' . $this->cellWrapDate($scheduled_start) . '</td>'.
             '<td align="right">' . $this->cellWrapDate(gmt_date_to_local_pretty_format($array['date_added'])) . '</td>';
    }

    function bulkActions()
    {
      return array(
        'DeleteItems' => array('icon'=>'delete.gif','alt'=>ACTION_DELETE,'onclick' => "confirmBulkAction('".JAVASCRIPT_CONFIRM_DELETE."','".TEXT_ITEMS."','DeleteConfirm');"),
        'AddListingsFromUploadsManager' => array('icon'=>'uploads.gif','alt'=>ACTION_UPLOAD,'action'=>'scheduler')
      );
    }

  }//end class
?>