<?php
/*
  $Id: install.php,v 1.13 2008/08/13 19:06:09 auctionblox Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2005 AuctionBlox

  Portions Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

  function abx_db_tables() {
    return 'abx_api_queue,abx_basket,abx_configuration,abx_feedback_state,abx_fixed_shipping,abx_houses,abx_items,abx_listings,abx_schedule_info,abx_seller_info,abx_sites,abx_uploads,abx_winners,abx_workflow_state';
  }

  function abx_db_upgrade($error_reporting = false)
  {
    global $abxDatabase;

    $abxDatabase->setErrorReporting($error_reporting);

    if (defined('TABLE_PRODUCTS_FIXED_SHIPPING') == false)
      define('TABLE_PRODUCTS_FIXED_SHIPPING', 'products_fixed_shipping');

    $Query = $abxDatabase->query('select * from ' . TABLE_PRODUCTS_FIXED_SHIPPING . ' order by products_id');

    $keys = array(
      'products_id',
      'is_enabled',
    );

    $abxDatabase->delete(TABLE_ABX_FIXED_SHIPPING);

    while($data = $Query->next()) {

      $array                         = abxArray::setArray($keys,$data);
      $array['shipping']             = $data['domestic_shipping'];
      $array['shipping_addl']        = $data['domestic_shipping_addl'];
      $array['shipping_global']      = $data['global_shipping'];
      $array['shipping_global_addl'] = $data['global_shipping_addl'];

      $abxDatabase->insert(TABLE_ABX_FIXED_SHIPPING,$array);

    }

    unset($Query,$data);

    if (defined('TABLE_AUCTION_WINNERS') == false)
      define('TABLE_AUCTION_WINNERS', 'auction_winners');

    $Query = $abxDatabase->query('select * from ' . TABLE_AUCTION_WINNERS . ' order by auction_winner_id');

    $keys = array(
      'auction_winner_id',
      'ext_customer_id',
      'ext_email_address',
      'customers_id',
    );

    $abxDatabase->delete(TABLE_ABX_WINNERS);

    while($data = $Query->next()) {

      $array          = abxArray::setArray($keys,$data);
      $array['score'] = $data['ext_rating'];

      $abxDatabase->insert(TABLE_ABX_WINNERS,$array);

    }

    unset($Query,$data);

    if(defined('TABLE_AUCTION_ITEMS') == false)
      define('TABLE_AUCTION_ITEMS', 'auction_items');

    $Query = $abxDatabase->query('select * from ' . TABLE_AUCTION_ITEMS . ' order by auction_item_id');

    $keys = array(
      'auction_house_id',
      'site',
      'listing_type',
      'ext_id',
      'ext_title',
      'is_buy_it_now',
      'start_time',
      'end_time',
      'quantity',
      'quantity_sold',
      'currency',
      'start_price',
      'status',
      'version',
      'listing_fee'
    );

    $abxDatabase->delete(TABLE_ABX_LISTINGS);

    while($data = $Query->next()) {

      $array                  = abxArray::setArray($keys,$data);
      $array['id']            = $data['auction_item_id'];
      $array['uuid']          = md5(uniqid(rand(),true));
      $array['current_price'] = $data['end_price'];

      $abxDatabase->insert(TABLE_ABX_LISTINGS,$array);

    }

    unset($Query,$data);

    if(defined('TABLE_AUCTION_UPLOADS') == false)
      define('TABLE_AUCTION_UPLOADS', 'auction_uploads');

    $Query = $abxDatabase->query('select * from ' . TABLE_AUCTION_UPLOADS . ' order by id');

    $keys = array(
      'id',
      'uuid',
      'title',
      'listing_type',
      'site',
      'duration',
      'quantity',
      'price',
      'bin_price',
      'currency',
      'upload_status',
      'last_modified'
    );

    $abxDatabase->delete(TABLE_ABX_UPLOADS);

    while($data = $Query->next()) {

      $array                    = abxArray::setArray($keys,$data);
      $array['scheduled_start'] = $data['time_start'];

      $abxDatabase->insert(TABLE_ABX_UPLOADS,$array);

    }

    unset($Query,$data);

    if(defined('TABLE_AUCTION_BASKET') == false)
      define('TABLE_AUCTION_BASKET', 'auction_basket');

    $Query = $abxDatabase->query('select * from ' . TABLE_AUCTION_BASKET . ' order by auction_basket_id');

    $keys = array(
      'auction_basket_id',
      'auction_house_id',
      'site',
      'listing_type',
      'auction_item_id',
      'ext_id',
      'ext_key2',
      'auction_winner_id',
      'listing_status',
      'time_start',
      'time_end',
      'orders_id',
      'ext_title',
      'ext_desc',
      'quantity',
      'currency',
      'price_start',
      'price_end',
      'insurance',
      'insurance_option',
      'shipping',
      'shipping_type',
      'shipping_zip',
      'shipping_country',
      'sales_tax',
      'sales_tax_percent',
      'products_id',
      'feedback_left',
      'workflow_state',
      'workflow_state_change_date'
    );

    $abxDatabase->delete(TABLE_ABX_BASKET);

    while($data = $Query->next()) {

      $array         = abxArray::setArray($keys,$data);
      $array['uuid'] = md5(uniqid(rand(),true));

      $abxDatabase->insert(TABLE_ABX_BASKET,$array);

    }

    unset($Query,$data);

    if(defined('TABLE_AUCTION_LISTINGS') == false)
      define('TABLE_AUCTION_LISTINGS', 'auction_listings');

    $Query = $abxDatabase->query('select * from ' . TABLE_AUCTION_LISTINGS . ' order by id');

    $keys = array(
      'id',
      'title',
      'subtitle',
      'listing_type',
      'site',
      'city_state',
      'country',
      'region',
      'category1',
      'category2',
      'store_category',
      'duration',
      'quantity',
      'price',
      'bin_price',
      'reserve_price',
      'currency',
      'paypal_email',
      'payment_description',
      'sales_tax_state',
      'sales_tax_percent',
      'sales_tax_sandh',
      'shipping_type',
      'shipping_location',
      'shipping',
      'shipping_addl',
      'insurance_option',
      'insurance',
      'extra_private',
      'extra_bold',
      'extra_highlight',
      'extra_gallery',
      'extra_gallery_url',
      'extra_category_featured',
      'extra_homepage_featured',
      'counter',
      'products_id',
      'description',
      'last_modified',
      'picture1_url',
      'picture2_url',
      'picture3_url',
      'picture4_url',
      'picture5_url',
      'picture6_url',
      'picture7_url',
      'picture8_url'
    );

    while($data = $Query->next()) {

      $payment_methods = array();

      if ($data['paypal_accepted'] == 1)             $payment_methods[] = 'PP';
      if ($data['paypal_immediate_pay'] == 1)        $payment_methods[] = 'AP';
      if ($data['payment_mastercard_visa'] == 1)     $payment_methods[] = 'VM';
      if ($data['payment_cod'] == 1)                 $payment_methods[] = 'COD';
      if ($data['payment_amex'] == 1)                $payment_methods[] = 'AX';
      if ($data['payment_discover'] == 1)            $payment_methods[] = 'DI';
      if ($data['payment_moneyorder_cashiers'] == 1) $payment_methods[] = 'MO';
      if ($data['payment_check'] == 1)               $payment_methods[] = 'PC';
      if ($data['payment_other'] == 1)               $payment_methods[] = 'PO';

      $array                    = abxArray::setArray($keys,$data);
      $array['uuid']            = md5(uniqid(rand(),true));
      $array['payment_methods'] = implode(',',$payment_methods);

      $abxDatabase->insert(TABLE_ABX_ITEMS,$array);

    }

    $tables = abx_db_tables();
    $tables = explode(',',$tables);

    foreach($tables as $table)
      $abxDatabase->query('analyze table ' . $table);

    foreach($tables as $table)
      $abxDatabase->query('optimize table ' . $table);

  }

  function abx_remove_osc_configuration_keys()
  {
    global $abxDatabase;

    $keys = array(
      'AUCTIONBLOX_USERID',
      'AUCTIONBLOX_API_URL',
      'AUCTIONBLOX_CHECKOUT_LINK',
      'AUCTIONBLOX_UPLOAD_LINK',
      'AUCTIONBLOX_PASSCODE',
      'AUCTIONBLOX_POSITIVE_FEEDBACK_TEMPLATE',
      'AUCTIONBLOX_NEUTRAL_FEEDBACK_TEMPLATE',
      'AUCTIONBLOX_NEGATIVE_FEEDBACK_TEMPLATE',
      'NPB_ALERT_URL',
      'FINAL_VALUE_CREDIT_URL',
      'EBAY_COUNTRY_CODE',
      'SEND_WBN',
      'AUCTION_EMAIL_ADDRESS',
      'VAT_PERCENT',
      'STORE_TIME_ZONE',
      'EBAY_STORE_CATEGORIES',
      'MODULE_PAYMENT_PAYPALIPN_ID'
    );

    $abxDatabase->delete(TABLE_CONFIGURATION,"configuration_key in ('" . implode("','",$keys) . "')");
  }

  function abx_ppscipn_install($error_reporting = false)
  {
/*
    global $abxDatabase;

    $abxDatabase->setErrorReporting($error_reporting);

    $Qtable = $abxDatabase->query("show tables like '%paypal%'");

    $tables = array();
    while($result = $Qtable->next())
      foreach($result as $table)
        $tables["{$table}"] = 1;

    if (isset($tables[TABLE_PAYPAL_CHECKOUT]) === false) {

      $abxDatabase->query('create table ' . TABLE_PAYPAL_CHECKOUT . ' ( ' . ppscipn_paypal_checkout() .  ' )');

    }

    if (isset($tables[TABLE_PAYPAL]) === false) {

      $abxDatabase->query('create table ' . TABLE_PAYPAL . ' ( ' . ppscipn_paypal() .  ' )');

    } else {

      abx_copy_table(TABLE_PAYPAL,TABLE_PAYPAL.'_'.date('Ymdhis'));

      $abxDatabase->query('truncate table ' . TABLE_PAYPAL);

    }

    if(defined('TABLE_PAYPALIPN_TXN') == false)
      define('TABLE_PAYPALIPN_TXN', 'paypalipn_txn');

    if ($tables[TABLE_PAYPALIPN_TXN]) {

      $Query = $abxDatabase->query('select * from ' . TABLE_PAYPALIPN_TXN . ' order by paypalipn_txn_id');

      $keys = array (
        'txn_type',
        'payment_type',
        'payment_status',
        'pending_reason',
        'invoice',
        'mc_currency',
        'first_name',
        'last_name',
        'address_street',
        'address_city',
        'address_state',
        'address_zip',
        'address_country',
        'address_status',
        'payer_email',
        'payer_id',
        'payer_status',
        'business',
        'receiver_email',
        'txn_id',
        'num_cart_items',
        'mc_gross',
        'mc_fee',
        'payment_gross',
        'payment_fee',
        'settle_amount',
        'settle_currency',
        'exchange_rate',
        'for_auction',
        'auction_buyer_id',
        'auction_multi_item',
        'quantity',
        'tax',
        'notify_version',
        'verify_sign',
        'memo'
      );

      while($data = $Query->next()) {

        $array                      = abxArray::setArray($keys,$data);
        $array['paypal_id']         = $data['paypalipn_txn_id'];
        $array['payment_date']      = datetime_to_sql_format($data['payment_date']);
        $array['payment_time_zone'] = paymentTimeZone($data['payment_date']);
        $array['date_added']        = $array['payment_date'];

        $abxDatabase->insert(TABLE_PAYPAL,$array);
      }

    }//if $tables[TABLE_PAYPALIPN_TXN]

    if (isset($tables[TABLE_PAYPAL_PAYMENT_STATUS_HISTORY]) === false) {

      $abxDatabase->query('create table ' . TABLE_PAYPAL_PAYMENT_STATUS_HISTORY . ' ( ' . ppscipn_paypal_payment_status_history() .  ' )');

    } else {

      abx_copy_table(TABLE_PAYPAL_PAYMENT_STATUS_HISTORY,TABLE_PAYPAL_PAYMENT_STATUS_HISTORY.'_'.date('Ymdhis'));

      $abxDatabase->query('truncate table ' . TABLE_PAYPAL_PAYMENT_STATUS_HISTORY);

    }

    $Query = $abxDatabase->query('select paypal_id, payment_status, pending_reason, date_added  from ' . TABLE_PAYPAL . ' order by paypal_id');

    while($data = $Query->next()) {

      $keys = array(
        'paypal_id',
        'payment_status',
        'pending_reason',
        'date_added'
      );

      $array = abxArray::setArray($keys,$data);

      $abxDatabase->insert(TABLE_PAYPAL_PAYMENT_STATUS_HISTORY,$array);

    }

    if(defined('TABLE_PAYPAL_AUCTION') == false)
      define('TABLE_PAYPAL_AUCTION' ,'paypal_auction');

    if (isset($tables[TABLE_PAYPAL_AUCTION]) === false) {

      $abxDatabase->query('create table ' . TABLE_PAYPAL_AUCTION . ' ( ' . ppscipn_paypal_auction() .  ' )');

    } else {

      abx_copy_table(TABLE_PAYPAL_AUCTION,TABLE_PAYPAL_AUCTION.'_'.date('Ymdhis'));

      $abxDatabase->query('truncate table ' . TABLE_PAYPAL_AUCTION);

    }

    if(defined('TABLE_PAYPALIPN_AUCTION') == false)
      define('TABLE_PAYPALIPN_AUCTION' ,'paypalipn_auction');

    if ($tables[TABLE_PAYPALIPN_AUCTION]) {

      $Query = $abxDatabase->query('select *  from ' . TABLE_PAYPALIPN_AUCTION . ' order by paypalipn_txn_id');

      while($data = $Query->next()) {

        $keys = array(
          'item_number',
          'auction_buyer_id',
          'auction_multi_item',
          'auction_closing_date',
          'is_old'
        );

        $array              = abxArray::setArray($keys,$data);
        $array['paypal_id'] = $data['paypalipn_txn_id'];

        $abxDatabase->insert(TABLE_PAYPAL_AUCTION,$array);

        $abxDatabase->update(TABLE_PAYPAL,array('auction_buyer_id' => $array['auction_buyer_id']),'paypal_id = ' . $array['paypal_id']);

      }

    }//if $tables[TABLE_PAYPALIPN_AUCTION]

    $table = $abxDatabase->query("show columns from " . TABLE_ORDERS);

    $tableColumns = array();

    while($result = $table->next())
      $tableColumns[$result['Field']] = 1;

    if (isset($tableColumns['payment_id']) === false)
      $abxDatabase->query("alter table " . TABLE_ORDERS . " add payment_id int(11) default '0' not null");

    $table = $abxDatabase->query("show columns from " . TABLE_ORDERS_PRODUCTS_ATTRIBUTES);

    $tableColumns = array();

    while($result = $table->next())
      $tableColumns[$result['Field']] = 1;

    if (isset($tableColumns['products_options_id']) === false)
      $abxDatabase->query("alter table " . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . " add products_options_id int(11) default '0' not null");

    if (isset($tableColumns['products_options_values_id']) === false)
      $abxDatabase->query("alter table " . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . " add products_options_values_id int(11) default '0' not null");

    $abxDatabase->query('analyze table '.TABLE_PAYPAL);

    $abxDatabase->query('analyze table '.TABLE_PAYPAL_AUCTION);

    $abxDatabase->query('analyze table '.TABLE_PAYPAL_PAYMENT_STATUS_HISTORY);

    $abxDatabase->query('optimize table '.TABLE_PAYPAL);

    $abxDatabase->query('optimize table '.TABLE_PAYPAL_AUCTION);

    $abxDatabase->query('optimize table '.TABLE_PAYPAL_PAYMENT_STATUS_HISTORY);
*/
  }

  function ppscipn_paypal_checkout()
  {
    return "
      orders_id int(11) NOT NULL default '0',
      txn_signature varchar(32) NOT NULL default '',
      checkout_info text NOT NULL,
      PRIMARY KEY (orders_id),
      UNIQUE KEY txn_signature (txn_signature)
      ";
  }

  function ppscipn_paypal_payment_status_history()
  {
    return "
      payment_status_history_id int(11) NOT NULL auto_increment,
      paypal_id int(11) NOT NULL default '0',
      payment_status varchar(17) NOT NULL default '',
      pending_reason varchar(14) default NULL,
      reason_code varchar(15) default NULL,
      date_added datetime NOT NULL default '0000-00-00 00:00:00',
      PRIMARY KEY (payment_status_history_id),
      KEY paypal_id (paypal_id)
    ";
  }

  function ppscipn_paypal()
  {
    return "
      paypal_id int(11) unsigned NOT NULL auto_increment,
      txn_type varchar(10) NOT NULL default '',
      reason_code varchar(15) default NULL,
      payment_type varchar(7) NOT NULL default '',
      payment_status varchar(17) NOT NULL default '',
      pending_reason varchar(14) default NULL,
      invoice varchar(64) default NULL,
      mc_currency char(3) NOT NULL default '',
      first_name varchar(32) NOT NULL default '',
      last_name varchar(32) NOT NULL default '',
      payer_business_name varchar(64) default NULL,
      address_name varchar(32) default NULL,
      address_street varchar(64) default NULL,
      address_city varchar(32) default NULL,
      address_state varchar(32) default NULL,
      address_zip varchar(10) default NULL,
      address_country varchar(64) default NULL,
      address_status varchar(11) default NULL,
      payer_email varchar(96) NOT NULL default '',
      payer_id varchar(32) NOT NULL default '',
      payer_status varchar(10) NOT NULL default '',
      payment_date datetime default NULL,
      payment_time_zone char(4) NOT NULL default '',
      business varchar(96) NOT NULL default '',
      receiver_email varchar(96) NOT NULL default '',
      receiver_id varchar(32) NOT NULL default '',
      txn_id varchar(17) NOT NULL default '',
      parent_txn_id varchar(17) default NULL,
      num_cart_items tinyint(4) unsigned NOT NULL default '1',
      mc_gross decimal(7,2) NOT NULL default '0.00',
      mc_fee decimal(7,2) NOT NULL default '0.00',
      payment_gross decimal(7,2) default NULL,
      payment_fee decimal(7,2) default NULL,
      settle_amount decimal(7,2) default NULL,
      settle_currency char(3) default NULL,
      exchange_rate decimal(4,2) default NULL,
      for_auction varchar(5) NOT NULL default 'false',
      auction_buyer_id varchar(64) NOT NULL default '',
      auction_closing_date datetime NOT NULL default '0000-00-00 00:00:00',
      auction_multi_item tinyint(4) NOT NULL default '0',
      quantity int(11) NOT NULL default '',
      tax decimal(7,2) default NULL,
      notify_version decimal(2,1) NOT NULL default '0.0',
      verify_sign varchar(128) NOT NULL default '',
      last_modified datetime default NULL,
      date_added datetime default NULL,
      memo text,
      PRIMARY KEY  (paypal_id),
      UNIQUE KEY txn_id (txn_id),
      KEY parent_txn_id (parent_txn_id)
    ";
  }

  function ppscipn_paypal_auction()
  {
    return "
      paypal_id int(11) NOT NULL default '0',
      item_number varchar(96) NOT NULL default '',
      auction_buyer_id varchar(96) NOT NULL default '',
      auction_multi_item tinyint(4) NOT NULL default '0',
      auction_closing_date datetime NOT NULL default '0000-00-00 00:00:00',
      is_old int(1) NOT NULL default '0',
      PRIMARY KEY (paypal_id,item_number)
    ";
  }

  function abx_copy_table($tablename,$new_tablename)
  {
    global $abxDatabase;

    $table = $abxDatabase->fetch_row("show tables like '{$tablename}'");

    if(empty($table) === true)
      return;

    $table = $abxDatabase->fetch_row("show tables like '{$new_tablename}'");

    if(empty($table) === false)
      return;

    $tableInfo = array();

    $query = $abxDatabase->query("show fields from {$tablename}");

    while($query->next()) {

      $schema = $query->value('Field') . ' ' . $query->value('Type');

      $schema .= (strlen($query->value('Default')) > 0) ? ' default \'' . $query->value('Default') . '\'' : '';

      $schema .= ($query->value('Null') != 'YES')       ? ' not null' : '';

      $schema .= (strlen($query->value('Extra')) > 0)   ? ' ' . $query->value('Extra') : '';

      $tableInfo[] = $schema;

    }

    $tableIndexes = array();

    $query = $abxDatabase->query("show keys from {$tablename}");

    while ($query->next()) {

      $keyName = $query->value('Key_name');

      if (isset($tableIndexes[$keyName]) === false)
        $tableIndexes[$keyName] = array(
          'unique' => ($query->value('Non_unique') == '1') ? 0 : 1,
          'columns' => array()
        );

      $tableIndexes[$keyName]['columns'][] = $query->value('Column_name');
    }


    foreach($tableIndexes as $keyName => $keyInfo) {

      $keyColumns = implode($keyInfo['columns'], ', ');

      if ($keyName == 'PRIMARY')

        $tableInfo[] = 'PRIMARY KEY (' . $keyColumns . ')';

      elseif ($keyInfo['unique'])

        $tableInfo[] = 'UNIQUE ' . $keyName . ' (' . $keyColumns . ')';

      else

        $tableInfo[] = 'KEY ' . $keyName . ' (' . $keyColumns . ')';

    }

    $abxDatabase->query("create table {$new_tablename} (" . implode(",",$tableInfo) . ") type=MyISAM;");

    $abxDatabase->query("insert into {$new_tablename} select * from {$tablename}");
  }

  function datetime_to_sql_format($paypalDateTime)
  {
    $months = array('Jan' => '01', 'Feb' => '02', 'Mar' => '03', 'Apr' => '04', 'May' => '05',  'Jun' => '06',  'Jul' => '07', 'Aug' => '08', 'Sep' => '09', 'Oct' => '10', 'Nov' => '11', 'Dec' => '12');

    $array  = explode(" ",$paypalDateTime);

    $time   = explode(":",$array[0]);

    $hour   = $time[0];$minute = $time[1];$second = $time[2];

    $month  = $months[$array[1]];

    $day    = substr_replace($array[2],'',-1,1);

    $year   = $array[3];

    return ($year . "-" . $month . "-" . $day . " " . $hour . ":" . $minute . ":" . $second);
  }

  function paymentTimeZone($paypalDateTime)
  {
    $array = explode(" ",$paypalDateTime);

    return $array[4];
  }
?>