<?php
/*
  $Id: install.php,v 1.7 2008/04/02 18:47:54 devosc Exp $

  AuctionBlox, sell more, work less!
  http://www.auctionblox.com

  Copyright (c) 2004 AuctionBlox
*/

  class abxModule_Install extends abxModule {

    function abxModule_Install()
    {
      if (empty($_POST) === false)
        $this->process();
    }

    function process()
    {
      global $abxDatabase, $abxVersion;

      $error_reporting = false;

      switch($_POST['perform']) {
        case 'upgrade':
        	if (!isset($_POST['step'])){
                require_once(DIR_FS_ABX_CLASSES.'abxConfiguration.php');
      			if (abxConfiguration::upgrade($abxVersion)) {
	        		$_SESSION['abxConfig']['uptodate'] = true;
    	  		}
      			//determine if we are upgrading from a version of ABX prior to 4.7.0
      			if (version_compare($_SESSION['previousAbxVersion'], '4.7.0') < 0 && version_compare(AUCTIONBLOX_VERSION, '4.7.0') > -1){
      				$_POST['step'] = 'scrub470';
      			}
      			else{
      				$_POST['step'] = 'complete';
      			}
      		}
      		elseif ($_POST['step'] == 'scrub470'){
      			//the normal logic we would execute right here will be executed from the page so that we can periodically flush the
      			//output to keep the connection alive long enough to update all the records
      			$_POST['step'] = 'scrub470_complete';	
      		}
      		elseif ($_POST['step'] == 'scrub470_complete'){
      			//MMD - if there were updates to apply for the next release of ABX, we would insert another 'step' here.
      			$_POST['step'] = 'complete';	
      		}
        
        break;
        case 'install':

          require_once(DIR_FS_ABX_FUNCTIONS . 'install.php');

          if (!ini_get('safe_mode'))
            set_time_limit(0);

          $install = abx_db_install(DIR_FS_ABX_INCLUDES.'auctionblox.sql.php',abx_db_tables(),$error_reporting);

          switch($install['ErrorLevel']) {
            case '1':

              abxMessageStack::add_session($install['Message'],'error');

              abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX, '&abx=install'));

              break;

            case '0':

              if ($_POST['perform'] == 'upgrade') {

                abx_db_upgrade($error_reporting);

                abx_remove_osc_configuration_keys();

              }

              abx_ppscipn_install($error_reporting);

              if (empty($_POST['abx_email']) === false) {

                $sql_array = array(
                  'configuration_value' => $_POST['abx_email'],
                  'last_modified'       => 'now()'
                );

                $abxDatabase->update(TABLE_ABX_CONFIGURATION,$sql_array,"configuration_key='AUCTIONBLOX_USERID'");

              }

              if (empty($_POST['abx_passcode']) === false) {

                $sql_array = array(
                  'configuration_value' => $_POST['abx_passcode'],
                  'last_modified'       => 'now()'
                );

                $abxDatabase->update(TABLE_ABX_CONFIGURATION,$sql_array,"configuration_key='AUCTIONBLOX_PASSCODE'");

              }

              $configQuery = &$abxDatabase->query('select configuration_key as cfgKey, configuration_value as cfgValue from ' . TABLE_ABX_CONFIGURATION);

              while($configQuery->next())
                @define($configQuery->value('cfgKey'), $configQuery->value('cfgValue'));

              require_once(DIR_FS_ABX_CLASSES . 'abxAccount.php');

              if (abxAccount::configure()) {

                $seller = $abxDatabase->fetch_row('select seller_id, user_id from ' . TABLE_ABX_SELLER_INFO . ' limit 1');

                $abxDatabase->update(TABLE_ABX_BASKET,array('user_id' => $seller['user_id']));

                $abxDatabase->update(TABLE_ABX_LISTINGS,array('user_id' => $seller['user_id']));

                $abxDatabase->update(TABLE_ABX_ITEMS,array('seller_id' => $seller['seller_id']));

                abxMessageStack::add_session(TEXT_ACCOUNT_UPDATED_SUCCESSFULLY,'success');
                abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX, '&abx=install-new'));

              } else {

                //abxMessageStack::add_session('Account Not Configured','error');
                abxPage::redirect(abx_href_link(FILENAME_AUCTIONBLOX, '&abx=install-configure'));

              }

              break;
          }

          break;
      }
    }

    function display()
    {
      $page = new abxPage;
      $page->includeLanguageFile('abx_install');
      $page->setContentFile('abx_install');

      return $page;
    }

  }//end class
?>