<?php
/* */
  require_once (DIR_FS_ABX_CLASSES . 'API/abxSoapClient.php');
  
  class abxModule_Shippinginfo extends abxModule {

    function abxModule_Shippinginfo()
    {
      $this->process();
    }

    function process()
    {
    }
    
    function display(){
    	$site = $_GET['site'];

      // eBay does not return shipping info for ebay motors, but its the same for US
      // when the category is Parts & Accessories        
      if($site === 'EMO') $site = 'US';

    	if ($_GET['type'] == 'package_type'){
    		if (!isset($_SESSION['abx_shipping_package_types'][$site])){
    			$_SESSION['abx_shipping_package_types'][$site] = abxModule_Shippinginfo::getPackageTypes($site);
    		}
    		$typesArray = $_SESSION['abx_shipping_package_types'][$site];
    		echo "{
    			identifier: 'id', items: [";
    		for ($i = 0; $i < count($typesArray); $i++){
    			if ($i > 0){
    				echo ", ";
    			}
    			echo "{ id: '". $typesArray[$i]['name'] ."', name: '". $typesArray[$i]['description'] ."' }";
    		} 
    			
    		echo "]}";
    	}
    
    	if ($_GET['type'] == 'shipping_type'){
    		$sites_without_calc_shipping = array("UK", "AT", "BFR", "FR", "DE", "IT", "BNL", "NL", "ES", "CH");
    		$allow_calculated_shipping = true;
    		for ($i = 0; $i < count($sites_without_calc_shipping); $i++){
    			if ($site == $sites_without_calc_shipping[$i]){
    				$allow_calculated_shipping = false;
    			}
    		}
    		if ($allow_calculated_shipping){
    			echo "{
    				identifier: 'id',
    				items: [
        				{name: 'eBay Flat Shipping', id: 'F'},
        				{name: 'eBay Calculated Shipping', id: 'E'},
        				{name: 'Not Specified (Shipping will be calculated during checkout)', id: 'C'}
    					]
					}";
    		}
    		else{
    			echo "{
    				identifier: 'id',
    				items: [
        				{name: 'eBay Flat Shipping', id: 'F'},
        				{name: 'Not Specified (Shipping will be calculated during checkout)', id: 'C'}
    					]
					}";
    		}
    		    		
    	}
    	
    	if ($_GET['type'] == 'shipto'){
    		echo "{
    			identifier: 'id',
    			items: [
        			{name: 'Worldwide', id: 'Worldwide'},
        			{name: 'Custom', id: 'Custom'}
    				]
				}";    		
    	}
    	
    	if ($_GET['type'] == 'shipto_custom_locations'){
    		if ($_SESSION['abx_shipping_custom_locations'][$site] == null){
    			$_SESSION['abx_shipping_custom_locations'][$site] = abxModule_Shippinginfo::getCustomLocations($site);
    		}
    		$locationsArray = $_SESSION['abx_shipping_custom_locations'][$site];
    		echo "{
    			identifier: 'id', items: [";
    			
    		$count = 0;
    		for ($i = 0; $i < count($locationsArray); $i++){
    			if ($locationsArray[$i]['name'] != 'Worldwide' && $locationsArray[$i]['name'] != 'None'){
    				if ($count > 0){
    					echo ", ";
    				}
    				echo "{ id: '". $locationsArray[$i]['name'] ."', name: '". $locationsArray[$i]['description'] ."' }";
    				$count++;
    			}
    		} 
    			
    		echo "]}";
    		    		
    	}
    	
    	if ($_GET['type'] == 'dom_calc'){
    		$methods = abxModule_Shippinginfo::getShippingMethods($site, $_GET['package_type'], false, 'calculated');
    		abxModule_Shippinginfo::renderMethods($methods);
    	
    	}
    	
    	if ($_GET['type'] == 'dom_flat'){
    		$methods = abxModule_Shippinginfo::getShippingMethods($site, null, false, 'flat');
    		abxModule_Shippinginfo::renderMethods($methods);
    	}
    	
    	if ($_GET['type'] == 'int_calc'){
    		$methods = abxModule_Shippinginfo::getShippingMethods($site, $_GET['package_type'], true, 'calculated');
    		abxModule_Shippinginfo::renderMethods($methods);
    	}
    	
    	if ($_GET['type'] == 'int_flat'){
    		$methods = abxModule_Shippinginfo::getShippingMethods($site, null, true, 'flat');
    		abxModule_Shippinginfo::renderMethods($methods);
    	}
    }
    
    function getPackageTypes($site){
    	
    	$result = abxSoapClient::call('1.0/ebay/ShippingService', 'getAllShippingPackagesWithMethods', array('site' => $site));
    	return $result['shippingPackage'];
    	    	
    }	
    
    function getCustomLocations($site){
    	
    	$result = abxSoapClient::call('1.0/ebay/ShippingService', 'getShippingLocations', array('site' => $site));
    	return $result['shippingLocation'];
    	    	
    }
    
    function getAllShippingMethods($site){
    	$result = abxSoapClient::call('1.0/ebay/ShippingService', 'getAllShippingMethods', array('site' => $site));
    	return $result['shippingMethod'];
    }
    
    function getShippingMethods($site, $package_type, $international, $type){
    	
    	//first we make sure we have the data we need, if not we fail gracefully
    	if ($site == null || $site == '' || ($type == 'calculated' && ($package_type == null || $package_type == ''))){
    		return array();
    	}
    	
    	$package = null;
    	//determine if we need to filter based on the package
    	if ($type == 'calculated' && $package_type != null){
    		//next we get the package we need
    		if (!isset($_SESSION['abx_shipping_package_types'][$site])){
    			$_SESSION['abx_shipping_package_types'][$site] = abxModule_Shippinginfo::getPackageTypes($site);
    		}
    		$typesArray = $_SESSION['abx_shipping_package_types'][$site];
    		for ($i = 0; $i < count($typesArray); $i++){
    			if ($typesArray[$i]['name'] == $package_type){
    				$package = $typesArray[$i];
    			}
    		}
    	}
    	
    	//now we get the shipping methods array
    	if (!isset($_SESSION['abx_shipping_methods'][$site])){
    		$_SESSION['abx_shipping_methods'][$site] = abxModule_Shippinginfo::getAllShippingMethods($site);
    	}
    	$methodsArray = $_SESSION['abx_shipping_methods'][$site];
    	
    	//now we iterate through the methods filtering them based on the criteria for this request
    	$result = array();
    	for ($i = 0; $i < count($methodsArray); $i++){
    		$add_to_result = true;	
			if (($international && $methodsArray[$i]['international'] != 'true') || (!$international && $methodsArray[$i]['international'] == 'true')){
				$add_to_result = false;
			}
			//filter flat/calc services
			if ($methodsArray[$i][$type] != 'true'){
				$add_to_result = false;
			}
			// now, if we are doing calculated shipping we must filter by package
			if ($add_to_result && $type=="calculated" && $package != null){
				$method_valid_for_package = false;
				for ($j = 0; $j < count($package['method']); $j++){
					if ($methodsArray[$i]['name'] == $package['method'][$j]['name']){
						$method_valid_for_package = true;
					}
				}
				if (!$method_valid_for_package){
					$add_to_result = false;
				}
			}
			
			//now add to the result if we can
    		if ($add_to_result){
    			$result[] = $methodsArray[$i];
    		}
    	}
    	
    	return $result;
    }
    
    function renderMethods($methods){
    	echo "{
    		identifier: 'id', items: [" .
    				"{ id: '', name: 'None', dimensionsRequired: '0'}"; //add this option so we can reset gracefully
    			
    	for ($i = 0; $i < count($methods); $i++){
    		echo ", ";
    		echo "{ id: '". $methods[$i]['name'] ."', name: '". addslashes($methods[$i]['description']) ."', ";
			if ($methods[$i]['dimensionsRequired'] == 'true'){
				echo "dimensionsRequired: '1'";
			}
			else{
				echo "dimensionsRequired: '0'";
			}
			echo "}";
    		
    	} 
    			
    	echo "]}";
    }
       
  }//end class
?>
