<?php
#####################################################################################################
#
#					Module pour la plateforme de paiement Systempay
#						Version : 2.6b (rvision 25621)
#									########################
#					Dvelopp pour osCommerce
#						Version : 2.2ms2
#						Compatibilit plateforme : V1
#									########################
#					Dvelopp par Lyra Network
#						http://www.lyra-network.com/
#						01/06/2011
#						Contact : supportvad@lyra-network.com
#
#####################################################################################################

/**
 * Main class implementing OSC payment module API
 *
 */
class vads {
	/**
	 * @var string
	 */
	var $code;
	/**
	 * @var string
	 */
	var $title;
	/**
	 * @var string
	 */
	var $description;
	/**
	 * @var boolean
	 */
	var $enabled;
	/**
	 * @var int
	 */
	var $sort_order;
	/**
	 * @var string
	 */
	var $form_action_url;
	/**
	 * @var int
	 */
	var $order_status;

	/**
	 * Class constructor
	 */
	function vads() {
		global $order;

		// Initialize code
		$this->code = 'vads';
		
		// Initialize title
		$this->title = MODULE_PAYMENT_VADS_TITLE;
        $this->icon = DIR_WS_ICONS . 'spplus_50.gif'; //NBen je rajoute cette notion pour affichage logo SPPLUS
		
		// Initialize description
		$this->description  = '';
		$this->description .= '<b>'.MODULE_PAYMENT_VADS_MODULE_INFORMATION.'</b>';
		$this->description .= '<br/><br/>';
		$this->description .= MODULE_PAYMENT_VADS_DEVELOPED_BY.'<a href="http://www.lyra-network.com/" target="_blank">Lyra network</a>';
		$this->description .= '<br/><br/>';
		$this->description .= MODULE_PAYMENT_VADS_CONTACT_EMAIL.'<a href="mailto:supportvad@lyra-network.com">supportvad@lyra-network.com</a>';
		$this->description .= '<br/><br/>';
		$this->description .= MODULE_PAYMENT_VADS_CONTRIB_VERSION.'2.6b';
		$this->description .= '<br/><br/>';
		$this->description .= MODULE_PAYMENT_VADS_GATEWAY_VERSION.'V1';
		$this->description .= '<br/><br/>';
		$this->description .= MODULE_PAYMENT_VADS_CMS_VERSION.'osCommerce 2.2ms2';
		$this->description .= '<br/><br/>';
		$this->description .= MODULE_PAYMENT_VADS_SILENT_URL.HTTP_SERVER.DIR_WS_CATALOG.'checkout_process_vads.php';
		
		// Initialize enabled
		$this->enabled = (MODULE_PAYMENT_VADS_STATUS == 'True');

		// Initialize sort_order
		$this->sort_order = MODULE_PAYMENT_VADS_SORT_ORDER;
		
		$this->form_action_url = MODULE_PAYMENT_VADS_GATEWAY_URL;
		
		if ((int)MODULE_PAYMENT_VADS_ORDER_STATUS_ID > 0) {
			$this->order_status = MODULE_PAYMENT_VADS_ORDER_STATUS_ID;
		}

		/* If there's an order to treat, start preliminary payment zone check */
		if (is_object($order)){
			$this->update_status();
		}
	}

	/**
	 * Payment zone check
	 * @return null
	 */
	function update_status() {
		global $order;

		if ( $this->enabled && ((int)MODULE_PAYMENT_VADS_ZONE > 0) ) {
			$check_flag = false;
			$check_query = tep_db_query("SELECT zone_id FROM " . TABLE_ZONES_TO_GEO_ZONES .
										" WHERE geo_zone_id = '" . MODULE_PAYMENT_VADS_ZONE .
										"' AND zone_country_id = '" . $order->billing['country']['id'] .
										"' ORDER by zone_id ASC;");
			while ($check = tep_db_fetch_array($check_query)) {
				if ($check['zone_id'] < 1) {
					$check_flag = true;
					break;
				} elseif ($check['zone_id'] == $order->billing['zone_id']) {
					$check_flag = true;
					break;
				}
			}

			if (!$check_flag) {
				$this->enabled = false;
			}
		}
	}

	/**
	 * JS checks : we let the platform do all the validation itself
	 * @return false
	 */
	function javascript_validation() {
		return false;
	}

	/**
	 * Parameters for what the payment option will look like in the list
	 * @return array
	 */
	function selection() {
		return array('id' => $this->code,
                   'module' => $this->title, 'icon' => $this->icon);
	}

	/**
	 * Server-side checks after payment selection : We let the platform do all the validation itself
	 * @return false
	 */
	function pre_confirmation_check() {
		return false;
	}

	/**
	 * Server-size checks before payment confirmation :  We let the platform do all the validation itself
	 * @return false
	 */
	function confirmation() {
		return false;
	}

	/**
	 * Prepare the form that will be sent to the payment gateway
	 * @return string
	 */
	function process_button() {
		global $order, $languages_id;

		$available_langs = array('fr','de','en','es','zh','it','ja');

		$country = $order->customer['country']["iso_code_2"];
		// Get the language code
		$lang_query = tep_db_query("select code from " . TABLE_LANGUAGES . " where languages_id=".$languages_id);
		$lang_data = tep_db_fetch_array($lang_query);
		$lang_code = strtolower($lang_data['code']);
		$langage = in_array($lang_code,$available_langs) ? $lang_code : MODULE_PAYMENT_VADS_LANGUAGE;
		
		// Use our custom class to generate the html
		$vads_api = new VADS_API();
		$vads_api->set('platform_url',		MODULE_PAYMENT_VADS_GATEWAY_URL);
		$vads_api->set('version',			'V1');
		$vads_api->set('key_test',			MODULE_PAYMENT_VADS_KEY_TEST);
		$vads_api->set('key_prod',			MODULE_PAYMENT_VADS_KEY_PROD);
		$vads_api->set('amount', 			(round($order->info['total'],2)*100));
		$vads_api->set('capture_delay', 	MODULE_PAYMENT_VADS_DELAY);
		$vads_api->set('currency', 			MODULE_PAYMENT_VADS_CURRENCY);
		$vads_api->set('cust_email',		$order->customer['email_address']);
		$vads_api->set('ctx_mode',			MODULE_PAYMENT_VADS_MODE);
		$vads_api->set('payment_cards',		MODULE_PAYMENT_VADS_PAYMENT_CARDS);
		$vads_api->set('payment_config',	'SINGLE');
		$vads_api->set('site_id',			MODULE_PAYMENT_VADS_SITE_ID);
		$vads_api->set('validation_mode',	MODULE_PAYMENT_VADS_VALIDATION_MODE);
		$vads_api->set('cust_id',			session_id());
		$vads_api->set('cust_name',			$order->customer['firstname'].' '.$order->customer['lastname']);
		$vads_api->set('cust_address',		$order->customer['street_address']);
		$vads_api->set('cust_zip',			$order->customer['postcode']);
		$vads_api->set('cust_city',			$order->customer['city']);
		$vads_api->set('cust_country',		$country);
		$vads_api->set('language',			$langage);
		$vads_api->set('order_id',			$this->getIdOrder());
		$vads_api->set('url_return',		MODULE_PAYMENT_VADS_DEFAULT_URL);
		$vads_api->set('url_success',		MODULE_PAYMENT_VADS_SUCCESS_URL);
		$vads_api->set('contrib', 			'osCommerce2.2ms2_2.6b');
		$vads_api->set('redirect_enabled',	MODULE_PAYMENT_VADS_REDIRECT_ENABLED);
		$vads_api->set('redirect_success_timeout',MODULE_PAYMENT_VADS_REDIRECT_SUCCESS_TIMEOUT);
		$vads_api->set('redirect_success_message',utf8_encode(MODULE_PAYMENT_VADS_REDIRECT_SUCCESS_MESSAGE));
		$vads_api->set('redirect_error_timeout',MODULE_PAYMENT_VADS_REDIRECT_ERROR_TIMEOUT);
		$vads_api->set('redirect_error_message',utf8_encode(MODULE_PAYMENT_VADS_REDIRECT_ERROR_MESSAGE));
		$vads_api->set('return_mode',		MODULE_PAYMENT_VADS_RETURN_MODE);
		
		$process_button_string = $vads_api->getRequestHtmlInputs();

		return $process_button_string;
	}

	/**
	 * Verify client data after he returned from payment gateway
	 */
	function before_process()
	{
		$vad_api = new VADS_API();
		$vad_api->setResponseFromPost(
			$_REQUEST,
			MODULE_PAYMENT_VADS_KEY_TEST,
			MODULE_PAYMENT_VADS_KEY_PROD,
			MODULE_PAYMENT_VADS_MODE
		);
		
		$from_server = isset($_REQUEST['hash']);
		
		// Check authenticity
		if( !$vad_api->isAuthentifiedResponse() ) {
			if($from_server) {
				echo $vad_api->getCheckUrlResponse('auth_fail');
			}
			tep_redirect(
				tep_href_link(FILENAME_CHECKOUT_PAYMENT,
				'error_message=' . urlencode(MODULE_PAYMENT_VADS_TEXT_ERROR_MESSAGE),
				'NONSSL',
				true)
			);
			die();
		}
		
		// Act according to case
		if( $vad_api->isAcceptedPayment() ) {
			// Successful payment
			if($from_server) {
				echo $vad_api->getCheckUrlResponse('payment_ok');
			}
			else {
//				// Abnormal case : payment confirmed by client, but order has not been confirmed by gateway
//				if( MODULE_PAYMENT_VADS_MODE=='TEST' ) {
//					// see after_process
//					$_SESSION['vads_check_url_warning'] = true;
//				}
			}
			// Let checkout_process.php finish the job
			return;
		}
		else {
			// Payment process failed
			if($from_server) {
				die( $vad_api->getCheckUrlResponse('payment_ko') );
			}
			else {
				$error_msg  = 'error_message=' . urlencode(
					MODULE_PAYMENT_VADS_TEXT_ERROR_MESSAGE . ' - ' . $vad_api->getResponseMessage('detail')
				);
				tep_redirect( tep_href_link(FILENAME_CHECKOUT_PAYMENT,$error_msg,'NONSSL') );
				die();
			}
		}
	}

	/**
	 * Post-processing after the order has been finalised
	 */
	function after_process() {
//		if( isset($_SESSION['vads_check_url_warning']) )
//		{
//			// Prepare a warning message
//			unset($_SESSION['vads_check_url_warning']);
//			$error = 'error_message='.urlencode(MODULE_PAYMENT_VADS_CHECK_URL_NOT_CALLED_ERROR_MESSAGE);
//
//			// Proceed as osCommerce would have, with the added error_message
//			$cart->reset(true);
//			tep_session_unregister('sendto');
//			tep_session_unregister('billto');
//			tep_session_unregister('shipping');
//			tep_session_unregister('payment');
//			tep_session_unregister('comments');
//
//			tep_redirect(tep_href_link(FILENAME_CHECKOUT_SUCCESS, $error, 'SSL'));
//
//			require(DIR_WS_INCLUDES . 'application_bottom.php');
//
//			die();
//		}
		return false;
	}

	/**
	 * Return true/1 if the module is installed
	 * @return unknown_type
	 */
	function check() {
		if (!isset($this->_check)) {
			$check_query = tep_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION .
										" WHERE configuration_key = 'MODULE_PAYMENT_VADS_STATUS';");
			$this->_check = tep_db_num_rows($check_query);
		}
		return $this->_check;
	}
	
	
	/**
	 * Build and execute a query for the install() function
	 * Parameters have to be escaped before
	 *
	 * @param string $title
	 * @param string $key
	 * @param string $value
	 * @param string $description
	 * @param string $group_id
	 * @param string $sort_order
	 * @param string $date_added
	 * @param string $set_function
	 * @param string $use_function
	 * @return
	 */
	function _install_query($key, $value, $group_id, $sort_order, $set_function=null, $use_function=null) {
		// Get title and desc translations
		$title = constant($key.'_TITLE');
		$description = constant($key.'_DESC');
		// Build query
		$query  = "";
		$query .= "INSERT INTO " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added";
		$query .= isset($set_function) ? ", set_function" : "";
		$query .= isset($use_function) ? ", use_function" : "";
		$query .= ") VALUES (";
		$query .= "'".mysql_real_escape_string($title)."'";
		$query .= ", '".$key."'";
		$query .= ", '".$value."'";
		$query .= ", '".mysql_real_escape_string($description)."'";
		$query .= ", '".$group_id."'";
		$query .= ", '".$sort_order."'";
		$query .= ", NOW()";
		$query .= isset($set_function) ? ", '".$set_function."'" : "";
		$query .= isset($use_function) ? ", '".$use_function."'" : "";
		$query .= ");";
		// execute;
		tep_db_query($query);
	}
	
	/**
	 * Module install (register admin-managed parameters in database)
	 */
	function install() {
		global $language;

		include_once(DIR_FS_CATALOG.'includes/languages/'.$language.'/modules/payment/'.$this->code.'.php');

		// Ex: _install_query($key, $value, $group_id, $sort_order, $set_function=null, $use_function=null)
		// osCommerce specific parameters
		$this->_install_query('MODULE_PAYMENT_VADS_STATUS', 'True', 6, 1, "tep_cfg_select_option(array(\'True\', \'False\'),");
		$this->_install_query('MODULE_PAYMENT_VADS_SORT_ORDER', '1', 6, 2);
		$this->_install_query('MODULE_PAYMENT_VADS_ZONE', '0', 6, 3, "tep_cfg_pull_down_zone_classes(", "tep_get_zone_class_title");
		
		// Gateway access parameters
		$this->_install_query('MODULE_PAYMENT_VADS_SITE_ID', '12345678', 6, 10);
		$this->_install_query('MODULE_PAYMENT_VADS_KEY_TEST', '1111111111111111', 6, 11);
		$this->_install_query('MODULE_PAYMENT_VADS_KEY_PROD', '2222222222222222', 6, 12);
		$this->_install_query('MODULE_PAYMENT_VADS_MODE', 'TEST', 6, 13,"tep_cfg_select_option(array(\'TEST\', \'PRODUCTION\'),");
		$this->_install_query('MODULE_PAYMENT_VADS_GATEWAY_URL', 'https://paiement.systempay.fr/vads-payment/', 6, 14);
		
		// Payment options
		$this->_install_query('MODULE_PAYMENT_VADS_CURRENCY', '978', 6, 20);
		$this->_install_query('MODULE_PAYMENT_VADS_LANGUAGE', 'FR', 6, 21);
		$this->_install_query('MODULE_PAYMENT_VADS_DELAY', '', 6, 22);
		$this->_install_query('MODULE_PAYMENT_VADS_VALIDATION_MODE', '', 6, 23);
		$this->_install_query('MODULE_PAYMENT_VADS_PAYMENT_CARDS', '', 6, 24);
		
		
		// Gateway return parameters
		$this->_install_query('MODULE_PAYMENT_VADS_REDIRECT_ENABLED', 'False', 6, 40, "tep_cfg_select_option(array(\'True\', \'False\'),");
		$this->_install_query('MODULE_PAYMENT_VADS_REDIRECT_SUCCESS_TIMEOUT', 5, 6, 41);
		$this->_install_query('MODULE_PAYMENT_VADS_REDIRECT_SUCCESS_MESSAGE', MODULE_PAYMENT_VADS_REDIRECT_SUCCESS_MESSAGE_DEFAULT, 6, 42);
		$this->_install_query('MODULE_PAYMENT_VADS_REDIRECT_ERROR_TIMEOUT', 5, 6, 43);
		$this->_install_query('MODULE_PAYMENT_VADS_REDIRECT_ERROR_MESSAGE', MODULE_PAYMENT_VADS_REDIRECT_ERROR_MESSAGE_DEFAULT, 6, 44);
		$this->_install_query('MODULE_PAYMENT_VADS_RETURN_MODE', 'GET', 6, 45, "tep_cfg_select_option(array(\'GET\', \'POST\'),");
		$default_success_url = HTTP_SERVER.DIR_WS_CATALOG.'checkout_success.php';
		$this->_install_query('MODULE_PAYMENT_VADS_SUCCESS_URL', $default_success_url, 6, 46);
		$this->_install_query('MODULE_PAYMENT_VADS_DEFAULT_URL', HTTP_SERVER.DIR_WS_CATALOG.'checkout_process.php', 6, 47);
		$this->_install_query('MODULE_PAYMENT_VADS_ORDER_STATUS_ID', '0', 6, 48, "tep_cfg_pull_down_order_statuses(", "tep_get_order_status_name");
	}

	/**
	 * Module deletion
	 */
	function remove() {
		$config_params = $this->keys();
		
		foreach($config_params as $param)
		{
			tep_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key ='".$param."'");
		}
	}

	/**
	 * Returns the names of module's parameters
	 * @return array[int]string
	 */
	function keys() {
		return array('MODULE_PAYMENT_VADS_STATUS', 'MODULE_PAYMENT_VADS_SORT_ORDER',
			'MODULE_PAYMENT_VADS_ZONE',
			
			'MODULE_PAYMENT_VADS_SITE_ID',
			'MODULE_PAYMENT_VADS_KEY_TEST', 'MODULE_PAYMENT_VADS_KEY_PROD',
			'MODULE_PAYMENT_VADS_MODE', 'MODULE_PAYMENT_VADS_GATEWAY_URL',
			
			'MODULE_PAYMENT_VADS_LANGUAGE', 'MODULE_PAYMENT_VADS_CURRENCY', 'MODULE_PAYMENT_VADS_PAYMENT_CARDS',
			'MODULE_PAYMENT_VADS_DELAY', 'MODULE_PAYMENT_VADS_VALIDATION_MODE',
			
			'MODULE_PAYMENT_VADS_REDIRECT_ENABLED',
			'MODULE_PAYMENT_VADS_REDIRECT_SUCCESS_TIMEOUT','MODULE_PAYMENT_VADS_REDIRECT_SUCCESS_MESSAGE',
			'MODULE_PAYMENT_VADS_REDIRECT_ERROR_TIMEOUT','MODULE_PAYMENT_VADS_REDIRECT_ERROR_MESSAGE',
			'MODULE_PAYMENT_VADS_RETURN_MODE',
			'MODULE_PAYMENT_VADS_SUCCESS_URL', 'MODULE_PAYMENT_VADS_DEFAULT_URL',
			'MODULE_PAYMENT_VADS_ORDER_STATUS_ID'
		);
	}

	/**
	 * Try to guess what will be the order's id when osCommerce will register it at the end of the payment process.
	 * This is only used to set order_id in the request to the payment gateway. It might be inconsistent with the
	 * final osCommerce order id (in cases like two clients going to the payment gateway at the same time...)
	 * @return int
	 */
	function getIdOrder(){
		$sql="SELECT MAX(orders_id) FROM " . TABLE_ORDERS;

		$rech=tep_db_query($sql);

		if(tep_db_num_rows($rech) == 0)
			return 0;
			
		return mysql_result($rech,0,0)+1;
	}
}




/**
 * Classe implmentant la gnration de formulaire et la vrification de signature
 *
 */
class VADS_API
{
	//TODO il manque certains paramtres facultatifs (user_info, order_info2/3, theme_config...)
	
	/* ********* *
	 * ATTRIBUTS *
	 * ********* */
	/* PARAMETRES D'ENVOI OBLIGATOIRES */
	var $version='V1';		// Version de la plateforme de paiement
	var $currency='978';	// Monnaie  utiliser selon norme ISO 4217 (http://www.iso.org/iso/support/currency_codes_list-1.htm)
	var $payment_cards='';	// Liste des types de cartes pouvant tre utilises pour le paiement
							// vide = tout type accept, sinon une combinaison des codes suivants spars par ";" : AMEX;CB;MASTERCARD;VISA

	var $amount; 			// Montant de la trasaction (en cents)
	var $capture_delay; 	// Dlais en jour avant remis en banque (si vide, paramtre par dfaut dfini dans le back office)
	var $ctx_mode;			// Mode de solicitation de la plateforme (TEST ou PRODUCTION)
	
	var $payment_config; 	// Type de paiement (SINGLE ou MULTI)
							/*Exemple pour un paiement de 10000 cents (100 euros) :
							 payment_config=SINGLE (en une fois)
							 ou
							 payment_config=MULTI:first=5000;count=3;period=30 (en plusieurs fois)
							 (Premier paiement de 5000 cents aujourd'hui + "capture_delay"
							 Deuxime paiement de 2500 cents  aujourd'hui + "capture_delay"+ 30 jours
							 Troisime paiement de 2500 cents  aujourd'hui + "capture_delay" + 60 jours)*/
	var $signature;			// Utilise pour authentifier les changes avec la plateforme (cf. calculSignature() )
	var $site_id;			// Disponible dans le back office de la plateforme de paiement
	var $trans_date;		// Date locale du site (format : AAAAMMJJHHMMSS)
	var $trans_id;			// Constitu de 6 caractres numriques, unique pour le site et pour la journe entire (cf. function calculTransId() )
	var $validation_mode;	// Si validation manuelle du commerant. Par dfaut paramtre dfini dans le backoffice

	var $platform_url;	// Url de la plateforme de paiement

	var $key_test;			// Cl fournie par la plateforme servant  calculer la signature
	var $key_prod;			// idem en mode production

	/* PARAMETRES D'ENVOI FACULTATIFS */
	var $cust_id;			// Identifiant client pour le marchand
	var $cust_name;			// Nom du client
	var $cust_title;		// Civilit du client
	var $cust_email;		// Adresse e-mail du client (envoi d'un mail rcapitulatif de la transaction)
	var $cust_address;		// Adresse du client
	var $cust_zip;			// Code postal du client
	var $cust_city;			// Ville du client
	var $cust_phone;		// Numro de tlphone du client
	var $cust_country;		// Pays du client (Norme ISO 3166 http://www.iso.org/iso/fr/country_codes/iso_3166_code_lists/english_country_names_and_code_elements.htm)
	var $language;			// Langue de la page de paiement Norme ISO 639-1 (par dfaut le franais est slectionn)
							//valeurs possibles : fr (dfaut), de, en, zh, es, fr, it, ja
	var $order_id;			// Numro de commande (rappel dans l'e-mail de confirmation du client), 32 caractres alpha-numriques maximum
	var $order_info;		// Rsum de la commande
	var $url_return;		// Url par dfaut (aprs appui du bouton "retourner  la boutique" par le client sur la plateforme)
	var $url_success;		// Url en cas de succs du paiement (aprs appui du bouton "retourner  la boutique")
	var $url_referral;		// Url en cas de refus d'autorisation, code 02 "referral" (aprs appui du bouton "retourner  la boutique")
	var $url_refused;		// Url en cas de refus autre que "referral" (aprs appui du bouton "retourner  la boutique")
	var $url_cancel;		// Url en cas d'annulation par le client (aprs appui sur "annuler et retourner sur la boutique")
	var $url_error;			// Url en cas d'erreur interne
	var $url_check;			// Url appele par la plateforme de paiement pour confirmer le paiement
							// Pour une scurit optimale, ne pas utiliser ce paramtre. Le configurer dans le backoffice de la plateforme
	var $contrib='osCommerce2.2ms2_2.6b';	// code identifiant le plugin de paiement (par ex. "thelia_v2.0")
	var $redirect_enabled;	// Activer ou non la redirection automatique du client vers la boutique
	var $redirect_success_timeout;	// si $redirect_enabled, dfinit le temps en secondes (0-300) avant la redirection automatique
	var $redirect_success_message;	// si $redirect_enabled, dfinit le message affich avant la redirection automatique
	var $redirect_error_timeout;	// si $redirect_enabled, dfinit le temps avant redirection automatique, lorsque le paiement a chou
	var $redirect_error_message;	// si $redirect_enabled, dfinit le message affich avant redirection automatique, lorsque le paiement a chou
	var $return_mode;		// POST (dfaut), GET ou NONE : faon dont les paramtres seront transmis lorsque le client clique sur "retour  la boutique"


	/* PARAMETRES DE REPONSE DE LA PLATEFORME */
	var $auth_result;		// Code retour de la demande d'autorisation retourne par la banque mettrice, si disponible (vide sinon).
	var $auth_mode;			// Indique comment a t ralise la demande d?autorisation. Ce champ peut prendre les valeurs suivantes :
							#- FULL : correspond  une autorisation du montant total de la transaction dans le cas d?un paiement unitaire avec remise  moins de 6 jours,
							# 		ou  une autorisation du montant du premier paiement dans le cas du paiement en N fois, dans le cas d?une remise de ce premier paiement  moins de 6 jours.
							#- MARK : correspond  une prise d?empreinte de la carte, dans le cas ou le paiement est envoy en banque  plus de 6 jours.
	var $auth_number;		// Numro d'autorisation retourn par le serveur bancaire, si disponible (vide sinon).
	var $card_brand;		// Type de carte utilis pour le paiement, si disponible (vide sinon).
	var $card_number;		// Numro de carte masqu.
	var $extra_result;		// Code complmentaire de rponse. Sa signification dpend de la valeur renseigne dans result.
							# Lorsque result vaut 30 (erreur de requte), alors extra_result contient un code indiquant quel champ a t mal rempli
	var $warranty_result;	// Si l?autorisation a t ralise avec succs, indique la garantie du paiement, lie  3D-Secure :
							# YES => Le paiement est garanti
							# NO => Le paiement n?est pas garanti
							# UNKNOWN => Suite  une erreur technique, le paiement ne peut pas tre garanti
							# Non valoris => Garantie de paiement non applicable
	var $payment_certificate;// Si l?autorisation a t ralise avec succs, la plateforme de paiement dlivre un certificat de paiement. Pour toute question concernant un paiement ralis sur la plateforme, cette information devra tre communique.
	var $result;			// Code retour.
							#- 00 : Paiement ralis avec succs.
							#- 02 : Le commerant doit contacter la banque du porteur.
							#- 05 : Paiement refus.
							#- 17 : Annulation client.
							#- 30 : Erreur de format de la requte. A mettre en rapport avec la valorisation du champ extra_result.
							#- 96 : Erreur technique lors du paiement.
	var $hash;				// Valeur retour de serveur  serveur permettant de calculer la signature de retour
	
	var $received_signature;// Signature reue en POST au retour de la plateforme

	
	/* VARIABLES LIEES L'OBJET */
	var $timestamp='';		//Timestamp lors de la cration du formulaire

	var $tab_auth_result;	// Tableau de rponses de confirmation (code => traduction)
	var $tab_warranty_result;// Tableau de rponses 3D Secure
	var $tab_result;		// Tableau de rponses globales
	var $tab_extra_result;	// Tableau de rponses globales dtailles

	
	/* LISTES DES ATTRIBUTS DE L'OBJET utiles pour les foreach... */
	// lies  la requte (sauf key et signature)
	var $request_mandatory = array(
		'amount','capture_delay','currency','ctx_mode','payment_cards','payment_config','site_id','trans_date','trans_id',
		'validation_mode','version'
	);
	var $request_optionnal = array(
		'cust_id','cust_name','cust_title','cust_address','cust_zip','cust_city','cust_phone','cust_country','language','order_id','order_info',
		'cust_email','url_return','url_success','url_referral','url_refused','url_cancel','url_error','url_check','contrib',
		'redirect_success_timeout','redirect_success_message','redirect_error_timeout','redirect_error_message','return_mode'
	);
	var $request_signature = array(
		'version','site_id','ctx_mode','trans_id','trans_date','validation_mode','capture_delay','payment_config','payment_cards','amount',
		'currency'
	);
	
	// lies  la rponse (sauf key, signature et hash)
	var $response_specific = array(
		'auth_result','auth_mode','auth_number','card_brand','card_number','extra_result','warranty_result','payment_certificate','result'
	);
	var $response_requestlike = array(
		// same as response
		'amount','contrib','ctx_mode','currency','payment_config','site_id','trans_date','trans_id','version','order_id','order_info',
		'cust_address','cust_country','cust_email','cust_id','cust_name','cust_phone','cust_title','cust_city','cust_zip','payment_src',
		// same as response or default
		'capture_delay','validation_mode','language'
	);
	var $response_signature = array(
		'version','site_id','ctx_mode','trans_id','trans_date','validation_mode','capture_delay','payment_config','card_brand','card_number',
		'amount','currency','auth_mode','auth_result','auth_number','warranty_result','payment_certificate','result'
	);
	
	// Autres attributs
	var $misc = array('key_test','key_prod','hash','redirect_enabled','platform_url','signature','received_signature');
	
	
	/* ********************************* *
	 * GETTERS/SETTERS SUR LES VARIABLES *
	 * ********************************* */
	/**
	 * renvoie un tableau contenant les noms des attributs lis  telle ou telle fonction de l'objet
	 */
	function getAttributeList($type=null)
	{
		switch($type)
		{
			case "request_mandatory":
				return $this->request_mandatory;
			case "request_optionnal":
				return $this->request_optionnal;
			case "request_all":
				return array_merge($this->request_mandatory,$this->request_optionnal);
				
			case "response_specific":
				return $this->response_specific;
			case "response_requestlike":
				return $this->response_requestlike;
			case "response_all":
				return array_merge($this->response_specific, $this->response_requestlike);
				
			case "request_signature":
				return $this->request_signature;
			case "response_signature":
				return $this->response_signature;
				
			case "misc":
				return $this->misc;
			case "all":
			default:
				return array_unique(array_merge(
					$this->request_mandatory, $this->request_optionnal, $this->request_signature,
					$this->response_specific, $this->response_requestlike, $this->response_signature,
					$this->misc
				));
		}
	}
	
	/**
	 * renvoie la valeur d'un attribut public
	 */
	function get($name='')
	{
		$result = null;
		if( in_array($name, $this->getAttributeList("all"),true) )
		{
			$result = $this->$name;
		}
		if($name==="key")
		{
			$result = ($this->ctx_mode=="TEST") ? $this->key_test : $this->key_prod;
		}
		return $result;
	}
	
	/**
	 * Renvoie la liste des codes iso des langues supportes par la plateforme de paiement
	 * @return multitype:string
	 */
	function getSupportedLanguages() {
		return array('fr','de','en','es','zh','it','ja','pt');
	}
	
	/**
	 * Rcupration du code numrique ISO 4217 d'une devise  partir de son code  3 lettres.
	 * @param string $alpha3 code alphabtique de la devise (ex:EUR,USD,JPY...)
	 */
	function convertAlphaCurrency($alpha3) {
		$currencies = array (
			"AUD" => "036", //Dollar australien
			"CAD" => "124", //Dollar canadien
			"CNY" => "156", //Renminbi yuan chinois
			"DKK" => "208", //Couronne danoise
			"JPY" => "392", //Yen
			"SEK" => "752", //Couronne sudoise
			"CHF" => "756", //Franc suisse
			"GBP" => "826", //Livre sterling
			"USD" => "840", //Dollar des tats-Unis
            "EUR" => "978"  //Euro            
		);
		if(array_key_exists($alpha3, $currencies)) {
			return $currencies[$alpha3];
		}
		else {
			return false;
		}
	}
	
	/**
	 * Modifie la valeur d'un attribut public
	 * @return boolean true si russite, false sinon
	 */
	function set($name='',$value=null)
	{
		if( in_array($name, $this->getAttributeList("all")) )
		{
			$this->$name = $value;
			return true;
		}
		return false;
	}
	
	/**
	 * Modifie les valeurs d'attributs publics  partir d'un tableau
	 * @param $params tableau de paramtres format nom=>valeur
	 * @return boolean true si toutes les valeurs du tableau ont pu tre enregistres, false si non
	 */
	function setFromArray($params)
	{
		$result = true;
		foreach ($params as $name => $value)
		{
			$temp_result = $this->set($name,$value);
			if( $temp_result == false )
				$result = false;
		}
		return $result;
	}
	
	/* ************ *
	 * CONSTRUCTEUR *
	 * ************ */
	function VADS_API()
	{
		// Intialisation des variables prives
		$this->timestamp=time();
		$this->loadResponsesTranslation();
		$auth_result='';
		$auth_mode='';
		$auth_number='';
		$card_brand='';
		$card_number='';
		$extra_result='';
		$warranty_result='';
		$payment_certificate='';
		$result='';
		$hash='';

		//Calcul
		$this->generateTrans_id();
		$this->getTrans_date();
	}

	/**
	 * Chargement des traductions des codes retour dans tab_result, tab_auth_result et tab_warranty_result
	 */
	function loadResponsesTranslation($lang='fr'){
		$translations = array();
		//NB : translations have to be complete !
		$translations['fr'] = array(
//			'MISSING_RESULT_TRANSLATION' => "Traduction manquante pour le code de retour ",
//			'MISSING_EXTRA_RESULT_TRANSLATION' => "Traduction manquante pour le code de retour complmentaire ",
			
			# warranty_result
			'PAIEMENT_GARANTI' => 'Le paiement est garanti',
			'PAIEMENT_PAS_GARANTI' => 'Le paiement n\'est pas garanti',
			'INCIDENT_TECHNIQUE_PAIEMENT_PAS_GARANTI' => 'Suite  une erreur technique, le paiement ne peut pas tre garanti',
			
			# result
			'PAIEMENT_REALISE_SUCCES' => 'Paiement ralis avec succs',
			'COMMERCANT_CONTACTER_BANQUE_PORTEUR' => 'Le commerant doit contacter la banque du porteur',
			'PAIEMENT_REFUSE' => 'Paiement refus',
			'ANNULATION_CLIENT' => 'Annulation client',
			'ERREUR_FORMAT_REQUETE' => 'Erreur de format de la requte',
			'ERREUR_TECHNIQUE_LORS_PAIEMENT' => 'Erreur technique lors du paiement',
			
			# extra_result
			'VERSION_MODE_PAIEMENT_BPL' => "Version du module de paiement (normalement : 2.6b)",
			'ATTRIBUER_LORS_INSCIPTION_COMMERCANT' => "Attribu lors de l'inscription du commerant",
			'UNIQUE_POUR_SITE_POUR_1_JOURNEE' => "Unique pour le site et pour la journe",
			'DATE_LOCALE_SITE' => "Date locale du site",
			'SI_VALIDATION_MANUELLE_COMMERCANT' => "Si validation manuelle du commerant",
			'DELAI_NB_JOUR_REMISE_BANQUE' => "Dlais en jour avant remise en banque",
			'TYPE_PAIEMENT' => "Type de paiement (en une ou plusieurs fois)",
			'LISTE_CARTES_DISPO' => "Liste des types de cartes disponibles",
			'MONTANT_TRANSACTION' => "Montant de la trasaction (en cents)",
			'MONNAIE_UTILISER_ISO' => "Monnaie  utiliser selon norme ISO 4217",
			'MODE_PLATEFORME' => "Mode de solicitation de la plateforme",
			'LANGUE_PAGE_PAIEMENT'=> "Langue de la page de paiement Norme ISO 639-1",
			'NUMERO_COMMANDE' => "Numro de commande",
			'RESUME_COMMANDE' => "Rsum de la commande",
			'ADRESSE_EMAIL_CLIENT' => "Adresse e-mail du client",
			'IDENTIFIANT_CLIENT_POUR_MARCHANT' => "Identifiant client pour le marchand",
			'CIVILITE_CLIENT' => "Civilit du client",
			'NOM_CLIENT' => "Nom du client",
			'ADRESSE_CLIENT' => "Adresse du client",
			'CODE_POSTAL_CLIENT' => "Code postal du client",
			'VILLE_CLIENT' => "Ville du client",
			'PAYS_CLIENT_ISO' => "Pays du client (Norme ISO 3166 )",
			'TELEPHONE_CLIENT' => "Tlphone du client",
			'ERREUR_INCONNUE_DANS_REQUETE' => "Erreur inconnue dans la requte",
			'URL_SUCCESS' => "Url de retour lorsque le paiement est russi",
			'URL_REFUS' => "Url de retour lorsque le paiement est refus",
			'URL_REFUS_AUTORISATION' => "Url de retour lorsque le paiement n'a pas t autoris",
			'URL_ANNULATION' => "Url de retour lorsque le client annule le paiement",
			'URL_DEFAUT' => "Url de retour par dfaut",
			'URL_ERREUR' => "Url de retour en cas d'erreur",
		);
		
		$translation = array_key_exists($lang,$translations) ? $translations[$lang] : $translations['fr'];
		
		
//		$missing_msg = $translation['MISSING_RESULT_TRANSLATION'];

		# warranty_result
		$this->tab_warranty_result['YES'] = $translation['PAIEMENT_GARANTI'];
		$this->tab_warranty_result['NO'] = $translation['PAIEMENT_PAS_GARANTI'];
		$this->tab_warranty_result['UNKNOWN'] = $translation['INCIDENT_TECHNIQUE_PAIEMENT_PAS_GARANTI'];

		# result
		$this->tab_result['00'] = $translation['PAIEMENT_REALISE_SUCCES'];
		$this->tab_result['02'] = $translation['COMMERCANT_CONTACTER_BANQUE_PORTEUR'];
		$this->tab_result['05'] = $translation['PAIEMENT_REFUSE'];
		$this->tab_result['17'] = $translation['ANNULATION_CLIENT'];
		$this->tab_result['30'] = $translation['ERREUR_FORMAT_REQUETE'];
		$this->tab_result['96'] = $translation['ERREUR_TECHNIQUE_LORS_PAIEMENT'];

//		$missing_msg = $translation['MISSING_EXTRA_RESULT_TRANSLATION'];
		# extra_result
		$this->tab_extra_result['01'] = 'version => '.$translation['VERSION_MODE_PAIEMENT_BPL'];
		$this->tab_extra_result['02'] = 'site_id => '.$translation['ATTRIBUER_LORS_INSCIPTION_COMMERCANT'];
		$this->tab_extra_result['03'] = 'trans_id => '.$translation['UNIQUE_POUR_SITE_POUR_1_JOURNEE'];
		$this->tab_extra_result['04'] = 'trans_date => '.$translation['DATE_LOCALE_SITE'];
		$this->tab_extra_result['05'] = 'validation_mode => '.$translation['SI_VALIDATION_MANUELLE_COMMERCANT'];
		$this->tab_extra_result['06'] = 'capture_delay => '.$translation['DELAI_NB_JOUR_REMISE_BANQUE'];
		$this->tab_extra_result['07'] = 'payment_config => '.$translation['TYPE_PAIEMENT'];
		$this->tab_extra_result['08'] = 'payment_cards => '.$translation['LISTE_CARTES_DISPO'];
		$this->tab_extra_result['09'] = 'amount => '.$translation['MONTANT_TRANSACTION'];
		$this->tab_extra_result['10'] = 'currency => '.$translation['MONNAIE_UTILISER_ISO'];
		$this->tab_extra_result['11'] = 'ctx_mode => '.$translation['MODE_PLATEFORME'];
		$this->tab_extra_result['12'] = 'language => '.$translation['LANGUE_PAGE_PAIEMENT'];
		$this->tab_extra_result['13'] = 'order_id => '.$translation['NUMERO_COMMANDE'];
		$this->tab_extra_result['14'] = 'order_info => '.$translation['RESUME_COMMANDE'];
		$this->tab_extra_result['15'] = 'cust_email => '.$translation['ADRESSE_EMAIL_CLIENT'];
		$this->tab_extra_result['16'] = 'cust_id => '.$translation['IDENTIFIANT_CLIENT_POUR_MARCHANT'];
		$this->tab_extra_result['17'] = 'cust_title => '.$translation['CIVILITE_CLIENT'];
		$this->tab_extra_result['18'] = 'cust_name => '.$translation['NOM_CLIENT'];
		$this->tab_extra_result['19'] = 'cust_address => '.$translation['ADRESSE_CLIENT'];
		$this->tab_extra_result['20'] = 'cust_zip => '.$translation['CODE_POSTAL_CLIENT'];
		$this->tab_extra_result['21'] = 'cust_city => '.$translation['VILLE_CLIENT'];
		$this->tab_extra_result['22'] = 'cust_country => '.$translation['PAYS_CLIENT_ISO'];
		$this->tab_extra_result['23'] = 'cust_phone => '.$translation['TELEPHONE_CLIENT'];
		$this->tab_extra_result['24'] = 'url_success => '.$translation['URL_SUCCESS'];
		$this->tab_extra_result['25'] = 'url_refused => '.$translation['URL_REFUS'];
		$this->tab_extra_result['26'] = 'url_referral => '.$translation['URL_REFUS_AUTORISATION'];
		$this->tab_extra_result['27'] = 'url_cancel => '.$translation['URL_ANNULATION'];
		$this->tab_extra_result['28'] = 'url_return => '.$translation['URL_DEFAUT'];
		$this->tab_extra_result['29'] = 'url_error => '.$translation['URL_ERREUR'];
		$this->tab_extra_result['99'] = $translation['ERREUR_INCONNUE_DANS_REQUETE'];
	}

	/* ******************* *
	 * CALCUL DE SIGNATURE *
	 * ******************* */
	/**
	 * Gnre la signature  envoyer  la plateforme  partir des champs enregistrs, la stocke
	 * dans $this->signature et la renvoie.
	 * @param $hashed boolean true par dfaut ; mettre  false pour obtenir la signature avant hachage
	 * @return string la signature calcule
	 */
	function generateRequestSignature($hashed=true)
	{
		$sign_content = "";
		foreach ($this->request_signature as $field)
		{
			$sign_content .= $this->$field;
			$sign_content .= "+";
		}
		$sign_content .= $this->get("key");
		$this->signature = $hashed ? sha1($sign_content) : $sign_content;
		return $this->signature;
	}
	
	/**
	 * Gnre la signature de la rponse  partir des champs enregistrs, la stocke
	 * dans $this->signature et la renvoie.
	 * @param $hashed boolean true par dfaut ; mettre  false pour obtenir la signature avant hachage
	 * @return string la signature calcule
	 */
	function generateResponseSignature($hashed=true)
	{
		$sign_content = "";
		foreach ($this->response_signature as $field)
		{
			$sign_content .= $this->$field;
			$sign_content .= "+";
		}
		$sign_content .= ($this->hash != '') ? $this->hash."+" : "";
//		$sign_content .= ($this->contrib=='osCommerce2.2ms2_2.6b') ? '' : '+'.$this->get('contrib');
		$sign_content .= $this->get("key");
		$this->signature = $hashed ? sha1($sign_content) : $sign_content;
		return $this->signature;
	}
	
	
	/* ****************************************** *
	 * CONSTRUCTION DE LA REQUETE A LA PLATEFORME *
	 * ****************************************** */
	/**
	 * Renvoie true si tous les champs obligatoires de la requte ont t prpars, false sinon
	 * @return boolean
	 */
	function isRequestReady()
	{
		foreach ($this->getAttributeList("request_mandatory") as $field_name)
		{
			$value = $this->$field_name;
			if($value === null)
				return false;
		}
		return true;
	}
	 
	/**
	 * Renvoie le code html du formulaire utilis pour rediriger le client vers la plateforme de paiement
	 * @param $enteteMethod	POST ou GET ; utilisez de prfrence POST, sinon voir aussi getRequestUrlEncodedFields
	 * @param $enteteAdd attributs supplmentaires pour la balise <form>
	 * @param $inputType type des entres, hidden par dfaut
	 * @param $buttonValue texte du bouton
	 * @param $buttonAdd attributs supplmentaires du bouton
	 * @param $buttonType type du bouton, par dfaut submit
	 * @return string
	 */
	function getRequestHtmlForm($enteteAdd='',$inputType='hidden',
								$buttonValue='Aller sur la plateforme de paiement',$buttonAdd='',$buttonType='submit')
	{
		if(!$this->isRequestReady()) { return false; }
		
		$html  = "";
		$html .= '<form action="'.$this->platform_url.'" method="POST" '.$enteteAdd.'>';
		$html .= "\n";
		$html .= $this->getRequestHtmlInputs($inputType);
		$html .= '<input type="'.$buttonType.'" value="'.$buttonValue.'" '.$buttonAdd.'/>';
		$html .= "\n";
		$html .= '</form>';
		return $html;
	}
	
	/**
	 * Renvoie le code html des inputs du formulaire de redirection vers la plateforme
	 * @param $inputType par dfaut hidden
	 * @return string
	 */
	function getRequestHtmlInputs($inputType='hidden')
	{
		if(!$this->isRequestReady()) { return false; }
		
		$html = "";
		foreach ($this->getAttributeList("request_mandatory") as $field_name)
		{
			$value = $this->$field_name;
			$html .= '<input type="'.$inputType.'" name="'.$field_name.'" value="'.$value.'" />';
			$html .= "\n";
		}
		foreach ($this->getAttributeList("request_optionnal") as $field_name)
		{
			if( substr($field_name,0,8) == 'redirect' && !$this->isRedirectEnabled() )
			{
				continue;
			}
			$value = $this->$field_name;
			if($value !== null)
			{
				$html .= '<input type="'.$inputType.'" name="'.$field_name.'" value="'.$value.'" />';
				$html .= "\n";
			}
		}
		$sign = $this->generateRequestSignature();
		$html .= '<input type="'.$inputType.'" name="signature" value="'.$sign.'" />';
		$html .= "\n";
		return $html;
	}
	
	/**
	 * Renvoie l'url de la plateforme avec les paramtres  transmettre encods (mthode GET)
	 * Utiliser de prfrence un formulaire POST (url plus propre, pas de limite  la longueur des paramtres),
	 * cf. getRequestHtmlForm
	 * @return unknown_type
	 */
	function getRequestUrl()
	{
		if(!$this->isRequestReady()) { return false; }
		
		return $this->platform_url . '?' . $this->getRequestUrlEncodedFields();
	}
	
	/**
	 * Renvoie les paramtres url encods  transmettre lors de la redirection vers la plateforme,
	 * si vous utilisez un lien plutt qu'un formulaire.
	 * Utilisez de prfrence un formulaire POST (url plus propre, pas de limite  la longueur de paramtres) ou
	 * vitez d'utiliser les paramtres optionnels trop longs
	 * @return string ex : amount=1000&order_id=123&order_info=10%20euros%20%E0%20payer&...
	 */
	function getRequestUrlEncodedFields()
	{
		if(!$this->isRequestReady()) { return false; }
		
		$fields = "";
		foreach ($this->getAttributeList("request_mandatory") as $field_name)
		{
			$value = $this->$field_name;
			$fields .= $field_name."=".rawurlencode($value);
			$fields .= "&";
		}
		foreach ($this->getAttributeList("request_optionnal") as $field_name)
		{
			if( substr($field_name,0,8) == 'redirect' && !$this->isRedirectEnabled() )
			{
				continue;
			}
			$value = $this->$field_name;
			if($value !== null)
			{
				$fields .= $field_name."=".rawurlencode($value);
				$fields .= "&";
			}
		}
		$sign  = $this->generateRequestSignature();
		$fields .= "signature=$sign";
		return $fields;
	}
	
	/**
	 * return whether the automatic redirection is enabled or not
	 * (true if redirect_enabled = true or c.i. "true")
	 * @return boolean
	 */
	function isRedirectEnabled()
	{
		// accept true, 1, '1', "True"(ci)
		return (strval($this->redirect_enabled) === "1"
			|| strtolower($this->redirect_enabled) === "true");
	}
	
	/**
	 * Gnration d'un trans_id unique pour la transaction de ce site pour la journe
	 * Le renvoie et le stocke dans $this->trans_id
	 * @return string
	 */
	function generateTrans_id()
	{
		/*
		 * On utilise le nombre de diximes de seconde depuis minuit, qui respecte la spc :
		 * - 6 chiffres
		 * - de 000000  864000, donc infrieur  899999
		 * - unique sur une journe (sauf si 2 clients paient  moins de 0.1 seconde d'intervalle)
		 */
		list($usec, $sec) = explode(" ", microtime());	// microsecondes, compatible php4
		$temp = ($this->timestamp + $usec - strtotime('today 00:00')) * 10;
		$temp = sprintf('%06d',$temp);
		
		$this->trans_id = $temp;
		return $this->trans_id;
	}
	
	/**
	 * Renvoie et stocke dans $this->trans_date la date au format AAAAMMJJHHmmSS
	 * @return string
	 */
	function getTrans_date(){
		$temp = gmdate('YmdHis',$this->timestamp);

		$this->trans_date=$temp;
		return $this->trans_date;
	}
	
	
	/* ********************************** *
	 * ANALYSE DE LA REPONSE DE LA BANQUE *
	 * ********************************** */
	/**
	 * Set the response-related attributes from given tab ($_REQUEST by default)
	 * @param $tab
	 */
	function setResponseFromPost($tab=null, $key_test=null, $key_prod=null, $ctx_mode=null)
	{
		$tab = isset($tab) ? $tab : $_REQUEST;
		foreach ( $this->getAttributeList("response_all") as $field_name )
		{
			$this->$field_name = isset($tab[$field_name]) ? $tab[$field_name] : null;
		}
		if (isset($key_test)) {$this->key_test = $key_test;}
		if (isset($key_prod)) {$this->key_prod = $key_prod;}
		if (isset($ctx_mode)) {$this->ctx_mode = $ctx_mode;}
		$this->hash = isset($tab['hash']) ? $tab['hash'] : null;
		$this->received_signature = isset($tab['signature']) ? $tab['signature'] : null;
	}
	
	/**
	 * Compare la signature soumise avec celle calcule  partir des champs
	 * @param string $post_signature
	 * @return boolean true si les deux signatures sont identiques
	 */
	function isAuthentifiedResponse()
	{
		return ($this->generateResponseSignature() == $this->received_signature);
	}
	
	/**
	 * Renvoie true si le code retour enregistr correspond  un paiement russi, false sinon
	 * @return boolean
	 */
	function isAcceptedPayment()
	{
		return ($this->result == '00');
	}
	
	/**
	 * Renvoie true si le code retour enregistr correspond  une annulation client, false sinon
	 * @return boolean
	 */
	function isCancelledPayment()
	{
		return ($this->result == '17');
	}
	
	/**
	 * Renvoie, selon le paramtre type, le code retour de la rponse de la banque ou sa traduction
	 * @param $type 'detail' : renvoie le message et les dtails ventuels ; 'id' : renvoie le code retour ; sinon juste le message
	 * @return string
	 */
	function getResponseMessage($type='',$lang='fr'){
		// on demande le code...
		if($type == 'id')
			return $this->result;
		
		// ...ou sa traduction ?
		$this->loadResponsesTranslation($lang);
		$return = $this->tab_result[$this->result];
		if( $type == 'detail' && $this->result=='30')
		{
			// avec des dtails le cas chant
			$return .= $this->tab_extra_result[$this->extra_result];
		}

		return $return;
	}
	
	/**
	 * Renvoie la traduction du code retour 3D secure
	 * @return string
	 */
	function getReponse3DSec($lang='fr'){
		$this->loadResponsesTranslation($lang);
		$return = '';
		if($this->warranty_result!=''){
			$return .= $this->tab_warranty_result[$this->warranty_result];
		}

		return $return;
	}
	
	/* ********************************** *
	 * REPONSE A L'APPEL DE L'URL SERVEUR *
	 * ********************************** */
	/**
	 * Renvoie une rponse interprtable par la plateforme dans le cadre de l'appel de l'url serveur
	 * @param $success vrai pour donner une rponse positive  la plateforme, faux sinon ; si null, on utilise la mthode isAuthentifiedResponse
	 * @param $message informations complmentaires sur le rsultat du traitement de l'appel serveur
	 * @return string
	 */
	function getCheckUrlResponse($code='', $extra_msg="")
	{
		$success = false;
		$message  = '';
		
		// Messages prdfinis selon le cas
		$cases = array(
			'payment_ok' 				=> array(true,'Paiement valide trait'),
			'payment_ko' 				=> array(true,'Paiement invalide trait'),
			'payment_ok_already_done' 	=> array(true,'Paiement valide trait, dj enregistr'),
			'order_not_found' 			=> array(false,'Impossible de retrouver la commande'),
			'payment_ko_on_order_ok' 	=> array(false,'Code paiement invalide reu pour une commande dj valide'),
			'auth_fail' 				=> array(false,'Echec authentification'),
			'ok' 						=> array(true,''),
			'ko' 						=> array(false,'')
		);
		
		if(array_key_exists($code,$cases))
		{
			$success = $cases[$code][0];
			$message = $cases[$code][1];
		}
		
		$message .= ' '.$extra_msg;
		$message = str_replace("\n",'',$message);
		
		$response  = "";
		$response = '<span style="display:none">';
		$response .= $success ? "OK-" : "KO-";
		$response .= $this->get('hash');
		$response .= ($message===' ') ? "\n" : "=$message\n";
		$response .= '</span>';
		return $response;
	}
}

?>