<?php
/*
  $Id: outremer.php,v 1.3 2005/01/20 14:30:00 fsimon Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com
  Released under the GNU General Public License

  Copyright (c) 2005, ADIF

*/


class outremer
{
  var $code, $title, $description, $icon, $enabled;

  // class constructor
  function outremer()
  {
    $this->code = 'outremer';
    $this->title = MODULE_SHIPPING_OUTREMER_TEXT_TITLE;
    $this->description = MODULE_SHIPPING_OUTREMER_TEXT_DESCRIPTION;
    $this->sort_order = MODULE_SHIPPING_OUTREMER_SORT_ORDER;
    $this->icon = DIR_WS_ICONS . 'colissimo.gif'; // colissimo.gif ou shipping_laposte.gif au choix
    $this->tax_class = MODULE_SHIPPING_OUTREMER_TAX_CLASS;
    $this->enabled = MODULE_SHIPPING_OUTREMER_STATUS;
  }

// class methods
  function quote($method = '')
  {
    global $order, $cart, $shipping_weight;

    $this->quotes = array('id' => $this->code,
                          'module' => MODULE_SHIPPING_OUTREMER_TEXT_TITLE,
                          'methods' => array());

    if (tep_not_null($this->icon)) $this->quotes['icon'] = tep_image($this->icon, $this->title);

    $dest_country = $order->delivery['country']['iso_code_2'];
    $dest_cp = substr( $order->delivery['postcode'], 0, 2 );
    $typ_env = "ZD";

    function testpays($tab,$sep,$pays) {
      $table = split("[$sep]" , $tab);
      $valret = false;
      for ($i = 0; $i < sizeof($table); $i++)
      {
      	if ($pays == $table[$i])
      	{
         $valret = true;
         break;
        }
      }
      return $valret;
    }

    // Tests pour DOM ou TOM
    if ( ($dest_country == 'YT') || ($dest_country == 'PM') || ($dest_country == 'GF') || ($dest_country == 'GP') || ($dest_country == 'MQ') || ($dest_country == 'RE')) {
	   $typ_env = "DOM";
	} elseif ( ($dest_country == 'NC') || ($dest_country == 'PF') || ($dest_country == 'WF') || ($dest_country == 'TF')) {
	   $typ_env = "TOM";
    }
    
    $delai = "";
    switch ( $typ_env ) {
      case "DOM"   :
        $cost = MODULE_SHIPPING_OUTREMER_TDOM;
        $delai = " , j+5 &agrave; j+7 ";
        break;
      case "TOM"   :
        $cost = MODULE_SHIPPING_OUTREMER_TTOM;
        $delai = " , j+5 &agrave; j+7 ";
        break;
    }

    $table = split("[:,]" , $cost);
    for ($i = 0; $i < sizeof($table); $i+=2)
    {
    	if ($shipping_weight > $table[$i]) continue;

    	$this->quotes['methods'][] = array('id'    => $this->code,
                                         'title' => $shipping_weight . ' ' . MODULE_SHIPPING_OUTREMER_TEXT_UNITS."$delai" ,
                                         'cost'  => $table[$i+1] + MODULE_SHIPPING_OUTREMER_HANDLING);

      if ($this->tax_class > 0)
      {
        $this->quotes['tax'] = tep_get_tax_rate($this->tax_class,
                                                $order->delivery['country']['id'],
                                                $order->delivery['zone_id']);
      }
      return $this->quotes;
    }

    $this->quotes['error'] = MODULE_SHIPPING_OUTREMER_INVALID_ZONE;
    return $this->quotes;
  }

  function check()
  {
    $check = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_OUTREMER_STATUS'");
    $check = tep_db_num_rows($check);
    return $check;
  }

  function install()
  {
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) 
                  VALUES ('Valider Colis Rapides', 'MODULE_SHIPPING_OUTREMER_STATUS', 'True', 'Activer / Dsactiver Colis Rapides sans perdre les valeurs chang&eacute;es', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
                  VALUES ('Tarifs DOM', 'MODULE_SHIPPING_OUTREMER_TDOM', '0.5:11.50, 1:14.00, 2:18.50, 3:23.50, 4:28.50, 5:33.50, 6:38.50, 7:43.50, 8:48.50, 9:53.50, 10:58.50, 15:76.00, 20:101.00, 25:126.00, 30:151.00', 'Port bas&eacute; sur le poids total des produits, tarif intrad&eacute;partemental. Exemple: 1:3.50,2:5.50,etc.. Jusqu\'&agrave; 1 Kg factur&eacute; 3.50, jusqu\' 2 Kg, 5.50, etc', '6', '0', now())");

    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
                  VALUES ('Tarifs TOM', 'MODULE_SHIPPING_OUTREMER_TTOM', '0.5:17.00, 1:20.00, 2:31.40, 3:42.80, 4:54.20, 5:65.60, 6:77.00, 7:88.40, 8:99.80, 9:111.20, 10:126.60', 'Port bas&eacute; sur le poids total des produits, tarif intrad&eacute;partemental. Exemple: 1:3.50,2:5.50,etc.. Jusqu\'&agrave; 1 Kg factur&eacute; 3.50, jusqu\' 2 Kg, 5.50, etc', '6', '0', now())");
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
                  VALUES ('Frais fixes', 'MODULE_SHIPPING_OUTREMER_HANDLING', '0', 'Frais fixes : emballage...', '6', '0', now())");
	  tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) 
	                VALUES ('Classe de taxe', 'MODULE_SHIPPING_OUTREMER_TAX_CLASS', '2', 'Appliquer le taux de taxe suivant sur les frais de livraison.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) 
                  VALUES ('Code postal', 'MODULE_SHIPPING_OUTREMER_STORE_POSTCODE', '06300', 'Code postal de la boutique', '6', '0', now())");
	  tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) 
	                VALUES ('Ordre de tri', 'MODULE_SHIPPING_OUTREMER_SORT_ORDER', '0', 'Ordre de tri pour l\'affichage (Le plus petit nombre est montr&eacute; en premier).', '6', '0', now())");
  }

  function remove()
  {
    tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
  }

  function keys()
  {
    return array('MODULE_SHIPPING_OUTREMER_STATUS',
                 'MODULE_SHIPPING_OUTREMER_TDOM',
                 'MODULE_SHIPPING_OUTREMER_TTOM',
                 'MODULE_SHIPPING_OUTREMER_HANDLING',
                 'MODULE_SHIPPING_OUTREMER_STORE_POSTCODE',
                 'MODULE_SHIPPING_OUTREMER_TAX_CLASS',
                 'MODULE_SHIPPING_OUTREMER_SORT_ORDER'
                 );
  }

}

?>
