<?php
/*
  $Id: mondial_relay.php,v 1.27 2003/02/05 22:41:52 hpdl Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

  class mondialrelay {
    var $code, $title, $description, $icon, $enabled;

// class constructor
    function mondialrelay() {
      global $order;

      $this->code = 'mondialrelay';
      $this->title = MODULE_SHIPPING_MONDIALRELAY_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_MONDIALRELAY_TEXT_DESCRIPTION;
      $this->sort_order = MODULE_SHIPPING_MONDIALRELAY_SORT_ORDER;
      $this->icon = '';
      $this->tax_class = MODULE_SHIPPING_MONDIALRELAY_TAX_CLASS;
      $this->enabled = ((MODULE_SHIPPING_MONDIALRELAY_STATUS == 'true') ? true : false);// la valeur de test 'true' ou 'false' est convertie dans application_top depuis 'Oui' ou 'Non' ! laisser le test sur la valeur 'true'

      if ( ($this->enabled == true) && ((int)MODULE_SHIPPING_MONDIALRELAY_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_SHIPPING_TABLE_ZONE . "' and zone_country_id = '" . $order->delivery['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->delivery['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

// class methods
    function quote($method = '') {
      global $order, $cart, $shipping_weight, $shipping_num_boxes;

      if (MODULE_SHIPPING_MONDIALRELAY_MODE == 'prix') {
        $order_total = $cart->show_total();
      } else {
        $order_total = $shipping_weight;
      }

      $mondial_relay_cost = split("[:,]" , MODULE_SHIPPING_MONDIALRELAY_COST);
      $size = sizeof($mondial_relay_cost);
      for ($i=0, $n=$size; $i<$n; $i+=2) {
        if ($order_total <= $mondial_relay_cost[$i]) {
          $shipping = $mondial_relay_cost[$i+1];
          break;
        }
      }

      if (MODULE_SHIPPING_MONDIALRELAY_MODE == 'poids') {
        $shipping = $shipping * $shipping_num_boxes;
      }

      $this->quotes = array('id' => $this->code,
                            'module' => MODULE_SHIPPING_MONDIALRELAY_TEXT_TITLE,
                            'methods' => array(array('id' => $this->code,
                                                     'title' => MODULE_SHIPPING_MONDIALRELAY_TEXT_WAY,
                                                     'cost' => $shipping + MODULE_SHIPPING_MONDIALRELAY_HANDLING)));

      if ($this->tax_class > 0) {
        $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
      }

      if (tep_not_null($this->icon)) $this->quotes['icon'] = tep_image($this->icon, $this->title);

      return $this->quotes;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_MONDIALRELAY_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Utiliser ce mode de livraison', 'MODULE_SHIPPING_MONDIALRELAY_STATUS', 'Oui', 'Voulez-vous utiliser ce module de livraison?', '6', '0', 'tep_cfg_select_option(array(\'Oui\', \'Non\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Tableau de prix', 'MODULE_SHIPPING_MONDIALRELAY_COST', '25:8.50,50:5.50,10000:0.00', 'Le montant du port est calcul selon le montant de la commande ou selon le poids total de celle-ci. Exemple: 25:8.50,50:5.50,etc. Jusqu\' 25 cot 8.50 (HT), entre 25 et 50 cot 5.50, etc.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Type de mondial_relay', 'MODULE_SHIPPING_MONDIALRELAY_MODE', 'poids', 'Le montant des frais de port est calcul en fonction du poids total ou du prix total de la commande.', '6', '0', 'tep_cfg_select_option(array(\'poids\', \'prix\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('FRais fixes', 'MODULE_SHIPPING_MONDIALRELAY_HANDLING', '0', 'Frais fixes ou de manutention pour ce mode de livraison.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('TVA Applicable', 'MODULE_SHIPPING_MONDIALRELAY_TAX_CLASS', '0', 'Choisissez le taux de TVA applicable  ce mode de livraison.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Zone de livraison', 'MODULE_SHIPPING_MONDIALRELAY_ZONE', '0', 'Si une zone est slectionne, seule cette zone proposera ce mode de livraison.', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre d\'affichage', 'MODULE_SHIPPING_MONDIALRELAY_SORT_ORDER', '0', 'Ordre dans l\'affichage des modules', '6', '0', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_SHIPPING_MONDIALRELAY_STATUS', 'MODULE_SHIPPING_MONDIALRELAY_COST', 'MODULE_SHIPPING_MONDIALRELAY_MODE', 'MODULE_SHIPPING_MONDIALRELAY_HANDLING', 'MODULE_SHIPPING_MONDIALRELAY_TAX_CLASS', 'MODULE_SHIPPING_MONDIALRELAY_ZONE', 'MODULE_SHIPPING_MONDIALRELAY_SORT_ORDER');
    }
  }